<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Customer extends Public_Controller {

    function __construct() {
        parent::__construct();
        $this->site_title = $this->config->item('gk_name');
        $this->load->model('User_Model');
        $this->load->model('Customer_Model');
        $this->load->helper('site');
        if (!$this->User_Model->is_logged_in()) {
            redirect('user');
        }
    }

    public function logout() {
        $this->User_Model->logout();
    }

    public function index() {
        $data = array();
        $this->page_title = "Customer Account";
        $this->current_section = "Customer Account";
        $data['current_page'] = 'index';
        $data['url_page'] = 'customer';
        $data['user'] = $this->Customer_Model->get_list('gkpos_customer', array('phone' => $this->session->userdata('online_userphone'), 'email' => $this->session->userdata('online_useremail')));
        $this->render_page('customer/index', $data);
    }

    public function index2() {
        $data = array();
        $this->page_title = "Customer Account";
        $this->current_section = "Customer Account";
        $data['current_page'] = 'index';
        $data['url_page'] = 'customer';
        $data['user'] = $this->Customer_Model->get_list('gkpos_customer', array('phone' => $this->session->userdata('online_userphone'), 'email' => $this->session->userdata('online_useremail')));
        $this->render_page('customer/index2', $data);
    }

    public function profile() {
        $this->page_title = "Customer Profile";
        $this->current_section = "Customer Profile";
        $data['current_page'] = 'index';
        $data['url_page'] = 'customer';
        $data['user'] = $this->Customer_Model->get_list('gkpos_customer', array('phone' => $this->session->userdata('online_userphone'), 'email' => $this->session->userdata('online_useremail')));
        $this->render_page('customer/profile', $data);
    }

    public function profile_edit() {
        $this->page_title = "Customer Editing Profile";
        $this->current_section = "Update Customer Profile";
        $data['current_page'] = 'profile_edit';
        $data['url_page'] = 'customer';
        $data['user'] = $this->Customer_Model->get_list('gkpos_customer', array('phone' => $this->session->userdata('online_userphone'), 'email' => $this->session->userdata('online_useremail')));
        //debugPrint($data);
        $this->render_page('customer/profile_edit', $data);
    }

    public function update_profile() {
        $data = $this->prepareData();
        unset($data['email']);
        unset($data['phone']);
        if ($this->db->update('gkpos_customer', $data, array('phone' => $this->session->userdata('online_userphone'), 'email' => $this->session->userdata('online_useremail')))) {
            $this->session->set_flashdata('app_success', "Your account updated successfully");
            echo json_encode(array('success' => true, 'message' => "Your account updated successfully"));
        } else {
            echo json_encode(array('success' => true, 'message' => "Your account update failed"));
        }
    }

    public function changepassword() {
        $this->page_title = "Change Password";
        $this->current_section = "Change Password";
        $data['current_page'] = 'changepassword';
        $data['url_page'] = 'customer';
        $this->render_page('customer/changepassword', $data);
    }

    public function savechanged_password() {
        $data = $this->prepareData();
        $user = $this->Customer_Model->get_single('gkpos_customer', array('phone' => $this->session->userdata('online_userphone'), 'email' => $this->session->userdata('online_useremail'), 'password' => md5($data['current_password'])));
        $success = false;
        $message = null;
        if (!empty($user) && (isset($data['password']) && $data['password'] != null)) {
            if ($this->db->update('gkpos_customer', array('password' => md5($data['password'])), array('phone' => $this->session->userdata('online_userphone'), 'email' => $this->session->userdata('online_useremail')))) {
                $success = true;
                $message = "Your Password updated successfully";
            } else {
                $success = true;
                $message = "Your Password update failed! please try again";
            }
        } else {
            $success = false;
            $message = "Your provided current password is wrong! Please provide the correct one";
        }
        echo json_encode(array('success' => $success, 'message' => $message));
    }

    public function order_summary() {
        $data = array();
        $this->page_title = "Customer Order Summary";
        $data['current_page'] = 'order_summary';
        $data['url_page'] = 'customer';
        $condition = '';
        $offset = intval($this->uri->segment(3));
        $offset = $offset ? $offset : 0;
        $result = $this->Customer_Model->get_paged_list('gkpos_order', array('order_type' => 'online',
            'email' => $this->session->userdata('online_useremail'),
            'phone' => $this->session->userdata('online_userphone')), 'customer/order_summary', 3, $offset, 'created', 'DESC'
        );

        $data['orders'] = $result['rows'];
        $data['pagination'] = $result['pagination'];
        $data['count'] = $offset;
        $this->render_page('customer/order_summary', $data);
    }

    public function order_detail($id = null) {
        $this->page_title = "Customer Order Detail";
        $data['current_page'] = 'order_detail';
        $data['url_page'] = 'customer';
        if ($id != null && $this->Customer_Model->exists('gkpos_order', 'id', $id)) {
            $data['order'] = $order = $this->Site_Model->get_list('gkpos_order', array('id' => $id));
            $data['items'] = $this->Site_Model->get_list('gkpos_order_detail', array('order_id' => $order[0]->id));
            $discount = $this->Site_Model->get_single('gkpos_order_discount', array('order_id' => $order[0]->id));
            $data['discount'] = !empty($discount) ? $discount->amount : 0;
            $vat = $this->Site_Model->get_single('gkpos_order_vat', array('order_id' => $order[0]->id));
            $data['vat'] = !empty($vat) ? $vat->amount : 0;
        }
        $this->render_page('customer/order_detail', $data);
    }

    public function address() {
        $this->page_title = "Customer Address List";
        $data['current_page'] = 'address';
        $data['url_page'] = 'customer';
        $data['primary'] = $this->Customer_Model->get_list('gkpos_customer', array('phone' => $this->session->userdata('online_userphone'), 'email' => $this->session->userdata('online_useremail')), array('street', 'postcode', 'city', 'country'));
        $data['secondary'] = $this->Customer_Model->get_customer_address($this->session->userdata('online_userphone'));
        $this->render_page('customer/address', $data);
    }

    public function cart() {
        $this->page_title = "Customer Current Cart";
        $obj = $this->Site_Model;
        $data = array();
        $data['cart'] = $obj->get_cart();
        if ($obj->cart_configuration($obj->get_order_type())) {
            $data['subtotal'] = $obj->get_subtotal();
            $data['vat'] = $obj->get_vat_amount();
            $data['order_type'] = $obj->get_order_type();
            $data['discount'] = $obj->get_discount_amount();
            $data['bogodiscount'] = $obj->get_bogodiscount_amount();
            $data['cross_promotion'] = $obj->get_cross_promotion();
            $data['cross_promo_amount'] = $obj->get_cross_promotion_amount();
            $data['deliveryPlan'] = $obj->get_deliveryplan();
            $data['delivery_condition'] = 'fullfilled';
            if (!empty($data['deliveryPlan'])) {
                $data['delivery_condition'] = $this->Site_Model->get_subtotal() >= $data['deliveryPlan']['min_order'] ? 'fullfilled' : 'notfullfilled';
            }
            $data['delivery_time'] = !empty($data['deliveryPlan']) ? $data['deliveryPlan']['delivery_time'] : $this->config->item('default_delivery_time');
            $data['total'] = $obj->get_total();
            $data['cc_fee'] = $obj->get_cc_fee();
        }
        $data['current_page'] = 'cart';
        $data['url_page'] = 'customer';
        $this->render_page('customer/cart', $data);
    }

}
