<?php

class Gallery extends Public_Controller {

    function __construct() {
        parent::__construct();
        $this->site_title = $this->config->item('gk_name');
        $this->load->helper('site');
    }

    public function index() {
        $data = array();
        if ($this->cache->get('site_gallery')) {
            $data = $this->cache->get('site_gallery');
        } else {
            $data['gallery'] = $this->Site_Model->get_list('page', array('slug' => 'gallery'));
            $data['images'] = $this->Site_Model->get_list('gallery', null, array('image'));
            $this->cache->save('site_gallery', $data, 900);
        }


        $this->page_title = $data['gallery'][0]->title;
        $this->current_section = $data['gallery'][0]->title;
        $data['url_page'] = "page_gallery";
        $this->body_class[] = 'gallery';
        $this->page_meta_keywords = $data['gallery'][0]->meta_keys;
        $this->page_meta_description = $data['gallery'][0]->meta_desc;
        $this->render_page('gallery/index', $data);
    }

}
