<?php

class Gprsprinter extends MY_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Gprsprinter_Model');
        $this->load->helper('site');
    }
    public function callback($rest_id = false, $order_id = false, $action = false, $msg = false, $delivery_time = false) {
        mail('aktarcse152@gmail.com', 'PrinterCallback', $this->input->server('QUERY_STRING'));
        $m1 = explode('_', $msg);
        $msg = implode(' ', $m1);
        $rest_id = ($rest_id == false) ? $this->input->get_post('a') : $rest_id;
        $order_id = ($order_id == false) ? $this->input->get_post('o') : $order_id;
        $action = ($action == false) ? $this->input->get_post('ak') : $action;
        $delivery_time = ($delivery_time == false) ? date("Y-m-d") . ' ' . $this->input->get_post('dt') : date("Y-m-d") . ' ' . $delivery_time;
        $msg = ($msg == false) ? $this->input->get_post('m') : $msg;
        switch ($action) {
            case 'Accepted':
                $success = false;
                if ($delivery_time != null) {
                    $success = $this->db->update('gkpos_order', array('online_status' => 1, 'delivery_time' => $delivery_time, 'has_print' => 0, 'is_printed' => 1, 'message' => $msg), array('id' => $order_id));
                } else {
                    $success = $this->db->update('gkpos_order', array('online_status' => 1, 'delivery_time' => $delivery_time, 'has_print' => 0, 'is_printed' => 1, 'message' => $msg), array('id' => $order_id));
                }
                if ($success) {
                    if ($this->notify_customer($order_id)) {
                        $s1 = true;
                        sleep(5);
                        $s2 = $this->notify_admin($order_id);
                    }
                }
                break;
            case 'Rejected':
                $success = $this->db->update('gkpos_order', array('online_status' => 2, 'message' => $msg, 'has_print' => null, 'is_printed' => null, 'sent_option' => null), array('id' => $order_id));
                if ($success) {
                    if ($this->notify_customer($order_id)) {
                        $s1 = true;
                        sleep(5);
                        $s2 = $this->notify_admin($order_id);
                    }
                }
                break;
            default:
                echo 'ack is not valid!';
                exit;
        }
    }

    public function notify_customer($id) {
        if ($this->Gprsprinter_Model->exists('gkpos_order', 'id', $id)) {
            $order = $this->Gprsprinter_Model->get_single('gkpos_order', array('id' => $id));
            $data['recipent'] = $order->name;
            $data['to'] = $order->email;
            $data['from'] = $this->config->item('gk_email');
            $data['from_title'] = $this->config->item('gk_name');
            if ($order->online_status == 1) {
                $data['subject'] = "Order confirmation from " . $this->config->item('gk_name');
                $data['txt'] = $order->online_type = "collection" ? "You are requested to collect your order #" . strtoupper($order->id) . " from  us at " . $order->delivery_time : ". Your order #" . strtoupper($order) . " will be delivered at your order delivery address around " . $order->delivery_time;
            }
            if ($order->online_status == 2) {
                $data['subject'] = "Order Rejection from " . $this->config->item('gk_name');
                $data['txt'] = "Your order # " . strtoupper($order->id) . " has been rejected from " . $this->config->item('gk_name') . ' Restaurant';
                if ($order->message != null) {
                    $data['txt'].="<br/> Rejected Reason: " . $order->message;
                }
            }
            $data['verify_link'] = null;
            $data['message'] = $this->load->view('email_template/common', $data, true);
            if ($this->send_email($data)) {
                return true;
            } else {
                return false;
            }
        }
    }

    public function notify_admin($id) {
        if ($this->Gprsprinter_Model->exists('gkpos_order', 'id', $id)) {
            $order = $this->Gprsprinter_Model->get_single('gkpos_order', array('id' => $id));
            $data['recipent'] = 'Admin';
            $data['to'] = $this->config->item('gk_email');
            $data['from'] = 'info@website';
            $data['from_title'] = $this->config->item('gk_name');
            if ($order->online_status == 1) {
                $data['subject'] = "Customer order confirmation from " . $this->config->item('gk_name');
                $data['txt'] = $order->online_type = "collection" ? "Please ensure that the customer can collect order #" . strtoupper($order->id) . " from " . $this->config->item('gk_name') . ' Restaurant at around ' . $order->delivery_time : "Please ensure that the order #" . strtoupper($order->id) . " delivered at customer delivery address around " . $order->delivery_time;
            }
            if ($order->online_status == 2) {
                $data['subject'] = "Order Rejection from " . $this->config->item('gk_name');
                $data['txt'] = "Customer order # " . strtoupper($order->id) . " has been rejected from Your restaurant";
                if ($order->message != null) {
                    $data['txt'].="<br/> Reject Reason " . $order->message;
                }
            }
            $data['verify_link'] = null;
            $data['message'] = $this->load->view('email_template/common', $data, true);
            if ($this->send_email($data)) {
                return true;
            } else {
                return false;
            }
        }
    }

    public function orderrequest($rest_id = false, $user = false, $password = false) {
      //  mail('parveskamran@gmail.com', 'Printer', $this->input->server('QUERY_STRING'));
        echo $this->Gprsprinter_Model->getgprsprinter_pendings_feed();
    }

}
