<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Onlineorder extends Public_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Site_Model');
        $this->load->model('User_Model');
        $this->load->model('Customer_Model');
        $this->load->helper('site');
        $this->site_title = $this->config->item('gk_name');
    }

    public function checklogin() {
        $status = $this->User_Model->is_logged_in();
        $isRestaaurantOpened = $this->isRestaaurantOpened;
        if ($isRestaaurantOpened) {
            $this->Site_Model->clear_preorder();
        }
        $preorder = $this->Site_Model->get_preorder() == 'yes' ? 'yes' : 'no';
        echo json_encode(array('status' => $status ? true : false, 'isRestaaurantOpened' => $isRestaaurantOpened ? true : false, 'preorder' => $preorder));
    }

    public function preordercheck() {
        $preorder = $this->input->post('preorder');
        $this->Site_Model->set_preorder($preorder);
        $preorder = $this->Site_Model->get_preorder() == 'yes' ? 'yes' : 'no';
        echo json_encode(array('preorder' => $preorder));
    }

    public function index() {
        $this->db->flush_cache();
        $data = array();
        if ($this->cache->get('site_onlineorder')) {
            $data = $this->cache->get('site_onlineorder');
        } else {
            $data['pageOnlineOrder'] = $this->Site_Model->get_list('page', array('slug' => 'onlineorder'));
            $data['categories'] = $this->Site_Model->get_list('gkpos_category', array('status' => 1, 'online' => 1), null, null, 0, 'order', 'ASC');
            $menus = array();
            foreach ($data['categories'] as $category) {
                $menus[$category->id] = $this->Site_Model->get_list('gkpos_menu', array('category' => $category->id, 'status' => 1, 'online' => 1), null, null, 0, 'order', 'ASC');
            }
            $data['menus'] = $menus;
            $selections = array();
            foreach ($menus as $menu) {
                if ($menu != null) {
                    foreach ($menu as $selection) {
                        $selections[$selection->category][$selection->id] = $this->Site_Model->get_list('gkpos_selection', array('category' => $selection->category, 'menu' => $selection->id, 'status' => 1, 'online' => 1), null, null, 0, 'order', 'ASC');
                    }
                }
            }
            $data['selections'] = $selections;
            $data['allDeals'] = $deals = $this->Site_Model->get_list('meal_deal', null, null, null, 0, 'order', 'ASC');
            $deal_sets = array();
            $deal_set_menus = array();
            if (!empty($deals)) {
                foreach ($deals as $deal) {
                    $deal_sets[$deal->id] = $dealSets = $this->Site_Model->get_list('meal_deal_set', array('deal' => $deal->id), null, null, 0, 'id', 'ASC');
                    foreach ($dealSets as $dealSet) {
                        $deal_set_menus[$deal->id][$dealSet->id] = $this->Site_Model->get_list('meal_deal_menu', array('deal' => $deal->id, 'set' => $dealSet->id), null, null, 0, 'menu', 'ASC');
                    }
                }
            }
            $data['deal_sets'] = $deal_sets;
            $data['deal_set_menus'] = $deal_set_menus;
            $service_time = $this->Site_Model->get_list('servicetime');
            $servicetime_arr = array();
            foreach ($service_time as $st) {
                $servicetime_arr[$st->day] = $st;
            }
            $data['service_time'] = $servicetime_arr;
            $data['isRestaaurantOpened'] = $this->isRestaaurantOpened;
            $data['hasDeliveryPlan'] = $this->hasDeliveryPlan;
            $data['promotions'] = $promotions = $this->Site_Model->get_promostions();
            $this->cache->save('site_onlineorder', $data, 1800);
        }
        $home = $data['pageOnlineOrder'];
        $this->page_title = $home[0]->title;
        $this->current_section = $home[0]->title;
        $data['url_page'] = "page_menu";
        $this->body_class[] = 'online-order';
        $this->page_meta_keywords = $home[0]->meta_keys;
        $this->page_meta_description = $home[0]->meta_desc;
        $data['cart_filler'] = $this->load->view('onlineorder/cart_filler', array(), true);
        $this->render_page('onlineorder/index', $data);
    }

    public function addtocart() {
        $isRestaaurantOpened = $this->isRestaaurantOpened;
        $preorder = $this->Site_Model->get_preorder() == 'yes' ? 'yes' : 'no';
        if ($isRestaaurantOpened || $preorder == 'yes') {
            $data = $this->input->post();
            $result = $this->Site_Model->addtocart($data);
            echo json_encode($result);
        } else {
            echo json_encode(array('success' => false, 'item' => array(), 'line' => 0));
        }
    }

    public function loadcart() {
        $data = array();
        $obj = $this->Site_Model;
        $data['cart'] = $obj->get_cart();
        if ($obj->cart_configuration($obj->get_order_type())) {
            $data['subtotal'] = $obj->get_subtotal();
            $data['vat'] = $obj->get_vat_amount();
            $data['order_type'] = $obj->get_order_type();
            $data['discount'] = $obj->get_discount_amount();
            $data['bogodiscount'] = $obj->get_bogodiscount_amount();
            $data['cross_promotion'] = $obj->get_cross_promotion();
            $data['cross_promo_amount'] = $obj->get_cross_promotion_amount();
            $data['deliveryPlan'] = $obj->get_deliveryplan();
            $data['delivery_time'] = !empty($data['deliveryPlan']) ? $data['deliveryPlan']['delivery_time'] : $this->config->item('default_delivery_time');
            $data['total'] = $obj->get_total();
            $data['cc_fee'] = $obj->get_cc_fee();
        }
        $data['hasDeliveryPlan'] = $this->hasDeliveryPlan;
        $this->load->view('onlineorder/cart', $data, false);
    }

    public function loadcart_checkout() {
        $data = array();
        $obj = $this->Site_Model;
        $data['cart'] = $obj->get_cart();
        $data['online_methods'] = $this->Site_Model->get_list('payment_gateway', array('type' => 'online', 'status' => 1));
        $data['online_method'] = $this->Site_Model->get_online_method();
        if ($obj->cart_configuration($obj->get_order_type())) {
            $data['subtotal'] = $obj->get_subtotal();
            $data['vat'] = $obj->get_vat_amount();
            $data['order_type'] = $obj->get_order_type();
            $data['discount'] = $obj->get_discount_amount();
            $data['bogodiscount'] = $obj->get_bogodiscount_amount();
            $data['cross_promotion'] = $obj->get_cross_promotion();
            $data['cross_promo_amount'] = $obj->get_cross_promotion_amount();
            $data['deliveryPlan'] = $obj->get_deliveryplan();
            $data['delivery_condition'] = 'fullfilled';
            if (!empty($data['deliveryPlan'])) {
                $data['delivery_condition'] = $this->Site_Model->get_subtotal() >= $data['deliveryPlan']['min_order'] ? 'fullfilled' : 'notfullfilled';
            }
            $data['delivery_time'] = !empty($data['deliveryPlan']) ? $data['deliveryPlan']['delivery_time'] : $this->config->item('default_delivery_time');
            $data['total'] = $obj->get_total();
            $data['cc_fee'] = $obj->get_cc_fee();
            $data['hasDeliveryPlan'] = $this->hasDeliveryPlan;
        }
        $this->load->view('onlineorder/cart_checkout', $data, false);
    }

    public function reduce_item() {
        $line = $this->input->post('line');
        if ((int) $line >= 1) {
            echo json_encode($this->Site_Model->reduce_item($line));
        }
    }

    public function increment_item() {
        $line = $this->input->post('line');
        if ((int) $line >= 1) {
            echo json_encode($this->Site_Model->increment_item($line));
        }
    }

    public function remove_item() {
        $line = $this->input->post('line');
        if ((int) $line >= 1) {
            echo json_encode($this->Site_Model->remove_item($line));
        }
    }

    public function fixordertype() {
        $order_type = $this->input->post('order_type');
        $this->Site_Model->clear_all_discount();
        $this->Site_Model->set_order_type($order_type);
        if ($this->Site_Model->get_order_type()) {
            echo json_encode(array('success' => true));
        } else {
            echo json_encode(array('success' => false));
        }
    }

    public function checkdeliveryplan() {
        $this->Site_Model->clear_all_discount();
        $this->Site_Model->set_order_type('online_delivery');
        $postcode = postcodeFormat($this->input->post('postcode'));
        $success = $this->_manage_deliveryplan($postcode);
        if ($success && $this->Site_Model->get_delivery_postcode()) {
            $this->db->select('house, building, floor_or_apt, street, city, postcode');
            $this->db->where('phone', $this->session->userdata('online_userphone'));
            $this->db->where('postcode', $postcode);
            $this->db->limit(1);
            $delivery_address = $this->db->get('gkpos_order')->row_array();
            if (!empty($delivery_address)) {
                $this->Site_Model->set_delivery_address($delivery_address);
            } else {
                $this->Site_Model->set_delivery_address($this->primary_address());
            }
        }
        if ($this->Site_Model->get_order_type() == 'online_delivery' && $success) {
            echo json_encode(array('success' => true, 'postcode' => $postcode));
        } else {
            echo json_encode(array('success' => false, 'message' => 'Sorry, We do not provide delivery service this area'));
        }
    }

    private function _manage_deliveryplan($postcode) {
        $postcode_arr = explode(' ', $postcode);
        $initial_code = strtoupper($postcode_arr[0]);
        $success = false;
        $deliveryPlan = $this->Site_Model->get_single_array('gkpos_deliveryplan', array('status' => 1, 'initial_code' => $initial_code), array('id', 'is_free', 'delivery_charge', 'min_order', 'delivery_time'));
        if (!empty($deliveryPlan)) {
            if ((int) $deliveryPlan['delivery_charge'] > 0) {
                $this->Site_Model->set_delivery_postcode($postcode);
                $this->Site_Model->set_deliveryplan($deliveryPlan);
                $success = true;
            } else {
                if (trim($this->config->item('deliveryplan_google') == 'yes')) {
                    $deliveryDistance = get_delivery_distance(postcodeFormat($this->config->item('deliveryplan_source_postcode')), $postcode);
                    if ($deliveryDistance <= $this->config->item('deliveryplan_radius_distance')) {
                        if ($deliveryDistance > $this->config->item('deliveryplan_offset')) {
                            $deliveryPlan['is_free'] = 2;
                            $paidDistance = $deliveryDistance - (double) $this->config->item('deliveryplan_offset');
                            $deliveryPlan['delivery_charge'] = $paidDistance * (double) $this->config->item('deliveryplan_rate');
                        } else {
                            $deliveryPlan['delivery_charge'] = 0;
                        }
                        $this->Site_Model->set_delivery_postcode($postcode);
                        $this->Site_Model->set_deliveryplan($deliveryPlan);
                        $success = true;
                    } else {
                        $success = false;
                        $this->Site_Model->clear_deliveryplan();
                        $this->Site_Model->clear_delivery_address();
                        $this->Site_Model->clear_delivery_postcode($postcode);
                    }
                }
            }
        } else {
            $this->Site_Model->clear_deliveryplan();
            $this->Site_Model->clear_delivery_address();
            $this->Site_Model->clear_delivery_postcode($postcode);
        }
        return $success;
    }

    public function manage_delivery_time() {
        $time = $this->input->post('time');
        $this->Site_Model->set_delivery_time($time);
        if ($this->Site_Model->get_delivery_time()) {
            echo json_encode(array('status' => true, 'time' => $this->Site_Model->get_delivery_time()));
        }
    }

    public function checkout() {
        $cart = $this->Site_Model->get_cart();
        if (!$this->User_Model->is_logged_in() || empty($cart)) {
            if ($this->config->item('website_style') == 'singlepage') {
                redirect(base_url() . '#food-menu');
            } else {
                redirect(base_url() . 'onlineorder');
            }
        } else {
            $service_time = $this->Site_Model->get_list('servicetime');
            $servicetime_arr = array();
            foreach ($service_time as $st) {
                $servicetime_arr[$st->day] = $st;
            }
            $data['service_time'] = $servicetime_arr;
            $data['url_page'] = "page_menu";
            $this->page_title = "Checkout";
            $this->current_section = "Checkout";
            $data['order_type'] = $this->Site_Model->get_order_type();
            $data['promotion'] = $this->Site_Model->get_promotion();
            if ($data['order_type'] == 'online_delivery') {
                $deliveryPlan = $this->Site_Model->get_deliveryplan();
                $subtotal = $this->Site_Model->get_subtotal();
                if ($subtotal < $deliveryPlan['min_order']) {
                    if ($this->config->item('website_style') == 'singlepage') {
                        redirect(base_url() . '#food-menu');
                    } else {
                        redirect(base_url() . 'onlineorder');
                    }
                }
                $data['delivery_postcode'] = $this->Site_Model->get_delivery_postcode();
                $data['primary'] = $this->Customer_Model->get_list('gkpos_customer', array('phone' => $this->session->userdata('online_userphone'), 'email' => $this->session->userdata('online_useremail')));
                $data['secondary'] = $this->Customer_Model->get_customer_address($this->session->userdata('online_userphone'));
            }
            $timer = $this->get_delivery_time();
            $data['delivery_address'] = $this->Site_Model->get_delivery_address();
            $data['online_method'] = $this->Site_Model->get_online_method();
            $data['delivery_time'] = $timer['delivery_time'];
            $data['saved_delivery_time'] = $this->Site_Model->get_delivery_time();
            $data['timePickStart'] = $timer['timePickStart'];
            $data['time_slot'] = $timer['time_slot'];
            $data['isRestaaurantOpened'] = $this->isRestaaurantOpened;
            $data['hasDeliveryPlan'] = $this->hasDeliveryPlan;
            $data['online_methods'] = $this->Site_Model->get_list('payment_gateway', array('type' => 'online', 'status' => 1));
            $this->render_page('onlineorder/checkout', $data);
        }
    }

    private function get_delivery_time() {
        $now = date($this->config->item('timeformat'));
        $order_type_str = $this->Site_Model->get_order_type();
        $order_type_arr = explode('_', $order_type_str);
        $nowDate = new DateTime($now);
        $nowDate->add(new DateInterval('PT' . $this->config->item('default_' . $order_type_arr[1] . '_time') . 'M'));
        $nowTime = $nowDate->format('h:i a');

        $sevenDays = $this->Site_Model->get_list('servicetime');
        $week = array();
        foreach ($sevenDays as $key => $day) {
            $week[$day->day] = $day;
        }
        $opened = $week[strtolower(date('D'))]->open;
        $openedObj = new DateTime($opened);
        $openingTime = $openedObj->format('h:i a');
        $closed = $week[strtolower(date('D'))]->closed;
        $closedObj = new DateTime($closed);
        $interval = $openedObj->diff($closedObj);
        $totalMins = 0;
        if ($interval->h >= 1) {
            $totalMins += $interval->h * 60;
        }
        if ($interval->i >= 1) {
            $totalMins += $interval->i;
        }
        $timeSlotIndex = ceil($totalMins / 10);
        $timeSlot = array();
        for ($i = 0; $i < $timeSlotIndex; $i++) {
            $nowSlotDate = new DateTime($openingTime);
            $nowSlotDate->add(new DateInterval('PT10M'));
            $nowSlotTime = $nowSlotDate->format('h:i a');
            $timeSlot[] = $nowSlotTime;
            $openingTime = $nowSlotTime;
        }
        return array('timePickStart' => $nowTime, 'delivery_time' => $nowTime, 'time_slot' => $timeSlot);
    }

    public function promotion() {
        if (!$this->User_Model->is_logged_in()) {
            redirect('user');
        }
        $code = $this->input->post('txtpromocode');
        $promotion = array();
        if ($code != null) {
            $this->db->where('code', $code);
            $this->db->where('status', 1);
            $this->db->where('is_opened', 1);
            $this->db->where('start <=', date('Y-m-d'));
            $this->db->where('end >=', date('Y-m-d'));
            $promotion = $this->db->get('promotion')->row();
        }
        $success = false;
        $message = null;
        if (empty($promotion)) {
            echo json_encode(array('success' => $success, 'message' => 'Sorry! Invalid voucher code'));
            exit();
        } else {
            if ($promotion->min_order > $this->Site_Model->get_subtotal()) {
                echo json_encode(array('success' => $success, 'message' => 'Sorry, you have not yet exceeded ' . to_currency($promotion->min_order)));
                exit();
            } else {
                if ($promotion->used_as == 1) {
                    $HasSingleConsumed = $this->Site_Model->get_single('gkpos_order', array('phone' => $this->session->userdata('online_userphone'), 'email' => $this->session->userdata('online_useremail'), 'promo_code' => $promotion->code));
                    if (!empty($HasSingleConsumed)) {
                        echo json_encode(array('success' => $success, 'message' => 'Sorry, Your voucher code quota already consumed'));
                        exit();
                    }
                }
                $order_type = $this->Site_Model->get_order_type();
                if ($order_type == 'online_collection' && $promotion->collection != 'yes') {
                    echo json_encode(array('success' => $success, 'message' => 'Sorry, Your voucher code not for ' . $order_type));
                    exit();
                }
                if ($order_type == 'online_delivery' && $promotion->delivery != 'yes') {
                    echo json_encode(array('success' => $success, 'message' => 'Sorry, Your voucher code not for ' . $order_type));
                    exit();
                }
                $sessionPromotion = $this->Site_Model->get_promotion();

                if (!empty($sessionPromotion) && $sessionPromotion['code'] == $promotion->code) {
                    echo json_encode(array('success' => $success, 'message' => 'Sorry, It Seems You have already applied it'));
                    exit();
                }
                $data = array(
                    'code' => $promotion->code,
                    'number' => $promotion->amount,
                    'func' => $promotion->function,
                    'collection' => $promotion->collection,
                    'delivery' => $promotion->delivery,
                    'allow_cross' => $promotion->allow_cross,
                    'food' => $promotion->food,
                    'nonfood' => $promotion->nonfood,
                    'min_order' => $promotion->min_order
                );
                $this->Site_Model->set_promotion($data);
                if ($this->Site_Model->get_promotion()) {
                    $this->Site_Model->clear_discount_on();
                    $this->Site_Model->clear_min_order_discounted_amount();
                    $this->Site_Model->clear_discount();
                    $promotion_arr = $this->Site_Model->get_promotion();
                    if ($promotion_arr['allow_cross'] == '0') {
                        $this->Site_Model->set_discount_on(array('food' => $promotion_arr['food'], 'nonfood' => $promotion_arr['nonfood']));
                        $this->Site_Model->set_min_order_discounted_amount($promotion_arr['min_order']);
                        $this->Site_Model->clear_cross_promotion();
                    } else {
                        $this->Site_Model->set_cross_promotion('yes');
                    }
                    $success = true;

                    $offer_amount = $promotion_arr['func'] == 'percent' ? $promotion_arr['number'] . '%' : to_currency($promotion_arr['number']);
                    $food_type = $promotion_arr['food'] == 'yes' ? 'food' : '';
                    $food_type .= $promotion_arr['nonfood'] = 'yes' ? ' nonfood' : '';
                    $message = 'Successfully Applied, Enjoy' . $offer_amount . ' promotional offer on ' . $food_type;
                } else {
                    $success = false;
                    $message = "Your voucher code application failed";
                }
                echo json_encode(array('success' => $success, 'message' => $message));
            }
        }
    }

    public function remove_promotion() {
        $this->Site_Model->clear_all_discount();
        if (!$this->Site_Model->get_discount() && !$this->Site_Model->get_promotion()) {
            echo json_encode(array('success' => true, 'message' => "Your voucher code removed successfully"));
        } else {
            echo json_encode(array('success' => false, 'message' => "Your voucher code removal failed"));
        }
    }

    public function get_primary_address() {
        $primary = $this->Customer_Model->get_single('gkpos_customer', array('phone' => $this->session->userdata('online_userphone'), 'email' => $this->session->userdata('online_useremail')), array('house', 'building', 'floor_or_apt', 'street', 'city', 'postcode'));
        $success = false;
        $success_deliveryPlan = false;
        if (!empty($primary)) {
            $success = true;
            $this->Site_Model->set_delivery_address(objectToArray($primary));
            $postcode = postcodeFormat($primary->postcode);
            $success_deliveryPlan = $this->_manage_deliveryplan($postcode);
            $delivery_condition = true;
            if ($this->Site_Model->get_deliveryplan() && $success_deliveryPlan) {
                $plan = $this->Site_Model->get_deliveryplan();
                $delivery_condition = $plan['min_order'] > $this->Site_Model->get_subtotal() ? false : true;
            }
        }
        echo json_encode(array('success' => $success, 'deliveryPlan' => $success_deliveryPlan, 'deliveryCondtion' => $delivery_condition, 'address' => objectToArray($primary)));
    }

    private function primary_address() {
        $primary = $this->Customer_Model->get_single_array('gkpos_customer', array('phone' => $this->session->userdata('online_userphone'), 'email' => $this->session->userdata('online_useremail')), array('house', 'building', 'floor_or_apt', 'street', 'city', 'postcode'));
        return $primary;
    }

    public function get_secondary_address() {
        $address = trim($this->input->post('address'));
        $exploded_address = explode('_', $address);
        $street = $exploded_address[0];
        $city = $exploded_address[1];
        $postcode = postcodeFormat($exploded_address[2]);
        $success_deliveryPlan = $this->_manage_deliveryplan($postcode);
        $this->db->select('house, building, floor_or_apt, street, city, postcode');
        $this->db->where('phone', $this->session->userdata('online_userphone'));
        $this->db->where('email', $this->session->userdata('online_useremail'));
        $this->db->where('postcode', $postcode);
        $this->db->where('street', $street);
        $this->db->or_where('city', $city);
        $this->db->limit(1);
        $secondary = $this->db->get('gkpos_order')->row();
        $delivery_condition = true;
        if ($this->Site_Model->get_deliveryplan() && $success_deliveryPlan) {
            $plan = $this->Site_Model->get_deliveryplan();
            $delivery_condition = $plan['min_order'] > $this->Site_Model->get_subtotal() ? false : true;
        }
        if (!empty($secondary)) {
            echo json_encode(array('success' => true, 'deliveryPlan' => $success_deliveryPlan, 'deliveryCondtion' => $delivery_condition, 'address' => objectToArray($secondary)));
        } else {
            echo json_encode(array('success' => false));
        }
    }

    public function process_ccfee() {
        $gateway = $this->input->post('gateway');
        $this->Site_Model->set_online_method($gateway);
        if ($gateway == 'cod') {
            $this->Site_Model->clear_cc_fee();
            echo json_encode(array('success' => true, 'ccFee' => 0));
        } else {
            $gatewayRow = $this->Site_Model->get_single('payment_gateway', array('title' => $gateway));
            $ccFee = !empty($gatewayRow) ? $gatewayRow->cc_fee : 0;
            $this->Site_Model->set_cc_fee($ccFee);
            if ($this->Site_Model->get_cc_fee()) {
                echo json_encode(array('success' => true, 'ccFee' => $ccFee));
            } else {
                echo json_encode(array('success' => false, 'ccFee' => $ccFee));
            }
        }
    }

    public function clear_ccfee() {
        $this->Site_Model->clear_cc_fee();
        if (!$this->Site_Model->get_cc_fee()) {
            $this->Site_Model->clear_online_method();
            $this->Site_Model->set_online_method('cod');
            echo json_encode(array('success' => true));
        } else {
            echo json_encode(array('success' => true));
        }
    }

    public function checkout_verification() {
        $data = $this->prepareData();
        $order_type = $this->Site_Model->get_order_type();
        $success_deliveryPlan = false;
        if ($order_type == 'online_delivery') {
            $postcode = postcodeFormat($data['postcode']);
            $deliveryPostcode = $this->Site_Model->get_delivery_postcode();
            if (trim(strtolower(str_replace(' ', '', $postcode))) != trim(strtolower(str_replace(' ', '', $deliveryPostcode)))) {
                $this->Site_Model->clear_deliveryplan();
                $result = $this->Site_Model->cart_configuration('online_delivery');
                $success_deliveryPlan = $this->_manage_deliveryplan($postcode);
                if ($result && $success_deliveryPlan) {
                    $this->Site_Model->cart_configuration('online_delivery');
                }
            } else {
                $success_deliveryPlan = true;
            }
            $delivery_address = array(
                'house' => $data['house'],
                'building' => $data['building'],
                'floor_or_apt' => $data['floor_or_apt'],
                'street' => $data['street'],
                'city' => $data['city'],
                'postcode' => $data['postcode'],
            );
            $this->Site_Model->set_delivery_address($delivery_address);
        } else {
            $this->Site_Model->clear_deliveryplan();
            $this->Site_Model->clear_delivery_address();
        }
        $data['order_type'] = 'online';
        $order_type_arr = explode('_', $order_type);
        $data['online_type'] = strtolower($order_type_arr[1]);
        $data['online_method'] = strtolower($data['online_method']);
        $this->Site_Model->set_checkout_data($data);
        $delivery_condition = true;
        if ($this->Site_Model->get_deliveryplan() && $success_deliveryPlan) {
            $plan = $this->Site_Model->get_deliveryplan();
            $delivery_condition = $plan['min_order'] > $this->Site_Model->get_subtotal() ? false : true;
        }
        $success = false;
        if ($order_type == 'online_delivery' && $success_deliveryPlan && $this->Site_Model->get_checkout_data()) {
            $primaryAddress = $this->primary_address();
            if (trim($primaryAddress['postcode']) == null || trim($primaryAddress['street']) == null) {
                $delivery_address = $this->Site_Model->get_delivery_address();
                $this->db->update('gkpos_customer', $delivery_address, array('phone' => $this->session->userdata('online_userphone'), 'email' => $this->session->userdata('online_useremail')));
            }
            $success = true;
        } else {
            if ($order_type == 'online_collection' && !$success_deliveryPlan && $this->Site_Model->get_checkout_data()) {
                $success = true;
            }
        }
        echo json_encode(array('success' => $success, 'deliveryCondition' => $delivery_condition, 'deliveryPlan' => $success_deliveryPlan));
    }

    public function reset_deliveryplan() {
        $this->Site_Model->clear_deliveryplan();
        $this->Site_Model->clear_delivery_address();
        $this->Site_Model->clear_delivery_postcode();
        if (!$this->Site_Model->get_deliveryplan() && !$this->Site_Model->get_delivery_address() && !$this->Site_Model->get_delivery_postcode()) {
            echo json_encode(array('success' => true));
        } else {
            echo json_encode(array('success' => true));
        }
    }

    public function processing() {
        $data['url_page'] = "page_menu";
        $this->page_title = "Order Processing";
        $checkoutInfo = $this->Site_Model->get_checkout_data();
        $is_processing = false;
        if (!empty($checkoutInfo)) {
            $data['processing'] = 'Processing, Please wait....';
            $is_processing = true;
        } else {
            $is_processing = false;
            $data['processing'] = 'Processing failed, Please try again....';
        }
        $this->render_page('onlineorder/processing', $data);
    }

    public function processorder() {
        $checkoutInfo = $this->Site_Model->get_checkout_data();
        $success = false;
        if (!empty($checkoutInfo)) {
            $cc_fee = $this->Site_Model->get_cc_fee();
            if ($cc_fee != null || $cc_fee > 0) {
                $checkoutInfo['cc_fee'] = $cc_fee;
            }
            if ($checkoutInfo['online_type'] == 'delivery') {
                $checkoutInfo['email'] = $this->session->userdata('online_useremail');
            } else {
                $checkoutInfo['email'] = $this->session->userdata('online_useremail');
                $checkoutInfo['phone'] = $this->session->userdata('online_userphone');
                $checkoutInfo['name'] = $this->db->where('email', $this->session->userdata('online_useremail'))->get('gkpos_customer')->row()->name;
            }
            $checkoutInfo['status'] = 2;
            $promotion = $this->Site_Model->get_promotion();
            if (!empty($promotion)) {
                $checkoutInfo['promo_code'] = $promotion['code'];
            }
            if ($this->Site_Model->get_cross_promotion() == 'yes') {
                $checkoutInfo['promo_amount'] = $this->Site_Model->get_cross_promotion_amount();
            }
            if ($this->Site_Model->get_deliveryplan()) {
                $deliveryplan = $this->Site_Model->get_deliveryplan();
                if ($deliveryplan['is_free'] == 2) {
                    $checkoutInfo['delivery_charge'] = $deliveryplan['delivery_charge'];
                }
            }
            $checkoutInfo['order_total'] = $this->Site_Model->get_subtotal();
            $checkoutInfo['grand_total'] = $this->Site_Model->get_total();
            $checkoutInfo['bogo_discount'] = $this->Site_Model->get_bogodiscount_amount() ? $this->Site_Model->get_bogodiscount_amount() : '0';
            $this->db->trans_start();
            $order = $this->save_order($checkoutInfo);
            if (!empty($order)) {
                $this->Site_Model->set_current_orderid($order->id);
            }
            if (!empty($order) && $this->Site_Model->get_cart()) {
                $this->save_order_detail($order->id);
            }
            if ($this->Site_Model->get_discount() && $this->Site_Model->get_discount_amount()) {
                $this->save_order_discount($order->id);
            }
            if ($this->Site_Model->get_vat() && $this->Site_Model->get_vat_amount()) {
                $this->save_order_vat($order->id);
            }
            $this->db->trans_complete();
            $success = $this->db->trans_status();
        }
        echo json_encode(array('success' => $success));
    }

    private function save_order($data) {
        $data['id'] = $this->Site_Model->get_key();
        if ($data['online_method'] != 'cod') {
            $data['online_status'] = 3;
        }
        $data['created'] = date('Y-m-d H:i:s');
        if ($this->db->insert("gkpos_order", $data)) {
            return $this->Site_Model->get_single('gkpos_order', array('id' => $data['id'], 'phone' => $data['phone'], 'email' => $data['email']));
        } else {
            return array();
        }
    }

    private function save_order_detail($order_id) {
        $cart = $this->Site_Model->get_cart();
        if (!empty($cart)) {
            foreach ($cart as $item) {
                $item['order_id'] = $order_id;
                unset($item['bogo']);
                unset($item['bogo_discount_on']);
                unset($item['deal']);
                $this->db->insert('gkpos_order_detail', $item);
            }
            return true;
        } else {
            return false;
        }
    }

    private function save_order_discount($order_id) {
        $discount_data = $this->Site_Model->get_discount();
        if (!empty($discount_data)) {
            $discount_amount = 0;
            $corss_promotion_amount = 0;
            if ($this->Site_Model->get_discount_amount()) {
                $discount_amount = $this->Site_Model->get_discount_amount();
            }
            if ($this->Site_Model->get_cross_promotion_amount()) {
                $corss_promotion_amount = $this->Site_Model->get_cross_promotion_amount();
            }
            $discount_data['amount'] = $discount_amount + $corss_promotion_amount;
            $discount_data['order_id'] = $order_id;
            return $this->db->insert('gkpos_order_discount', $discount_data);
        }
    }

    private function save_order_vat($order_id) {
        $vat_data = $this->Site_Model->get_vat();
        if (!empty($vat_data)) {
            $vat_data['amount'] = $this->Site_Model->get_vat_amount() ? $this->Site_Model->get_vat_amount() : 0;
            $vat_data['order_id'] = $order_id;
            return $this->db->insert('gkpos_order_vat', $vat_data);
        } else {
            return false;
        }
    }

    public function forwarding() {
        $data['url_page'] = 'onlineorder';
        $this->page_title = "Forwarding";
        $this->current_section = "Order Forwarding";
        $order_id = $this->Site_Model->get_current_orderid();
        $order = $this->Site_Model->get_single('gkpos_order', array('id' => $order_id));
        if (!empty($order)) {
            $success = $this->db->update('gkpos_order', array('status' => 3), array('id' => $order->id));
            if ($success && $order->order_type == 'online' && $order->online_method == 'cod') {
                if ($this->notify_customer($order->id)) {
                    sleep(1);
                    if ($this->notify_admin($order->id)) {
                        redirect('onlineorder/confirming/' . $order->id);
                    }
                } else {
                    redirect('onlineorder/confirming/' . $order->id);
                }
            }
            if ($success && $order->order_type == 'online' && $order->online_method != 'cod') {
                $this->paymentgateway($order->id);
            }
        }
    }

    public function paymentgateway($order_id) {
        if ($this->Site_Model->exists('gkpos_order', 'id', $order_id)) {
            $order = $this->Site_Model->get_single('gkpos_order', array('id' => $order_id));
            $data['order_id'] = $order->id;
            $data['total'] = $order->grand_total;
            $method = strtolower($order->online_method);
            $data['gateway_info'] = $this->Site_Model->get_list('payment_gateway', array('title' => strtoupper($method)));
            $data['processing'] = 'progressing to ' . $method . ' payment gateway';
            $data['url_page'] = 'onlineorder';
            $this->page_title = "Online Order";
            $this->render_page('onlineorder/gateway/' . $method, $data);
        }
    }

    public function process_stripe($orderid) {
        if ($orderid && $this->Site_Model->exists('gkpos_order', 'id', $orderid)) {
            $order = $this->Site_Model->get_single('gkpos_order', array('id' => $orderid));
            $stripe = $this->Site_Model->get_single('payment_gateway', array('title' => strtoupper('stripe')));
            $stripeSecretKey = null;
            if (!empty($stripe)) {
                $stripeSecretKey = $stripe->is_live == 2 ? $stripe->callback_url : $stripe->cancel_url;
            }
            require APPPATH . '/libraries/stripe/init.php';
            \Stripe\Stripe::setApiKey($stripeSecretKey);
            $errorArray = array();
            $charge = array();
            try {
                $infoArray = array(
                    'amount' => to_currency_no_money($order->grand_total) * 100,
                    'currency' => 'GBP',
                    'description' => $orderid,
                    'source' => $this->input->post('stripeToken'),
                );
                $charge = \Stripe\Charge::create($infoArray);
            } catch (\Stripe\Error\Card $e) {
                array_push($errorArray, $e->getMessage());
            } catch (\Stripe\Error\RateLimit $e) {
                array_push($errorArray, $e->getMessage());
            } catch (\Stripe\Error\InvalidRequest $e) {
                array_push($errorArray, $e->getMessage());
            } catch (\Stripe\Error\Authentication $e) {
                array_push($errorArray, $e->getMessage());
            } catch (\Stripe\Error\ApiConnection $e) {
                array_push($errorArray, $e->getMessage());
            } catch (\Stripe\Error\Base $e) {
                array_push($errorArray, $e->getMessage());
            } catch (Exception $e) {
                array_push($errorArray, $e->getMessage());
            } finally {
                if (!empty($errorArray)) {
                    $this->session->set_flashdata('paymentGatewayError', 'Your card payment rejected');
                    redirect('onlineorder/paymentgateway/' . $orderid);
                } else {
                    if (!empty($charge)) {
                        if ($charge->id && $charge->description && $charge->paid && $charge->status === 'succeeded') {
                            $this->db->update('gkpos_order', array('paid_status' => 1, 'online_status' => 0), array('id' => $orderid));
                            $this->db->insert(' gkpos_order_payment', array('order_id' => $orderid, 'method' => 'online', 'amount' => $charge->amount / 100, 'code' => $charge->id));
                            if ($this->notify_customer($orderid)) {
                                sleep(1);
                                $this->notify_admin($orderid);
                            }
                        }
                        $this->Site_Model->clear_all();
                        redirect('onlineorder/confirming/' . strtolower($orderid));
                    }
                }
            }
        }
    }

    public function nochex_callback_url_working() {
        $response = $this->_nochex_http_post("www.nochex.com", 80, "/nochex.dll/apc/apc", $_POST);
        $nochex_orderid = $_POST['order_id'];
        $amount = $_POST['amount'];
        $code = $_POST['transaction_id'];
        $isAuthorised = strstr($response, "AUTHORISED");
        if (isset($nochex_orderid) && $isAuthorised) {
            $this->db->update('gkpos_order', array('paid_status' => 1, 'online_status' => 0), array('id' => $nochex_orderid));
            $this->db->insert(' gkpos_order_payment', array('order_id' => $nochex_orderid, 'method' => 'online', 'amount' => $amount, 'code' => $code));
        } else {
            mail('aktar.bd84@gmail.com', 'APC DEbug', 'NOT OK');
        }
    }

    public function nochex_callback_url() {
        $response = $this->_nochex_http_post("www.nochex.com", 80, "/nochex.dll/apc/apc", $_POST);
        $nochex_orderid = $_POST['order_id'];
        $amount = $_POST['amount'];
        $code = $_POST['transaction_id'];
        $isAuthorised = strstr($response, "AUTHORISED");
        if (isset($nochex_orderid) && $isAuthorised) {
            if ($this->Site_Model->exists('gkpos_order', 'id', $nochex_orderid)) {
                $this->Site_Model->clear_all();
                $this->db->update('gkpos_order', array('paid_status' => 1, 'online_status' => 0), array('id' => $nochex_orderid));
                $this->db->insert(' gkpos_order_payment', array('order_id' => $nochex_orderid, 'method' => 'online', 'amount' => $amount, 'code' => $code));
                if ($this->notify_customer($nochex_orderid)) {
                    sleep(5);
                    $this->notify_admin($nochex_orderid);
                }
            }
        } else {
            mail('aktar.bd84@gmail.com', 'APC DEbug', 'NOT OK');
        }
    }

    private function _nochex_http_post($server, $port, $url, $vars) {
        $urlencoded = "";
        foreach ($vars as $Index => $Value) // loop round variables and encode them to be used in query
            $urlencoded .= urlencode($Index) . "=" . urlencode($Value) . "&";
        $urlencoded = substr($urlencoded, 0, -1);   // returns portion of string, everything but last character

        $headers = "POST $url HTTP/1.0\r\n"  // headers to be sent to the server
                . "Content-Type: application/x-www-form-urlencoded\r\n"
                . "Host: www.nochex.com\r\n"
                . "Content-Length: " . strlen($urlencoded) . "\r\n\r\n";  // length of the string

        $fp = fsockopen($server, $port, $errno, $errstr, 10);  // returns file pointer
        if (!$fp)
            return "ERROR: fsockopen failed.\r\nError no: $errno - $errstr";  // if cannot open socket then display error message
        fputs($fp, $headers);  //writes to file pointer
        fputs($fp, $urlencoded);
        $ret = "";
        while (!feof($fp))
            $ret .= fgets($fp, 1024); // while it’s not the end of the file it will loop 
        fclose($fp);  // closes the connection
        return $ret; // array 
    }

    public function nochex_success_url($order_id) {
        if ($order_id) {
            $status = $this->Site_Model->exists('gkpos_order', 'id', $order_id);
            if ($status) {
                redirect('onlineorder/confirming/' . strtolower($order_id));
            } else {
                if ($this->config->item('website_style') == 'singlepage') {
                    redirect(base_url() . '#food-menu');
                } else {
                    redirect(base_url() . 'onlineorder');
                }
            }
        }
    }

    public function nochex_cancel_url($order_id) {
        if ($this->Site_Model->exists('gkpos_order', 'id', $order_id)) {
            $this->db->trans_start();
            $this->db->delete('gkpos_order', array('id' => $order_id));
            $this->db->delete('gkpos_order_detail', array('order_id' => $order_id));
            $this->db->delete('gkpos_order_discount', array('order_id' => $order_id));
            $this->db->delete('gkpos_order_vat', array('order_id' => $order_id));
            $this->db->trans_complete();
            $success = $this->db->trans_status();
            if ($success) {
                if ($this->config->item('website_style') == 'singlepage') {
                    redirect(base_url() . '#food-menu');
                } else {
                    redirect(base_url() . 'onlineorder');
                }
            } else {
                redirect('onlineorder/nochex_cancel_url');
            }
        }
    }

    public function notify_customer($order_id) {
        if ($this->Site_Model->exists('gkpos_order', 'id', $order_id)) {
            $data['order'] = $order = $this->Site_Model->get_list('gkpos_order', array('id' => $order_id));
            $data['items'] = $this->Site_Model->get_list('gkpos_order_detail', array('order_id' => $order[0]->id));
            $discount = $this->Site_Model->get_single('gkpos_order_discount', array('order_id' => $order[0]->id));
            $data['discount'] = !empty($discount) ? $discount->amount : 0;
            $vat = $this->Site_Model->get_single('gkpos_order_vat', array('order_id' => $order[0]->id));
            $data['vat'] = !empty($vat) ? $vat->amount : 0;
            $data['recipent'] = $order[0]->name;
            $data['to'] = $order[0]->email;
            $data['from'] = $this->config->item('gk_email');
            $data['from_title'] = $this->config->item('gk_name');
            $data['subject'] = "Order acknowledgement from " . $this->config->item('gk_name');
            $data['txt'] = "You have placed following items in your order " . strtoupper($order[0]->id) . ". We are reviewing this order now. Please wait for another confirmation email.";
            $data['message'] = $this->load->view('email_template/order_detail', $data, true);
            if ($this->send_email($data)) {
                return true;
            } else {
                return false;
            }
        }
    }

    public function notify_admin($order_id) {
        if ($this->Site_Model->exists('gkpos_order', 'id', $order_id)) {
            $data['order'] = $order = $this->Site_Model->get_list('gkpos_order', array('id' => $order_id));
            $data['items'] = $this->Site_Model->get_list('gkpos_order_detail', array('order_id' => $order[0]->id));
            $discount = $this->Site_Model->get_single('gkpos_order_discount', array('order_id' => $order[0]->id));
            $data['discount'] = !empty($discount) ? $discount->amount : 0;
            $vat = $this->Site_Model->get_single('gkpos_order_vat', array('order_id' => $order[0]->id));
            $data['vat'] = !empty($vat) ? $vat->amount : 0;
            $data['recipent'] = 'Admin';
            $data['to'] = $this->config->item('gk_email');
            $data['from'] = $this->config->item('gk_email');
            $data['from_title'] = $this->config->item('gk_name');
            $data['subject'] = "New Order " . strtoupper($order[0]->id);
            $data['txt'] = $order[0]->name . " has asked for the following items, Please review and confirm as soon as possible";
            $data['message'] = $this->load->view('email_template/order_detail', $data, true);
            if ($this->send_email($data)) {
                return true;
            } else {
                return false;
            }
        }
    }

    public function confirming($order_id) {
        $data['url_page'] = 'onlineorder';
        $this->page_title = "Order Confimation";
        $this->current_section = "Order confirmation";
        if ($this->Site_Model->exists('gkpos_order', 'id', $order_id)) {
            $order = $this->Site_Model->get_list('gkpos_order', array('id' => $order_id));
            if (!empty($order)) {
                $this->Site_Model->clear_all();
                $data['order'] = $order;
                $this->render_page('onlineorder/confirming', $data);
            }
        } else {
            redirect('/');
        }
    }

    public function confirmed_status() {
        $orderid = $this->input->post('id');
        if ($this->Site_Model->exists('gkpos_order', 'id', $orderid)) {
            $order = $this->Site_Model->get_single('gkpos_order', array('id' => $orderid));
            $responseText = null;
            if ($order->online_status == 1) {
                echo '<h4 class="status" style="padding:5px; font-weight:bold; color: green; text-transform: uppercase; font-size:17px; text-align:center;">Your order has been accepted </h4>';
                $responseText = '<h5 class="status" style="color:#000; padding-bottom:5px;  font-size:16px;">Thank you for being patient,your order has been accepted for <br/><strong style="font-size:20px;text-transform: uppercase">' . $order->delivery_time . '</strong></h5>';
            }
            if ($order->online_status == 2) {
                $responseText = '<h3 class="status" style="color:#ff0000;padding-bottom:5px; padding-top:5px; ">Your order has been rejected</h3>';
                if ($order->message != null) {
                    $responseText .= '<div style="text-align:center; padding-bottom:5px; padding-top:5px; font-size:17px; color: #000000;">Message from restaurant: <br/><span style="font-size:14px; font-style:italic;">' . $order->message . '</span></div>';
                }
            }
            if ($order->online_status == 0) {
                $responseText = '<h4 class="status" style="font-size:17px;">Your order is under acknowledgement</h4>';
                $responseText .= '<table cellspacing="10px" cellpadding="0" width="100%"><tr><td width="41%" align="left"></td><td align="left"><img src="' . ASSETS_SITE_IMAGE_PATH . 'ajax-loader(3).gif" style="margin-left:10px" id="home_loader"  /></td></tr></table>';
            }
            echo $responseText;
        }
    }

    public function square() {
        $this->load->view('onlineorder/gateway/square');
    }

    public function process_square($orderid) {
        if ($orderid && $this->Site_Model->exists('gkpos_order', 'id', $orderid)) {
            $order = $this->Site_Model->get_single('gkpos_order', array('id' => $orderid));
            $gateway = $this->Site_Model->get_single('payment_gateway', array('title' => strtoupper('square')));
            require APPPATH . '/libraries/vendor/autoload.php';
            $access_token = $gateway->is_live == 2 ? trim($gateway->cancel_url) : trim($gateway->callback_url);
            \SquareConnect\Configuration::getDefaultConfiguration()->setAccessToken($access_token);
            $locations_api = new \SquareConnect\Api\LocationsApi();
            try {
                $locations = $locations_api->listLocations();
                $location = current(array_filter($locations->getLocations(), function($location) {
                            $capabilities = $location->getCapabilities();
                            return is_array($capabilities) &&
                                    in_array('CREDIT_CARD_PROCESSING', $capabilities);
                        }));
            } catch (\SquareConnect\ApiException $e) {
                echo "Caught exception!<br/>";
                print_r("<strong>Response body:</strong><br/>");
                echo "<pre>";
                var_dump($e->getResponseBody());
                echo "</pre>";
                echo "<br/><strong>Response headers:</strong><br/>";
                echo "<pre>";
                var_dump($e->getResponseHeaders());
                echo "</pre>";
                exit(1);
            }
            $transactions_api = new \SquareConnect\Api\TransactionsApi();
            $customer = $this->Site_Model->get_single('gkpos_customer', array('phone' => $order->phone, 'email' => $order->email));
            $request_body = array(
                "card_nonce" => $_POST['nonce'],
                "amount_money" => array(
                    "amount" => to_currency_no_money($order->grand_total) * 100,
                    "currency" => "GBP"
                ),
                "idempotency_key" => uniqid(),
                "buyer_email_address" => $order->email,
                "customer_id" => $order->phone,
                "reference_id" => $order->id,
                "note" => $order->delivery_note,
                "billing_address" => array(
                    'address_line_1' => $order->online_type == 'delivery' ? $order->street : $customer->street,
                    'locality' => $order->online_type == 'delivery' ? $order->city : $customer->city,
                    'last_name' => $order->online_type == 'delivery' ? $order->name : $customer->name,
                    'postal_code' => $order->online_type == 'delivery' ? $order->postcode : $customer->postcode,
                    'country' => 'GB', //$order->online_type == 'delivery' ? $order->country : $customer->country,
                ),
                "shipping_address" => array(
                    'address_line_1' => $order->online_type == 'delivery' ? $order->street : $customer->street,
                    'locality' => $order->online_type == 'delivery' ? $order->city : $customer->city,
                    'last_name' => $order->online_type == 'delivery' ? $order->name : $customer->name,
                    'postal_code' => $order->online_type == 'delivery' ? $order->postcode : $customer->postcode,
                    'country' => 'GB'// $order->online_type == 'delivery' ? $order->country : $customer->country,
                )
            );
            try {
                $result = $transactions_api->charge($location->getId(), $request_body);
                $tenderObj = $result->getTransaction()->getTenders()[0];
                $reference_id = $result->getTransaction()->getReferenceId();
                $code = $result->getTransaction()->getId();
                if (isset($reference_id)) {
                    if ($this->Site_Model->exists('gkpos_order', 'id', $reference_id)) {
                        $this->db->update('gkpos_order', array('paid_status' => 1, 'online_status' => 0), array('id' => $reference_id));
                        $this->db->insert(' gkpos_order_payment', array('order_id' => $reference_id, 'method' => 'online', 'amount' => $tenderObj->getAmountMoney()->getAmount() / 100, 'code' => $code));
                        if ($this->notify_customer($reference_id)) {
                            sleep(1);
                            $this->notify_admin($reference_id);
                        }
                    }
                    $this->Site_Model->clear_all();
                    redirect('onlineorder/confirming/' . strtolower($reference_id));
                }
            } catch (\SquareConnect\ApiException $e) {
                echo "Caught exception!<br/>";
                print_r("<strong>Response body:</strong><br/>");
                echo "<pre>";
                var_dump($e->getResponseBody());
                echo "</pre>";
                echo "<br/><strong>Response headers:</strong><br/>";
                echo "<pre>";
                var_dump($e->getResponseHeaders());
                echo "</pre>";
            }
        }
    }

}
