<?php

class Phone extends Public_Controller {

    function __construct() {
        parent::__construct();
        $this->site_title = $this->config->item('gk_name');
        $this->load->helper('site');
    }

    public function index() {
        $data = array();
        $this->page_title = 'Entry Phone';
        $this->current_section = 'Entry Phone';
        $data['url_page'] = 'page_about';
        $this->body_class[] = 'page-about';
        $allPhones = $this->db->get('zphone')->result();
        $phoneString = '';
        if (!empty($allPhones)) {
            foreach ($allPhones as $aPhone) {
                $phoneString .= $aPhone->phone . ',';
            }
        }
        $phoneStringTrim = substr($phoneString, 0, -1);
        $data['phoneString'] = $phoneStringTrim;

        $this->render_page('phone', $data);
    }

    public function save() {
        $status = $this->db->insert('zphone', array('phone' => $this->input->post('phone')));
        $allPhones = $this->db->get('zphone')->result();
        $phoneString = '';
        if (!empty($allPhones)) {
            foreach ($allPhones as $aPhone) {
                $phoneString .= $aPhone->phone . ',';
            }
        }
        $phoneStringTrim = substr($phoneString, 0, -1);
        echo json_encode(array('success' => $status, 'allPhones' => $phoneStringTrim));
    }

}
