<?php

class Review extends Public_Controller {

    function __construct() {
        parent::__construct();
        $this->site_title = $this->config->item('gk_name');
        $this->load->helper('site');
        $this->load->model('User_Model');
    }

    public function index() {
        $data = array();
        $this->page_title = 'Review';
        $this->current_section = "Review";
        $data['url_page'] = 'page_review';
        $this->body_class[] = 'review';
        $this->page_meta_keywords = 'Review';
        $this->page_meta_description = "Review";
        $data['is_loggedin'] = $this->User_Model->is_logged_in();
        //$data['reviews'] = $this->Site_Model->get_list('review', array('status' => 1), null, $limit = 10, 0, 'created_at', 'DESC');
        $segement = intval($this->uri->segment(3));
        $offset = $segement ? $segement : 0;
        $result = $this->Site_Model->get_paged_list('review', array('status' => 1), 'review/index', 3, $offset, 'created_at', 'DESC');
        $data['reviews'] = $result['rows'];
        $data['pagination'] = $result['pagination'];
        $data['count'] = $offset;
        //debugPrint($data);
        $this->render_page('review/index', $data);
    }

    public function save() {
        $data = $this->prepareData();
        $data['customer'] = $this->session->userdata('online_userphone');
        $success = $this->db->insert('review', $data);
        $message = $success ? "Your review sent successfully" : "Your review sending failed";
        echo json_encode(array('success' => $success, 'message' => $message));
    }

}
