<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends Public_Controller {

    function __construct() {
        parent::__construct();
        $this->site_title = $this->config->item('gk_name');
        $this->load->helper('site');
    }

    public function index() {
        $data = array();
        if ($this->cache->get('site_home')) {
            $data = $this->cache->get('site_home');
        } else {
            $data['home'] = $this->Site_Model->get_list('page', array('slug' => 'home'));
            $data['sevendays'] = $this->Site_Model->get_list('servicetime');
            $data['promotions'] = $this->Site_Model->get_list('promotion');
            $this->cache->save('site_home', $data, 900);
        }
        $data['url_page'] = 'home';
        $this->page_title = $data['home'][0]->title;
        $this->current_section = $data['home'][0]->title;
        $this->body_class[] = 'home';
        $this->page_meta_keywords = $data['home'][0]->meta_keys;
        $this->page_meta_description = $data['home'][0]->meta_desc;
        $week = array();
        foreach ($data['sevendays'] as $key => $day) {
            $week[$day->day] = $day;
        }
        $data['week'] = $week;
        $data['isRestaaurantOpened'] = $this->isRestaaurantOpened;
        $service_time = $data['sevendays'];
        $servicetime_arr = array();
        foreach ($service_time as $st) {
            $servicetime_arr[$st->day] = $st;
        }
        $data['service_time'] = $servicetime_arr;
        $data['contact'] = $this->Site_Model->get_list('page', array('slug' => 'contact'));
        $onlineOrder = $this->onloineorder();
        $gallery= $this->gallery();
        $Totaldata = array_merge($data, $onlineOrder,$gallery);
        //debugPrint($Totaldata);

        $this->render_page('home/index', $Totaldata);
    }

    private function onloineorder() {
        $data = array();
        if ($this->cache->get('site_onlineorder')) {
            $data = $this->cache->get('site_onlineorder');
        } else {
            $data['pageOnlineOrder'] = $this->Site_Model->get_list('page', array('slug' => 'onlineorder'));
            $data['categories'] = $this->Site_Model->get_list('gkpos_category', array('status' => 1, 'online' => 1), null, null, 0, 'order', 'ASC');
            $menus = array();
            foreach ($data['categories'] as $category) {
                $menus[$category->id] = $this->Site_Model->get_list('gkpos_menu', array('category' => $category->id, 'status' => 1, 'online' => 1), null, null, 0, 'order', 'ASC');
            }
            $data['menus'] = $menus;
            $selections = array();
            $toppings = array();
            foreach ($menus as $menu) {
                if ($menu != null) {
                    foreach ($menu as $selection) {
                        $selections[$selection->category][$selection->id] = $this->Site_Model->get_list('gkpos_selection', array('category' => $selection->category, 'menu' => $selection->id, 'status' => 1, 'online' => 1), null, null, 0, 'order', 'ASC');
                        $toppings[$selection->category][$selection->id] = $this->Site_Model->get_list('menu_toppings', array('category' => $selection->category, 'menu' => $selection->id), null, null, 0, 'toppings', 'ASC');
                    }
                }
            }
            $data['selections'] = $selections;
            $data['menuToppings'] = $toppings;
            $allToppings = $this->Site_Model->get_list('toppings', array('status' => 1));
            $allToppingsInfo = array();
            foreach ($allToppings as $topping) {
                $allToppingsInfo[$topping->id] = $topping;
            }
            $data['allToppings'] = $allToppingsInfo;
            $data['allDeals'] = $deals = $this->Site_Model->get_list('meal_deal', null, null, null, 0, 'order', 'ASC');
            $deal_sets = array();
            $deal_toppings = array();
            $deal_set_menus = array();
            if (!empty($deals)) {
                foreach ($deals as $deal) {
                    $deal_sets[$deal->id] = $dealSets = $this->Site_Model->get_list('meal_deal_set', array('deal' => $deal->id), null, null, 0, 'id', 'ASC');
                    $deal_toppings[$deal->id] = $this->Site_Model->get_list('meal_deal_toppings', array('meal_deal' => $deal->id), null, null, 0, 'toppings', 'ASC');
                    foreach ($dealSets as $dealSet) {
                        $deal_set_menus[$deal->id][$dealSet->id] = $this->Site_Model->get_list('meal_deal_menu', array('deal' => $deal->id, 'set' => $dealSet->id), null, null, 0, 'menu', 'ASC');
                    }
                }
            }
            $data['deal_sets'] = $deal_sets;
            $data['deal_toppings'] = $deal_toppings;
            $data['deal_set_menus'] = $deal_set_menus;
            $service_time = $this->Site_Model->get_list('servicetime');
            $servicetime_arr = array();
            foreach ($service_time as $st) {
                $servicetime_arr[$st->day] = $st;
            }
            $data['service_time'] = $servicetime_arr;
            $data['isRestaaurantOpened'] = $this->isRestaaurantOpened;
            $data['promotions'] = $promotions = $this->Site_Model->get_promostions();
        }

        $data['cart_filler'] = $this->load->view('onlineorder/cart_filler', array(), true);
        return $data;
    }

    private function gallery() {
        $data = array();
        if ($this->cache->get('site_gallery')) {
            $data = $this->cache->get('site_gallery');
        } else {
            $data['gallery'] = $this->Site_Model->get_list('page', array('slug' => 'gallery'));
            $data['images'] = $this->Site_Model->get_list('gallery', null, array('image'));
            $this->cache->save('site_gallery', $data, 900);
        }
        return $data;
    }


}
