<?php

class MY_Controller extends MX_Controller {

    public $appconfig;
    public $isRestaaurantOpened;
    public $hasDeliveryPlan;
    public $deliveryArea = array();

    function __construct() {
        parent::__construct();
        $this->load->driver('cache', array('adapter' => 'apc', 'backup' => 'file'));
        $this->appconfig = $this->Appconfig->get_all()->result();
        $this->isRestaaurantOpened = $this->is_restaurant_open();
        $this->hasDeliveryPlan = $this->has_deliveryplan();
    }

    public function uploadimage($config) {
        $this->load->helper('directory');
        $config = $config;
        $this->load->library('upload', $config);
        $this->upload->do_upload('image');
        return strlen($this->upload->display_errors()) == 0 || !strcmp($this->upload->display_errors(), '<p>' . $this->lang->line('upload_no_file_selected') . '</p>');
    }

    public function prepareRegistrationData() {
        $items = array();
        foreach ($this->input->post() as $key => $value) {
            if ($key == 'CustPassword') {
                continue;
            }

            $items[] = $key;
        }
        $data = elements($items, $this->input->post());
        $data['CustPassword'] = md5($this->input->post('CustPassword'));
        return $data;
    }

    public function prepareData() {
        $items = array();
        foreach ($this->input->post() as $key => $value) {
            if ($key == 'submit_form' || $key == 'id') {
                continue;
            }
            $items[] = $key;
        }
        $data = elements($items, $this->input->post());
        return $data;
    }

    public function prepareGkposData($postedData) {
        $items = array();
        foreach ($postedData as $key => $value) {
            if ($key == 'submit_form' || $key == 'id') {
                continue;
            }
            $items[] = $key;
        }
        $data = elements($items, $postedData);
        return $data;
    }

    public function send_email($data = null) {
        if ($data != null || !empty($data)) {
            $this->load->library('email');
            $config['mailtype'] = 'html';
            $config['send_multipart'] = FALSE;
            $config['wordwrap'] = TRUE;
            $this->email->initialize($config);
            $this->email->from($data['from'], $data['from_title']);
            $this->email->to($data['to']);
            $this->email->subject($data['subject']);
            $this->email->message($data['message']);
            $this->email->reply_to($data['from'], $data['from_title']);

            if ($_SERVER['SERVER_NAME'] != 'localhost') {
                if ($this->email->send()) {
                    return TRUE;
                } else {
                    return FALSE;
                }
            } else {
                return TRUE;
            }
        }
    }

    public function is_restaurant_open() {
        $this->load->model('Site_Model');
        $goOfflineRow = $this->Site_Model->get_single('config', array('key' => 'gkpos_go_offline'));
        if ($goOfflineRow->value == 'yes' || $goOfflineRow->value == 'no') {
            if ($goOfflineRow->value == 'yes') {
                if ($this->check_opening()) {
                    return TRUE;
                } else {
                    return FALSE;
                }
            } else {
                return TRUE;
            }
        } else {
            return $this->check_opening();
        }
    }

    private function check_opening() {
        $today = $this->Site_Model->get_single('servicetime', array('day' => strtolower(date('D'))));
        $current_time = date('g:i A');
        $sunrise = $today->open;
        $sunset = $today->closed;
        $date1 = DateTime::createFromFormat('g:i A', $current_time);
        $date2 = DateTime::createFromFormat('g:i A', $sunrise);
        $date3 = DateTime::createFromFormat('g:i A', $sunset);
        if ($date1 > $date2 && $date1 < $date3) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function has_deliveryplan() {
        $this->load->model('Site_Model');
        $deliveryPlanList = $this->Site_Model->get_list('gkpos_deliveryplan', array('status' => 1));
        if (!empty($deliveryPlanList)) {
            $this->deliveryArea = $deliveryPlanList;
            return TRUE;
        } else {
            $this->deliveryArea = array();
            return FALSE;
        }
    }

    public function clear_cache($cacheID) {
        $success = $this->cache->delete($cacheID);
        $message = $success ? 'Cache Clear Successfully' : 'Cache Clear Failed';
        return json_encode(array('success' => $success, 'message' => $message));
    }

}
