<?php

if (!function_exists('objectToArray')) {

    function objectToArray($d) {
        if (is_object($d)) {
            $d = get_object_vars($d);
        }
        if (is_array($d)) {
            return array_map(__FUNCTION__, $d);
        } else {
            return $d;
        }
    }

}
if (!function_exists('check_internet_connection')) {

    function check_internet_connection($sCheckHost = 'www.google.com') {
        return (bool) @fsockopen($sCheckHost, 80, $iErrno, $sErrStr, 5);
    }

}

if (!function_exists('get_single_record')) {

    function get_single_record($table, $condition = null, $columns = '*', $order = null) {
        $CI = & get_instance();
        $CI->db->select($columns);
        if ($order)
            $CI->db->order_by($order);
        if ($condition)
            $CI->db->where($condition);
        return $CI->db->get($table)->row();
    }

}

if (!function_exists('get_record_list')) {

    function get_record_list($table, $condition = null, $columns = '*', $order = null) {
        $CI = & get_instance();
        $CI->db->select($columns);
        if ($order)
            $CI->db->order_by($order);
        if ($condition)
            $CI->db->where($condition);
        return $CI->db->get($table)->result();
    }

}

if (!function_exists('gkpos_chopstring')) {

    function gkpos_chopstring($incoming_string, $x = 200) {
        $string = strip_tags(stripslashes($incoming_string)); // convert to plaintext
        return substr($string, 0, strpos(wordwrap($string, $x), "\n"));
    }

}

if (!function_exists('postcodeFormat')) {

    function postcodeFormat($postcode) {
        //trim and remove spaces
        $cleanPostcodeParam = preg_replace("/[^A-Za-z0-9]/", '', $postcode);
        //make uppercase
        $cleanPostcode = strtoupper($cleanPostcodeParam);
        //if 5 charcters, insert space after the 2nd character
        if (strlen($cleanPostcode) == 5) {
            $postcode = substr($cleanPostcode, 0, 2) . " " . substr($cleanPostcode, 2, 3);
        }
        //if 6 charcters, insert space after the 3rd character
        elseif (strlen($cleanPostcode) == 6) {
            $postcode = substr($cleanPostcode, 0, 3) . " " . substr($cleanPostcode, 3, 3);
        }
        //if 7 charcters, insert space after the 4th character
        elseif (strlen($cleanPostcode) == 7) {
            $postcode = substr($cleanPostcode, 0, 4) . " " . substr($cleanPostcode, 4, 3);
        }
        return $postcode;
    }

}

if (!function_exists('formatPhoneNumber')) {

    function formatPhoneNumber($IncomingPhoneNumber) {
        $phoneNumber = preg_replace('/[^0-9]/', '', $IncomingPhoneNumber);
        if (strlen($phoneNumber) > 10) {
            $countryCode = substr($phoneNumber, 0, strlen($phoneNumber) - 10);
            $areaCode = substr($phoneNumber, -10, 3);
            $nextThree = substr($phoneNumber, -7, 3);
            $lastFour = substr($phoneNumber, -4, 4);
            $phoneNumber = '+' . $countryCode . ' (' . $areaCode . ') ' . $nextThree . '-' . $lastFour;
        } else if (strlen($phoneNumber) == 10) {
            $areaCode = substr($phoneNumber, 0, 3);
            $nextThree = substr($phoneNumber, 3, 3);
            $lastFour = substr($phoneNumber, 6, 4);
            $phoneNumber = '(' . $areaCode . ') ' . $nextThree . '-' . $lastFour;
        } else if (strlen($phoneNumber) == 7) {
            $nextThree = substr($phoneNumber, 0, 3);
            $lastFour = substr($phoneNumber, 3, 4);
            $phoneNumber = $nextThree . '-' . $lastFour;
        }
        return $phoneNumber;
    }

}
if (!function_exists('get_order_type')) {

    function get_order_type($id) {
        $ci = & get_instance();
        $sql = " SELECT *
                   FROM gkpos_order
               WHERE id = $id              
               ";
        return $ci->db->query($sql)->row()->order_type;
    }

}

if (!function_exists('get_gkcategory_name')) {

    function get_gkcategory_name($id) {
        $ci = & get_instance();
        $sql = " SELECT *
                   FROM gkpos_category
               WHERE id = $id              
               ";
        return $ci->db->query($sql)->row()->title;
    }

}
if (!function_exists('get_menu_info_by_id')) {

    function get_menu_info_by_id($id) {
        $ci = & get_instance();
        $sql = " SELECT *
                   FROM gkpos_menu
               WHERE id = $id              
               ";
        return $ci->db->query($sql)->row();
    }

}
if (!function_exists('get_selection_info_by_id')) {

    function get_selection_info_by_id($id) {
        $ci = & get_instance();
        $sql = " SELECT *
                   FROM gkpos_selection
               WHERE id = $id              
               ";
        return $ci->db->query($sql)->row();
    }

}
if (!function_exists('get_topping_info_by_id')) {

    function get_topping_info_by_id($id) {
        $ci = & get_instance();
        $sql = " SELECT *
                   FROM toppings
               WHERE id = $id              
               ";
        return $ci->db->query($sql)->row();
    }

}

if (!function_exists('debugPrint')) {

    function debugPrint($object, $title = "", $isMarkup = false) {
        echo '<font color="red">Debug <<< START';
        if (!empty($title)) {
            echo "$title: ";
        }
        if ($isMarkup == false) {
            echo "<pre>";
            print_r($object);
            echo "</pre>";
        } else {
            echo htmlspecialchars($object);
        }
        echo 'END >>></font>';
    }

}

function thumb($src, $width, $height, $image_thumb = '') {

    // Get the CodeIgniter super object
    $CI = &get_instance();

    // get src file's dirname, filename and extension
    $path = pathinfo($src);

    // Path to image thumbnail
    if (!$image_thumb)
        $image_thumb = $path['dirname'] . DIRECTORY_SEPARATOR . $path['filename'] . "_" . $height . '_' . $width . "." . $path['extension'];

    if (!file_exists($image_thumb)) {

        // LOAD LIBRARY
        $CI->load->library('image_lib');

        // CONFIGURE IMAGE LIBRARY
        $config['source_image'] = $src;
        $config['new_image'] = $image_thumb;
        $config['width'] = $width;
        $config['height'] = $height;

        $CI->image_lib->initialize($config);
        $CI->image_lib->resize();
        $CI->image_lib->clear();

        // get our image attributes
        list($original_width, $original_height, $file_type, $attr) = getimagesize($image_thumb);

        // set our cropping limits.
        $crop_x = ($original_width / 2) - ($width / 2);
        $crop_y = ($original_height / 2) - ($height / 2);

        // initialize our configuration for cropping
        $config['source_image'] = $image_thumb;
        $config['new_image'] = $image_thumb;
        $config['x_axis'] = $crop_x;
        $config['y_axis'] = $crop_y;
        $config['maintain_ratio'] = false;

        $CI->image_lib->initialize($config);
        $CI->image_lib->crop();
        $CI->image_lib->clear();
    }

    return basename($image_thumb);
}

/* End of file thumb_helper.php */
/* Location: ./application/helpers/thumb_helper.php */
if (!function_exists('get_delivery_distance')) {

    function get_delivery_distance($orgins, $destination) {
        $CI = & get_instance();
        $key = trim($CI->config->item('google_map_api_key')) != null ? $CI->config->item('google_map_api_key') : GOOGLE_API_KEY;
        $url = "https://maps.googleapis.com/maps/api/distancematrix/json?units=imperial&origins=" . urlencode($orgins) . "&destinations=" . urlencode($destination) . "&mode=driving&language=en&key=" . $key;
        $drivingdetails = json_decode(file_get_contents($url));
        if (isset($drivingdetails->rows[0]->elements[0]->distance)) {
            $distance_text = $drivingdetails->rows[0]->elements[0]->distance->text;
            return (double) str_replace('mi', '', $distance_text);
        } else {
            return 0;
        }
    }

}
if (!function_exists('get_topping_category_name')) {

    function get_topping_category_name($id) {
        $ci = & get_instance();
        $sql = " SELECT *
                   FROM toppings_category
               WHERE id = $id              
               ";
        return $ci->db->query($sql)->row();
    }

}

function detectDevice() {
    $ua = $_SERVER["HTTP_USER_AGENT"];
    $android = strpos($ua, 'Android') ? true : false;
    $blackberry = strpos($ua, 'BlackBerry') ? true : false;
    $iphone = strpos($ua, 'iPhone') ? true : false;
    $palm = strpos($ua, 'Palm') ? true : false;
    if ($android || $blackberry || $iphone || $palm) {
        return true;
    }
}

if (!function_exists('get_template')) {

    function get_template() {
        $ci = & get_instance();
        $sql = " SELECT *
                   FROM template
                ";
        $result = $ci->db->query($sql)->result();
        $organizedResult = array();
        if (!empty($result)) {
            foreach ($result as $key => $obj) {
                $organizedResult[$obj->wrapper] = $obj;
            }
        }
        return $organizedResult;
    }

}

if (!function_exists('get_customer_name')) {

    function get_customer_name($phone) {
        $ci = & get_instance();
        $sql = " SELECT *
                   FROM gkpos_customer
               WHERE phone = $phone              
               ";
        return $ci->db->query($sql)->row()->name;
    }

}
