<?php

class Customer_Model extends MY_Model {

    function __construct() {
        parent::__construct();
        $this->_table_name = "gkpos_customer";
        $this->_primary_key = 'phone';
    }

    public function get_customer_address($phone) {
        $this->db->select('floor_or_apt,house,building,street,postcode,city,state,country');
        $this->db->from('gkpos_order');
        $this->db->where('phone', $phone);
        $this->db->where('online_type', 'delivery');
        $this->db->where('postcode <>', NULL);
        $this->db->group_by('postcode');
        $this->db->order_by('created', 'DESC');
        return $this->db->get()->result();
    }

}
