<?php

class Gprsprinter_Model extends MY_Model {

    function __construct() {
        parent::__construct();
        $this->_table_name = "gkpos_order";
        $this->_primary_key = 'id';
    }

    function getgprsprinter_pendings_feed() {
        $order = $this->get_list('gkpos_order', array('order_type' => 'online', 'online_status' => 0), null, 1, 0, 'created', 'ASC');
        $lines = array();
        if (!empty($order)) {
            $item_details = $this->get_list('gkpos_order_detail', array('order_id' => $order[0]->id));
            $items = array();
            if (!empty($item_details)) {
                foreach ($item_details as $item) {
                    $product_title = $item->selection_title != null ? $item->selection_title . ' ' . $item->menu_title : $item->menu_title;
                    $product_title.=$item->set_items != null || $item->set_items != '' ? "%%" . $item->set_items : '';
                    $product_title.=$item->toppings != null || $item->toppings != '' ? "%%" . $item->toppings : '';
                    $product_price = $item->price * $item->quantity;
                    $items[] = '%%' . strtoupper(trim($item->category_title)) . ',' . $item->quantity . ',' . str_replace(',', ' ', $product_title) . ',' . number_format($product_price, 2, '.', " ");
                }
            }
            $grand_total = number_format($order[0]->grand_total, 2, '.', " ");
            $PayStatus = $order[0]->paid_status == 1 ? 6 : 7;
            $OrderPolicy = ($order[0]->online_type == 'collection') ? 2 : 1;
            $IsVerified = 4;
            $customer_address = $order[0]->street != null ? $order[0]->street . ', ' : '';
            $customer_address.=$order[0]->city != null ? $order[0]->city . ', ' : '';
            $customer_address.=$order[0]->postcode;
            $paymentMethod = '';
            if ($order[0]->online_method == 'cod') {
                $paymentMethod = 'CASH';
            } else if ($order[0]->online_method == 'nochex') {
                $paymentMethod = "CARD";
            } else {
                $paymentMethod = "CARD";
            }
            $discount = $this->get_single('gkpos_order_discount', array('order_id' => $order[0]->id));
            $discount_total = !empty($discount) && $discount->amount > 0 ? number_format($discount->amount, 2, '.', " ") : number_format(0, 2, '.', " ");
            $rest_name = $this->config->item('gk_name');
            $customer_prev_total = 100;
            $rest_id = 29;
            $deliveryCost = $order[0]->delivery_charge != null && $order[0]->delivery_charge > 0 ? number_format($order[0]->delivery_charge, 2, '.', " ") : number_format(0, 2, '.', " ");
            $ccFee = $order[0]->cc_fee != null && $order[0]->cc_fee > 0 ? number_format($order[0]->cc_fee, 2, '.', " ") : number_format(0, 2, '.', " ");
            $auThCode='none';
            $lines[] = "#" . $rest_id . "*" . $rest_name . "*" . $OrderPolicy . "*" . $order[0]->id . "*" . implode(';', $items) . "*" . $deliveryCost . ";" . $ccFee . ";" . $discount_total . ";" . $grand_total . ";*" . $IsVerified . ";" . str_replace(',', ' ', $order[0]->name) . ";" . str_replace(';', ' ', $customer_address) . ";" . $order[0]->delivery_time . ' ' . date('d-m-y',  strtotime('today')) . ";" . $customer_prev_total . ";" . $PayStatus . ";" . $paymentMethod . ":" . $auThCode . ";" . $order[0]->phone . ";*" . str_replace(';', ' ', $order[0]->delivery_note) . "#";
        }
        $feed_data = implode("\r\n", $lines);
        return $feed_data;
    }

}
