<?php

class Site_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_single_post($slug) {
        $this->_table_name = 'post';
        return $this->get_by(array('slug' => $slug, 'is_published' => 1, 'is_deleted' => 0), TRUE);
    }

    public function get_promostions() {
        $this->db->where('status', 1);
        $this->db->where('is_opened', 1);
        $this->db->where('start <=', date('Y-m-d'));
        $this->db->where('end >=', date('Y-m-d'));
        return $this->db->get('promotion')->result();
    }

    public function get_cart_item($category, $menu, $sel = 0) {
        if ($sel > 0) {
            $this->db->select('GS.id as selection,GS.title as selection_title,GS.base_price,GS.in_price,GS.out_price,GS.menu,GM.title as menu_title,GS.category, GC.title as category_title,GC.print_option as category_print_option,GC.type as category_type');
            $this->db->from('gkpos_selection GS');
            $this->db->join('gkpos_menu as GM', 'GS.menu=GM.id', 'left');
            $this->db->join('gkpos_category as GC', 'GM.category=GC.id', 'left');
            $this->db->where(array('GS.id' => $sel));
        } else {
            $this->db->select('GM.id as menu,GM.title as menu_title,GM.category,GM.base_price,GM.in_price,GM.out_price, GC.title as category_title,GC.print_option as category_print_option,GC.type as category_type ');
            $this->db->from('gkpos_menu GM');
            $this->db->join('gkpos_category as GC', 'GM.category=GC.id', 'left');
            $this->db->where(array('GM.id' => $menu, 'GC.id' => $category));
        }
        return $this->db->get()->row();
    }

    public function addtocart($data) {
        $category = $data['category'];
        $menu = $data['menu'];
        $sel = $data['selection'];

        $maxLine = 0;
        $updatekey = 0;
        $currentCartItems = $this->get_cart();
        $set_items = $data['set_items'] != null ? substr($data['set_items'], 1) : '';
        $toppings = $data['toppings'] != null ? substr($data['toppings'], 1) : '';
        if (empty($currentCartItems)) {
            $maxLine = $maxLine;
        } else {
            foreach ($currentCartItems as $line => $item) {
                if ($maxLine <= $item['line']) {
                    $maxLine = $item['line'];
                }
            }
        }
        $existInCuurentCart = false;
        if (!empty($currentCartItems)) {
            foreach ($currentCartItems as $line => $item) {
                if ($item['is_special'] == 'yes') {
                    if ((int) $menu > 0 && $menu == $item['menu'] && $category == $item['category'] && strtolower($set_items) == strtolower($item['set_items']) && strtolower($toppings) == strtolower($item['toppings'])) {
                        $existInCuurentCart = true;
                        $updatekey = $item['line'];
                    }
                } else {
                    if ((int) $sel <= 0) {
                        if ((int) $menu > 0 && $menu == $item['menu'] && $category == $item['category'] && strtolower($toppings) == strtolower($item['toppings'])) {
                            $existInCuurentCart = true;
                            $updatekey = $item['line'];
                        }
                    } else {
                        if ((int) $sel > 0 && $sel == $item['selection'] && $menu = $item['menu'] && $category == $item['category'] && strtolower($toppings) == strtolower($item['toppings'])) {
                            $existInCuurentCart = true;
                            $updatekey = $item['line'];
                        }
                    }
                }
            }
        }
        if ($existInCuurentCart) {
            $currentCartItems[$updatekey]['quantity'] = $currentCartItems[$updatekey]['quantity'] + $data['quantity'];
            $this->set_cart($currentCartItems);
            if ((int) trim($data['bogo']) == (int) 1) {
                $this->manage_bogo($updatekey, 'plus');
            }
            return array('success' => true, 'line' => $updatekey);
        } else {
            $newItemLine = $maxLine + 1;
            $item = $this->add_item($newItemLine, $data);
            $currentCartItems[$newItemLine] = $item;
            $this->set_cart($currentCartItems);
            if ((int) trim($data['bogo']) == (int) 1) {
                $this->manage_bogo($newItemLine, 'plus');
            }
            return array('success' => true, 'line' => $newItemLine, 'item' => $item);
        }
    }

    private function manage_bogo($line, $action) {
        $items = $this->get_cart();
        $item = $items[$line];
        $bogo_data = array(
            'bogo' => $item['bogo'],
            'category' => $item['category'],
            'menu' => $item['menu'],
            'deal' => $item['deal'],
            'selection' => $item['selection'],
            'bogo_discount_on' => $item['bogo_discount_on'],
        );
        $lines = array();
        foreach ($items as $key => $item) {
            $array_to_compare['bogo'] = $item['bogo'];
            $array_to_compare['category'] = $item['category'];
            $array_to_compare['menu'] = $item['menu'];
            $array_to_compare['deal'] = $item['deal'];
            $array_to_compare['selection'] = $item['selection'];
            $array_to_compare['bogo_discount_on'] = $item['bogo_discount_on'];
            if (!array_diff_assoc($bogo_data, $array_to_compare)) {
                $lines[] = $key;
            }
        }
        //debugPrint($lines);
        $quantity = 0;
        if (!empty($lines)) {
            if (count($lines) == 1) {
                $item = $items[$lines[0]];
                $quantity += $item['quantity'];
            } else {
                foreach ($lines as $line) {
                    $item = $items[$line];
                    $quantity += $item['quantity'];
                }
            }
        }
        $unit_price = 0;
        if ($bogo_data['bogo_discount_on'] == 'selection') {
            $result = $this->db->where('id', $bogo_data[$bogo_data['bogo_discount_on']])->get('gkpos_selection')->row();
            $unit_price = $result->out_price > 0 ? $result->out_price : $result->base_price;
        }
        if ($bogo_data['bogo_discount_on'] == 'deal') {
            $result = $this->db->where('id', $bogo_data[$bogo_data['bogo_discount_on']])->get('meal_deal')->row();
            $unit_price = $result->price;
        }
        if ($bogo_data['bogo_discount_on'] == 'menu') {
            $result = $this->db->where('id', $bogo_data[$bogo_data['bogo_discount_on']])->get('gkpos_menu')->row();
            $unit_price = $result->out_price > 0 ? $result->out_price : $result->base_price;
        }
        $bogo_discount = $this->get_bogo_discount() ? $this->get_bogo_discount() : array();
        $bogokey = $bogo_data['bogo_discount_on'] . '_' . $bogo_data[$bogo_data['bogo_discount_on']];
        if ($action == 'plus') {
            if ($quantity >= 2) {
                $divideByTwo = $quantity / 2;
                $multiDiscount = (int) $divideByTwo * $unit_price;
                $bogo_discount[$bogokey] = $multiDiscount;
            }
        }
        if ($action == 'minus') {
            if ($quantity == 2 || $quantity == 1) {
                unset($bogo_discount[$bogokey]);
            } else {
                $quantity -= 1;
                $divideByTwo = $quantity / 2;
                $multiDiscount = (int) $divideByTwo * $unit_price;
                $bogo_discount[$bogokey] = $multiDiscount;
            }
        }
        if ($action == 'remove') {
            $lineQuantity = $item['quantity'];
            $quantity -= $lineQuantity;
            if ($quantity < 2 || count($lines) <= 1) {
                unset($bogo_discount[$bogokey]);
            } else {
                $divideByTwo = $quantity / 2;
                $multiDiscount = (int) $divideByTwo * $unit_price;
                $bogo_discount[$bogokey] = $multiDiscount;
            }
        }
        $this->set_bogo_discount($bogo_discount);
    }

    function add_item($newItemLine, $data) {
        if (!empty($data)) {
            $item = array(
                'line' => $newItemLine,
                'category' => $data['category'],
                'category_title' => $data['category_title'],
                'category_print_option' => $data['print_option'],
                'category_type' => $data['type'],
                'is_special' => $data['is_special'],
                'deal' => $data['deal'],
                'menu' => $data['menu'],
                'menu_title' => $data['menu_title'],
                'selection' => $data['selection'],
                'selection_title' => $data['selection_title'],
                'set_items' => $data['set_items'] != null ? substr($data['set_items'], 1) : '',
                'toppings' => $data['toppings'] != null ? substr($data['toppings'], 1) : '',
                'quantity' => $data['quantity'],
                'price' => $data['price'],
                'bogo' => $data['bogo'],
                'bogo_discount_on' => $data['bogo_discount_on']
            );
            return $item;
        } else {
            return array();
        }
    }

    public function reduce_item($line) {
        $items = $this->get_cart();
        if ($items[$line]['bogo'] == 1) {
            $this->manage_bogo($line, 'minus');
        }
        if ($items[$line]['quantity'] > 1) {
            $items[$line]['quantity'] -= 1;
        } else {
            $this->remove_item($line);
        }
        $this->set_cart($items);
        return array('success' => true, 'line' => $line);
    }

    public function increment_item($line) {
        $items = $this->get_cart();
        $items[$line]['quantity'] += 1;
        $this->set_cart($items);
        if ($items[$line]['bogo'] == 1) {
            $this->manage_bogo($line, 'plus');
        }
        return array('success' => true, 'line' => $line);
    }

    public function remove_item($line) {
        $items = $this->get_cart();
        if ($items[$line]['bogo'] == 1) {
            $this->manage_bogo($line, 'remove');
        }
        unset($items[$line]);
        $this->set_cart($items);
        return array('success' => true, 'line' => false);
    }

    function get_cart() {
        if ($this->session->userdata('customer_cart')) {
            return $this->session->userdata('customer_cart');
        }
    }

    function set_cart($cart_data) {
        $this->session->set_userdata('customer_cart', $cart_data);
    }

    function empty_cart() {
        $this->session->unset_userdata('customer_cart');
    }

    public function cart_configuration($order_type = null) {
        if ($this->get_cc_fee() && $this->get_online_method() == 'cod') {
            $this->clear_cc_fee();
        }
        if ($order_type == null && !$this->get_order_type()) {
            $this->set_order_type('online_collection');
        }
        $cart = $this->get_cart();
        $subtotal = 0;
        $grand_total = 0;
        if (!empty($cart)) {
            foreach ($cart as $item) {
                $subtotal += $item['quantity'] * $item['price'];
            }
            $grand_total += $subtotal;
        }
        $this->set_subtotal($subtotal);

        if ($this->get_deliveryplan()) {
            $deliveryplan = $this->get_deliveryplan();
            if (!empty($deliveryplan) && $deliveryplan['is_free'] == 2) {
                $grand_total += $deliveryplan['delivery_charge'];
            }
        }

        if (!$this->get_vat()) {
            $this->initiate_vat();
        }
        if (!$this->get_discount()) {
            $this->initiate_discount($this->get_order_type());
        }
        if ($this->get_vat() && $subtotal >= 0) {
            $data = $this->get_vat();
            $vat = 0;
            if ($data['func'] == 1) {
                $vat = $subtotal * $data['number'] / 100;
            }
            $this->set_vat_amount($vat);
            $grand_total += $vat;
        }
        $discountedTotal = $this->get_discounted_total($this->get_discount_on());
        $min_order = $this->get_min_order_discounted_amount();

        if ($discountedTotal < $min_order) {
            $this->clear_discount();
            $this->clear_discount_amount();
        } else {
            if ($this->get_discount() && $subtotal >= 0) {
                $discount = $this->get_discount();
                if (!empty($discount)) {
                    $discount['total'] = $discountedTotal;
                    $discount_amount = $this->calculate_discount($discount);
                    $grand_total -= $discount_amount;
                    $this->set_discount_amount($discount_amount);
                }
            }
        }

        if ($this->get_bogo_discount()) {
            $bogo_discount = $this->get_bogo_discount();
            $bogodiscount_amount = 0;
            if (!empty($bogo_discount)) {
                foreach ($bogo_discount as $amount) {
                    $bogodiscount_amount += $amount;
                }

                $grand_total -= $bogodiscount_amount;
                $this->set_bogodiscount_amount($bogodiscount_amount);
            } else {
                $this->clear_bogo_discount();
                $this->clear_bogodiscount_amount();
            }
        } else {
            $this->clear_bogo_discount();
            $this->clear_bogodiscount_amount();
        }

        if ($this->get_cross_promotion() && $this->get_cross_promotion() == 'yes') {
            $promo = $this->get_promotion();
            $promo['total'] = $discountedTotal;
            $promo['func'] = $promo['func'] == 'percent' ? 1 : 2;
            $promo['number'] = $promo['number'];
            $crossPromoamount = $this->calculate_discount($promo);
            $grand_total -= $crossPromoamount;
            $this->set_cross_promotion_amount($crossPromoamount);
        }

        if ($this->get_cc_fee()) {
            $grand_total += $this->get_cc_fee();
        }
        $this->set_total($grand_total);
        return true;
    }

    public function get_discounted_total($type) {
        $discountedTotal = 0;
        if ($type == 'both') {
            $special_item_price = 0;
            $cart = $this->get_cart();
            if (!empty($cart)) {
                foreach ($cart as $item) {
                    if ($item['is_special'] == 'yes') {
                        $special_item_price += $item['quantity'] * $item['price'];
                    }
                }
            }
            $subTotal = $this->get_subtotal();
            $discountedTotal = $subTotal - $special_item_price;
        }
        if ($type == 'food') {
            $foodtoal = 0;
            $cart = $this->get_cart();
            if (!empty($cart)) {
                foreach ($cart as $item) {
                    if ($item['category_type'] == 1 && $item['is_special'] != 'yes') {
                        $foodtoal += $item['quantity'] * $item['price'];
                    }
                }
            }
            $discountedTotal = $foodtoal;
        }
        if ($type == 'nonfood') {
            $nonfoodtoal = 0;
            $cart = $this->get_cart();
            if (!empty($cart)) {
                foreach ($cart as $item) {
                    if ($item['category_type'] == 2 && $item['is_special'] != 'yes') {
                        $nonfoodtoal += $item['quantity'] * $item['price'];
                    }
                }
            }
            $discountedTotal = $nonfoodtoal;
        }
        return $discountedTotal;
    }

    public function calculate_discount($data) {
        $discount = 0;
        if (isset($data['func']) && $data['func'] == 1) {
            $discount = $data['total'] * $data['number'] / 100;
        } else {
            $discount = $data['number'];
        }
        return $discount;
    }

    public function set_order_type($data) {
        $this->session->set_userdata('cart_order_type', $data);
    }

    public function get_order_type() {
        if ($this->session->userdata('cart_order_type')) {
            return $this->session->userdata('cart_order_type');
        }
    }

    public function clear_order_type() {
        if ($this->session->userdata('cart_order_type')) {
            $this->session->unset_userdata('cart_order_type');
        }
    }

    public function set_preorder($data) {
        $this->session->set_userdata('preorder', $data);
    }

    public function get_preorder() {
        if ($this->session->userdata('preorder')) {
            return $this->session->userdata('preorder');
        }
    }

    public function clear_preorder() {
        if ($this->session->userdata('preorder')) {
            $this->session->unset_userdata('preorder');
        }
    }

    public function initiate_vat() {
        if ($this->config->item('gk_vat_reg') != '' || $this->config->item('gk_vat_reg')) {
            $vat['number'] = $this->config->item('gk_vat_percent') > 0 ? $this->config->item('gk_vat_percent') : 0;
            $vat['func'] = 1;
            $vat['amount'] = 0;
            $vat['is_included'] = $this->config->item('gk_vat_included') == 'yes' ? 1 : 2;
            $this->set_vat($vat);
        } else {
            $this->clear_vat();
        }
    }

    public function get_vat() {
        if ($this->session->userdata('cart_vat')) {
            return $this->session->userdata('cart_vat');
        }
    }

    public function set_vat($data) {
        $this->session->set_userdata('cart_vat', $data);
    }

    public function clear_vat() {
        if ($this->session->userdata('cart_vat')) {
            $this->session->unset_userdata('cart_vat');
        }
    }

    function set_vat_amount($data) {
        $this->session->set_userdata('vat_amount', $data);
    }

    function get_vat_amount() {
        if ($this->session->userdata('vat_amount')) {
            return $this->session->userdata('vat_amount');
        }
    }

    function clear_vat_amount() {
        if ($this->session->userdata('vat_amount')) {
            $this->session->unset_userdata('vat_amount');
        }
    }

    public function get_subtotal() {
        if ($this->session->userdata('cart_subtotal')) {
            return $this->session->userdata('cart_subtotal');
        }
    }

    public function set_subtotal($data) {
        $this->session->set_userdata('cart_subtotal', $data);
    }

    public function clear_subtotal() {
        if ($this->session->userdata('cart_subtotal')) {
            $this->session->unset_userdata('cart_subtotal');
        }
    }

    function initiate_discount($order_type) {
        if ($this->get_promotion()) {
            $this->db->trans_start();
            $this->promotional_discount($order_type);
            $this->db->trans_complete();
        } else {
            $this->db->trans_start();
            $this->default_discount($order_type);
            $this->db->trans_complete();
        }
    }

    public function promotional_discount($order_type) {
        $order_type_arr = explode('_', $order_type);
        $org_order_type = $order_type_arr[1];
        $promotion = $this->get_promotion();
        if ($promotion['allow_cross'] == 0) {
            if ($promotion[$org_order_type] == 'yes') {
                if ($this->get_subtotal() >= $this->get_min_order_discounted_amount()) {
                    $discount['number'] = $promotion['number'];
                    $discount['func'] = $promotion['func'] == 'percent' ? 1 : 2;
                    $discount['amount'] = 0;
                    $discount['food'] = $promotion['food'];
                    $discount['nonfood'] = $promotion['food'];
                    $discount['min_order'] = $promotion['min_order'];
                    $this->set_discount($discount);
                } else {
                    $this->clear_discount();
                }
            }
        }
        if ($promotion['allow_cross'] == 1 && $this->get_cross_promotion() == 'yes') {
            if ($promotion[$org_order_type] == 'yes') {
                $this->default_discount($order_type);
            }
        }
    }

    public function default_discount($order_type) {
        if ($this->config->item('gk_discount_applied') == 'yes' && !$this->get_discount() && $order_type != null) {
            $defaultDiscountMinOrder = $this->config->item('gk_discount_min_order');
            $getCurrentCartAmount = $this->get_subtotal();
            $gk_discount_dineout = $this->config->item('gk_discount_online');
            $discountAppliedOn = null;
            $dineOutFlag = false;
            $dineOutFlagHasDistinct = false;
            if ($gk_discount_dineout != null && $gk_discount_dineout == 'yes') {
                $dineOutFlag = true;
                $this->db->where('type', 'online_collection');
                $this->db->or_where('type', 'online_delivery');
                $dineOutDisCountPlan = $this->db->get('gkpos_discountplan')->result();
                $type1 = $dineOutDisCountPlan[0]->is_applied == 'yes' ? 'yes' : null;
                $type2 = $dineOutDisCountPlan[1]->is_applied == 'yes' ? 'yes' : null;
                if ($type1 == 'yes' || $type2 == 'yes') {
                    $dineOutFlagHasDistinct = true;
                    foreach ($dineOutDisCountPlan as $discountPlan) {
                        if ($discountPlan->type == $order_type) {
                            $discountAppliedOn['food'] = $discountPlan->food == null && $discountPlan->nonfood == null ? $this->config->item('gk_discount_food') : $discountPlan->food;
                            $discountAppliedOn['nonfood'] = $discountPlan->food == null && $discountPlan->nonfood == null ? $this->config->item('gk_discount_nonfood') : $discountPlan->nonfood;
                        }
                    }
                    $this->set_discount_on($discountAppliedOn);
                } else {
                    $discountAppliedOn['food'] = $this->config->item('gk_discount_food');
                    $discountAppliedOn['nonfood'] = $this->config->item('gk_discount_nonfood');
                    $this->set_discount_on($discountAppliedOn);
                    $dineOutFlagHasDistinct = false;
                }
            }

            if ($dineOutFlag && $dineOutFlagHasDistinct) {
                $overrideDiscountPlan = $this->get_single('gkpos_discountplan', array('type' => $order_type));
                if ($overrideDiscountPlan->is_applied == 'yes') {
                    $minOrderAmountForDiscount = $overrideDiscountPlan->min_order > 0 ? $overrideDiscountPlan->min_order : $defaultDiscountMinOrder;
                    $minOrderAmountForDiscount = $minOrderAmountForDiscount > 0 ? $minOrderAmountForDiscount : 0;
                    $this->set_min_order_discounted_amount($minOrderAmountForDiscount);
                    if ($getCurrentCartAmount >= $minOrderAmountForDiscount) {
                        $number = $overrideDiscountPlan->number > 0 ? $overrideDiscountPlan->number : $this->config->item('gk_discount_percent');
                        $discount['number'] = $number > 0 ? $number : 0;
                        $discount['func'] = $overrideDiscountPlan->func != null && $overrideDiscountPlan->func > 0 ? $overrideDiscountPlan->func : 1;
                        $discount['amount'] = 0;
                        $discount['food'] = $overrideDiscountPlan->food == null && $overrideDiscountPlan->nonfood == null ? $this->config->item('gk_discount_food') : $overrideDiscountPlan->food;
                        $discount['nonfood'] = $overrideDiscountPlan->food == null && $overrideDiscountPlan->nonfood == null ? $this->config->item('gk_discount_nonfood') : $overrideDiscountPlan->nonfood;
                        $discount['min_order'] = $minOrderAmountForDiscount;
                        $this->set_discount($discount);
                    } else {
                        $this->clear_discount();
                    }
                } else {
                    $this->clear_discount();
                }
            } else {
                if ($dineOutFlag && !$dineOutFlagHasDistinct) {
                    $overrideDiscountPlan = $this->get_single('gkpos_discountplan', array('type' => $order_type));
                    $minOrderAmountForDiscount = $overrideDiscountPlan->min_order > 0 ? $overrideDiscountPlan->min_order : $defaultDiscountMinOrder;
                    $minOrderAmountForDiscount = $minOrderAmountForDiscount > 0 ? $minOrderAmountForDiscount : 0;
                    $this->set_min_order_discounted_amount($minOrderAmountForDiscount);
                    if ($getCurrentCartAmount >= $minOrderAmountForDiscount) {
                        $number = $overrideDiscountPlan->number > 0 ? $overrideDiscountPlan->number : $this->config->item('gk_discount_percent');
                        $discount['number'] = $number > 0 ? $number : 0;
                        $discount['func'] = $overrideDiscountPlan->func != null && $overrideDiscountPlan->func > 0 ? $overrideDiscountPlan->func : 1;
                        $discount['amount'] = 0;
                        $discount['food'] = $overrideDiscountPlan->food == null && $overrideDiscountPlan->nonfood == null ? $this->config->item('gk_discount_food') : $overrideDiscountPlan->food;
                        $discount['nonfood'] = $overrideDiscountPlan->food == null && $overrideDiscountPlan->nonfood == null ? $this->config->item('gk_discount_nonfood') : $overrideDiscountPlan->nonfood;
                        $discount['min_order'] = $minOrderAmountForDiscount;
                        $this->set_discount($discount);
                    } else {
                        $this->clear_discount();
                    }
                }
            }
        } else {
            $this->clear_discount();
        }
    }

    public function set_discount_on($data) {
        $applied_on = null;
        $food = isset($data['food']) && $data['food'] == 'yes' ? true : false;
        $nonfood = isset($data['nonfood']) && $data['nonfood'] == 'yes' ? true : false;
        $both = ($food && $nonfood) ? true : false;
        if ($both) {
            $applied_on = "both";
        }
        if ($food && !$both) {
            $applied_on = "food";
        }
        if ($nonfood && !$both) {
            $applied_on = "nonfood";
        }
        $this->session->set_userdata('discount_on', $applied_on);
    }

    public function get_discount_on() {
        if ($this->session->userdata('discount_on')) {
            return $this->session->userdata('discount_on');
        }
    }

    public function clear_discount_on() {
        if ($this->session->userdata('discount_on')) {
            $this->session->unset_userdata('discount_on');
        }
    }

    public function set_min_order_discounted_amount($data) {
        $this->session->set_userdata('min_order', $data);
    }

    public function get_min_order_discounted_amount() {
        if ($this->session->userdata('min_order')) {
            return $this->session->userdata('min_order');
        }
    }

    public function clear_min_order_discounted_amount() {
        if ($this->session->userdata('min_order')) {
            $this->session->unset_userdata('min_order');
        }
    }

    public function get_discount() {
        if ($this->session->userdata('cart_discount')) {
            return $this->session->userdata('cart_discount');
        }
    }

    public function set_discount($data) {
        $this->session->set_userdata('cart_discount', $data);
    }

    public function clear_discount() {
        if ($this->session->userdata('cart_discount')) {
            $this->session->unset_userdata('cart_discount');
        }
    }

    function set_discount_amount($data) {
        $this->session->set_userdata('discount_amount', $data);
    }

    function get_discount_amount() {
        if ($this->session->userdata('discount_amount')) {
            return $this->session->userdata('discount_amount');
        }
    }

    function clear_discount_amount() {
        if ($this->session->userdata('discount_amount')) {
            $this->session->unset_userdata('discount_amount');
        }
    }

    public function set_bogo_discount($data) {
        $this->session->set_userdata('cart_bogo_discount', $data);
    }

    public function get_bogo_discount() {
        if ($this->session->userdata('cart_bogo_discount')) {
            return $this->session->userdata('cart_bogo_discount');
        }
    }

    public function clear_bogo_discount() {
        $this->session->unset_userdata('cart_bogo_discount');
    }

    function set_bogodiscount_amount($data) {
        $this->session->set_userdata('bogodiscount_amount', $data);
    }

    function get_bogodiscount_amount() {
        if ($this->session->userdata('bogodiscount_amount')) {
            return $this->session->userdata('bogodiscount_amount');
        }
    }

    function clear_bogodiscount_amount() {
        if ($this->session->userdata('bogodiscount_amount')) {
            $this->session->unset_userdata('bogodiscount_amount');
        }
    }

    function get_deliveryplan() {
        if ($this->session->userdata('cart_deliveryplan')) {
            return $this->session->userdata('cart_deliveryplan');
        }
    }

    function set_deliveryplan($data) {
        $this->session->set_userdata('cart_deliveryplan', $data);
    }

    public function clear_deliveryplan() {
        if ($this->session->userdata('cart_deliveryplan')) {
            $this->session->unset_userdata('cart_deliveryplan');
        }
    }

    function get_total() {
        if ($this->session->userdata('cart_total')) {
            return $this->session->userdata('cart_total');
        }
    }

    function set_total($data) {
        $this->session->set_userdata('cart_total', $data);
    }

    public function clear_total() {
        if ($this->session->userdata('cart_total')) {
            $this->session->unset_userdata('cart_total');
        }
    }

    public function get_promotion() {
        if ($this->session->userdata('cart_promotion')) {
            return $this->session->userdata('cart_promotion');
        }
    }

    public function set_promotion($data) {
        $this->session->set_userdata('cart_promotion', $data);
    }

    public function clear_promotion() {
        if ($this->session->userdata('cart_promotion')) {
            $this->session->unset_userdata('cart_promotion');
        }
    }

    public function set_cross_promotion($data) {
        $this->session->set_userdata('has_cross_promotion', $data);
    }

    public function get_cross_promotion() {
        if ($this->session->userdata('has_cross_promotion')) {
            return $this->session->userdata('has_cross_promotion');
        }
    }

    public function clear_cross_promotion() {
        if ($this->session->userdata('has_cross_promotion')) {
            $this->session->unset_userdata('has_cross_promotion');
        }
    }

    public function set_cross_promotion_amount($data) {
        $this->session->set_userdata('cross_promotion_amount', $data);
    }

    public function get_cross_promotion_amount() {
        if ($this->session->userdata('cross_promotion_amount')) {
            return $this->session->userdata('cross_promotion_amount');
        }
    }

    public function clear_cross_promotion_amount() {
        if ($this->session->userdata('cross_promotion_amount')) {
            $this->session->unset_userdata('cross_promotion_amount');
        }
    }

    public function set_checkout_data($data) {
        $this->session->set_userdata('checkout_info', $data);
    }

    public function get_checkout_data() {
        if ($this->session->userdata('checkout_info')) {
            return $this->session->userdata('checkout_info');
        }
    }

    public function clear_checkout_data() {
        if ($this->session->userdata('checkout_info')) {
            $this->session->unset_userdata('checkout_info');
        }
    }

    function get_current_orderid() {
        if ($this->session->userdata('current_order_id')) {
            return $this->session->userdata('current_order_id');
        }
    }

    function set_current_orderid($order_id) {
        $this->session->set_userdata('current_order_id', $order_id);
    }

    function clear_current_orderid() {
        if ($this->session->userdata('current_order_id')) {
            $this->session->unset_userdata('current_order_id');
        }
    }

    function get_delivery_address() {
        if ($this->session->userdata('delivery_address')) {
            return $this->session->userdata('delivery_address');
        }
    }

    function set_delivery_address($data) {
        $this->session->set_userdata('delivery_address', $data);
    }

    function clear_delivery_address() {
        if ($this->session->userdata('delivery_address')) {
            $this->session->unset_userdata('delivery_address');
        }
    }

    function get_cc_fee() {
        if ($this->session->userdata('cc_fee')) {
            return $this->session->userdata('cc_fee');
        }
    }

    function set_cc_fee($data) {
        $this->session->set_userdata('cc_fee', $data);
    }

    function clear_cc_fee() {
        if ($this->session->userdata('cc_fee')) {
            $this->session->unset_userdata('cc_fee');
        }
    }

    function get_delivery_postcode() {
        if ($this->session->userdata('delivery_postcode')) {
            return $this->session->userdata('delivery_postcode');
        }
    }

    function set_delivery_postcode($data) {
        $this->session->set_userdata('delivery_postcode', $data);
    }

    function clear_delivery_postcode() {
        if ($this->session->userdata('delivery_postcode')) {
            $this->session->unset_userdata('delivery_postcode');
        }
    }

    function get_online_method() {
        if ($this->session->userdata('payment_method')) {
            return $this->session->userdata('payment_method');
        }
    }

    function set_online_method($data) {
        $this->session->set_userdata('payment_method', $data);
    }

    function clear_online_method() {
        if ($this->session->userdata('payment_method')) {
            $this->session->unset_userdata('payment_method');
        }
    }

    function is_checkout_login() {
        if ($this->session->userdata('checkout_login')) {
            return $this->session->userdata('checkout_login');
        }
    }

    function set_checkout_login($checkout_loging) {
        $this->session->set_userdata('checkout_login', $checkout_loging);
    }

    function clear_checkout_login() {
        if ($this->session->userdata('checkout_login')) {
            $this->session->unset_userdata('checkout_login');
        }
    }

    function get_delivery_time() {
        if ($this->session->userdata('delivery_time')) {
            return $this->session->userdata('delivery_time');
        }
    }

    function set_delivery_time($data) {
        $this->session->set_userdata('delivery_time', $data);
    }

    function clear_delivery_time() {
        if ($this->session->userdata('delivery_time')) {
            $this->session->unset_userdata('delivery_time');
        }
    }

    public function clear_all() {
        $this->clear_all_discount();
        $this->clear_vat();
        $this->clear_vat_amount();
        $this->clear_subtotal();
        $this->empty_cart();
        $this->clear_total();
        $this->clear_current_orderid();
        $this->clear_online_method();
        $this->clear_cc_fee();
        $this->clear_preorder();
        $this->clear_checkout_login();
        $this->clear_bogo_discount();
        $this->clear_bogodiscount_amount();
        $this->clear_delivery_postcode();
        $this->clear_delivery_time();
    }

    public function clear_all_discount() {
        $this->clear_order_type();
        $this->clear_discount_on();
        $this->clear_min_order_discounted_amount();
        $this->clear_discount();
        $this->clear_discount_amount();
        $this->clear_promotion();
        $this->clear_delivery_address();
        $this->clear_deliveryplan();
        $this->clear_cross_promotion();
        $this->clear_cross_promotion_amount();
        $this->clear_checkout_data();
    }

}
