<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Booking extends Gkpos_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Booking_Model');
        $this->load->helper('gkpos');
        $this->load->model('Entry_Model');
        if (!$this->Entry_Model->is_logged_in()) {
            redirect('gkpos/entry');
        }
    }

    public function index($segment = 0) {
        $start_date = DateTime::createFromFormat($this->config->item('dateformat'), $this->input->post('start_date') != null ? $this->input->post('start_date') : date($this->config->item('dateformat'), strtotime('today')));
        $end_date = DateTime::createFromFormat($this->config->item('dateformat'), $this->input->post('end_date') != null ? $this->input->post('end_date') : date($this->config->item('dateformat'), strtotime('today')));
        $start_date_value = $start_date->format('Y-m-d');
        $end_date_value = $end_date->format('Y-m-d');
        $limit = $this->config->item('gk_report_line_page');
        $filters = array(
            'start_date' => $start_date_value,
            'end_date' => $end_date_value
        );
        $records = $this->Booking_Model->get_booking_rows('gkpos_booking', $filters);
        $maxCounter = $records > $limit ? ceil($records / $limit) : 0;
        $offset = $segment > 0 ? $segment * $limit : 0;
        $data['maxCounter'] = $maxCounter;
        $data['segment'] = $segment;
        $data['start_date'] = $start_date_value;
        $data['end_date'] = $end_date_value;
        $data['list'] = $result = $this->Booking_Model->get_booking_list('gkpos_booking', $filters, $offset, $limit, 'created_at', 'DESC');
        $this->load->view('gkpos/booking/view', $data);
    }

    public function filter($segment = 0) {
        $start_date = DateTime::createFromFormat($this->config->item('dateformat'), $this->input->post('start_date') != null ? $this->input->post('start_date') : date($this->config->item('dateformat'), strtotime('today')));
        $end_date = DateTime::createFromFormat($this->config->item('dateformat'), $this->input->post('end_date') != null ? $this->input->post('end_date') : date($this->config->item('dateformat'), strtotime('today')));
        $start_date_value = $start_date->format('Y-m-d');
        $end_date_value = $end_date->format('Y-m-d');
        $limit = $this->config->item('gk_report_line_page');
        $filters = array(
            'start_date' => $start_date_value,
            'end_date' => $end_date_value
        );
        $records = $this->Booking_Model->get_booking_rows('gkpos_booking', $filters);
        $maxCounter = $records > $limit ? ceil($records / $limit) : 0;
        $offset = $segment > 0 ? $segment * $limit : 0;
        $data['maxCounter'] = $maxCounter;
        $data['segment'] = $segment;
        $data['start_date'] = $start_date_value;
        $data['end_date'] = $end_date_value;
        $data['list'] = $result = $this->Booking_Model->get_booking_list('gkpos_booking', $filters, $offset, $limit, 'created_at', 'DESC');
        $this->load->view('gkpos/booking/filter', $data);
    }

    public function add() {
        $data = array();
        $sevenDays = $this->Booking_Model->get_list('servicetime');
        $week = array();
        foreach ($sevenDays as $key => $day) {
            $week[$day->day] = $day;
        }
        $opened = $week[strtolower(date('D'))]->open;
        $openedObj = new DateTime($opened);
        $openingTime = $openedObj->format('h:i a');
        $closed = $week[strtolower(date('D'))]->closed;
        $closedObj = new DateTime($closed);
        $interval = $openedObj->diff($closedObj);
        $totalMins = 0;
        if ($interval->h >= 1) {
            $totalMins += $interval->h * 60;
        }
        if ($interval->i >= 1) {
            $totalMins += $interval->i;
        }
        $timeSlotIndex = ceil($totalMins / 15);
        $timeSlot = array();
        for ($i = 0; $i < $timeSlotIndex; $i++) {
            $nowDate = new DateTime($openingTime);
            $nowDate->add(new DateInterval('PT15M'));
            $nowTime = $nowDate->format('h:i a');
            $timeSlot[] = $nowTime;
            $openingTime = $nowTime;
        }
        $data['time_slot'] = $timeSlot;
        $this->load->view('gkpos/booking/add', $data);
    }

    public function save() {
        $success = false;
        if ($this->input->post()) {
            $data = $this->prepareData();
            $res_date = DateTime::createFromFormat('d/m/Y', $this->input->post('res_date') != null ? $this->input->post('res_date') : date($this->config->item('dateformat'), strtotime('today')));
            $res_date_value = $res_date->format('Y-m-d');
            $data['res_date'] = $res_date_value;
            $data['created_at'] = date('Y-m-d');
            $success = $this->db->insert('gkpos_booking', $data);
        }
        echo json_encode(array('success' => $success, 'message' => $success ? 'save successfully' : 'save failed'));
    }

    public function delete() {
        $id = $this->input->post('id');
        $success = $this->db->delete('gkpos_booking', array('id' => $id));
        echo json_encode(array('success' => $success, 'message' => $success ? ' Reservation deleted successfully !' : 'Reservation deletion failed!'));
    }

    public function pending_booking() {
        $data['booking'] = $this->Booking_Model->get_list('gkpos_booking', array('status' => 0), null, 1, 0, 'created_at', 'DESC');
        $this->load->view('gkpos/gkpos/online/pending_booking', $data, false);
    }

    public function reaction() {
        $status_txt = array('Pending', 'Confirmed', 'Canceled');
        $id = $this->input->post('id');
        $status = $this->input->post('status');
        $success = $this->db->update('gkpos_booking', array('status' => $status), array('id' => $id));
        if ($success && $status != 0) {
            $recepient = $this->Booking_Model->get_single('gkpos_booking', array('id' => $id));
            $data['recipent'] = 'Customer';
            $data['to'] = $recepient->res_email;
            $data['from'] = $this->config->item('gk_email');
            $data['from_title'] = $this->config->item('gk_name');
            if ($status == 1) {
                $data['subject'] = "Reservation Confirmation";
                $data['txt'] = 'your reservation has been confirmed';
            }
            if ($status == 2) {
                $data['subject'] = "Reservation Rejected";
                $data['txt'] = 'Sorry! your reservation has been rejected';
            }
            $data['verify_link'] = null;
            $data['message'] = $this->load->view('email_template/common', $data, true);
            if ($this->send_email($data)) {
                $success = true;
            } else {
                $success = false;
            }
        }
        echo json_encode(array('success' => $success, 'message' => $success ? $status_txt[$status] . ' operation on booking done successfully !' : $status_txt[$status] . ' operation on booking failed!'));
    }

}
