<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Gkpos extends Gkpos_Controller {

    function __construct() {
        parent::__construct();
        $this->site_title = $this->config->item('gk_name');
        $this->load->model('Entry_Model');
        if (!$this->Entry_Model->is_logged_in()) {
            if ($this->config->item('gk_only_online_admin') == 'yes') {
                redirect('gkpos/entry/online');
            } else {
                redirect('gkpos/entry');
            }
        }
        $this->load->helper('gkpos');
        $this->load->model('Gkpos_Model');
    }

    public function index() {
        if ($this->config->item('gk_only_online_admin') == 'yes') {
            redirect('gkpos/settings/base');
        }
        $this->page_title = 'Gkpos | Mainboard';
        $this->current_section = "Mainboard";
        $this->body_class [] = "pos-mainboard";
        $data['current_page'] = "gkpos";
        $this->db->trans_start();
        $data['table_orders'] = $this->Gkpos_Model->get_table_orders();
        $data['takeaway_orders'] = $this->Gkpos_Model->get_takeaway_orders();
        $data['bar_orders'] = $this->Gkpos_Model->get_bar_orders();
        $this->db->trans_complete();
        if ($this->db->trans_status()) {
            //debugPrint($this->session->userdata());
            $this->render_page('gkpos/gkpos/index/index', $data);
        }
    }

    public function indexajax() {
        $this->db->trans_start();
        $data['table_orders'] = $this->Gkpos_Model->get_table_orders();
        $data['takeaway_orders'] = $this->Gkpos_Model->get_takeaway_orders();
        $data['bar_orders'] = $this->Gkpos_Model->get_bar_orders();
        $this->db->trans_complete();
        $data['current_page'] = "indexajax";
        if ($this->db->trans_status()) {
            $this->load->view('gkpos/gkpos/index/indexajax', $data, false);
        }
    }

    public function indexajaxccontent() {
        $data['current_page'] = "indexajaxccontent";
        $this->db->trans_start();
        $data['table_orders'] = $this->Gkpos_Model->get_table_orders();
        $data['takeaway_orders'] = $this->Gkpos_Model->get_takeaway_orders();
        $data['bar_orders'] = $this->Gkpos_Model->get_bar_orders();
        $this->db->trans_complete();
        if ($this->db->trans_status()) {
            $this->load->view('gkpos/gkpos/index/indexajaxccontent', $data, false);
        }
    }

    public function takeaway() {
        $info = $this->input->post('info');
        $data['info'] = $info;
        $data['current_section'] = "Takeaway";
        $data['current_page'] = "takeaway";
        $this->load->view('gkpos/gkpos/takeaway', $data, false);
    }

    public function delivery() {
        $info = $this->input->post('info');
        if (is_array($info) && count($info > 1)) {
            $data['callerName'] = $info[0];
            $data['callerPhone'] = $info[1];
            $data['callerOrderType'] = $info[2];
            $data['isPhoneCall'] = $info[3];
            $data['info'] = $info[2];
            $data['customer'] = $this->Gkpos_Model->get_single('gkpos_customer', array('phone' => $data['callerPhone']));
            if (empty($data['customer'])) {
                $data['customer'] = (object) array('name' => $info[0], 'phone' => $info[1]);
            }
            $this->db->update('gkpos_caller', array('status' => 0, 'missed_call' => 0), array('caller_id' => $info[1], 'status' => 1));
        } else {
            $data['info'] = $info;
        }
        $data['current_section'] = $this->lang->line('gkpos_delivery');
        $data['current_page'] = "delivery";
        $this->load->view('gkpos/gkpos/delivery/order_place', $data, false);
    }

    public function delivery_order() {
        $info = $this->input->post('info');
        $data['info'] = $info;
        $data['current_section'] = "Takeaway-Delivery Orders Only";
        $data['current_page'] = "delivery_order";
        $data['takeaway_orders'] = $this->Gkpos_Model->get_delivery_orders();
        $this->load->view('gkpos/gkpos/delivery/order_list', $data, false);
    }

    public function collection() {
        $info = $this->input->post('info');
        if (is_array($info) && count($info > 1)) {
            $data['callerName'] = $info[0];
            $data['callerPhone'] = $info[1];
            $data['callerOrderType'] = $info[2];
            $data['isPhoneCall'] = $info[3];
            $data['customer'] = $this->Gkpos_Model->get_single('gkpos_customer', array('phone' => $data['callerPhone']));
            if (empty($data['customer'])) {
                $data['customer'] = (object) array('name' => $info[0], 'phone' => $info[1]);
            }
            $this->db->update('gkpos_caller', array('status' => 0, 'missed_call' => 0), array('caller_id' => $info[1], 'status' => 1));
        } else {
            $data['info'] = $info;
        }

        $data['current_section'] = $this->lang->line('gkpos_collection');
        $data['current_page'] = "collection";
        $this->load->view('gkpos/gkpos/collection/order_place', $data, false);
    }

    public function collection_order() {
        $info = $this->input->post('info');
        $data['info'] = $info;
        $data['current_section'] = "Takeaway-Collection Orders Only";
        $data['current_page'] = "collection_order";
        $data['takeaway_orders'] = $this->Gkpos_Model->get_collection_orders();
        $this->load->view('gkpos/gkpos/collection/order_list', $data, false);
    }

    public function waiting() {
        $info = $this->input->post('info');
        if (is_array($info) && count($info > 1)) {
            $data['callerName'] = $info[0];
            $data['callerPhone'] = $info[1];
            $data['callerOrderType'] = $info[2];
            $data['isPhoneCall'] = $info[3];
            $data['info'] = $info[2];
        } else {
            $data['info'] = $info;
        }
        $data['current_section'] = $this->lang->line('gkpos_waiting');
        $data['current_page'] = "waiting";
        $this->load->view('gkpos/gkpos/waiting/order_place', $data, false);
    }

    public function waiting_order() {
        $info = $this->input->post('info');
        $data['info'] = $info;
        $data['current_section'] = "Takeaway-Waiting Orders Only";
        $data['current_page'] = "waiting_order";
        $data['takeaway_orders'] = $this->Gkpos_Model->get_waiting_orders();
        $this->load->view('gkpos/gkpos/waiting/order_list', $data, false);
    }

    public function bar() {
        $info = $this->input->post('info');
        if (is_array($info) && count($info > 1)) {
            $data['callerName'] = $info[0];
            $data['callerPhone'] = $info[1];
            $data['callerOrderType'] = $info[2];
            $data['isPhoneCall'] = $info[3];
            $data['info'] = $info[2];
        } else {
            $data['info'] = $info;
        }
        $data['current_section'] = $this->lang->line('gkpos_bar');
        $data['current_page'] = "bar";
        $this->load->view('gkpos/gkpos/bar/order_place', $data, false);
    }

    public function bar_order() {
        $info = $this->input->post('info');
        $data['info'] = $info;
        $data['current_section'] = "Bar orders only";
        $data['current_page'] = "bar_order";
        $data['takeaway_orders'] = $this->Gkpos_Model->get_bar_orders();
        $this->load->view('gkpos/gkpos/bar/order_list', $data, false);
    }

    public function table() {
        $info = $this->input->post('info');
        if (is_array($info) && count($info > 1)) {
            $data['callerName'] = $info[0];
            $data['callerPhone'] = $info[1];
            $data['callerOrderType'] = $info[2];
            $data['isPhoneCall'] = $info[3];
            $data['info'] = $info[2];
        } else {
            $data['info'] = $info;
        }
        $data['current_section'] = $this->lang->line('gkpos_table');
        $data['current_page'] = "table";
        $this->load->view('gkpos/gkpos/table/order_place', $data, false);
    }

    public function table_seated_not_ordered() {
        $info = $this->input->post('info');
        $data['info'] = $info;
        $data['current_section'] = "Table Seated But Not Ordered";
        $data['current_page'] = "table_seated_not_ordered";
        $data['table_orders'] = $this->Gkpos_Model->get_table_seated_not_ordered();
        $this->load->view('gkpos/gkpos/table/seated_not_ordered', $data, false);
    }

    public function table_seated_ordered() {
        $info = $this->input->post('info');
        $data['info'] = $info;
        $data['current_section'] = "Table Seated and ordered";
        $data['current_page'] = "table_seated_ordered";
        $data['table_orders'] = $this->Gkpos_Model->get_table_seated_ordered();
        $this->load->view('gkpos/gkpos/table/seated_ordered', $data, false);
    }

    public function table_waiting_payment() {
        $info = $this->input->post('info');
        $data['info'] = $info;
        $data['current_section'] = "Waiting for table order Paymnet";
        $data['current_page'] = "table_waiting_payment";
        $data['table_orders'] = $this->Gkpos_Model->get_table_waiting_payment();
        $this->load->view('gkpos/gkpos/table/wating_payment', $data, false);
    }

    public function logoff() {
        $this->Entry_Model->logout();
    }

    public function keyboard_setting() {
        $is_touch = $this->input->post('is_touch');
        echo $this->Appconfig->batch_save(array('is_touch' => $is_touch));
    }

    public function search_customer() {
        $key = $this->input->post('key');
        $value = $this->input->post('value');
        $value = str_replace(' ', '', $value);
        $customer = $this->Gkpos_Model->get_single('gkpos_customer', array($key => $value));
        if (!empty($customer)) {
            echo json_encode(array('status' => true, 'customer' => $customer));
        } else {
            echo json_encode(array('status' => false));
        }
    }

    public function get_customer() {
        $term = $this->input->get('term');
        $this->db->select('name');
        $this->db->from('gkpos_customer');
        $this->db->where("name LIKE '%" . $term . "%'");
        $this->db->order_by("name", "asc");
        $result = $this->db->get()->result();
        $customer = array_map('current', $result);
        echo json_encode($customer);
    }

    public function get_customer_phone() {
        $term = $this->input->get('term');
        $this->db->select('phone');
        $this->db->from('gkpos_customer');
        $this->db->where("phone LIKE '%" . $term . "%'");
        $this->db->order_by("phone", "asc");
        $result = $this->db->get()->result();
        $customer = array_map('current', $result);
        echo json_encode($customer);
    }

    public function get_customer_city() {
        $term = $this->input->get('term');
        $this->db->select('city');
        $this->db->from('gkpos_customer');
        $this->db->where("city LIKE '%" . $term . "%'");
        $this->db->group_by("city");
        $this->db->order_by("city", "asc");
        $result = $this->db->get()->result();
        $customer = array_map('current', $result);
        echo json_encode($customer);
    }

    public function get_customer_postcode() {
        $term = $this->input->get('term');
        $this->db->select('postcode');
        $this->db->from('gkpos_customer');
        $this->db->where("postcode LIKE '%" . $term . "%'");
        $this->db->group_by("postcode");
        $this->db->order_by("postcode", "asc");
        $result = $this->db->get()->result();
        $customer = array_map('current', $result);
        echo json_encode($customer);
    }

    public function orderinitiate() {
        $gorder_id = $this->Gkpos_Model->get_key();
        $postedData = $this->input->post();
        $postedData['online_status'] = 1;
        $success = false;
        if ($this->form_validation->run('gkpos_' . $postedData['order_type']) == FALSE) {
            $message = validation_errors();
            $success = false;
        } else {
            $success = true;
            $message = "ok";
        }
        if ($success) {
            $inner_success = false;
            $data = $postedData;
            if ($postedData['order_type'] != 'table') {
                if ($postedData['order_type'] == 'delivery') {
                    $now = date('Y-m-d H:i:s');
                    $nowDate = new DateTime($now);
                    if ($postedData['delivery_time'] != null) {
                        $postedData['delivery_time'] = $postedData['delivery_time'] + (int) $this->config->item('default_delivery_time');
                        $nowDate->add(new DateInterval('PT' . $postedData['delivery_time'] . 'M'));
                        $postedData['delivery_time'] = $nowDate->format('Y-m-d H:i:s');
                    } else {
                        $nowDate->add(new DateInterval('PT' . (int) $this->config->item('default_delivery_time') . 'M'));
                        $postedData['delivery_time'] = $nowDate->format('Y-m-d H:i:s');
                    }
                }

                if ($postedData['order_type'] == 'collection') {
                    $now = date('Y-m-d H:i:s');
                    $nowDate = new DateTime($now);
                    if ($postedData['delivery_time'] != null) {
                        $postedData['delivery_time'] = $postedData['delivery_time'];
                    } else {
                        $nowDate->add(new DateInterval('PT' . (int) $this->config->item('default_collection_time') . 'M'));
                        $postedData['delivery_time'] = $nowDate->format('Y-m-d H:i:s');
                    }
                }

                if (isset($postedData['postcode'])) {
                    $postedData['postcode'] = postcodeFormat($postedData['postcode']);
                }

                $exists = $this->Gkpos_Model->exists('gkpos_customer', 'phone', $postedData['phone']);
                if (!$exists) {
                    if (isset($data['order_type'])) {
                        unset($data['order_type']);
                    }
                    if (isset($data['delivery_time'])) {
                        unset($data['delivery_time']);
                    }
                    $data = $this->prepareGkposData($data);
                    $data['status'] = '1';
                    $data['created_by'] = $this->session->userdata('gkpos_userid');
                    unset($data['online_status']);
                    $inner_success = $this->Gkpos_Model->save_customer_info($data);
                    $postedData = $this->prepareGkposData($postedData);
                    $postedData['id'] = $gorder_id;
                    $postedData['status'] = '1';
                    $postedData['created_by'] = $this->session->userdata('gkpos_userid');
                    $postedData['created'] = date('Y-m-d H:i:s');
                    $order_id = $this->Gkpos_Model->save_order_info($postedData);
                    $inner_success = $order_id ? true : false;
                    if ($order_id) {
                        $this->__go_to_order_lookup($gorder_id, $postedData['created_by']);
                        $activity = array(
                            'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has created ' . $postedData['order_type'] . ' order-' . $gorder_id
                        );
                        $this->Gkpos_Model->posactivity($activity);
                    }

                    $message = $inner_success ? $message : $this->lang->line('gkpos_internal_problem');
                    echo json_encode(array('success' => $inner_success, 'order_id' => $gorder_id, 'name' => $postedData['name'], 'message' => $message));
                    exit();
                } else {
                    $customer = $this->Gkpos_Model->get_single('gkpos_customer', array('phone' => $postedData['phone']));
                    if ($customer->postcode == null && $postedData['order_type'] == 'delivery') {
                        $customerData = $this->prepareGkposData($postedData);
                        if (isset($customerData['order_type'])) {
                            unset($customerData['order_type']);
                        }
                        if (isset($customerData['delivery_time'])) {
                            unset($customerData['delivery_time']);
                        }
                        if (isset($customerData['phone'])) {
                            unset($customerData['phone']);
                        }
                        if (isset($customerData['name'])) {
                            unset($customerData['name']);
                        }
                        unset($customerData['online_status']);
                        $this->db->update('gkpos_customer', $customerData, array('phone' => $postedData['phone']));
                    }
                    $data = $this->prepareGkposData($postedData);
                    $data['status'] = '1';
                    $data['created_by'] = $this->session->userdata('gkpos_userid');
                    $data['created'] = date('Y-m-d H:i:s');
                    $data['id'] = $gorder_id;
                    $order_id = $this->Gkpos_Model->save_order_info($data);
                    if ($order_id) {
                        $this->__go_to_order_lookup($gorder_id, $data['created_by']);
                        $activity = array(
                            'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has created ' . $postedData['order_type'] . ' order-' . $gorder_id
                        );
                        $this->Gkpos_Model->posactivity($activity);
                    }
                    $inner_success = $order_id ? true : false;
                    $message = $inner_success ? $message : $this->lang->line('gkpos_internal_problem');
                    echo json_encode(array('success' => $inner_success, 'order_id' => $gorder_id, 'name' => $data['name'], 'message' => $message));
                    exit();
                }
            } else {
                $table_info = $this->Gkpos_Model->get_single('gkpos_table', array('table_number' => (int) $postedData['table_number']));
                if (!empty($table_info)) {
                    if ($table_info->is_vacant == '2') {
                        echo json_encode(array('success' => false, 'message' => $this->lang->line('gkpos_table') . ' ' . (int) $postedData['table_number'] . ' ' . $this->lang->line('gkpos_table_not_vacant')));
                        exit();
                    } else {
                        $inner_status1 = $this->db->update('gkpos_table', array('guest_quantity' => (int) $postedData['guest_quantity'], 'is_vacant' => '2', 'modified' => date('Y-m-d H:i:s'), 'modified_by' => $this->session->userdata('gkpos_userid')), array('id' => $table_info->id, 'table_number' => $table_info->table_number));
                        $data = $this->prepareGkposData($data);
                        $data['table_id'] = $table_info->id;
                        $data['status'] = '1';
                        $data['created_by'] = $this->session->userdata('gkpos_userid');
                        $data['table_number'] = (int) $data['table_number'];
                        $data['guest_quantity'] = (int) $data['guest_quantity'];
                        $data['created'] = date('Y-m-d H:i:s');
                        $data['id'] = $gorder_id;
                        $order_id = $this->Gkpos_Model->save_order_info($data);
                        if ($order_id) {
                            $this->__go_to_order_lookup($gorder_id, $data['created_by']);
                            $activity = array(
                                'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has created ' . $postedData['order_type'] . ' order-' . $gorder_id . ' for table number ' . $data['table_number']
                            );
                            $this->Gkpos_Model->posactivity($activity);
                        }
                        $inner_status2 = $order_id;
                        $inner_status = ($inner_status1 && $inner_status2) ? true : false;
                        $message = $inner_status ? "ok" : $this->lang->line('gkpos_internal_problem');
                        echo json_encode(array('success' => $inner_status, 'order_id' => $gorder_id, 'name' => $data['table_number'], 'message' => $message));
                        exit();
                    }
                } else {
                    if ($data['order_type']) {
                        unset($data['order_type']);
                    }
                    $data['status'] = '1';
                    $data['created_by'] = $this->session->userdata('gkpos_userid');
                    $data['is_vacant'] = '2';
                    $data['table_number'] = (int) $data['table_number'];
                    $data['guest_quantity'] = (int) $data['guest_quantity'];
                    $data = $this->prepareGkposData($data);
                    unset($data['online_status']);
                    $id = $this->Gkpos_Model->save_table_info($data);
                    if ($id) {
                        $postedData = $this->prepareGkposData($postedData);
                        $postedData['table_id'] = $id;
                        $postedData['status'] = '1';
                        $postedData['table_number'] = (int) $postedData['table_number'];
                        $postedData['guest_quantity'] = (int) $postedData['guest_quantity'];
                        $postedData['created_by'] = $this->session->userdata('gkpos_userid');
                        $postedData['created'] = date('Y-m-d H:i:s');
                        $postedData['id'] = $gorder_id;
                        $order_id = $this->Gkpos_Model->save_order_info($postedData);
                        if ($order_id) {
                            $this->__go_to_order_lookup($gorder_id, $postedData['created_by']);
                            $activity = array(
                                'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has created ' . $postedData['order_type'] . ' order-' . $gorder_id . ' for table number ' . $data['table_number']
                            );
                            $this->Gkpos_Model->posactivity($activity);
                        }
                        $inner_status = $order_id ? true : false;
                        $message = $inner_status ? "ok" : $this->lang->line('gkpos_internal_problem');
                        echo json_encode(array('success' => $inner_status, 'order_id' => $gorder_id, 'name' => $postedData['table_number'], 'message' => $message));
                        exit();
                    }
                }
            }
        }
        if ($order_id && $order_id != '') {
            echo json_encode(array('success' => $success, 'order_id' => $order_id, 'message' => $message));
        } else {
            echo json_encode(array('success' => $success, 'message' => $message));
        }
    }

    private function __go_to_order_lookup($id, $createdBy) {
        return $this->db->insert('gkpos_order_lookup', array('order_id' => $id, 'occupied_by' => $createdBy, 'is_locked' => 1));
    }

    public function gapitest() {
        $this->render_page('gkpos/apitest');
    }

    public function is_google_api_loaded() {
        if (!$this->Gkpos_Model->get_google_api()) {
            echo json_encode(array('success' => false, 'message' => 'need to load api'));
        } else {
            echo json_encode(array('success' => true, 'message' => 'need not to load api'));
        }
    }

    public function getkey() {
        echo $this->Gkpos_Model->get_key();
    }

    public function latestPendingOrder() {
        $data['order'] = $order = $this->Gkpos_Model->get_list('gkpos_order', array('order_type' => 'online', 'online_status' => 0), null, 1, 0, 'created', 'ASC');
        if (!empty($order)) {
            $data['items'] = $this->Gkpos_Model->get_list('gkpos_order_detail', array('order_id' => $order[0]->id));
            $discount = $this->Gkpos_Model->get_single('gkpos_order_discount', array('order_id' => $order[0]->id));
            $data['discount'] = !empty($discount) ? $discount->amount : 0;
            $vat = $this->Gkpos_Model->get_single('gkpos_order_vat', array('order_id' => $order[0]->id));
            $data['vat'] = !empty($vat) ? $vat->amount : 0;
            $payments = $this->Gkpos_Model->get_list('gkpos_order_payment', array('order_id' => $order[0]->id));
            $payments_cool = array();
            if (!empty($payments)) {
                foreach ($payments as $key => $obj) {
                    $payments_cool[$obj->method] = array(
                        'method' => $obj->method,
                        'amount' => $obj->amount,
                        'order_id' => $obj->order_id
                    );
                }
            }
            $data['payments'] = $payments_cool;
            //debugPrint($data);
            $this->load->view('gkpos/gkpos/online/pending_order', $data, false);
        }
    }

    public function online_order($action = null, $status = null) {
        $info = $this->input->post('info');
        $data['info'] = $info;
        $data['current_section'] = "Online orders only";
        $data['current_page'] = "online_order";
        $data['action'] = $action;
        $data['takeaway_orders'] = $this->Gkpos_Model->get_online_orders($action, $status);
        $this->load->view('gkpos/gkpos/online/online_order', $data, false);
    }

    public function online_solo_order($id = '0') {
        $data['order'] = $order = $this->Gkpos_Model->get_list('gkpos_order', array('id' => $id));
        if (!empty($order)) {
            $data['items'] = $this->Gkpos_Model->get_list('gkpos_order_detail', array('order_id' => $order[0]->id));
            $discount = $this->Gkpos_Model->get_single('gkpos_order_discount', array('order_id' => $order[0]->id));
            $data['discount'] = !empty($discount) ? $discount->amount : 0;
            $vat = $this->Gkpos_Model->get_single('gkpos_order_vat', array('order_id' => $order[0]->id));
            $data['vat'] = !empty($vat) ? $vat->amount : 0;
            $payments = $this->Gkpos_Model->get_list('gkpos_order_payment', array('order_id' => $order[0]->id));
            $payments_cool = array();
            if (!empty($payments)) {
                foreach ($payments as $key => $obj) {
                    $payments_cool[$obj->method] = array(
                        'method' => $obj->method,
                        'amount' => $obj->amount,
                        'order_id' => $obj->order_id
                    );
                }
            }
            $data['payments'] = $payments_cool;
            //debugPrint($data);
            $this->load->view('gkpos/gkpos/online/online_solo_order', $data, false);
        }
    }

    public function payopen() {
        $this->load->model('Orders_Model');
        $this->load->model('Report_Model');
        $id = $this->input->post('id');
        $data = array();
        if ($this->Orders_Model->exists('gkpos_order', 'id', $id)) {
            $data['order'] = $order = $this->Report_Model->get_list('gkpos_order', array('id' => $id));
            $this->Orders_Model->set_current_orderid($order[0]->id);
            $this->Orders_Model->set_total($id, $order[0]->grand_total);
            $data['payments_option'] = $this->Report_Model->get_payment_options();
        }
        $this->load->view('gkpos/gkpos/online/payopener', $data, false);
    }

    public function manage_delivery($action = null) {
        $data = array();
        $data['takeaway_orders'] = $this->Gkpos_Model->get_driver_orders($action);
        $data['drivers'] = $this->Gkpos_Model->get_list('gkpos_driver', array('status' => 1), array('id', 'name', 'email', 'phone'));
        $data['action'] = $action;
        $this->load->view('gkpos/gkpos/manage_delivery/index', $data, false);
    }

    public function add_driver($id = null) {
        $data = array();
        $this->load->view('gkpos/gkpos/manage_delivery/add_driver', $data, false);
    }

    public function list_driver($id = null) {
        $data = array();
        $data['drivers'] = $this->Gkpos_Model->get_list('gkpos_driver');
        $this->load->view('gkpos/gkpos/manage_delivery/list_driver', $data, false);
    }

    public function delete_driver($id) {
        $status = false;
        if ($id != null && (int) $id > 0) {
            $driverOrders = $this->Gkpos_Model->get_list('gkpos_driver_order', array('driver' => $id));
            if (empty($driverOrders)) {
                $status = $this->db->delete('gkpos_driver', array('id' => $id));
            }
        }
        echo json_encode(array('status' => $status));
    }

    public function save_driver() {
        $success = false;
        $msg = '';
        $data = $this->input->post();
        if (isset($data['id']) && $data['id'] > 0) {
            $updatedData = $this->prepareGkposData($data);
            $success = $this->db->update('gkpos_driver', $updatedData, array('id' => $data['id']));
            $msg = $success ? $this->lang->line('gkpos_update_success') : $this->lang->line('gkpos_update_failed');
        } else {
            $insertedData = $this->prepareGkposData($data);
            $insertedData['status'] = 1;
            $success = $this->db->insert('gkpos_driver', $insertedData);
            $msg = $success ? $this->lang->line('gkpos_save_success') : $this->lang->line('gkpos_save_failed');
        }
        echo json_encode(array('success' => $success, 'message' => $msg));
    }

    public function assign_driver() {
        $orders = $this->input->post('orders');
        $driver = $this->input->post('driver');
        if (!empty($orders) && (int) $driver > 0) {
            $s1 = false;
            $s2 = false;
            foreach ($orders as $key => $job) {
                $s1 = $this->db->update('gkpos_order', array('driver' => $driver), array('id' => $job));
                $job_arr = array(
                    'order_id' => $job,
                    'driver' => $driver,
                    'created_by' => $this->session->userdata('gkpos_userid')
                );
                $s2 = $this->db->insert('gkpos_driver_order', $job_arr);
            }
            echo json_encode(array('success' => $s1 && $s2, 'message' => $this->lang->line('gkpos_assign_success')));
        } else {
            echo json_encode(array('success' => false, 'message' => $this->lang->line('gkpos_select_job_and_driver')));
        }
    }

    public function driver_account($date = null) {
        $driverJobs = $this->Gkpos_Model->get_driver_account($date);
        $payments = array();
        $driverJobsArranged = array();
        if (!empty($driverJobs)) {
            $index = 0;
            foreach ($driverJobs as $driverJob) {
                $driverJobsArranged[$driverJob->driver][$index] = $driverJob;
                $payments[$driverJob->id] = $this->Gkpos_Model->get_list('gkpos_order_payment', array('order_id' => $driverJob->id));
                $index++;
            }
        }
        $data['jobs'] = $driverJobsArranged;
        $data['payments'] = $payments;
        if ($data != null) {
            $data['date'] = $date;
        } else {
            $data['date'] = date('d-m-Y');
        }
        $this->load->view('gkpos/gkpos/manage_delivery/driver_account', $data, false);
    }

    public function payopen_for_driver() {
        $this->load->model('Orders_Model');
        $this->load->model('Report_Model');
        $id = $this->input->post('id');
        $data = array();
        if ($this->Orders_Model->exists('gkpos_order', 'id', $id)) {
            $data['order'] = $order = $this->Report_Model->get_list('gkpos_order', array('id' => $id));
            $this->Orders_Model->set_current_orderid($order[0]->id);
            $this->Orders_Model->set_total($id, $order[0]->grand_total);
            $data['payments_option'] = $this->Report_Model->get_payment_options();
        }
        $this->load->view('gkpos/gkpos/manage_delivery/payopener', $data, false);
    }

    public function refresh() {
        $clearItems = $this->input->post('clearItems');
        $success = false;
        $fileList = directory_map('./application/cache');
        //debugPrint($fileList);
        if (!empty($fileList)) {
            foreach ($fileList as $file) {
                if (!is_array($file)) {
                    $filePart = explode('_', $file);
                    //debugPrint($filePart);
                    if (count($filePart) > 1 && in_array($filePart[1], $clearItems)) {
                        $success = $this->cache->delete($file);
                    }
                } else {
                    $success = false;
                }
            }
        }
        echo json_encode(array('success' => $success));
    }

    public function shift_table() {
        ///debugPrint($_POST);
        $order_id = $this->input->post('order_id');
        $new_table = $this->input->post('table_number');
        $existing_table_number = $this->input->post('existing_table_number');
        $existing_table_info = $this->Gkpos_Model->get_single('gkpos_table', array('table_number' => (int) $existing_table_number));
        $table_info = $this->Gkpos_Model->get_single('gkpos_table', array('table_number' => (int) $new_table));
        $updateTable = false;
        $orderUpdate = false;
        $newTableId = false;
        $success = false;
        $message = null;
        if (!empty($table_info)) {
            if ($table_info->is_vacant == '2') {
                $success = false;
                $message = $this->lang->line('gkpos_table') . ' ' . (int) $new_table . ' ' . $this->lang->line('gkpos_table_not_vacant');
            } else {
                if ($existing_table_info) {
                    $updateTable = $this->db->update('gkpos_table', array('guest_quantity' => (int) $existing_table_info->guest_quantity, 'is_vacant' => '2', 'modified' => date('Y-m-d H:i:s'), 'modified_by' => $this->session->userdata('gkpos_userid')), array('id' => $table_info->id, 'table_number' => $table_info->table_number));
                    $success = $updateTable;
                    $message = $success ? 'Table-' . $existing_table_number . ' switched succeffuly to table-' . $new_table : 'Table-' . $existing_table_number . ' shifting to' . $new_table . ' failed';
                }
            }
        } else {
            $data['status'] = '1';
            $data['created_by'] = $this->session->userdata('gkpos_userid');
            $data['is_vacant'] = '2';
            $data['table_number'] = (int) $new_table;
            $data['guest_quantity'] = (int) $existing_table_info->guest_quantity;
            $data = $this->prepareGkposData($data);
            $newTableId = $this->Gkpos_Model->save_table_info($data);
            $success = $newTableId;
            $message = $success ? 'Table-' . $existing_table_number . ' switched successfully to table-' . $new_table : 'Table-' . $existing_table_number . ' shifting to table-' . $new_table . ' failed';
        }
        $modoifiedTable = false;
        if ($success) {
            $modoifiedTable = $this->Gkpos_Model->get_single('gkpos_table', array('table_number' => (int) $new_table));
            $orderUpdate = $this->db->update('gkpos_order', array('table_number' => $modoifiedTable->table_number, 'guest_quantity' => $modoifiedTable->guest_quantity, 'switched_from' => $existing_table_number), array('id' => $order_id));
        }
        if ($success && $modoifiedTable && $orderUpdate) {
            $updateExitingTable = $this->db->update('gkpos_table', array('is_vacant' => '1', 'modified' => date('Y-m-d H:i:s'), 'modified_by' => $this->session->userdata('gkpos_userid')), array('id' => $existing_table_info->id, 'table_number' => $existing_table_info->table_number));
        }
        echo json_encode(array('success' => $success && $orderUpdate && $updateExitingTable, 'message' => $message, 'order_id' => $order_id));
    }

    function updateOrderedCustomerInfo() {
        $id = $this->input->post('id');
        $data = $this->prepareGkposData($this->input->post());
        $success = false;
        $message = null;
        if ($id && !empty($data)) {
            $success = $this->db->update('gkpos_order', $data, array('id' => $id));
            $message = $success ? 'Order Information Updated Successfully' : 'Order information update failed';
        }
        //debugPrint($data);
        echo json_encode(array('success' => $success, 'message' => $message, 'order_id' => $id));
    }

}
