<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Menumanagement extends Gkpos_Controller {

    function __construct() {
        parent::__construct();
        $this->site_title = $this->config->item('company');
        $this->load->model('Entry_Model');
        if (!$this->Entry_Model->is_logged_in()) {
            redirect('gkpos/entry');
        }
        $this->load->helper('gkpos');
        $this->load->model('Menumanagement_Model');
    }

    public function index() {
        $this->page_title = 'Gkpos | Menu Manager';
        $this->current_section = "Menu Manager";
        $this->body_class[] = "pos-menumanagement";
        $data = array();
        if ($this->cache->get('pos_menumanager')) {
            $data = $this->cache->get('pos_menumanager');
        } else {
            $data['selectCategories'] = $this->get_editable_category();
            $data['categories'] = $this->Site_Model->get_list('gkpos_category', null, null, null, 0, 'order', 'ASC');
            $menus = array();
            foreach ($data['categories'] as $category) {
                $menus[$category->id] = $this->Site_Model->get_list('gkpos_menu', array('category' => $category->id), null, null, 0, 'order', 'ASC');
            }
            $data['menus'] = $menus;
            $selections = array();
            foreach ($menus as $menu) {
                if ($menu != null) {
                    foreach ($menu as $selection) {
                        $selections[$selection->category][$selection->id] = $this->Site_Model->get_list('gkpos_selection', array('category' => $selection->category, 'menu' => $selection->id), null, null, 0, 'order', 'ASC');
                    }
                }
            }
            $data['selections'] = $selections;
            $this->cache->save('pos_menumanager', $data, 0);
        }
        $this->load->view('gkpos/menumanagement/layout', $data);
    }

    public function indexcontent() {
        $this->page_title = 'Gkpos | Menu Manager';
        $this->current_section = "Menu Manager";
        $this->body_class[] = "pos-menumanagement";
        $data = array();
        if ($this->cache->get('pos_menumanager')) {
            $data = $this->cache->get('pos_menumanager');
        } else {
            $data['selectCategories'] = $this->get_editable_category();
            $data['categories'] = $this->Site_Model->get_list('gkpos_category', null, null, null, 0, 'order', 'ASC');
            $menus = array();
            foreach ($data['categories'] as $category) {
                $menus[$category->id] = $this->Site_Model->get_list('gkpos_menu', array('category' => $category->id), null, null, 0, 'order', 'ASC');
            }
            $data['menus'] = $menus;
            $selections = array();
            foreach ($menus as $menu) {
                if ($menu != null) {
                    foreach ($menu as $selection) {
                        $selections[$selection->category][$selection->id] = $this->Site_Model->get_list('gkpos_selection', array('category' => $selection->category, 'menu' => $selection->id), null, null, 0, 'order', 'ASC');
                    }
                }
            }
            $data['selections'] = $selections;
            $this->cache->save('pos_menumanager', $data, 0);
        }
        $this->load->view('gkpos/menumanagement/index', $data);
    }

    public function category() {
        $success = false;
        $message = '';
        if ($this->input->post('submit_form')) {
            $this->db->trans_start();
            if ($this->form_validation->run('gkpos_category') == FALSE) {
                $message = validation_errors();
                $success = false;
            } else {
                $data = $this->prepareData();
                $exists = $this->Menumanagement_Model->exists('gkpos_category', 'LOWER(title)', strtolower($data['title']));
                if ($exists) {
                    $message = $this->lang->line('gkpos_duplicate_entry') . ' ' . $this->lang->line('gkpos_category') . ' ' . $data['title'] . ' ' . $this->lang->line('gkpos_already_exists') . ' ' . $this->lang->line('gkpos_try_another');
                    $success = false;
                } else {
                    $data['status'] = '1';
                    $last_id = $this->Menumanagement_Model->get_last_row_id('gkpos_category');
                    $data['order'] = $last_id > 0 ? $last_id + 1 : 1;
                    $data['created_by'] = $this->session->userdata('gkpos_userid');
                    $result = $this->Menumanagement_Model->save_menu_category($data);
                    $success = $result ? true : false;
                }
            }
            $this->db->trans_complete();
            if ($success && $this->db->trans_status()) {
                $message = $this->lang->line('gkpos_category') . ' ' . $data['title'] . ' ' . $this->lang->line('gkpos_saved_' . ($success ? '' : 'un') . 'successfully');
                echo json_encode(array('success' => $success, 'message' => $message));
            } else {
                echo json_encode(array('success' => $success, 'message' => $message));
            }
        }
    }

    public function categorysort() {
        $data = $this->input->post('data');
        $output = array();
        parse_str($data, $output);
        $position = 1;
        $this->db->trans_start();
        foreach ($output as $key => $value) {
            $this->Menumanagement_Model->sort_menu_category($key, $position);
            $position++;
        }
        $this->db->trans_complete();
        echo json_encode(array('success' => $this->db->trans_status()));
    }

    function editcategorycell() {
        $name = $this->input->post('name');
        $id = $this->input->post('pk');
        $value = $this->input->post('value');
        $result = false;
        $this->db->trans_start();
        if ($value == '3' && $name != 'print_option') {
            $result = $this->db->delete('gkpos_category', array('id' => $id));
            $this->db->delete('gkpos_menu', array('category' => $id));
            $this->db->delete('gkpos_selection', array('category' => $id));
            $this->db->delete('item_toppings', array('category' => $id));
        } else {
            $result = $this->db->update('gkpos_category', array($name => $value), array('id' => $id));
        }
        $this->db->trans_complete();
        echo json_encode(array('status' => $this->db->trans_status()));
    }

    private function get_editable_category() {
        $categories = $this->Menumanagement_Model->get_list('gkpos_category', array('status' => 1), array('id', 'title'));
        if (!empty($categories)) {
            $items = array();
            foreach ($categories as $key => $category) {
                $items[$key]['value'] = $category->id;
                $items[$key]['text'] = $category->title;
            }
            return $items;
        }
    }

    public function menu() {
        $success = false;
        $message = '';
        if ($this->input->post('submit_form')) {
            if ($this->form_validation->run('gkpos_menu') == FALSE) {
                $message = validation_errors();
                $success = false;
            } else {
                $data = $this->prepareData();
                $doesMenuExit = $this->db->where(array('category' => $data['category'], 'LOWER(title)' => strtolower($data['title'])))->get('gkpos_menu')->row();

                if (!empty($doesMenuExit)) {
                    $success = false;
                    $message = $this->lang->line('gkpos_duplicate_entry') . ' ' . $this->lang->line('gkpos_menu') . ' \'' . $data['title'] . '\' ' . $this->lang->line('gkpos_already_exists') . ' under this category';
                } else {
                    if (isset($data['is_special']) && isset($data['deal']) && $data['deal'] != null) {
                        unset($data['is_dine']);
                        unset($data['in_price']);
                        unset($data['out_price']);
                        unset($data['base_price']);
                    } else {
                        unset($data['deal']);
                        unset($data['is_special']);
                        if (!isset($data['is_dine'])) {
                            unset($data['in_price']);
                            unset($data['out_price']);
                        } else {
                            unset($data['is_dine']);
                            unset($data['base_price']);
                        }
                    }
                    $data['status'] = '1';
                    $last_id = $this->Menumanagement_Model->get_last_row_id('gkpos_menu');
                    $data['order'] = $last_id > 0 ? $last_id + 1 : 1;
                    $data['created_by'] = $this->session->userdata('gkpos_userid');
                    $result = $this->Menumanagement_Model->save_menu($data);
                    $success = $result ? true : false;
                }
            }
            if ($success) {
                $message = $this->lang->line('gkpos_menu') . ' ' . $data['title'] . ' ' . $this->lang->line('gkpos_saved_' . ($success ? '' : 'un') . 'successfully');
                echo json_encode(array('success' => $success, 'message' => $message));
            } else {
                echo json_encode(array('success' => $success, 'message' => $message));
            }
        }
    }

    function editmenucell() {
        $name = $this->input->post('name');
        $id = $this->input->post('pk');
        $value = $this->input->post('value');

        if ($value == '3' && ($name != 'free_toppings' || $name != 'max_toppings')) {
            $result = $this->db->delete('gkpos_menu', array('id' => $id));
            $this->db->delete('gkpos_selection', array('menu' => $id));
            $this->db->delete('item_toppings', array('menu' => $id));
        } else {
            $result = $this->db->update('gkpos_menu', array($name => $value), array('id' => $id));
        }
        echo json_encode(array('status' => $result));
    }

    public function selection() {
        $success = false;
        $message = '';
        if ($this->input->post('submit_form')) {
            if ($this->form_validation->run('gkpos_selection') == FALSE) {
                $message = validation_errors();
                $success = false;
            } else {
                $data = $this->prepareData();
                $data = $this->prepareData();
                $doesMenuExit = $this->db->where(array('category' => $data['category'], 'menu' => $data['menu'], 'LOWER(title)' => strtolower($data['title'])))->get('gkpos_selection')->row();
                if (!empty($doesMenuExit)) {
                    $success = false;
                    $message = $this->lang->line('gkpos_duplicate_entry') . ' ' . $this->lang->line('gkpos_menu') . ' \'s ' . $this->lang->line('gkpos_selection') . ' \'' . $data['title'] . '\' ' . $this->lang->line('gkpos_already_exists') . ' under this menu';
                } else {
                    if (isset($data['is_special']) && isset($data['deal']) && $data['deal'] != null) {
                        unset($data['is_dine']);
                        unset($data['in_price']);
                        unset($data['out_price']);
                        unset($data['base_price']);
                    } else {
                        unset($data['deal']);
                        unset($data['is_special']);
                        if (!isset($data['is_dine'])) {
                            unset($data['in_price']);
                            unset($data['out_price']);
                        } else {
                            unset($data['is_dine']);
                            unset($data['base_price']);
                        }
                    }
                    $data['status'] = '1';
                    $last_id = $this->Menumanagement_Model->get_last_row_id('gkpos_selection');
                    $data['order'] = $last_id > 0 ? $last_id + 1 : 1;
                    $data['created_by'] = $this->session->userdata('gkpos_userid');
                    $result = $this->Menumanagement_Model->save_menuselection($data);
                    $success = $result ? true : false;
                    $message = $this->lang->line('gkpos_menu') . ' ' . $this->lang->line('gkpos_selection') . ' ' . $data['title'] . ' ' . $this->lang->line('gkpos_saved_' . ($success ? '' : 'un') . 'successfully');
                }
            }
            echo json_encode(array('success' => $success, 'message' => $message));
        }
    }

    function editmenuselcell() {
        $name = $this->input->post('name');
        $id = $this->input->post('pk');
        $value = $this->input->post('value');
        $result = false;
        if ($value == '3' && ($name != 'free_toppings' || $name != 'max_toppings')) {
            $this->db->delete('gkpos_selection', array('id' => $id));
            $this->db->delete('item_toppings', array('selection' => $id));
        } else {
            $result = $this->db->update('gkpos_selection', array($name => $value), array('id' => $id));
        }
        echo json_encode(array('status' => $result));
    }

    public function exchange_category() {
        $name = $this->input->post('name');
        $value = $this->input->post('value');
        $id = $this->input->post('pk');
        $result = $this->db->update('gkpos_menu', array($name => $value), array('id' => $id));
        echo json_encode(array('status' => $result));
    }

    public function savemenuorder() {
        $category = $this->input->post('name');
        $order = $this->input->post('value');
        $id = $this->input->post('pk');
        $result = $this->db->update('gkpos_menu', array('order' => $order), array('id' => $id, 'category' => (int) $category));
        echo json_encode(array('status' => $result));
    }

    public function toppings($id = null) {
        $data = array();
        if ($id != null && $id > 0) {
            $data['thisTopping'] = $this->Site_Model->get_list('toppings', array('id' => $id));
        }
        $data['toppings'] = $this->Site_Model->get_list('toppings', null, null, null, 0, 'id', 'ASC');
        $this->load->view('gkpos/menumanagement/toppings', $data);
    }

    public function save_toppings() {
        $id = $this->input->post('id') ? $this->input->post('id') : null;
        $data = $this->prepareData();
        $success = false;
        $this->db->trans_start();
        if ($id != null && $id > 0) {
            $success = $this->db->update('toppings', $data, array('id' => $id));
        } else {
            $success = $this->db->insert('toppings', $data);
        }
        $this->db->trans_complete();
        $message = $success ? "Topping saved successfully" : "Topping saved failed";
        echo json_encode(array('success' => $success && $this->db->trans_status(), 'message' => $message));
    }

    function delete_atopping() {
        $id = $this->input->post('id');
        $success = false;
        if ((int) $id > 0) {
            $this->db->trans_start();
            $this->db->delete('toppings', array('id' => $id));
            $this->db->trans_complete();
            $activity = array(
                'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has deleted a toppoing'
            );
            $this->Menumanagement_Model->posactivity($activity);
            $success = $this->db->trans_status();
        }
        echo json_encode(array('success' => $success, 'message' => $success ? 'deleted successfully' : 'Deletion Failled'));
    }

    public function mealdeal($id = null) {
        $data = array();
        if ($this->cache->get('pos_mealdeal')) {
            $data = $this->cache->get('pos_mealdeal');
        } else {
            $data['allDeals'] = $this->Menumanagement_Model->get_list('meal_deal', null, null, null, 0, 'order', 'ASC');
            $deal_sets = array();
            if (!empty($data['allDeals'])) {
                foreach ($data['allDeals'] as $deal) {
                    $deal_sets[$deal->id] = $this->Menumanagement_Model->get_list('meal_deal_set', array('deal' => $deal->id), null, null, 0, 'id', 'ASC');
                }
            }
            $data['allToppings'] = $this->Menumanagement_Model->get_list('toppings', array('status' => 1));
            $data['deal_sets'] = $deal_sets;
            $this->cache->save('pos_mealdeal', $data);
        }
        if ($id > 0) {
            $data['thisMealDeal'] = $this->Menumanagement_Model->get_list('meal_deal', array('id' => $id));
        }
        $this->load->view('gkpos/menumanagement/mealdeal', $data);
    }

    public function mealdealsort() {
        $data = $this->input->post('data');
        $output = array();
        parse_str($data, $output);
        $position = 1;
        $this->db->trans_start();
        foreach ($output as $key => $value) {
            $this->Menumanagement_Model->sort_meal_deal($key, $position);
            $position++;
        }
        $this->db->trans_complete();
        echo json_encode(array('success' => $this->db->trans_status()));
    }

    public function savemealdeal() {
        $success = false;
        $message = '';
        if ($this->input->post('submit_form')) {
            $this->db->trans_start();
            $upload_success = $this->_dealimage_upload();
            $upload_data = $this->upload->data();
            if ($this->input->post('id') > 0) {
                $id = $this->input->post('id');
                $data = $this->prepareData();
                if (isset($data['image']) && $data['image'] == null) {
                    unset($data['image']);
                }
                if (!empty($upload_data['orig_name'])) {
                    $data['image'] = $upload_data['raw_name'] . $upload_data['file_ext'];
                }
                $success = $this->db->update('meal_deal', $data, array('id' => $id));
            } else {
                $data = $this->prepareData();
                if (!empty($upload_data['orig_name'])) {
                    $data['image'] = $upload_data['raw_name'] . $upload_data['file_ext'];
                }
                $data['status'] = '1';
                $last_id = $this->Menumanagement_Model->get_last_row_id('meal_deal');
                $data['order'] = $last_id > 0 ? $last_id + 1 : 1;
                $data['created_by'] = $this->session->userdata('gkpos_userid');
                $result = $this->db->insert('meal_deal', $data);
                $success = $result ? true : false;
            }
            $this->db->trans_complete();
            if ($success && $this->db->trans_status()) {
                $message = 'The Deal  ' . $data['title'] . ' ' . $this->lang->line('gkpos_saved_' . ($success ? '' : 'un') . 'successfully');
                echo json_encode(array('success' => $success, 'message' => $message));
            } else {
                echo json_encode(array('success' => $success, 'message' => $message));
            }
        }
    }

    private function _dealimage_upload() {
        $this->load->helper('directory');
        $config = array('upload_path' => './uploads/mealdeal/',
            'allowed_types' => 'gif|jpg|png|jpeg|pdf',
            'max_size' => '1024',
            'max_width' => '3000',
            'max_height' => '3000',
            'file_name' => 'image');
        $this->load->library('upload', $config);
        $this->upload->do_upload('image');
        return strlen($this->upload->display_errors()) == 0 || !strcmp($this->upload->display_errors(), '<p>' . $this->lang->line('upload_no_file_selected') . '</p>');
    }

    function editdealcell() {
        $name = $this->input->post('name');
        $id = $this->input->post('pk');
        $value = $this->input->post('value');
        $result = $this->db->update('meal_deal', array($name => $value), array('id' => $id));
        echo json_encode(array('status' => $result));
    }

    public function mealdeal_delete() {
        $id = (int) $this->input->post('id');
        $this->db->trans_start();
        $this->db->delete('meal_deal', array('id' => $id));
        $this->db->delete('meal_deal_set', array('deal' => $id));
        $this->db->delete('item_toppings', array('meal_deal' => $id));
        $this->db->update('gkpos_menu', array('is_special' => null, 'deal' => 0), array('deal' => $id));
        $this->db->update('gkpos_selection', array('is_special' => null, 'deal' => 0), array('deal' => $id));
        $this->db->trans_complete();
        $activity = array(
            'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has deleted a meal deal'
        );
        $this->Menumanagement_Model->posactivity($activity);
        $success = $this->db->trans_status();
        $message = $success == true ? $this->lang->line('gkpos_delete_success') : $this->lang->line('gkpos_delete_failed');
        echo json_encode(array('success' => $success, 'message' => $message));
    }

    public function pupulate() {
        $data = [];
        $deal_category = $this->input->post('deal_category');
        $deal_category_arr = explode('_', $deal_category);
        $deal = (int) $deal_category_arr[0];
        $category = (int) $deal_category_arr[1];
        if ($category > 0) {
            $this->db->trans_start();
            $data['menus'] = $this->Site_Model->get_list('gkpos_menu', array('category' => $category), null, null, 0, 'order', 'ASC');
            $selections = array();
            if (!empty($data['menus'])) {
                foreach ($data['menus'] as $menu) {
                    if ($menu != null) {
                        $selections [$menu->id] = $this->Site_Model->get_list('gkpos_selection', array('category' => $category, 'menu' => $menu->id), null, null, 0, 'order', 'ASC');
                    }
                }
                $data['selections'] = $selections;
            }
            $this->db->trans_complete();
            $len = count($data['menus']);
            $data['firstHalfMenus'] = array_slice($data['menus'], 0, floor($len / 2));
            $data['secondHalfMenus'] = array_slice($data['menus'], $len / 2);
            $data['category'] = $category;
            $data['deal'] = $deal;
            if ($this->db->trans_status()) {
                $this->load->view('gkpos/menumanagement/populate', $data);
            }
        }
    }

    public function add_set_block($id = null) {
        $data['MenuCategories'] = $this->Menumanagement_Model->get_list('gkpos_category', array('status' => 1, 'is_special' => null), null, null, 0, 'order', 'ASC');
        $data['deal'] = $this->input->post('deal');
        $this->load->view('gkpos/menumanagement/set_block', $data);
    }

    public function edit_set() {
        $data = [];
        $set_id = $this->input->post('id');
        $deal = $this->input->post('deal');
        if ((int) $set_id > 0) {
            $this->db->trans_start();
            $data['thisSet'] = $set = $this->Site_Model->get_list('meal_deal_set', array('id' => $set_id, 'deal' => $deal));
            if (!empty($set)) {
                $this->db->select('cat');
                $this->db->where('set', $set[0]->id);
                $this->db->group_by('cat');
                $setCategoryFromMenu = $this->db->get('meal_deal_menu')->result();
                $set_category = array();
                if (!empty($setCategoryFromMenu)) {
                    foreach ($setCategoryFromMenu as $category) {
                        array_push($set_category, $category->cat);
                    }
                }
                $this->db->select('cat');
                $this->db->where('set', $set[0]->id);
                $this->db->group_by('cat');
                $setCategoryFromSelection = $this->db->get('meal_deal_selection')->result();
                if (!empty($setCategoryFromSelection)) {
                    foreach ($setCategoryFromSelection as $category) {
                        if (!in_array($category->cat, $set_category)) {
                            array_push($set_category, $category->cat);
                        }
                    }
                }
                $set_menus = array();
                $set_selection = array();
                $menus_arr = array();
                $selections = array();
                if (!empty($set_category)) {
                    foreach ($set_category as $setCat) {
                        $menus_arr[$setCat] = $menus = $this->Site_Model->get_list('gkpos_menu', array('category' => $setCat), null, null, 0, 'order', 'ASC');
                        if (!empty($menus)) {
                            foreach ($menus as $menu) {
                                if ($menu != null) {
                                    $selections[$menu->category][$menu->id] = $this->Site_Model->get_list('gkpos_selection', array('category' => $menu->category, 'menu' => $menu->id), null, null, 0, 'order', 'ASC');
                                }
                            }
                        }
                    }
                }
                $data['set_category'] = $set_category;
                $data['menus'] = $menus_arr;
                $data['selections'] = $selections;
                $data['deal'] = $deal;
                $data['MenuCategories'] = $this->Menumanagement_Model->get_list('gkpos_category', array('status' => 1, 'is_special' => null), null, null, 0, 'order', 'ASC');
                $this->db->trans_complete();
            }
        }
        //debugPrint($data['selectedMenus']);
        if ($this->db->trans_status()) {
            $this->load->view('gkpos/menumanagement/edit_set_block', $data);
        }
    }

    public function savemealdealset() {
        $selections = $this->input->post('selection') ? $this->input->post('selection') : array();
        $menus = $this->input->post('menus') ? $this->input->post('menus') : array();
        $set = $this->input->post('id') ? $this->input->post('id') : false;
        $deal = $this->input->post('deal') ? $this->input->post('deal') : false;
        if (empty($menus) && empty($selections)) {
            echo json_encode(array('success' => false, 'message' => 'need at least ' . trim($this->input->post('allowed_selection')) . ' items on this set'));
        } else {
            $success = false;
            $set_id = null;
            $data = array(
                'title' => trim($this->input->post('set_title')),
                'deal' => trim($this->input->post('deal')),
                'allowed' => trim($this->input->post('allowed_selection')),
                'status' => trim($this->input->post('status')),
            );
            if ($set && $deal) {
                $set_id = $set;
                $this->db->trans_start();
                $success = $this->db->update('meal_deal_set', $data, array('id' => $set, 'deal' => $deal));
                $this->db->delete('meal_deal_menu', array('set' => $set, 'deal' => $deal));
                $this->db->delete('meal_deal_selection', array('set' => $set, 'deal' => $deal));
                $this->db->trans_complete();
            } else {
                $success = $this->db->insert('meal_deal_set', $data);
                $set_id = $this->db->insert_id();
            }
            if ($set_id != null && $set_id > 0) {
                if (!empty($menus)) {
                    foreach ($menus as $catMenu) {
                        if (!empty($catMenu)) {
                            foreach ($catMenu as $cat => $menu) {
                                $this->db->insert('meal_deal_menu', array('deal' => $data['deal'], 'set' => $set_id, 'cat' => $cat, 'menu' => $menu));
                            }
                        }
                    }
                }
                if (!empty($selections)) {
                    foreach ($selections as $key => $catMenuSelection) {
                        if (!empty($catMenuSelection)) {
                            foreach ($catMenuSelection as $cat => $menuSelection) {
                                if (!empty($menuSelection)) {
                                    foreach ($menuSelection as $menu => $sel) {
                                        $this->db->insert('meal_deal_selection', array('deal' => $data['deal'], 'set' => $set_id, 'cat' => $cat, 'menu' => $menu, 'selection' => $sel));
                                    }
                                }
                            }
                        }
                    }
                }
            }
            $message = $success == true ? $data['title'] . ' saved successfully' : $data['title'] . ' saved failed';
            echo json_encode(array('success' => $success, 'message' => $message));
        }
    }

    public function opentoppingbox() {
        $data = array();
        $item_table = $this->input->post('item_table');
        $id = $this->input->post('id');
        $hook = $this->input->post('hook');
        $category = $this->input->post('category');
        $data['item'] = $this->Menumanagement_Model->get_list($item_table, array('id' => $id));
        $data['toppingsList'] = $this->Menumanagement_Model->get_list('toppings', array('status' => 1));
        $data['item_table'] = $item_table;
        $data['hook'] = $hook;
        $data['id'] = $id;
        $data['category'] = $category;
        $toppingsCategoryList = $this->get_distinct_rows('item_toppings', $hook, $id, 'top_cat');
        $returnToppingsList = array();
        if (!empty($toppingsCategoryList)) {
            foreach ($toppingsCategoryList as $tcl) {
                $returnToppingsList [$tcl->top_cat] = $this->Menumanagement_Model->get_list('item_toppings', array('top_cat' => $tcl->top_cat, $hook => $id));
            }
        }
        $data['returnToppingsList'] = $returnToppingsList;
        $this->load->view('gkpos/menumanagement/opentoppingbox', $data);
    }

    public function savebulktoppings() {
        $item_table = $this->input->post('item_table');
        $primary_key_value = $this->input->post('id');

        $item_data = array(
            'max_toppings' => $this->input->post('max_toppings'),
            'free_toppings' => $this->input->post('free_toppings'),
        );
        $item_toppings_category_data = array(
            'title' => $this->input->post('category_title'),
            'max_select' => $this->input->post('max_select'),
        );
        $hook = $this->input->post('hook');
        $item_id = $this->Menumanagement_Model->save_general($item_table, 'id', $item_data, $primary_key_value);
        $toppings_category_id = $this->Menumanagement_Model->save_general('toppings_category', 'id', $item_toppings_category_data, null);
        $toppings = $this->input->post('toppings');
        $title = $this->input->post('title');
        $price = $this->input->post('price');
        $is_default = $this->input->post('is_default');
        $toppings_organized_data = array();
        $i = 0;
        foreach ($toppings as $atopping) {
            $toppings_organized_data[$i]['title'] = $title[$atopping];
            $toppings_organized_data[$i]['price'] = $price[$atopping];
            $toppings_organized_data[$i]['is_default'] = $is_default[$atopping];
            $toppings_organized_data[$i]['top_cat'] = $toppings_category_id;
            $toppings_organized_data[$i][$hook] = $item_id;
            $toppings_organized_data[$i]['category'] = $this->input->post('category');
            $i++;
        }
        foreach ($toppings_organized_data as $toppingObj) {
            $this->db->insert('item_toppings', $toppingObj);
        }
        $toppingsCategoryList = $this->get_distinct_rows('item_toppings', $hook, $item_id, 'top_cat');
        $returnToppingsList = array();
        if (!empty($toppingsCategoryList)) {
            foreach ($toppingsCategoryList as $tcl) {
                $returnToppingsList [$tcl->top_cat] = $this->Menumanagement_Model->get_list('item_toppings', array('top_cat' => $tcl->top_cat, $hook => $item_id));
            }
        }
        $data = array();
        $data['responseToppings'] = $returnToppingsList;
        echo json_encode(array('success' => true));
    }

    private function get_distinct_rows($table, $wherefield, $wherevalue, $select) {
        $this->db->distinct();
        $this->db->select($select);
        $this->db->where($wherefield, $wherevalue);
        $result = $this->db->get($table)->result();
        return $result;
    }

    function editbulktoppingscell() {
        $name = $this->input->post('name');
        $id = $this->input->post('pk');
        $value = $this->input->post('value');
        $result = false;
        if ($name == 'status' && $value == 2) {
            $result = $this->db->delete('item_toppings', array('id' => $id));
        } else {
            $result = $this->db->update('item_toppings', array($name => $value), array('id' => $id));
        }
        echo json_encode(array('status' => $result));
    }

    function editbulktoppingscategorycell() {
        $name = $this->input->post('name');
        $id = $this->input->post('pk');
        $value = $this->input->post('value');
        $result = false;
        if ($name == 'status' && $value == 2) {
            $result = $this->db->delete('toppings_category', array('id' => $id));
            $this->db->delete('item_toppings', array('top_cat' => $id));
        } else {
            $result = $this->db->update('toppings_category', array($name => $value), array('id' => $id));
        }
        echo json_encode(array('status' => $result));
    }

}
