<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Settings extends Gkpos_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Settings_Model');
        $this->load->helper('gkpos');
        $this->load->model('Entry_Model');
        if (!$this->Entry_Model->is_logged_in()) {
            redirect('gkpos/entry');
        }
    }

    public function base() {
        $data['current_section'] = $this->lang->line('gkpos_system_management');
        $data['current_page'] = "settings";
        $data['is_touch'] = $this->config->item('is_touch');
        $data['is_caller_id'] = $this->config->item('is_caller_id');
        $this->site_title = $this->config->item('gk_name');
        $this->page_title = 'Online | Admin';
        $this->current_section = "settings base";
        $this->render_page('gkpos/settings/index', $data);
    }

    public function index() {
        $data['current_section'] = $this->lang->line('gkpos_system_management');
        $data['current_page'] = "settings";
        $data['is_touch'] = $this->config->item('is_touch');
        $data['is_caller_id'] = $this->config->item('is_caller_id');
        $this->load->view('gkpos/settings/index', $data);
    }

    public function indexcontent() {
        $data['current_section'] = $this->lang->line('gkpos_system_management');
        $data['current_page'] = "settings";
        $data['is_touch'] = $this->config->item('is_touch');
        $data['is_caller_id'] = $this->config->item('is_caller_id');
        $this->load->view('gkpos/settings/indexcontent', $data);
    }

    public function general() {
        $data['current_section'] = $this->lang->line('gkpos_system_management');
        $data['current_page'] = "general";
        $data['logo_exists'] = $this->Appconfig->get('gk_logo') != '';
        $this->load->view('gkpos/settings/general/general', $data, false);
    }

    function save_general() {
        $upload_success = $this->_handle_logo_upload();
        $upload_data = $this->upload->data();

        $batch_save_data = array(
            'gk_name' => $this->input->post('gk_name'),
            'gk_tagline' => $this->input->post('gk_tagline'),
            'gk_name_show' => $this->input->post('gk_name_show'),
            'gk_address' => $this->input->post('gk_address'),
            'gk_phone' => $this->input->post('gk_phone'),
            'gk_email' => $this->input->post('gk_email'),
            'gk_fax' => $this->input->post('gk_fax'),
            'gk_website' => $this->input->post('gk_website'),
            'gk_policy' => $this->input->post('gk_policy')
        );

        if (!empty($upload_data['orig_name'])) {
            $batch_save_data['gk_logo'] = $upload_data['raw_name'] . $upload_data['file_ext'];
        }

        $result = $this->Appconfig->batch_save($batch_save_data);
        $success = $upload_success && $result ? true : false;
        $message = $this->lang->line('config_saved_' . ($success ? '' : 'un') . 'successfully');
        $message = $upload_success ? $message : $this->upload->display_errors();
        if ($success) {
            $activity = array(
                'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has updated general setting'
            );
            $this->Settings_Model->posactivity($activity);
        }

        echo json_encode(array('success' => $success, 'message' => $message));
    }

    private function _handle_logo_upload() {
        $this->load->helper('directory');
        // load upload library
        $config = array('upload_path' => './uploads/gkpos/logo/',
            'allowed_types' => 'gif|jpg|png',
            'max_size' => '1024',
            'max_width' => '800',
            'max_height' => '680',
            'file_name' => 'gk_logo');
        $this->load->library('upload', $config);
        $this->upload->do_upload('gk_logo');
        return strlen($this->upload->display_errors()) == 0 || !strcmp($this->upload->display_errors(), '<p>' . $this->lang->line('upload_no_file_selected') . '</p>');
    }

    public function remove_logo() {
        $result = $this->Appconfig->batch_save(array('gk_logo' => ''));

        echo json_encode(array('success' => $result));
    }

    public function add_cc_fee() {
        $data['current_section'] = $this->lang->line('gkpos_add_cce_fee');
        $data['current_page'] = "add_cc_fee";
        $this->load->view('gkpos/settings/general/add_cc_fee', $data, false);
    }

    public function save_cc_fee() {
        $batch_save_data = array(
            'gk_cc_fee' => $this->input->post('gk_cc_fee'),
        );
        $result = $this->Appconfig->batch_save($batch_save_data);
        $success = $result ? true : false;
        if ($success) {
            $activity = array(
                'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has updated ccFee'
            );
            $this->Settings_Model->posactivity($activity);
        }
        $message = $this->lang->line('config_saved_' . ($success ? '' : 'un') . 'successfully');
        echo json_encode(array('success' => $success, 'message' => $message));
    }

    public function vatsetup() {
        $data['current_section'] = $this->lang->line('gkpos_system_management') . ' VAT SETUP';
        $data['current_page'] = "vatsetup";
        $this->load->view('gkpos/settings/general/vatsetup', $data, false);
    }

    public function save_vat() {
        $batch_save_data = array(
            'gk_vat_reg' => $this->input->post('gk_vat_reg'),
            'gk_vat_percent' => $this->input->post('gk_vat_percent'),
            'gk_vat_included' => $this->input->post('gk_vat_included'),
        );
        $result = $this->Appconfig->batch_save($batch_save_data);
        $success = $result ? true : false;
        if ($success) {
            $activity = array(
                'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has updated vat setup'
            );
            $this->Settings_Model->posactivity($activity);
        }
        $message = $this->lang->line('config_saved_' . ($success ? '' : 'un') . 'successfully');
        echo json_encode(array('success' => $success, 'message' => $message));
    }

    public function discountsetup() {
        $data['current_section'] = $this->lang->line('gkpos_system_management') . ' DISCOUNT SETUP';
        $data['current_page'] = "discountsetup";
        $discount_plan = $this->Settings_Model->get_list('gkpos_discountplan');
        $discountPlan = array();
        foreach ($discount_plan as $plan) {
            $discountPlan[$plan->type] = $plan;
        }
        $data['plans'] = $discountPlan;
        //debugPrint($data);
        $this->load->view('gkpos/settings/general/discountsetup', $data, false);
    }

    public function save_discount() {
        $batch_save_data = array(
            'gk_discount_percent' => $this->input->post('gk_discount_percent'),
            'gk_discount_applied' => $this->input->post('gk_discount_applied'),
            'gk_discount_food' => $this->input->post('gk_discount_food'),
            'gk_discount_nonfood' => $this->input->post('gk_discount_nonfood'),
            'gk_discount_dinein' => $this->input->post('gk_discount_dinein'),
            'gk_discount_dineout' => $this->input->post('gk_discount_dineout'),
            'gk_discount_online' => $this->input->post('gk_discount_online'),
            'gk_discount_min_order' => $this->input->post('gk_discount_min_order'),
        );
        $result = $this->Appconfig->batch_save($batch_save_data);

        if ($batch_save_data['gk_discount_dinein'] == 'yes') {
            $tab_data = null;
            $bar_data = null;
            if ($this->input->post('table') == 'yes') {
                $tab_data = array(
                    'is_applied' => 'yes',
                    'number' => $this->input->post('tab_number'),
                    'func' => $this->input->post('tab_func'),
                    'food' => $this->input->post('tab_food'),
                    'nonfood' => $this->input->post('tab_nonfood'),
                    'min_order' => $this->input->post('tab_min_order'),
                );
                $this->db->update('gkpos_discountplan', $tab_data, array('type' => 'table'));
            } else {
                $tab_data = array(
                    'is_applied' => null,
                    'number' => null,
                    'func' => null,
                    'food' => null,
                    'nonfood' => null,
                    'min_order' => null,
                );
                $this->db->update('gkpos_discountplan', $tab_data, array('type' => 'table'));
            }
            if ($this->input->post('bar') == 'yes') {
                $bar_data = array(
                    'is_applied' => 'yes',
                    'number' => $this->input->post('bar_number'),
                    'func' => $this->input->post('bar_func'),
                    'food' => $this->input->post('bar_food'),
                    'nonfood' => $this->input->post('bar_nonfood') ? $this->input->post('bar_nonfood') : null,
                    'min_order' => $this->input->post('bar_min_order'),
                );
                $this->db->update('gkpos_discountplan', $bar_data, array('type' => 'bar'));
            } else {
                $bar_data = array(
                    'is_applied' => null,
                    'number' => null,
                    'func' => null,
                    'food' => null,
                    'nonfood' => null,
                    'min_order' => null,
                );
                $this->db->update('gkpos_discountplan', $bar_data, array('type' => 'bar'));
            }
        } else {
            $default_data = array(
                'is_applied' => null,
                'number' => null,
                'func' => null,
                'food' => null,
                'nonfood' => null,
                'min_order' => null,
            );
            $this->db->set($default_data);
            $this->db->where('type', 'table');
            $this->db->or_where('type', 'bar');
            $this->db->update('gkpos_discountplan');
        }

        if ($batch_save_data['gk_discount_dineout'] == 'yes') {
            $del_data = null;
            $col_data = null;
            $wai_data = null;
            if ($this->input->post('delivery') == 'yes') {
                $del_data = array(
                    'is_applied' => 'yes',
                    'number' => $this->input->post('del_number'),
                    'func' => $this->input->post('del_func'),
                    'food' => $this->input->post('del_food'),
                    'nonfood' => $this->input->post('del_nonfood'),
                    'min_order' => $this->input->post('del_min_order'),
                );
                $this->db->update('gkpos_discountplan', $del_data, array('type' => 'delivery'));
            } else {
                $del_data = array(
                    'is_applied' => null,
                    'number' => null,
                    'func' => null,
                    'food' => null,
                    'nonfood' => null,
                    'min_order' => null,
                );
                $this->db->update('gkpos_discountplan', $del_data, array('type' => 'delivery'));
            }
            if ($this->input->post('collection') == 'yes') {
                $col_data = array(
                    'is_applied' => 'yes',
                    'number' => $this->input->post('col_number'),
                    'func' => $this->input->post('col_func'),
                    'food' => $this->input->post('col_food'),
                    'nonfood' => $this->input->post('col_nonfood'),
                    'min_order' => $this->input->post('col_min_order'),
                );
                $this->db->update('gkpos_discountplan', $col_data, array('type' => 'collection'));
            } else {
                $col_data = array(
                    'is_applied' => null,
                    'number' => null,
                    'func' => null,
                    'food' => null,
                    'nonfood' => null,
                    'min_order' => null,
                );
                $this->db->update('gkpos_discountplan', $col_data, array('type' => 'collection'));
            }

            if ($this->input->post('waiting') == 'yes') {
                $wai_data = array(
                    'is_applied' => 'yes',
                    'number' => $this->input->post('wai_number'),
                    'func' => $this->input->post('wai_func'),
                    'food' => $this->input->post('wai_food'),
                    'nonfood' => $this->input->post('wai_nonfood'),
                    'min_order' => $this->input->post('wai_min_order'),
                );
                $this->db->update('gkpos_discountplan', $wai_data, array('type' => 'waiting'));
            } else {
                $wai_data = array(
                    'is_applied' => null,
                    'number' => null,
                    'func' => null,
                    'food' => null,
                    'nonfood' => null,
                    'min_order' => null,
                );
                $this->db->update('gkpos_discountplan', $wai_data, array('type' => 'waiting'));
            }
        } else {
            $default_data = array(
                'is_applied' => null,
                'number' => null,
                'func' => null,
                'food' => null,
                'nonfood' => null,
                'min_order' => null,
            );
            $this->db->set($default_data);
            $this->db->where('type', 'delivery');
            $this->db->or_where('type', 'collection');
            $this->db->or_where('type', 'waiting');
            $this->db->update('gkpos_discountplan');
        }

        if ($batch_save_data['gk_discount_online'] == 'yes') {
            $del_data = null;
            $col_data = null;
            if ($this->input->post('online_collection') == 'yes') {
                $del_data = array(
                    'is_applied' => 'yes',
                    'number' => $this->input->post('online_col_number'),
                    'func' => $this->input->post('online_col_func'),
                    'food' => $this->input->post('online_col_food'),
                    'nonfood' => $this->input->post('online_col_nonfood'),
                    'min_order' => $this->input->post('online_col_min_order'),
                );
                $this->db->update('gkpos_discountplan', $del_data, array('type' => 'online_collection'));
            } else {
                $del_data = array(
                    'is_applied' => null,
                    'number' => null,
                    'func' => null,
                    'food' => null,
                    'nonfood' => null,
                    'min_order' => null,
                );
                $this->db->update('gkpos_discountplan', $del_data, array('type' => 'online_collection'));
            }
            if ($this->input->post('online_delivery') == 'yes') {
                $col_data = array(
                    'is_applied' => 'yes',
                    'number' => $this->input->post('online_del_number'),
                    'func' => $this->input->post('online_del_func'),
                    'food' => $this->input->post('online_del_food'),
                    'nonfood' => $this->input->post('online_del_nonfood'),
                    'min_order' => $this->input->post('online_del_min_order'),
                );
                $this->db->update('gkpos_discountplan', $col_data, array('type' => 'online_delivery'));
            } else {
                $col_data = array(
                    'is_applied' => null,
                    'number' => null,
                    'func' => null,
                    'food' => null,
                    'nonfood' => null,
                    'min_order' => null,
                );
                $this->db->update('gkpos_discountplan', $col_data, array('type' => 'online_delivery'));
            }
        } else {
            $default_data = array(
                'is_applied' => null,
                'number' => null,
                'func' => null,
                'food' => null,
                'nonfood' => null,
                'min_order' => null,
            );
            $this->db->set($default_data);
            $this->db->where('type', 'online_delivery');
            $this->db->or_where('type', 'online_collection');
            $this->db->update('gkpos_discountplan');
        }
        $success = $result ? true : false;
        if ($success) {
            $activity = array(
                'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has updated discount setup'
            );
            $this->Settings_Model->posactivity($activity);
        }
        $message = $this->lang->line('config_saved_' . ($success ? '' : 'un') . 'successfully');
        echo json_encode(array('success' => $success, 'message' => $message));
    }

    public function depliveryplan() {
        $data['current_section'] = $this->lang->line('gkpos_system_management') . 'Delivery Plan';
        $data['current_page'] = "depliveryplan";
        $data['deliveryplan_list'] = $this->Settings_Model->get_list('gkpos_deliveryplan');
        $this->load->view('gkpos/settings/general/deliveryplan', $data, false);
    }

    function edit_deliveryplan() {
        if (isset($_POST) && !empty($_POST)) {
            $id = $this->input->post('id');
            $toEdit = $this->Settings_Model->get_single('gkpos_deliveryplan', array('id' => $id));
            if (!empty($toEdit)) {
                echo json_encode(array('success' => true, 'toEdit' => $toEdit, 'message' => $id));
            } else {
                echo json_encode(array('success' => false, 'toEdit' => $toEdit, 'message' => $id));
            }
        }
    }

    public function get_postcodelist() {
        $id = $this->input->post('id');
        $postcodes = $this->Settings_Model->get_single('gkpos_deliveryplan', array('id' => $id), array('postcodes'));
        if (!empty($postcodes)) {
            echo json_encode(array('success' => true, 'postcodes' => $postcodes, 'message' => $id));
        } else {
            echo json_encode(array('success' => false, 'postcodes' => $postcodes, 'message' => $id));
        }
    }

    public function save_deliveryplan() {
        $success = false;
        $message = null;
        $id = null;
        $data = array(
            'area' => $this->input->post('area'),
            'is_free' => isset($_POST['is_free']) ? 1 : 2,
            'delivery_charge' => $this->input->post('delivery_charge'),
            'delivery_time' => $this->input->post('delivery_time'),
            'min_order' => $this->input->post('min_order'),
            'initial_code' => postcodeFormat($this->input->post('initial_code')),
            'postcodes' => $this->input->post('postcodes'),
        );

        if (!isset($_POST['id']) && $this->Settings_Model->exists('gkpos_deliveryplan', 'initial_code', $data['initial_code'])) {
            $success = false;
            $message = 'Delivery plan for this area already eixsts';
        } else {
            if (isset($_POST['id']) && $_POST['id'] != null) {
                $id = $this->input->post('id');
            }
            $data = $this->prepareGkposData($data);
            if ($id == null) {
                $data['status'] = 1;
                $data['created_by'] = $this->session->userdata('gkpos_userid');
            }
            if ($id != null && $id > 0) {
                $data['modified'] = date('Y-m-d H:i:s');
                $data['modified_by'] = $this->session->userdata('gkpos_userid');
            }
            $result = $this->Settings_Model->save_deliveryplan($data, $id);
            $success = $result ? true : false;
            $message = $this->lang->line('config_saved_' . ($success ? '' : 'un') . 'successfully');
            if ($success) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has created a delivery plan for area ' . $data['initial_code']
                );
                $this->Settings_Model->posactivity($activity);
            }
        }


        echo json_encode(array('success' => $success, 'message' => $message));
    }

    public function update_deliveryplan() {
        $action = $this->input->post('action');
        $id = $this->input->post('id');
        if ($action == 'delete') {
            $success = $this->db->delete('gkpos_deliveryplan', array('id' => $id));
            $message = $success ? 'Plan deleted successfully' : 'Plan Deletion failed';
            if ($success) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has deleted a delivery Plan'
                );
                $this->Settings_Model->posactivity($activity);
            }
        }
        if ($action == 'activate') {
            $success = $this->db->update('gkpos_deliveryplan', array('status' => 1), array('id' => $id));
            $message = $success ? 'Plan activated successfully' : 'Plan Deletion failed';
            if ($success) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has activated a delivery Plan'
                );
                $this->Settings_Model->posactivity($activity);
            }
        }
        if ($action == 'deactivate') {
            $success = $this->db->update('gkpos_deliveryplan', array('status' => 2), array('id' => $id));
            $message = $success ? 'Plan activated successfully' : 'Plan deactivation failed';
            if ($success) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has deactivated a delivery Plan'
                );
                $this->Settings_Model->posactivity($activity);
            }
        }
        echo json_encode(array('success' => $success, 'message' => $message));
    }

    public function google_deliveryplan() {
        $data = $this->prepareData();
        $result = $this->Appconfig->batch_save($data);
        $success = $result ? true : false;
        $message = $this->lang->line('config_saved_' . ($success ? '' : 'un') . 'successfully');
        echo json_encode(array('success' => $success, 'message' => $message));
    }

    public function pagination() {
        $data['current_section'] = $this->lang->line('gkpos_system_management') . 'Pagination';
        $data['current_page'] = "pagination";
        $this->load->view('gkpos/settings/general/pagination', $data, false);
    }

    public function save_pagination() {
        $batch_save_data = array(
            'gk_category_line_page' => $this->input->post('gk_category_line_page'),
            'gk_menu_line_page' => $this->input->post('gk_menu_line_page'),
            'gk_report_line_page' => $this->input->post('gk_report_line_page')
        );
        $result = $this->Appconfig->batch_save($batch_save_data);
        $success = $result ? true : false;
        $message = $this->lang->line('config_saved_' . ($success ? '' : 'un') . 'successfully');
        if ($success) {
            $activity = array(
                'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has updated pagination'
            );
            $this->Settings_Model->posactivity($activity);
        }
        echo json_encode(array('success' => $success, 'message' => $message));
    }

    public function special() {
        $data['current_section'] = $this->lang->line('gkpos_system_management') . 'Special';
        $data['current_page'] = "Special";
        $data['voucher_list'] = $this->Settings_Model->get_list('gkpos_special');
        $this->load->view('gkpos/settings/special', $data, false);
    }

    public function save_spacial() {
        $data = $this->prepareData();
        $exists = $this->Settings_Model->exists('gkpos_special', 'LOWER(title)', strtolower($data['title']));
        if ($exists) {
            echo json_encode(array('success' => false, 'message' => 'This modifier aleady exists in the record'));
        } else {
            if ($this->db->insert('gkpos_special', $data)) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has added a special modifier'
                );
                $this->Settings_Model->posactivity($activity);
                echo json_encode(array('success' => true, 'message' => 'Modifier saved scuccessfully'));
            }
        }
    }

    public function update_special() {
        $action = $this->input->post('action');
        $id = $this->input->post('id');
        if ($action == 'delete') {
            $success = $this->db->delete('gkpos_special', array('id' => $id));
            $message = $success ? 'Special deleted successfully' : 'Special Deletion failed';
            if ($success) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has deleted a special modifier'
                );
                $this->Settings_Model->posactivity($activity);
            }
        }
        if ($action == 'activate') {
            $success = $this->db->update('gkpos_special', array('status' => 1), array('id' => $id));
            $message = $success ? 'Special activated successfully' : 'Special Deletion failed';
            if ($success) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has activated a special modifier'
                );
                $this->Settings_Model->posactivity($activity);
            }
        }
        if ($action == 'deactivate') {
            $success = $this->db->update('gkpos_special', array('status' => 2), array('id' => $id));
            $message = $success ? 'Special activated successfully' : 'Special Deletion failed';
            if ($success) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has deactivated a special modifier'
                );
                $this->Settings_Model->posactivity($activity);
            }
        }
        echo json_encode(array('success' => $success, 'message' => $message));
    }

    public function locale() {
        $data['current_section'] = $this->lang->line('gkpos_system_management') . ' VAT SETUP';
        $data['current_page'] = "Localization";
        $this->load->view('gkpos/settings/locale', $data, false);
    }

    function save_locale() {
        $batch_save_data = array(
            'currency_symbol' => $this->input->post('currency_symbol'),
            'currency_side' => $this->input->post('currency_side') != null,
            'language' => $this->input->post('language'),
            'timezone' => $this->input->post('timezone'),
            'dateformat' => $this->input->post('dateformat'),
            'timeformat' => $this->input->post('timeformat'),
            'thousands_separator' => $this->input->post('thousands_separator'),
            'decimal_point' => $this->input->post('decimal_point'),
            'currency_decimals' => $this->input->post('currency_decimals'),
            'tax_decimals' => $this->input->post('tax_decimals'),
            'quantity_decimals' => $this->input->post('quantity_decimals'),
            'gk_week_start' => $this->input->post('gk_week_start'),
            'gk_week_end' => $this->input->post('gk_week_end')
        );

        $result = $this->Appconfig->batch_save($batch_save_data);
        $success = $result ? true : false;
        if ($success) {
            $activity = array(
                'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has updated locale setup'
            );
            $this->Settings_Model->posactivity($activity);
        }
        echo json_encode(array('success' => $success, 'message' => $this->lang->line('config_saved_' . ($success ? '' : 'un') . 'successfully')));
    }

    public function giftcard() {
        $data['current_section'] = $this->lang->line('gkpos_system_management') . 'Giftcard';
        $data['current_page'] = "Giftcard";
        $data['voucher_list'] = $this->Settings_Model->get_list('gkpos_giftcard', '', '', '', '', 'status', 'DESC');
        $data['giftcard_code'] = $this->Settings_Model->get_giftcard_code();
        $this->load->view('gkpos/settings/giftcard', $data, false);
    }

    public function save_giftcard() {
        // $data = $this->prepareData();
        $start = DateTime::createFromFormat($this->config->item('dateformat'), $this->input->post('start') != null ? $this->input->post('start') : date($this->config->item('dateformat'), strtotime('today')));
        $end = DateTime::createFromFormat($this->config->item('dateformat'), $this->input->post('end') != null ? $this->input->post('end') : date($this->config->item('dateformat'), strtotime('today')));
        $data['title'] = $this->input->post('title');
        $data['code'] = $this->input->post('code');
        $data['amount'] = $this->input->post('amount');
        $data['balance'] = $this->input->post('amount');
        $data['start'] = $start->format('Y-m-d');
        $data['end'] = $end->format('Y-m-d');
        $data['holder'] = $this->input->post('holder');
        $data['phone'] = $this->input->post('phone');
        $data = $this->prepareGkposData($data);
        $exists = $this->Settings_Model->exists('gkpos_giftcard', 'LOWER(code)', strtolower($data['code']));
        if ($exists) {
            echo json_encode(array('success' => false, 'message' => 'This code aleady exists in the record'));
        } else {
            if ($this->db->insert('gkpos_giftcard', $data)) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has added new giftcard'
                );
                $this->Settings_Model->posactivity($activity);
                echo json_encode(array('success' => true));
            }
        }
    }

    public function update_giftcard() {
        $action = $this->input->post('action');
        $id = $this->input->post('id');
        if ($action == 'delete') {
            $success = $this->db->delete('gkpos_giftcard', array('id' => $id));
            $message = $success ? 'Giftcard deleted successfully' : 'Giftcard Deletion failed';
            if ($success) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has deleted giftcard'
                );
                $this->Settings_Model->posactivity($activity);
            }
        }
        if ($action == 'activate') {
            $success = $this->db->update('gkpos_giftcard', array('status' => 1), array('id' => $id));
            $message = $success ? 'Giftcard activated successfully' : 'giftcard activation failed';
            if ($success) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has activated a giftcard'
                );
                $this->Settings_Model->posactivity($activity);
            }
        }
        if ($action == 'deactivate') {
            $success = $this->db->update('gkpos_giftcard', array('status' => 2), array('id' => $id));
            $message = $success ? 'Giftcard deactivated successfully' : 'giftcard Deletion failed';
            if ($success) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has deactivated a giftcard'
                );
                $this->Settings_Model->posactivity($activity);
            }
        }
        echo json_encode(array('success' => $success, 'message' => $message));
    }

    public function expense() {
        $today_start = date($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), mktime(0, 0, 0));
        $today_end = date($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), mktime(23, 59, 59));
        $start_date = $this->input->post('start_date') != null ? $this->input->post('start_date') . ' ' . date($this->config->item('timeformat'), mktime(0, 0, 0)) : $today_start;
        $start_date_formatter = DateTime::createFromFormat($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), $start_date);
        $end_date = $this->input->post('end_date') != null ? $this->input->post('end_date') . ' ' . date($this->config->item('timeformat'), mktime(23, 59, 59)) : $today_end;
        $end_date_formatter = DateTime::createFromFormat($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), $end_date);
        $start_date_value = $start_date_formatter->format('Y-m-d H:i:s');
        $end_date_value = $end_date_formatter->format('Y-m-d H:i:s');
        if ($end_date_value && $start_date_value) {
            $this->db->where('created BETWEEN ' . $this->db->escape($start_date_value) . ' AND ' . $this->db->escape($end_date_value));
            $this->db->group_by('id');
            $this->db->order_by('created', 'DESC');
            $data['expense_list'] = $this->db->get('gkpos_expense')->result();
        }
        $data['current_section'] = $this->lang->line('gkpos_system_management') . 'Expense';
        $data['current_page'] = "Expense";
        $data['start_date'] = $start_date_formatter->format($this->config->item('dateformat'));
        $data['end_date'] = $end_date_formatter->format($this->config->item('dateformat'));
        $this->load->view('gkpos/settings/expense', $data, false);
    }

    public function expense_filter() {
        $today_start = date($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), mktime(0, 0, 0));
        $today_end = date($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), mktime(23, 59, 59));
        $start_date = $this->input->post('start_date') != null ? $this->input->post('start_date') . ' ' . date($this->config->item('timeformat'), mktime(0, 0, 0)) : $today_start;
        $start_date_formatter = DateTime::createFromFormat($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), $start_date);
        $end_date = $this->input->post('end_date') != null ? $this->input->post('end_date') . ' ' . date($this->config->item('timeformat'), mktime(23, 59, 59)) : $today_end;
        $end_date_formatter = DateTime::createFromFormat($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), $end_date);
        $start_date_value = $start_date_formatter->format('Y-m-d H:i:s');
        $end_date_value = $end_date_formatter->format('Y-m-d H:i:s');
        if ($end_date_value && $start_date_value) {
            $this->db->where('created BETWEEN ' . $this->db->escape($start_date_value) . ' AND ' . $this->db->escape($end_date_value));
            $this->db->group_by('id');
            $this->db->order_by('created', 'DESC');
            $data['expense_list'] = $this->db->get('gkpos_expense')->result();
        }
        $data['current_section'] = $this->lang->line('gkpos_system_management') . 'Expense';
        $data['current_page'] = "Expense";
        $data['start_date'] = $start_date_formatter->format($this->config->item('dateformat'));
        $data['end_date'] = $end_date_formatter->format($this->config->item('dateformat'));
        $this->load->view('gkpos/settings/expense_filter', $data, false);
    }

    public function get_expensetype() {
        $term = $this->input->get('term');
        $this->db->select('type');
        $this->db->from('gkpos_expense');
        $this->db->where("type LIKE '%" . $term . "%'");
        $this->db->order_by("type", "asc");
        $result = $this->db->get()->result();
        $customer = array_map('current', $result);
        echo json_encode($customer);
    }

    public function save_expense() {
        $postedData = $this->input->post();
        $data = $this->prepareGkposData($postedData);
        $data['created'] = date('Y-m-d H:i:s');
        $data['created_by'] = $this->session->userdata('gkpos_userid');
        if ($this->db->insert('gkpos_expense', $data)) {
            $activity = array(
                'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has added new expense'
            );
            $this->Settings_Model->posactivity($activity);
            echo json_encode(array('success' => true, 'message' => 'Expense saved successfully'));
        } else {
            echo json_encode(array('success' => false, 'message' => 'Expense saved failed'));
        }
    }

    public function printer() {
        $data['current_section'] = $this->lang->line('gkpos_system_printer_setting');
        $data['current_page'] = "Printer";
        $data['expense_list'] = $this->Settings_Model->get_list('gkpos_expense');
        $this->load->view('gkpos/settings/printer', $data, false);
    }

    public function save_printer() {
        $batch_save_data = array(
            'gk_guest_bill_from_browser' => $this->input->post('gk_guest_bill_from_browser'),
            'gk_billprinter' => $this->input->post('gk_billprinter'),
            'gk_ktcprinter' => $this->input->post('gk_ktcprinter'),
        );
        $result = $this->Appconfig->batch_save($batch_save_data);
        $success = $result ? true : false;
        if ($success) {
            $activity = array(
                'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has updated printer setting'
            );
            $this->Settings_Model->posactivity($activity);
        }
        $message = $this->lang->line('config_saved_' . ($success ? '' : 'un') . 'successfully');
        echo json_encode(array('success' => $success, 'message' => $message));
    }

    public function view_user() {
        $data['current_section'] = $this->lang->line('gkpos_system_user');
        $data['current_page'] = "view_user";
        $data['users'] = $this->Settings_Model->get_list('gkpos_user', array('type<>' => 1));
        $this->load->view('gkpos/settings/view_user', $data, false);
    }

    public function user($id = null) {
        $data['current_section'] = $this->lang->line('gkpos_system_user');
        $data['current_page'] = "User";
        if ($id != null && $id > 0) {
            $data['user'] = $this->Settings_Model->get_single('gkpos_user', array('id' => $id));
        }
        $data['image'] = null;
        $this->load->view('gkpos/settings/user', $data, false);
    }

    public function save_user() {
        $data = [];
        $success = false;
        $message = '';
        if ($this->input->post('submit_form')) {
            if ($this->form_validation->run('gkpos_user') == FALSE) {
                $message = validation_errors();
            } else {
                $data = $this->prepareData();
                $uploader_config = array('upload_path' => 'uploads/gkpos/user/',
                    'allowed_types' => 'gif|jpg|png',
                    'max_size' => '1024',
                    'max_width' => '450',
                    'max_height' => '450',
                    'file_name' => 'image'
                );
                $upload_success = $this->uploadimage($uploader_config);
                $upload_data = $this->upload->data();
                if (!empty($upload_data['orig_name'])) {
                    $data['image'] = $upload_data['raw_name'] . $upload_data['file_ext'];
                }
                $result = null;
                if ($this->input->post('id')) {
                    $data['modified'] = date('Y-m-d H:i:s');
                    $data['modified_by'] = $this->session->userdata('gkpos_userid');
                    $result = $this->db->update('gkpos_user', $data, array('id' => $this->input->post('id')));
                } else {
                    $data['created'] = date('Y-m-d H:i:s');
                    $data['created_by'] = $this->session->userdata('gkpos_userid');
                    $result = $this->db->insert('gkpos_user', $data);
                }
                $success = $upload_success || $result ? true : false;
                $message = $this->lang->line('gkpos_common_item_saved_' . ($success ? '' : 'un') . 'successfully');
                $message = $upload_success ? $message : $this->upload->display_errors();
            }
            if ($success) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has added/updated user information'
                );
                $this->Settings_Model->posactivity($activity);
            }
            echo json_encode(array('success' => $success, 'message' => $message));
        }
    }

    public function config_user() {
        if ($this->input->post('submit_form')) {
            $id = $this->input->post('id');
            $data = $this->prepareData();
            $data['password'] = md5($data['password']);
            if ($this->db->update('gkpos_user', $data, array('id' => $id))) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has updated user configuration'
                );
                $this->Settings_Model->posactivity($activity);
                echo json_encode(array('success' => true, 'message' => 'User Configuration Updated Successfully'));
            } else {
                echo json_encode(array('success' => false, 'message' => 'User Configuration Update failed'));
            }
        }
    }

    public function delete_user() {
        $id = $this->input->post('id');
        $user = $this->Settings_Model->get_single('gkpos_user', array('id' => $id));
        if (!empty($user)) {
            if (isset($user->image) && trim($user->image) != null) {
                $path = "uploads/gkpos/user/";
                $file = $user->image;
                if (checkfile($path, $file)) {
                    unlink(realpath($path . $file));
                }
            }
            if ($this->db->delete('gkpos_user', array('id' => $id))) {
                $activity = array(
                    'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has deleted a user'
                );
                $this->Settings_Model->posactivity($activity);
                echo json_encode(array('success' => true, 'message' => 'User Deleted Successfully'));
            } else {
                echo json_encode(array('success' => false, 'message' => 'User Deletion Failed'));
            }
        }
    }

    public function user_logs() {
        $data['current_section'] = $this->lang->line('gkpos_system_log_register');
        $data['current_page'] = "User Logs";
        $data['logs'] = $this->Settings_Model->get_list('gkpos_log');
        $this->load->view('gkpos/settings/logs', $data, false);
    }

    public function restaurant_setup() {
        $data['current_section'] = $this->lang->line('gkpos_restaurant_setup');
        $data['current_page'] = "restaurant_setup";
        $this->load->view('gkpos/settings/restaurant_setup', $data, false);
    }

    public function save_restaurant_setup() {

        $batch_save_data = array(
            'gk_order_delivery' => $this->input->post('gk_order_delivery'),
            'gk_order_collection' => $this->input->post('gk_order_collection'),
            'gk_order_waiting' => $this->input->post('gk_order_waiting'),
            'gk_order_table' => $this->input->post('gk_order_table'),
            'gk_order_bar' => $this->input->post('gk_order_bar'),
            'gk_order_online' => $this->input->post('gk_order_online'),
            'gk_only_online_admin' => $this->input->post('gk_only_online_admin'),
        );
        $result = $this->Appconfig->batch_save($batch_save_data);
        $success = $result ? true : false;
        if ($success) {
            $activity = array(
                'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has updated vat setup'
            );
            $this->Settings_Model->posactivity($activity);
        }
        $message = $this->lang->line('config_saved_' . ($success ? '' : 'un') . 'successfully');
        echo json_encode(array('success' => $success, 'message' => $message));
    }

    public function caller_id_setting() {
        $is_caller_id = $this->input->post('is_caller_id');
        echo $this->Appconfig->batch_save(array('is_caller_id' => $is_caller_id));
    }

    public function garbagecollector() {
        $path = "./application/cache/session";
        $fileList = directory_map($path);
        $success = false;
        if (!empty($fileList)) {
            foreach ($fileList as $afile) {
                chown($path . '/' . $afile, 666);
                if (is_writable($path . '/' . $afile)) {
                    $success = unlink($path . '/' . $afile);
                }
            }
        }
    }

    public function clear_billcopy_table() {
        $success = $this->db->truncate('gkpos_billcopy');
        echo json_encode(array('success' => $success, 'message' => $success ? 'Bill printer unlocked successfully' : 'Operation Failed'));
    }

    public function locked_orders() {
        $data['current_section'] = 'Locked Orders';
        $data['current_page'] = "Locked Orders";
        $data['lockedOrders'] = $this->Settings_Model->get_list('gkpos_order_lookup', array('is_locked' => 1));
        $this->load->view('gkpos/settings/locked_orders', $data, false);
    }

    public function caller_logs() {
        $data['current_section'] = 'Caller Logs';
        $data['current_page'] = "Caller Logs";
        $data['lockedOrders'] = $this->Settings_Model->get_list('gkpos_caller');
        $this->load->view('gkpos/settings/caller_logs', $data, false);
    }

    public function engaged_table() {
        $data['current_section'] = 'Engaged Table';
        $data['current_page'] = "Engaged Table";
        $data['lockedOrders'] = $this->Settings_Model->get_list('gkpos_table', array('is_vacant' => 2));
        $this->load->view('gkpos/settings/engaged_table', $data, false);
    }

    public function delivery_time() {
        $data['current_section'] = 'Delivery time';
        $data['current_page'] = "delivery_time";
        $this->load->view('gkpos/settings/general/delivery_time', $data, false);
    }

    public function save_default_time() {
        $batch_save_data = array(
            'default_collection_time' => $this->input->post('default_collection_time'),
            'default_delivery_time' => $this->input->post('default_delivery_time'),
        );
        $result = $this->Appconfig->batch_save($batch_save_data);
        $success = $result ? true : false;
        if ($success) {
            $activity = array(
                'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has updated default delivery/collection time'
            );
            $this->Settings_Model->posactivity($activity);
        }
        $message = $this->lang->line('config_saved_' . ($success ? '' : 'un') . 'successfully');
        echo json_encode(array('success' => $success, 'message' => $message));
    }

    public function go_onofline() {
        $gkpos_go_offline = $this->input->post('gkpos_go_offline');
        $success = false;
        if ($gkpos_go_offline == 'yes') {
            $success = $this->Appconfig->batch_save(array('gkpos_go_offline' => 'no'));
        } else {
            $success = $this->Appconfig->batch_save(array('gkpos_go_offline' => 'yes'));
        }
        echo json_encode(array('success' => $success));
    }

}
