<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Voidorders extends Gkpos_Controller {

    function __construct() {
        parent::__construct();
        $this->site_title = $this->config->item('company');
        $this->load->model('Entry_Model');
        if (!$this->Entry_Model->is_logged_in()) {
            redirect('gkpos/entry');
        }
        $this->load->helper('gkpos');
        $this->load->model('Voidorders_Model');
    }

    public function index($segment = 0) {
        $limit = $this->config->item('gk_report_line_page');
        $data['current_page'] = "voidorders";
        $today_start = date($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), mktime(0, 0, 0));
        $today_end = date($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), mktime(23, 59, 59));
        $start_date = $this->input->post('start_date') != null ? $this->input->post('start_date') . ' ' . date($this->config->item('timeformat'), mktime(0, 0, 0)) : $today_start;
        $start_date_formatter = DateTime::createFromFormat($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), $start_date);
        $end_date = $this->input->post('end_date') != null ? $this->input->post('end_date') . ' ' . date($this->config->item('timeformat'), mktime(23, 59, 59)) : $today_end;
        $end_date_formatter = DateTime::createFromFormat($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), $end_date);
        $start_date_value = $start_date_formatter->format('Y-m-d H:i:s');
        $end_date_value = $end_date_formatter->format('Y-m-d H:i:s');
        $filters = array(
            'start_date' => $start_date_value,
            'end_date' => $end_date_value,
        );
        $records = $this->Voidorders_Model->get_total_report_rows('gkpos_order', $filters);
        $maxCounter = $records > $limit ? ceil($records / $limit) : 0;
        $offset = $segment > 0 ? $segment * $limit : 0;
        $data['voidorders'] = $this->Voidorders_Model->search($filters, $offset, $limit)->result();
        $data['start_date'] = $start_date_formatter->format($this->config->item('dateformat'));
        $data['end_date'] = $end_date_formatter->format($this->config->item('dateformat'));
        $data['maxCounter'] = $maxCounter;
        $data['segment'] = $segment;
        //debugPrint(array( $data['voidorders'],$data['maxCounter'],$records));
        $this->load->view('gkpos/voidorders/index', $data, false);
    }

    public function filter($segment = 0) {
        $limit = $this->config->item('gk_report_line_page');
        $data['current_page'] = "voidorders";
        $today_start = date($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), mktime(0, 0, 0));
        $today_end = date($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), mktime(23, 59, 59));
        $start_date = $this->input->post('start_date') != null ? $this->input->post('start_date') . ' ' . date($this->config->item('timeformat'), mktime(0, 0, 0)) : $today_start;
        $start_date_formatter = DateTime::createFromFormat($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), $start_date);
        $end_date = $this->input->post('end_date') != null ? $this->input->post('end_date') . ' ' . date($this->config->item('timeformat'), mktime(23, 59, 59)) : $today_end;
        $end_date_formatter = DateTime::createFromFormat($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), $end_date);
        $start_date_value = $start_date_formatter->format('Y-m-d H:i:s');
        $end_date_value = $end_date_formatter->format('Y-m-d H:i:s');
        $filters = array(
            'start_date' => $start_date_value,
            'end_date' => $end_date_value,
        );
        $records = $this->Voidorders_Model->get_total_report_rows('gkpos_order', $filters);
        $maxCounter = $records > $limit ? ceil($records / $limit) : 0;
        $offset = $segment > 0 ? $segment * $limit : 0;
        $data['voidorders'] = $this->Voidorders_Model->search($filters, $offset, $limit)->result();
        $data['start_date'] = $start_date_formatter->format($this->config->item('dateformat'));
        $data['end_date'] = $end_date_formatter->format($this->config->item('dateformat'));
        $data['maxCounter'] = $maxCounter;
        $data['segment'] = $segment;
        $this->load->view('gkpos/voidorders/filtered', $data, false);
    }
    public function deleteReportRow() {
        $order_id = $this->input->post('id');
        $status = $this->Voidorders_Model->delete_order($order_id);
        echo json_encode(array('status' => $status));
    }

}
