<?php

defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';

class Printer extends REST_Controller {

    function __construct($config = 'rest') {
        parent::__construct($config);
        $this->load->model('Printer_Model');
    }

    public function ktcprinter_post() {
        $data = $this->Printer_Model->get_ktc_print();
        $this->response($data, REST_Controller::HTTP_OK); // OK 
    }

    public function billprinter_post() {
        $data = $this->Printer_Model->get_bill();
        $this->response($data, REST_Controller::HTTP_OK); // OK 
    }

    public function reportprinter_post() {
        $data = $this->Printer_Model->get_ktc_print();
        $this->response($data, REST_Controller::HTTP_OK); // OK 
    }

    public function updatektcprinter_post() {
        $order_id = $this->post('order_id');
        $is_printed = $this->post('is_printed');
        if ($order_id && $is_printed == 1) {
            $this->db->trans_start();
            $this->db->update('gkpos_order', array('is_printed' => 1, 'has_print' => 0, 'sent_option' => NULL), array('id' => $order_id));
            $this->db->update('gkpos_order_detail', array('changed' => NULL), array('order_id' => $order_id));
            $this->db->trans_complete();
            $this->response(array('status' => $this->db->trans_status()), REST_Controller::HTTP_OK);
        } else {
            $this->response(array('status' => false), REST_Controller::HTTP_OK);
        }
    }

    public function updatebillprinter_post() {
        $order_id = $this->post('order_id');
        $bill_printed = $this->post('bill_printed');
        if ($order_id && $bill_printed == 1) {
            $this->db->trans_start();
            $this->db->update('gkpos_order', array('bill_printed' => 1, 'has_print' => 0, 'sent_option' => NULL), array('id' => $order_id));
            $this->db->update('gkpos_order_detail', array('changed' => NULL), array('order_id' => $order_id));
            $this->db->delete('gkpos_billcopy', array('order_id' => $order_id));
            $this->db->trans_complete();
            $this->response(array('status' => $this->db->trans_status()), REST_Controller::HTTP_OK);
        } else {
            $this->response(array('status' => false), REST_Controller::HTTP_OK);
        }
    }

    public function callerid_post() {
        $caller_id = $this->post('caller_id');
        if ($caller_id != null || $caller_id != '') {
            $caller_id = $this->extract_callerid($caller_id);
            $data = array('status' => 1, 'created' => date('Y-m-d H:i:s'), 'caller_id' => $caller_id);
            $this->db->trans_start();
            $this->db->insert('gkpos_caller', $data);
            $this->db->trans_complete();
            $this->response(array('status' => $this->db->trans_status()), REST_Controller::HTTP_OK);
        } else {
            $this->response(array('status' => false), REST_Controller::HTTP_OK);
        }
    }

    private function extract_callerid($string) {
        $result = filter_var($string, FILTER_SANITIZE_NUMBER_INT);
        return $result;
    }

    public function register_post() {
        $success = false;
        $message = null;
        // $this->db->trans_start();
        $data = $this->post();
        if ($data['password'] && $data['password'] != null) {
            $data['password'] = md5($data['password']);
        } else {
            unset($data['password']);
        }
        if ($data['action'] && $data['action'] == 'update') {
            $phone = $data['phone'];
            $email = $data['email'];
            unset($data['email']);
            unset($data['phone']);
            unset($data['action']);
            $data['is_verified'] = 1;
            $success = $this->db->update('gkpos_customer', $data, array('phone' => $phone, 'email' => $email));
            $message = "Your Account updated Successfully";
        } else {
            $data['status'] = 1;
            $data['is_verified'] = 0;
            $data['is_online'] = 1;
            $doesExist = $this->Printer_Model->get_single('gkpos_customer', array('phone' => $data['phone']));
            $success_message = "Your registration done successfully at " . $this->config->item('gk_name');
            if ($doesExist != null && !empty($doesExist)) {
                if ($doesExist->email != null && $doesExist->password != '') {
                    $success = false;
                    $message = 'User already exists with that email or/and phone';
                } else {
                    $success = $this->db->update('gkpos_customer', $data, array('phone' => $doesExist->phone));
                    $message = $success_message;
                }
            } else {
                $success = $this->db->insert('gkpos_customer', $data);
                $message = $success_message;
            }
        }
        //$this->db->trans_complete();
        $this->response(array('status' => $success, 'message' => $message), REST_Controller::HTTP_OK);
    }

    public function validate_post() {
        $data = $this->post();
        // mail('rabbanisoft.mortuza@gmail.com', 'Posted Data', $test);
        if ($data['email'] != null && $data['password'] != null) {
            $user = $this->Printer_Model->get_single('gkpos_customer', array('email' => $data['email'], 'password' => md5($data['password'])));
            if ($user && !empty($user)) {
                $this->response(array('status' => true, 'message' => 'ok', 'userInfo' => $user), REST_Controller::HTTP_OK);
                //$this->response(array('status' => true, 'message' => 'Ok','info'=>$user), REST_Controller::HTTP_OK);
            } else {
                $this->response(array('status' => false, 'message' => 'Invalid username or password'), REST_Controller::HTTP_OK);
                //$this->response(array('status' => false, 'message' => 'Invalid username/password'), REST_Controller::HTTP_OK);
            }
        } else {
            $this->response(array('status' => false, 'message' => 'No Data Posted'), REST_Controller::HTTP_OK);
        }
    }

    public function appdata_post() {
        $data = $this->Printer_Model->appsdata();
        $this->response($data, REST_Controller::HTTP_OK); // OK 
    }

    public function appcheckout_post() {
        $this->db->trans_start();
        $checkoutInfo = $this->post('checkoutInfo');
        $cart = $this->post('cart');
        $discount = $this->post('discount');
        $vat = $this->post('vat');
        if ($checkoutInfo['order_type'] != null && $checkoutInfo['online_type'] != null && $checkoutInfo['online_method'] != null && $checkoutInfo['phone'] != null && $checkoutInfo['name'] != null && $checkoutInfo['email'] != null) {
            $order = $this->save_app_order($checkoutInfo);
            if (!empty($order) && !empty($cart)) {
                $this->save_app_order_detail($cart, $order->id);
            }
            if (!empty($discount)) {
                $this->save_app_order_discount($discount, $order->id);
            }
            if (!empty($vat)) {
                $this->save_app_order_vat($vat, $order->id);
            }
            $this->db->trans_complete();
            $success = $this->db->trans_status();
            $order_id = !empty($order) ? $order->id : false;
            if ($success && $order_id) {
                $thisOrder = $this->Printer_Model->get_single('gkpos_order', array('id' => $order_id));
                $items = $this->Printer_Model->get_list('gkpos_order_detail', array('order_id' => $order_id));
                $discount[$order_id] = $this->Printer_Model->get_single('gkpos_order_discount', array('order_id' => $order->id));
                $vat[$order_id] = $this->Printer_Model->get_single('gkpos_order_vat', array('order_id' => $order->id));
                $payments[$order_id] = $this->Printer_Model->get_list('gkpos_order_payment`', array('order_id' => $order->id));
                $this->response(array('status' => $success, 'orders' => $thisOrder, 'items' => $items, 'discount' => $discount, 'vat' => $vat, 'payments' => $payments), REST_Controller::HTTP_OK); // OK
            } else {
                $this->response(array('status' => false), REST_Controller::HTTP_OK); // OK 
            }
        } else {
            $this->response(array('status' => false), REST_Controller::HTTP_OK); // OK 
        }
    }

    private function save_app_order($data) {
        $data['id'] = $this->Printer_Model->get_key();
        if ($data['online_method'] != 'cod') {
            $data['online_status'] = 3;
        }
        $data['created'] = date('Y-m-d H:i:s');
        if ($this->db->insert("gkpos_order", $data)) {
            return $this->Printer_Model->get_single('gkpos_order', array('id' => $data['id'], 'phone' => $data['phone'], 'email' => $data['email']));
        } else {
            return array();
        }
    }

    private function save_app_order_detail($cart, $order_id) {
        foreach ($cart as $item) {
            $item['order_id'] = $order_id;
            $this->db->insert('gkpos_order_detail', $item);
        }
    }

    private function save_app_order_discount($discount, $order_id) {
        $discount_data = $discount;
        if (!empty($discount_data)) {
            $discount_data['order_id'] = $order_id;
            return $this->db->insert('gkpos_order_discount', $discount_data);
        }
    }

    private function save_app_order_vat($vat, $order_id) {
        $vat_data = $vat;
        $vat_data['order_id'] = $order_id;
        return $this->db->insert('gkpos_order_vat', $vat_data);
    }

    public function appcustomerorders_post() {
        $email = $this->post('email');
        $phone = $this->post('phone');
        $orders = $this->Printer_Model->get_list('gkpos_order', array('email' => $email, 'phone' => $phone, 'order_type' => 'online'), null, 5, 0, 'created', 'DESC');
        $items = array();
        $discount = array();
        $vat = array();
        $payments = array();
        $status = false;
        if (!empty($orders)) {
            $status = true;
            foreach ($orders as $order) {
                $items[$order->id] = $this->Printer_Model->get_list('gkpos_order_detail', array('order_id' => $order->id));
                $discount[$order->id] = $this->Printer_Model->get_single('gkpos_order_discount', array('order_id' => $order->id));
                $vat[$order->id] = $this->Printer_Model->get_single('gkpos_order_vat', array('order_id' => $order->id));
                $payments[$order->id] = $this->Printer_Model->get_list('gkpos_order_payment`', array('order_id' => $order->id));
            }
        }
        $this->response(array('status' => $status, 'orders' => $orders, 'items' => $items, 'discount' => $discount, 'vat' => $vat, 'payments' => $payments), REST_Controller::HTTP_OK); // OK
    }

    public function bluetooth_post() {
        $data = $this->Printer_Model->bluetooth_pendingOrder();
        $this->response($data, REST_Controller::HTTP_OK); // OK 
    }

}
