<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Booking_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_booking_rows($table, $filters) {
        if (isset($filters['start_date']) && isset($filters['end_date'])) {
            $this->db->or_where('created_at BETWEEN ' . $this->db->escape($filters['start_date']) . ' AND ' . $this->db->escape($filters['end_date']));
            $this->db->or_where('res_date BETWEEN ' . $this->db->escape($filters['start_date']) . ' AND ' . $this->db->escape($filters['end_date']));
        }
        $this->db->from($table);
        return $this->db->count_all_results();
    }

    public function get_booking_list($table, $filters, $offset = null, $limit = null, $order_field = null, $order_type = null) {
        if (isset($filters['start_date']) && isset($filters['end_date'])) {
            $this->db->or_where('created_at BETWEEN ' . $this->db->escape($filters['start_date']) . ' AND ' . $this->db->escape($filters['end_date']));
            $this->db->or_where('res_date BETWEEN ' . $this->db->escape($filters['start_date']) . ' AND ' . $this->db->escape($filters['end_date']));
        }
        $this->db->group_by('id');
        if ($order_field && $order_type) {
            $this->db->order_by($order_field, $order_type);
        }
        if ($limit > 0) {
            $this->db->limit($limit, $offset);
        }
        return $this->db->get($table)->result();
    }

}
