<?php

class Gkpos_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function save_customer_info($data) {
        $this->_table_name = "gkpos_customer";
        $this->_primary_key = "phone";
        return $this->save($data);
    }

    public function save_table_info($data) {
        $this->_table_name = "gkpos_table";
        $this->_primary_key = "id";
        return $this->save($data);
    }

    public function save_order_info($data) {
        $this->_table_name = "gkpos_order";
        $this->_primary_key = "id";
        return $this->save($data);
    }

    public function get_table_orders() {
        $this->_table_name = "gkpos_order";
        $this->_primary_key = "id";
        $this->_order_by = "status";
        $results = $this->get_by(array('order_type' => 'table', 'paid_status' => 2));
        return $results;
    }

    public function get_table_seated_not_ordered() {
        $this->_table_name = "gkpos_order";
        $this->_primary_key = "id";
        $this->_order_by = "status";
        $results = $this->get_by(array('order_type' => 'table', 'status' => 1, 'paid_status' => 2));
        return $results;
    }

    public function get_table_seated_ordered() {
        $this->_table_name = "gkpos_order";
        $this->_primary_key = "id";
        $this->_order_by = "status";
        $results = $this->get_by(array('order_type' => 'table', 'status' => 2, 'paid_status' => 2));
        return $results;
    }

    public function get_table_waiting_payment() {
        $this->_table_name = "gkpos_order";
        $this->_primary_key = "id";
        $this->_order_by = "status";
        $results = $this->get_by(array('order_type' => 'table', 'status' => 3, 'paid_status' => 2));
        return $results;
    }

    public function get_takeaway_orders() {
        $this->db->where(array('order_type<>' => 'table', 'paid_status' => 2));
        $this->db->where(array('order_type<>' => 'bar'));
        $this->db->where(array('order_type<>' => 'online'));
        if ($this->config->item('gk_order_delivery') != 'yes') {
            $this->db->where(array('order_type<>' => 'delivery'));
        }
        if ($this->config->item('gk_order_collection') != 'yes') {
            $this->db->where(array('order_type<>' => 'collection'));
        }
        if ($this->config->item('gk_order_waiting') != 'yes') {
            $this->db->where(array('order_type<>' => 'waiting'));
        }
        $results = $this->db->get('gkpos_order')->result();
        return $results;
    }

    public function get_waiting_orders() {
        $this->_table_name = "gkpos_order";
        $this->_primary_key = "id";
        $results = $this->get_by(array('order_type' => 'waiting', 'paid_status' => 2));
        return $results;
    }

    public function get_delivery_orders() {
        $this->_table_name = "gkpos_order";
        $this->_primary_key = "id";
        $results = $this->get_by(array('order_type' => 'delivery', 'paid_status' => 2));
        return $results;
    }

    public function get_collection_orders() {
        $this->_table_name = "gkpos_order";
        $this->_primary_key = "id";
        $results = $this->get_by(array('order_type' => 'collection', 'paid_status' => 2));
        return $results;
    }

    public function get_bar_orders() {
        $this->_table_name = "gkpos_order";
        $this->_primary_key = "id";
        $results = $this->get_by(array('order_type' => 'bar', 'paid_status' => 2));
        return $results;
    }

    function set_google_api($term) {
        $this->session->set_userdata('google', $term);
    }

    function get_google_api() {
        if ($this->session->userdata('google')) {
            return $this->session->userdata('google');
        }
    }

    function clear_google_api() {
        $this->session->unset_userdata('google');
    }

    function user_login_status($id) {
        $this->_table_name = 'gkpos_user';
        $this->_primary_key = 'id';
        $result = $this->get_single('gkpos_user', array('id' => $id), array('is_loggedin', 'username'));
        if (!empty($result)) {
            return $result;
        } else {
            return false;
        }
    }

     public function get_online_orders($action, $status) {
        $today_start = date($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), mktime(0, 0, 0));
        $today_end = date($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), mktime(23, 59, 59));
        $start_date = $this->input->post('start_date') != null ? $this->input->post('start_date') . ' ' . date($this->config->item('timeformat'), mktime(0, 0, 0)) : $today_start;
        $start_date_formatter = DateTime::createFromFormat($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), $start_date);
        $end_date = $this->input->post('end_date') != null ? $this->input->post('end_date') . ' ' . date($this->config->item('timeformat'), mktime(23, 59, 59)) : $today_end;
        $end_date_formatter = DateTime::createFromFormat($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), $end_date);
        $start_date_value = $start_date_formatter->format('Y-m-d H:i:s');
        $end_date_value = $end_date_formatter->format('Y-m-d H:i:s');
        $this->db->where('created BETWEEN ' . $this->db->escape($start_date_value) . ' AND ' . $this->db->escape($end_date_value));
        $this->db->where('order_type', 'online');
        if ($action != null && ($action == 'pending' || $action == 'confirmed' || $action=='canceled')) {
            $this->db->where('online_status', $status);
        }
        if ($action != null && ($action == 'paid' || $action == 'unpaid')) {
            $this->db->where('paid_status', $status);
        }
        $this->db->order_by('created', 'DESC');
        $results = $this->db->get('gkpos_order')->result();
        return $results;
    }

    public function get_driver_orders($action) {
        $today_start = date($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), mktime(0, 0, 0));
        $today_end = date($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), mktime(23, 59, 59));
        $start_date = $this->input->post('start_date') != null ? $this->input->post('start_date') . ' ' . date($this->config->item('timeformat'), mktime(0, 0, 0)) : $today_start;
        $start_date_formatter = DateTime::createFromFormat($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), $start_date);
        $end_date = $this->input->post('end_date') != null ? $this->input->post('end_date') . ' ' . date($this->config->item('timeformat'), mktime(23, 59, 59)) : $today_end;
        $end_date_formatter = DateTime::createFromFormat($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), $end_date);
        $start_date_value = $start_date_formatter->format('Y-m-d H:i:s');
        $end_date_value = $end_date_formatter->format('Y-m-d H:i:s');

        $this->db->where('order_type', 'delivery');
        $this->db->where('created BETWEEN ' . $this->db->escape($start_date_value) . ' AND ' . $this->db->escape($end_date_value));
        if ($action == 'assigned') {
            $this->db->where('driver >=', 1);
        } else {
            $this->db->where('driver', NULL);
        }
        $this->db->where('status >=', 2);


        $this->db->or_where('order_type', 'online');
        $this->db->where('online_type', 'delivery');
        $this->db->where('online_status', 1);
        $this->db->where('created BETWEEN ' . $this->db->escape($start_date_value) . ' AND ' . $this->db->escape($end_date_value));
        if ($action == 'assigned') {
            $this->db->where('driver >=', 1);
        } else {
            $this->db->where('driver', NULL);
        }
        $this->db->where('status >=', 2);

        $this->db->order_by('created', 'DESC');
        $results = $this->db->get('gkpos_order')->result();
        return $results;
    }
    public function get_driver_account($date = null) {
        $today_start = date('d-m-Y' . ' ' . $this->config->item('timeformat'), mktime(0, 0, 0));
        $today_end = date('d-m-Y' . ' ' . $this->config->item('timeformat'), mktime(23, 59, 59));
        $start_date = ($date != null || $date != '') ? $date . ' ' . date($this->config->item('timeformat'), mktime(0, 0, 0)) : $today_start;
        $start_date_formatter = DateTime::createFromFormat('d-m-Y' . ' ' . $this->config->item('timeformat'), $start_date);
        $end_date = ($date != null || $date != '') ? $date . ' ' . date($this->config->item('timeformat'), mktime(23, 59, 59)) : $today_end;
        $end_date_formatter = DateTime::createFromFormat('d-m-Y' . ' ' . $this->config->item('timeformat'), $end_date);
        $start_date_value = $start_date_formatter->format('Y-m-d H:i:s');
        $end_date_value = $end_date_formatter->format('Y-m-d H:i:s');
        $this->db->select('GR.*');
        $this->db->from('gkpos_driver_order GD');
        $this->db->join('gkpos_order as GR', 'GD.order_id = GR.id', 'inner');
        $this->db->where('GD.created BETWEEN ' . $this->db->escape($start_date_value) . ' AND ' . $this->db->escape($end_date_value));
        $this->db->order_by('GD.driver', 'ASC');
        $this->db->group_by('order_id');
        $results = $this->db->get()->result();
        return $results;
    }

}
