<?php

class Online_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function save_promotion($data, $id = null) {
        $this->_table_name = 'promotion';
        $this->_primary_key = 'id';
        return $this->save($data, $id);
    }

    public function get_code() {
        $key = self::_generate_code();
        if ($key) {
            return $key;
        }
    }

    private function _generate_code($length = 7) {
        do {
            $newkey = substr(str_shuffle(str_repeat($x = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ', ceil($length / strlen($x)))), 1, $length);
        } while (self::_code_exists($newkey));
        return $newkey;
    }

    private function _code_exists($key) {
        return $this->db->where('id', $key)->count_all_results('promotion') > 0;
    }

}
