<?php

class Orders_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    function showcategory() {
        $data = array();
        return $this->load->view('gkpos/orders/listcategory', $data, true);
    }

    public function get_menulist_by_cat($catid, $offset = 0, $limit = 5) {
        $this->db->select('gm.id,gm.title,gm.content,gm.base_price,gm.in_price,gm.out_price,gm.order, gc.id as categoryId,gc.title as categoryTitle,gc.content as categoryContent,gc.type,gc.print_option');
        $this->db->from('gkpos_menu gm');
        $this->db->join('gkpos_category gc', 'gc.id=gm.category', 'left');
        $this->db->where(array('gm.category' => $catid, 'gm.status' => 1));
        $this->db->order_by('gm.order', 'asc');
        $this->db->limit($limit, $offset);
        $query = $this->db->get();
        if ($query->num_rows() != 0) {
            return $query->result_array();
        } else {
            return false;
        }
    }

    public function get_menulist_order_by_cat($catid, $offset = 0, $limit = 5) {
        $this->db->select('gm.id,gm.order');
        $this->db->from('gkpos_menu gm');
        $this->db->where(array('gm.category' => $catid, 'gm.status' => 1));
        $this->db->order_by('gm.order', 'asc');
        $this->db->limit($limit, $offset);
        $query = $this->db->get();
        if ($query->num_rows() != 0) {
            return $query->result_array();
        } else {
            return false;
        }
    }

    public function getmenuselection($category, $menu, $offset = 0, $limit = 0) {
        $this->db->select('SEL.id,SEL.title,SEL.content,SEL.base_price,SEL.in_price,SEL.out_price,SEL.order, MENU.id as selMenuId,MENU.title as selMenuTitle,MENU.content as selMenuContent,CATEGORY.id as selMenuCategoryId,CATEGORY.type as selMenuCategoryType,CATEGORY.print_option as selMenuCategoryPrintOption');
        $this->db->from('gkpos_selection SEL');
        $this->db->join('gkpos_menu MENU', 'MENU.id=SEL.menu', 'left');
        $this->db->join('gkpos_category CATEGORY', 'CATEGORY.id=SEL.category', 'left');
        $this->db->where(array('SEL.category' => $category, 'SEL.menu' => $menu, 'SEL.status' => 1));
        $this->db->order_by('SEL.order', 'asc');
        $this->db->limit($limit, $offset);
        $query = $this->db->get();
        if ($query->num_rows() != 0) {
            return $query->result_array();
        } else {
            return false;
        }
    }

    public function get_cart_item($category, $menu, $sel = 0) {
        if ($sel > 0) {
            $this->db->select('GS.id as selection,GS.title as selection_title,GS.base_price,GS.in_price,GS.out_price,GS.menu,GM.title as menu_title,GS.category, GC.title as category_title,GC.print_option as category_print_option,GC.type as category_type');
            $this->db->from('gkpos_selection GS');
            $this->db->join('gkpos_menu as GM', 'GS.menu=GM.id', 'left');
            $this->db->join('gkpos_category as GC', 'GM.category=GC.id', 'left');
            $this->db->where(array('GS.id' => $sel));
        } else {
            $this->db->select('GM.id as menu,GM.title as menu_title,GM.category,GM.base_price,GM.in_price,GM.out_price, GC.title as category_title,GC.print_option as category_print_option,GC.type as category_type ');
            $this->db->from('gkpos_menu GM');
            $this->db->join('gkpos_category as GC', 'GM.category=GC.id', 'left');
            $this->db->where(array('GM.id' => $menu, 'GC.id' => $category));
        }
        return $this->db->get()->row();
    }

    function get_current_orderid() {
        if ($this->session->userdata('current_orderid')) {
            return $this->session->userdata('current_orderid');
        }
    }

    function set_current_orderid($order_id) {
        $this->session->set_userdata('current_orderid', $order_id);
    }

    function clear_current_orderid() {
        $this->session->unset_userdata('current_orderid');
    }

    function get_current_ordertype() {
        if ($this->session->userdata('current_ordertype')) {
            return $this->session->userdata('current_ordertype');
        }
    }

    function set_current_ordertype($current_ordertype) {
        $this->session->set_userdata('current_ordertype', $current_ordertype);
    }

    function clear_current_ordertype() {
        $this->session->unset_userdata('current_ordertype');
    }

    function get_cart($order_id) {
        if ($this->session->userdata('cart_' . $order_id)) {
            return $this->session->userdata('cart_' . $order_id);
        }
    }

    function set_cart($order_id, $cart_data) {
        $this->session->set_userdata('cart_' . $order_id, $cart_data);
    }

    function cart_item_plus($order_id, $line, $quantity = false) {
        $items = $this->get_cart($order_id);
        $items[$line]['quantity'] += 1;
        $this->set_cart($order_id, $items);
        $this->set_cart_new($order_id, 'yes');
        if ($items[$line]['bogo'] == 1) {
            $this->manage_bogo($line, 'plus');
        }
        return array('success' => true, 'order_id' => $order_id, 'line' => $line);
    }

    function cart_item_minus($order_id, $line, $quantity = false) {
        $items = $this->get_cart($order_id);
        if ($items[$line]['bogo'] == 1) {
            $this->manage_bogo($line, 'remove');
        }
        $items[$line]['quantity'] > 1 ? $this->set_cart_new($order_id, 'yes') : $this->get_cart_new($order_id);
        $items[$line]['quantity'] -= $items[$line]['quantity'] > 1 ? 1 : 0;
        $this->set_cart($order_id, $items);
        return array('success' => true, 'order_id' => $order_id, 'line' => $line);
    }

    function cart_item_del($order_id, $line, $quantity = false) {
        $items = $this->get_cart($order_id);
        if ($items[$line]['bogo'] == 1) {
            $this->manage_bogo($line, 'remove');
        }
        unset($items[$line]);
        $this->set_cart($order_id, $items);
        return array('success' => true, 'order_id' => $order_id, 'line' => false);
    }

    function cart_item_quantity($order_id, $line, $quantity = false) {
        $items = $this->get_cart($order_id);
        $items[$line]['quantity'] = $quantity;
        $this->set_cart($order_id, $items);
        $this->set_cart_new($order_id, 'yes');
        return array('success' => true, 'order_id' => $order_id, 'line' => $line);
    }

    function empty_cart($order_id) {
        $this->session->unset_userdata('cart_' . $order_id);
        $this->clear_bogo_discount($order_id);
        $this->clear_bogodiscount_amount($order_id);
    }

    function get_cart_db($order_id) {
        if ($this->session->userdata('cart_db_' . $order_id)) {
            return $this->session->userdata('cart_db_' . $order_id);
        }
    }

    function set_cart_db($order_id, $cart_data) {
        $this->session->set_userdata('cart_db_' . $order_id, $cart_data);
    }

    function dbcart_item_plus($order_id, $line, $quantity = false) {
        $items = $this->get_cart_db($order_id);
        $items[$line]['quantity'] += 1;
        $this->set_cart_db($order_id, $items);
        $this->set_cart_new($order_id, 'yes');
        if ($items[$line]['bogo'] == 1) {
            $this->manage_bogo($line, 'plus');
        }
        return array('success' => true, 'order_id' => $order_id, 'line' => $line);
    }

    function dbcart_item_minus($order_id, $line, $quantity = false) {
        if (($this->session->userdata('gkpos_usertype') == 1 || $this->session->userdata('gkpos_usertype') == 2) && $this->get_voidorder_status($order_id)) {
            $items = $this->get_cart_db($order_id);
            if ($items[$line]['bogo'] == 1) {
                $this->manage_bogo($line, 'minus');
            }
            $items[$line]['quantity'] > 1 ? $this->set_cart_new($order_id, 'yes') : $this->get_cart_new($order_id);
            $items[$line]['quantity'] -= $items[$line]['quantity'] > 1 ? 1 : 0;
            $this->set_cart_db($order_id, $items);
            $this->set_cart_new($order_id, 'yes');
            return array('success' => true, 'order_id' => $order_id, 'line' => $line);
        } else {
            return array('success' => true, 'order_id' => $order_id, 'line' => $line, 'not_allowed' => 1);
        }
    }

    function dbcart_item_del($order_id, $line, $quantity = false) {
        if (($this->session->userdata('gkpos_usertype') == 1 || $this->session->userdata('gkpos_usertype') == 2) && $this->get_voidorder_status($order_id)) {
            if ($this->db->delete('gkpos_order_detail', array('order_id' => $order_id, 'line' => $line))) {
                $items = $this->get_cart_db($order_id);
                if ($items[$line]['bogo'] == 1) {
                    $this->manage_bogo($line, 'remove');
                }
                unset($items[$line]);
                $this->set_cart_db($order_id, $items);
                $this->set_cart_new($order_id, 'yes');
                return array('success' => true, 'order_id' => $order_id, 'line' => 0);
            } else {
                return array('success' => true, 'order_id' => $order_id, 'line' => $line, 'not_allowed' => 1);
            }
        } else {
            return array('success' => true, 'order_id' => $order_id, 'line' => $line, 'not_allowed' => 1);
        }
    }

    function cart_item_special($order_id, $line, $quantity = false) {
        $items = $this->get_cart($order_id);
        if ($items[$line]['selection_title'] != null && $items[$line]['menu_title'] != null) {
            $title = explode('-[', $items[$line]['menu_title']);
            if (count($title) > 1) {
                $items[$line]['menu_title'] = $title[0] . "-[" . $quantity . "]";
            } else {
                $items[$line]['menu_title'] .= "-[" . $quantity . "]";
            }
        } if ($items[$line]['selection_title'] == null && $items[$line]['menu_title'] != null) {
            $title = explode('-[', $items[$line]['menu_title']);
            if (count($title) > 1) {
                $items[$line]['menu_title'] = $title[0] . "-[" . $quantity . "]";
            } else {
                $items[$line]['menu_title'] .= "-[" . $quantity . "]";
            }
        } if ($items[$line]['selection_title'] != null && $items[$line]['menu_title'] == null) {
            $title = explode('-[', $items[$line]['selection_title']);
            if (count($title) > 1) {
                $items[$line]['selection_title'] = $title[0] . "-[" . $quantity . "]";
            } else {
                $items[$line]['selection_title'] .= "-[" . $quantity . "]";
            }
        }
        $this->set_cart($order_id, $items);
        $this->set_cart_new($order_id, 'yes');
        return array('success' => true, 'order_id' => $order_id, 'line' => $line);
    }

    function cart_item_special_old($order_id, $line, $quantity = false) {
        $items = $this->get_cart($order_id);
        if ($items[$line]['selection_title'] != '' || $items[$line]['selection_title'] != null) {
            $title = explode('-[', $items[$line]['selection_title']);
            if (count($title) > 1) {
                $items[$line]['selection_title'] = $title[0] . "-[" . $quantity . "]";
            } else {
                $items[$line]['selection_title'] .= "-[" . $quantity . "]";
            }
        } else {
            $title = explode('-[', $items[$line]['menu_title']);
            if (count($title) > 1) {
                $items[$line]['menu_title'] = $title[0] . "-[" . $quantity . "]";
            } else {
                $items[$line]['menu_title'] .= "-[" . $quantity . "]";
            }
        }
        $this->set_cart($order_id, $items);
        $this->set_cart_new($order_id, 'yes');
        return array('success' => true, 'order_id' => $order_id, 'line' => $line);
    }

    function dbcart_item_special($order_id, $line, $quantity = false) {
        $items = $this->get_cart_db($order_id);
        if ($items[$line]['selection_title'] != null && $items[$line]['menu_title'] != null) {
            $title = explode('-[', $items[$line]['menu_title']);
            if (count($title) > 1) {
                $items[$line]['menu_title'] = $title[0] . "-[" . $quantity . "]";
            } else {
                $items[$line]['menu_title'] .= "-[" . $quantity . "]";
            }
        } if ($items[$line]['selection_title'] == null && $items[$line]['menu_title'] != null) {
            $title = explode('-[', $items[$line]['menu_title']);
            if (count($title) > 1) {
                $items[$line]['menu_title'] = $title[0] . "-[" . $quantity . "]";
            } else {
                $items[$line]['menu_title'] .= "-[" . $quantity . "]";
            }
        } if ($items[$line]['selection_title'] != null && $items[$line]['menu_title'] == null) {
            $title = explode('-[', $items[$line]['selection_title']);
            if (count($title) > 1) {
                $items[$line]['selection_title'] = $title[0] . "-[" . $quantity . "]";
            } else {
                $items[$line]['selection_title'] .= "-[" . $quantity . "]";
            }
        }
        $this->set_cart_db($order_id, $items);
        $this->set_cart_new($order_id, 'yes');
        return array('success' => true, 'order_id' => $order_id, 'line' => $line);
    }

    function dbcart_item_special_old($order_id, $line, $quantity = false) {
        $items = $this->get_cart_db($order_id);
        if ($items[$line]['selection_title'] != '' || $items[$line]['selection_title'] != '') {
            $title = explode('-[', $items[$line]['selection_title']);
            if (count($title) > 1) {
                $items[$line]['selection_title'] = $title[0] . "-[" . $quantity . "]";
            } else {
                $items[$line]['selection_title'] .= "-[" . $quantity . "]";
            }
        } else {
            $title = explode('-[', $items[$line]['menu_title']);
            if (count($title) > 1) {
                $items[$line]['menu_title'] = $title[0] . "-[" . $quantity . "]";
            } else {
                $items[$line]['menu_title'] .= "-[" . $quantity . "]";
            }
        }
        $this->set_cart_db($order_id, $items);
        $this->set_cart_new($order_id, 'yes');
        return array('success' => true, 'order_id' => $order_id, 'line' => $line);
    }

    function dbcart_item_quantity($order_id, $line, $quantity = false) {
        $items = $this->get_cart_db($order_id);
        $items[$line]['quantity'] = $quantity;
        $this->set_cart_db($order_id, $items);
        $this->set_cart_new($order_id, 'yes');
        return array('success' => true, 'order_id' => $order_id, 'line' => $line);
    }

    function get_cart_new($order_id) {
        if ($this->session->userdata('cart_' . $order_id . '_has_new')) {
            return $this->session->userdata('cart_' . $order_id . '_has_new');
        }
        return $this->session->userdata('cart_' . $order_id . '_has_new');
    }

    function set_cart_new($order_id, $data) {
        $this->session->set_userdata('cart_' . $order_id . '_has_new', $data);
    }

    function clear_cart_new($order_id) {
        $this->session->unset_userdata('cart_' . $order_id . '_has_new');
    }

    function get_updated_cart($order_id) {
        if ($this->session->userdata('cart_' . $order_id . '_has_update')) {
            return $this->session->userdata('cart_' . $order_id . '_has_update');
        }
        return $this->session->userdata('cart_' . $order_id . '_has_update');
    }

    function set_updated_cart($order_id, $data) {
        $this->session->set_userdata('cart_' . $order_id . '_has_update', $data);
    }

    function clear_updated_cart($order_id) {
        $this->session->unset_userdata('cart_' . $order_id . '_has_update');
    }

    function empty_cart_db($order_id) {
        $this->session->unset_userdata('cart_db_' . $order_id);
    }

    public function set_order_total($order_id, $data) {
        $this->session->set_userdata('cart_order_total_' . $order_id, $data);
    }

    public function get_order_total($order_id) {
        if ($this->session->userdata('cart_order_total_' . $order_id)) {
            return $this->session->userdata('cart_order_total_' . $order_id);
        }
    }

    public function clear_order_total($order_id) {
        $this->session->unset_userdata('cart_order_total_' . $order_id);
    }

    //discount management session 
    function initiate_discount($order_id, $order_type, $discounted_total = null) {
        //get exiting discount of this order from discount table 
        $discount = $this->get_single_array('gkpos_order_discount', array('order_id' => $order_id));
        if (!empty($discount)) {
            $this->set_discount_on($order_id, array('food' => $discount['food'], 'nonfood' => $discount['nonfood']));
            $this->set_min_order_discounted_amount($order_id, $discount['min_order']);
            $this->set_discount($order_id, $discount);
        } else {
            if ($this->config->item('gk_discount_applied') == 'yes' && !$this->get_discount($order_id)) {
                $defaultDiscountMinOrder = $this->config->item('gk_discount_min_order');
                $getCurrentCartAmount = $this->get_order_total($order_id);
                $gk_discount_dinein = $this->config->item('gk_discount_dinein');
                $gk_discount_dineout = $this->config->item('gk_discount_dineout');
                $dineInFlag = false;
                $dineInFlagHasDistinct = false;
                $discountAppliedOn = null;
                if ($gk_discount_dinein != null && $gk_discount_dinein == 'yes') {
                    if ($order_type == 'table' || $order_type == 'bar') {
                        $dineInFlag = true;
                    }
                    if (true == $dineInFlag) {
                        $this->db->where('type', 'table');
                        $this->db->or_where('type', 'bar');
                        $dineInDisCountPlan = $this->db->get('gkpos_discountplan')->result();
                        $type1 = $dineInDisCountPlan[0]->is_applied == 'yes';
                        $type2 = $dineInDisCountPlan[1]->is_applied == 'yes';
                        if ($type1 == 'yes' || $type2 == 'yes') {
                            $dineInFlagHasDistinct = true;
                            if (!$this->get_discount_on($order_id)) {
                                foreach ($dineInDisCountPlan as $discountPlan) {
                                    if ($discountPlan->type == $order_type) {
                                        $discountAppliedOn['food'] = $discountPlan->food == null && $discountPlan->nonfood == null ? $this->config->item('gk_discount_food') : $discountPlan->food;
                                        $discountAppliedOn['nonfood'] = $discountPlan->food == null && $discountPlan->nonfood == null ? $this->config->item('gk_discount_nonfood') : $discountPlan->nonfood;
                                    }
                                }
                                $this->set_discount_on($order_id, $discountAppliedOn);
                            }
                        } else {
                            $discountAppliedOn['food'] = $this->config->item('gk_discount_food');
                            $discountAppliedOn['nonfood'] = $this->config->item('gk_discount_nonfood');
                            $this->set_discount_on($order_id, $discountAppliedOn);
                            $dineInFlagHasDistinct = false;
                        }
                    }
                }
                $dineOutFlag = false;
                $dineOutFlagHasDistinct = false;
                if ($gk_discount_dineout != null && $gk_discount_dineout == 'yes') {
                    if ($order_type == 'delivery' || $order_type == 'collection' || $order_type == 'waiting') {
                        $dineOutFlag = true;
                    }
                    if (true == $dineOutFlag) {
                        $this->db->where('type', 'collection');
                        $this->db->or_where('type', 'delivery');
                        $this->db->or_where('type', 'waiting');
                        $dineOutDisCountPlan = $this->db->get('gkpos_discountplan')->result();
                        $type1 = $dineOutDisCountPlan[0]->is_applied == 'yes' ? 'yes' : null;
                        $type2 = $dineOutDisCountPlan[1]->is_applied == 'yes' ? 'yes' : null;
                        $type3 = $dineOutDisCountPlan[2]->is_applied == 'yes' ? 'yes' : null;
                        if ($type1 == 'yes' || $type2 == 'yes' || $type3 == 'yes') {
                            $dineOutFlagHasDistinct = true;
                            foreach ($dineOutDisCountPlan as $discountPlan) {
                                if ($discountPlan->type == $order_type) {
                                    $discountAppliedOn['food'] = $discountPlan->food == null && $discountPlan->nonfood == null ? $this->config->item('gk_discount_food') : $discountPlan->food;
                                    $discountAppliedOn['nonfood'] = $discountPlan->food == null && $discountPlan->nonfood == null ? $this->config->item('gk_discount_nonfood') : $discountPlan->nonfood;
                                }
                            }
                            $this->set_discount_on($order_id, $discountAppliedOn);
                        } else {
                            $discountAppliedOn['food'] = $this->config->item('gk_discount_food');
                            $discountAppliedOn['nonfood'] = $this->config->item('gk_discount_nonfood');
                            $this->set_discount_on($order_id, $discountAppliedOn);
                            $dineOutFlagHasDistinct = false;
                        }
                    }
                }
                if ($dineInFlag && $dineInFlagHasDistinct) {
                    $overrideDiscountPlan = $this->get_single('gkpos_discountplan', array('type' => $order_type));
                    if ($overrideDiscountPlan->is_applied == 'yes') {
                        $minOrderAmountForDiscount = $overrideDiscountPlan->min_order > 0 ? $overrideDiscountPlan->min_order : $defaultDiscountMinOrder;
                        $minOrderAmountForDiscount = $minOrderAmountForDiscount > 0 ? $minOrderAmountForDiscount : 0;
                        $this->set_min_order_discounted_amount($order_id, $minOrderAmountForDiscount);
                        if ($getCurrentCartAmount >= $minOrderAmountForDiscount) {
                            $discount['order_id'] = $order_id;
                            $number = $overrideDiscountPlan->number > 0 ? $overrideDiscountPlan->number : $this->config->item('gk_discount_percent');
                            $discount['number'] = $number > 0 ? $number : 0;
                            $discount['func'] = $overrideDiscountPlan->func != null && $overrideDiscountPlan->func > 0 ? $overrideDiscountPlan->func : 1;
                            $discount['amount'] = 0;
                            $discount['food'] = $overrideDiscountPlan->food == null && $overrideDiscountPlan->nonfood == null ? $this->config->item('gk_discount_food') : $overrideDiscountPlan->food;
                            $discount['nonfood'] = $overrideDiscountPlan->food == null && $overrideDiscountPlan->nonfood == null ? $this->config->item('gk_discount_nonfood') : $overrideDiscountPlan->nonfood;
                            $discount['min_order'] = $minOrderAmountForDiscount;
                            $this->set_discount($order_id, $discount);
                        } else {
                            $this->clear_discount($order_id);
                        }
                    } else {
                        $this->clear_discount($order_id);
                    }
                } else {
                    if ($dineInFlag && !$dineInFlagHasDistinct) {
                        $overrideDiscountPlan = $this->get_single('gkpos_discountplan', array('type' => $order_type));
                        $minOrderAmountForDiscount = $overrideDiscountPlan->min_order > 0 ? $overrideDiscountPlan->min_order : $defaultDiscountMinOrder;
                        $minOrderAmountForDiscount = $minOrderAmountForDiscount > 0 ? $minOrderAmountForDiscount : 0;
                        $this->set_min_order_discounted_amount($order_id, $minOrderAmountForDiscount);
                        if ($getCurrentCartAmount >= $minOrderAmountForDiscount) {
                            $discount['order_id'] = $order_id;
                            $number = $overrideDiscountPlan->number > 0 ? $overrideDiscountPlan->number : $this->config->item('gk_discount_percent');
                            $discount['number'] = $number > 0 ? $number : 0;
                            $discount['func'] = $overrideDiscountPlan->func != null && $overrideDiscountPlan->func > 0 ? $overrideDiscountPlan->func : 1;
                            $discount['amount'] = 0;
                            $discount['food'] = $overrideDiscountPlan->food == null && $overrideDiscountPlan->nonfood == null ? $this->config->item('gk_discount_food') : $overrideDiscountPlan->food;
                            $discount['nonfood'] = $overrideDiscountPlan->food == null && $overrideDiscountPlan->nonfood == null ? $this->config->item('gk_discount_nonfood') : $overrideDiscountPlan->nonfood;
                            $discount['min_order'] = $minOrderAmountForDiscount;
                            $this->set_discount($order_id, $discount);
                        } else {
                            $this->clear_discount($order_id);
                        }
                    }
                }
                if ($dineOutFlag && $dineOutFlagHasDistinct) {
                    $overrideDiscountPlan = $this->get_single('gkpos_discountplan', array('type' => $order_type));
                    if ($overrideDiscountPlan->is_applied == 'yes') {
                        $minOrderAmountForDiscount = $overrideDiscountPlan->min_order > 0 ? $overrideDiscountPlan->min_order : $defaultDiscountMinOrder;
                        $minOrderAmountForDiscount = $minOrderAmountForDiscount > 0 ? $minOrderAmountForDiscount : 0;
                        $this->set_min_order_discounted_amount($order_id, $minOrderAmountForDiscount);
                        if ($getCurrentCartAmount >= $minOrderAmountForDiscount) {
                            $discount['order_id'] = $order_id;
                            $number = $overrideDiscountPlan->number > 0 ? $overrideDiscountPlan->number : $this->config->item('gk_discount_percent');
                            $discount['number'] = $number > 0 ? $number : 0;
                            $discount['func'] = $overrideDiscountPlan->func != null && $overrideDiscountPlan->func > 0 ? $overrideDiscountPlan->func : 1;
                            $discount['amount'] = 0;
                            $discount['food'] = $overrideDiscountPlan->food == null && $overrideDiscountPlan->nonfood == null ? $this->config->item('gk_discount_food') : $overrideDiscountPlan->food;
                            $discount['nonfood'] = $overrideDiscountPlan->food == null && $overrideDiscountPlan->nonfood == null ? $this->config->item('gk_discount_nonfood') : $overrideDiscountPlan->nonfood;
                            $discount['min_order'] = $minOrderAmountForDiscount;
                            $this->set_discount($order_id, $discount);
                        } else {
                            $this->clear_discount($order_id);
                        }
                    } else {
                        $this->clear_discount($order_id);
                    }
                } else {
                    if ($dineOutFlag && !$dineOutFlagHasDistinct) {
                        $overrideDiscountPlan = $this->get_single('gkpos_discountplan', array('type' => $order_type));
                        $minOrderAmountForDiscount = $overrideDiscountPlan->min_order > 0 ? $overrideDiscountPlan->min_order : $defaultDiscountMinOrder;
                        $minOrderAmountForDiscount = $minOrderAmountForDiscount > 0 ? $minOrderAmountForDiscount : 0;
                        $this->set_min_order_discounted_amount($order_id, $minOrderAmountForDiscount);
                        if ($getCurrentCartAmount >= $minOrderAmountForDiscount) {
                            $discount['order_id'] = $order_id;
                            $number = $overrideDiscountPlan->number > 0 ? $overrideDiscountPlan->number : $this->config->item('gk_discount_percent');
                            $discount['number'] = $number > 0 ? $number : 0;
                            $discount['func'] = $overrideDiscountPlan->func != null && $overrideDiscountPlan->func > 0 ? $overrideDiscountPlan->func : 1;
                            $discount['amount'] = 0;
                            $discount['food'] = $overrideDiscountPlan->food == null && $overrideDiscountPlan->nonfood == null ? $this->config->item('gk_discount_food') : $overrideDiscountPlan->food;
                            $discount['nonfood'] = $overrideDiscountPlan->food == null && $overrideDiscountPlan->nonfood == null ? $this->config->item('gk_discount_nonfood') : $overrideDiscountPlan->nonfood;
                            $discount['min_order'] = $minOrderAmountForDiscount;
                            $this->set_discount($order_id, $discount);
                        } else {
                            $this->clear_discount($order_id);
                        }
                    }
                }
            } else {
                $this->clear_discount($order_id);
            }
        }
    }

    public function set_discount_on($order_id, $data) {
        $applied_on = null;
        $food = isset($data['food']) && $data['food'] == 'yes' ? true : false;
        $nonfood = isset($data['nonfood']) && $data['nonfood'] == 'yes' ? true : false;
        $both = ($food && $nonfood) ? true : false;
        if ($both) {
            $applied_on = "both";
        }
        if ($food && !$both) {
            $applied_on = "food";
        }
        if ($nonfood && !$both) {
            $applied_on = "nonfood";
        }
        $this->session->set_userdata('discount_applied_on_' . $order_id, $applied_on);
    }

    public function get_discount_on($order_id) {
        if ($this->session->userdata('discount_applied_on_' . $order_id)) {
            return $this->session->userdata('discount_applied_on_' . $order_id);
        }
    }

    public function clear_discount_on($order_id) {
        if ($this->session->userdata('discount_applied_on_' . $order_id)) {
            $this->session->unset_userdata('discount_applied_on_' . $order_id);
        }
    }

    public function set_min_order_discounted_amount($order_id, $data) {
        $this->session->set_userdata('cart_min_order_discount_' . $order_id, $data);
    }

    public function get_min_order_discounted_amount($order_id) {
        if ($this->session->userdata('cart_min_order_discount_' . $order_id)) {
            return $this->session->userdata('cart_min_order_discount_' . $order_id);
        }
    }

    public function clear_min_order_discounted_amount($order_id) {
        if ($this->session->userdata('cart_min_order_discount_' . $order_id)) {
            $this->session->unset_userdata('cart_min_order_discount_' . $order_id);
        }
    }

    function set_discount($order_id, $data) {
        $this->session->set_userdata('cart_' . $order_id . '_discount', $data);
    }

    function get_discount($order_id) {
        if ($this->session->userdata('cart_' . $order_id . '_discount')) {
            return $this->session->userdata('cart_' . $order_id . '_discount');
        }
    }

    function clear_discount($order_id) {
        if ($this->session->userdata('cart_' . $order_id . '_discount')) {
            $this->session->unset_userdata('cart_' . $order_id . '_discount');
        }
    }

    function set_discount_amount($order_id, $data) {
        $this->session->set_userdata('cart_' . $order_id . '_discount_amount', $data);
    }

    function get_discount_amount($order_id) {
        if ($this->session->userdata('cart_' . $order_id . '_discount_amount')) {
            return $this->session->userdata('cart_' . $order_id . '_discount_amount');
        }
    }

    function clear_discount_amount($order_id) {
        $this->session->unset_userdata('cart_' . $order_id . '_discount_amount');
    }

    public function set_bogo_discount($order_id, $data) {
        $this->session->set_userdata('cart_bogo_discount_' . $order_id, $data);
    }

    public function get_bogo_discount($order_id) {
        if ($this->session->userdata('cart_bogo_discount_' . $order_id)) {
            return $this->session->userdata('cart_bogo_discount_' . $order_id);
        }
    }

    public function clear_bogo_discount($order_id) {
        $this->session->unset_userdata('cart_bogo_discount_' . $order_id);
    }

    function calculate_bogo_discount_amount($order_id) {
        $bogo_discount_amount = 0;
        $bogo_discount = $this->get_bogo_discount($order_id) ? $this->get_bogo_discount($order_id) : array();
        if (!empty($bogo_discount)) {
            foreach ($bogo_discount as $bogoamount) {
                $bogo_discount_amount += $bogoamount;
            }
        }
        $this->set_bogodiscount_amount($order_id, $bogo_discount_amount);
    }

    function set_bogodiscount_amount($order_id, $data) {
        $this->session->set_userdata('bogodiscount_amount_' . $order_id, $data);
    }

    function get_bogodiscount_amount($order_id) {
        if ($this->session->userdata('bogodiscount_amount_' . $order_id)) {
            return $this->session->userdata('bogodiscount_amount_' . $order_id);
        }
    }

    function clear_bogodiscount_amount($order_id) {
        if ($this->session->userdata('bogodiscount_amount_' . $order_id)) {
            $this->session->unset_userdata('bogodiscount_amount_' . $order_id);
        }
    }

    public function initiate_bogo_discount($order_id) {
        $bogo_discount = $this->get_list('bogo_discount', array('order_id' => $order_id));
        //debugPrint($bogo_discount);
        //exit();
        $bogo_discount_init = array();
        if (!empty($bogo_discount)) {
            foreach ($bogo_discount as $obj) {
                $bogo_discount_init[$obj->item] = $obj->value;
            }
            $this->set_bogo_discount($order_id, $bogo_discount_init);
        } else {
            $this->clear_bogo_discount($order_id);
        }
    }

    //Service Charge Management Session 
    function initiate_service_charge($order_id) {
        $servicecharge = $this->get_single_array('gkpos_order_servicecharge', array('order_id' => $order_id));
        if (!empty($servicecharge)) {
            $this->set_servicecharge($order_id, $servicecharge);
        } else {
            $this->clear_servicecharge($order_id);
        }
    }

    function set_servicecharge($order_id, $data) {
        $this->session->set_userdata('cart_' . $order_id . '_servicecharge', $data);
    }

    function get_servicecharge($order_id) {
        if ($this->session->userdata('cart_' . $order_id . '_servicecharge')) {
            return $this->session->userdata('cart_' . $order_id . '_servicecharge');
        }
    }

    function clear_servicecharge($order_id) {
        $this->session->unset_userdata('cart_' . $order_id . '_servicecharge');
    }

    function set_servicecharge_amount($order_id, $data) {
        $this->session->set_userdata('cart_' . $order_id . '_servicecharge_amount', $data);
    }

    function get_servicecharge_amount($order_id) {
        if ($this->session->userdata('cart_' . $order_id . '_servicecharge_amount')) {
            return $this->session->userdata('cart_' . $order_id . '_servicecharge_amount');
        }
    }

    function clear_servicecharge_amount($order_id) {
        $this->session->unset_userdata('cart_' . $order_id . '_servicecharge_amount');
    }

    //Service Charge Management Session End
    function initiate_vat($order_id) {
        $vat = $this->get_single_array('gkpos_order_vat', array('order_id' => $order_id));
        if (!empty($vat)) {
            $this->set_vat($order_id, $vat);
        } else {
            if ($this->config->item('gk_vat_reg') != '' || $this->config->item('gk_vat_reg')) {
                $vat['order_id'] = $order_id;
                $vat['number'] = $this->config->item('gk_vat_percent');
                $vat['func'] = 1;
                $vat['amount'] = 0;
                $vat['is_included'] = $this->config->item('gk_vat_included') == 'yes' ? 1 : 2;
                $this->set_vat($order_id, $vat);
            } else {
                $this->clear_vat($order_id);
            }
        }
    }

    function set_vat($order_id, $data) {
        $this->session->set_userdata('cart_' . $order_id . '_vat', $data);
    }

    function get_vat($order_id) {
        if ($this->session->userdata('cart_' . $order_id . '_vat')) {
            return $this->session->userdata('cart_' . $order_id . '_vat');
        }
    }

    function clear_vat($order_id) {
        if ($this->session->userdata('cart_' . $order_id . '_vat')) {
            $this->session->unset_userdata('cart_' . $order_id . '_vat');
        }
    }

    function set_vat_amount($order_id, $data) {
        $this->session->set_userdata('cart_' . $order_id . '_vat_amount', $data);
    }

    function get_vat_amount($order_id) {
        if ($this->session->userdata('cart_' . $order_id . '_vat_amount')) {
            return $this->session->userdata('cart_' . $order_id . '_vat_amount');
        }
    }

    function clear_vat_amount($order_id) {
        $this->session->unset_userdata('cart_' . $order_id . '_vat_amount');
    }

    function initiate_deliveryplan($order_id) {
        $order = $this->Orders_Model->get_single('gkpos_order', array('id' => $order_id), array('postcode'));
        $formatedPostcode = postcodeFormat($order->postcode);
        $postcode = explode(' ', $formatedPostcode);
        $initial_code = strtoupper($postcode[0]);
        $deliveryPlan = $this->Orders_Model->get_single_array('gkpos_deliveryplan', array('status' => 1, 'initial_code' => $initial_code), array('id', 'is_free', 'delivery_charge', 'min_order', 'delivery_time'));
        if (!empty($deliveryPlan)) {
            if ((int) $deliveryPlan['delivery_charge'] > 0) {
                $this->Orders_Model->set_deliveryplan($order_id, $deliveryPlan);
            } else {
                $deliveryDistance = get_delivery_distance(postcodeFormat($this->config->item('deliveryplan_source_postcode')), $formatedPostcode);
                if ($deliveryDistance > $this->config->item('deliveryplan_offset')) {
                    $deliveryPlan['is_free'] = 2;
                    $paidDistance = $deliveryDistance - (double) $this->config->item('deliveryplan_offset');
                    $deliveryPlan['delivery_charge'] = $paidDistance * (double) $this->config->item('deliveryplan_rate');
                } else {
                    $deliveryPlan['is_free'] = 1;
                    $deliveryPlan['delivery_charge'] = 0;
                }
                $this->Orders_Model->set_deliveryplan($order_id, $deliveryPlan);
            }
        } else {
            $this->Orders_Model->clear_deliveryplan($order_id);
        }
    }

    function get_deliveryplan($order_id) {
        if ($this->session->userdata('cart_' . $order_id . '_deliveryplan')) {
            return $this->session->userdata('cart_' . $order_id . '_deliveryplan');
        }
    }

    function set_deliveryplan($order_id, $data) {
        $this->session->set_userdata('cart_' . $order_id . '_deliveryplan', $data);
    }

    public function clear_deliveryplan($order_id) {
        $this->session->unset_userdata('cart_' . $order_id . '_deliveryplan');
    }

    function set_deliveryplan_amount($order_id, $data) {
        $this->session->set_userdata('cart_' . $order_id . '_delivery_charge', $data);
    }

    function get_deliveryplan_amount($order_id) {
        if ($this->session->userdata('cart_' . $order_id . '_delivery_charge')) {
            return $this->session->userdata('cart_' . $order_id . '_delivery_charge');
        }
    }

    function clear_deliveryplan_amount($order_id) {
        $this->session->unset_userdata('cart_' . $order_id . '_delivery_charge');
    }

    function set_subtotal($order_id, $total) {
        $this->session->set_userdata('cart_' . $order_id . '_subtotal', $total);
    }

    function get_subtotal($order_id) {
        if ($this->session->userdata('cart_' . $order_id . '_subtotal')) {
            return $this->session->userdata('cart_' . $order_id . '_subtotal');
        }
    }

    function clear_subtotal($order_id) {
        $this->session->unset_userdata('cart_' . $order_id . '_subtotal');
    }

    function set_total($order_id, $total) {
        $this->session->set_userdata('cart_' . $order_id . '_total', $total);
    }

    function get_total($order_id) {
        if ($this->session->userdata('cart_' . $order_id . '_total')) {
            return $this->session->userdata('cart_' . $order_id . '_total');
        }
    }

    function clear_total($order_id) {
        $this->session->unset_userdata('cart_' . $order_id . '_total');
    }

    public function addtocart($data) {
        $category = $data['category'];
        $menu = $data['menu'];
        $sel = $data['selection'];
        $maxLine = 0;
        $updatekey = 0;
        $dbcart_items = $this->get_cart_db($data['order_id']);
        $currentCartItems = $this->get_cart($data['order_id']);
        $set_items = $data['set_items'] != null ? substr($data['set_items'], 1) : '';
        $toppings = $data['toppings'] != null ? substr($data['toppings'], 1) : '';
        //setting up max line 
        if (empty($currentCartItems)) {
            if (empty($dbcart_items)) {
                $maxLine = $maxLine;
            } else {
                foreach ($dbcart_items as $line => $item) {
                    if ($maxLine <= $item['line']) {
                        $maxLine = $item['line'];
                    }
                }
            }
        } else {
            foreach ($currentCartItems as $line => $item) {
                if ($maxLine <= $item['line']) {
                    $maxLine = $item['line'];
                }
            }
        }
        //Find if item exists in current item cart 
        $existInCuurentCart = false;
        if (!empty($currentCartItems)) {
            foreach ($currentCartItems as $line => $item) {
                if ($item['is_special'] == 'yes') {
                    if ((int) $menu > 0 && $menu == $item['menu'] && $category == $item['category'] && strtolower($set_items) == strtolower($item['set_items']) && strtolower($toppings) == strtolower($item['toppings'])) {
                        $existInCuurentCart = true;
                        $updatekey = $item['line'];
                    }
                } else {
                    if ((int) $sel <= 0) {
                        if ((int) $menu > 0 && $menu == $item['menu'] && $category == $item['category'] && strtolower($toppings) == strtolower($item['toppings'])) {
                            $existInCuurentCart = true;
                            $updatekey = $item['line'];
                        }
                    } else {
                        if ((int) $sel > 0 && $sel == $item['selection'] && $menu = $item['menu'] && $category == $item['category'] && strtolower($toppings) == strtolower($item['toppings'])) {
                            $existInCuurentCart = true;
                            $updatekey = $item['line'];
                        }
                    }
                }
            }
        }
        $existInDbCart = false;
        if ($existInCuurentCart == false) {
            if (!empty($dbcart_items)) {
                foreach ($dbcart_items as $line => $item) {
                    if ($maxLine <= $item['line']) {
                        $maxLine = $item['line'];
                    }
                    if ($item['is_special'] == 'yes') {
                        if ((int) $menu > 0 && $menu == $item['menu'] && $category == $item['category'] && strtolower($set_items) == strtolower($item['set_items']) && strtolower($toppings) == strtolower($item['toppings'])) {
                            $existInDbCart = true;
                            $updatekey = $item['line'];
                        }
                    } else {
                        if ((int) $sel <= 0) {
                            if ((int) $menu > 0 && $menu == $item['menu'] && $category == $item['category'] && strtolower($toppings) == strtolower($item['toppings'])) {
                                $existInDbCart = true;
                                $updatekey = $item['line'];
                            }
                        } else {
                            if ((int) $sel > 0 && $sel == $item['selection'] && $menu = $item['menu'] && $category == $item['category'] && strtolower($toppings) == strtolower($item['toppings'])) {
                                $existInDbCart = true;
                                $updatekey = $item['line'];
                            }
                        }
                    }
                }
            }
        }
        //if item not found inside both of the places then insert as new in the current cart 
        $bogoLine = null;
        if (false == $existInDbCart && false == $existInCuurentCart) {
            $newItemLine = $maxLine + 1;
            $bogoLine = $newItemLine;
            $item = $this->add_item($newItemLine, $data);
            $currentCartItems[$newItemLine] = $item;
            $this->set_cart($data['order_id'], $currentCartItems);
            $this->set_cart_new($data['order_id'], 'yes');
            if ((int) trim($data['bogo']) == (int) 1) {
                $this->manage_bogo($bogoLine, 'plus');
            }
            return array('success' => true, 'order_id' => $data['order_id'], 'line' => $newItemLine, 'item' => $item);
        } else {
            if (true == $existInCuurentCart) {
                $currentCartItems[$updatekey]['quantity'] = $currentCartItems[$updatekey]['quantity'] + $data['quantity'];
                $bogoLine = $updatekey;
                $this->set_cart($data['order_id'], $currentCartItems);
                $this->set_cart_new($data['order_id'], 'yes');
                if ((int) trim($data['bogo']) == (int) 1) {
                    $this->manage_bogo($bogoLine, 'plus');
                }
                return array('success' => true, 'order_id' => $data['order_id'], 'line' => $updatekey);
            }
            if (true == $existInDbCart) {
                $dbcart_items[$updatekey]['quantity'] = $dbcart_items[$updatekey]['quantity'] + $data['quantity'];
                $bogoLine = $updatekey;
                $this->set_cart_db($data['order_id'], $dbcart_items);
                $this->set_cart_new($data['order_id'], 'yes');
                if ((int) trim($data['bogo']) == (int) 1) {
                    $this->manage_bogo($bogoLine, 'plus');
                }
                return array('success' => true, 'order_id' => $data['order_id'], 'line' => $updatekey);
            }
        }
    }

    function add_item($newItemLine, $data) {
        if (!empty($data)) {
            $item = array(
                'line' => $newItemLine,
                'order_id' => $data['order_id'],
                'category' => $data['category'],
                'category_title' => $data['category_title'],
                'category_print_option' => $data['print_option'],
                'category_type' => $data['type'],
                'is_special' => $data['is_special'],
                'deal' => $data['deal'],
                'menu' => $data['menu'],
                'menu_title' => $data['menu_title'],
                'selection' => $data['selection'],
                'selection_title' => $data['selection_title'],
                'set_items' => $data['set_items'] != null ? substr($data['set_items'], 1) : '',
                'toppings' => $data['toppings'] != null ? substr($data['toppings'], 1) : '',
                'quantity' => $data['quantity'],
                'price' => $data['price'],
                'bogo' => $data['bogo'],
                'bogo_discount_on' => $data['bogo_discount_on']
            );
            return $item;
        } else {
            return array();
        }
    }

    private function manage_bogo($line, $action) {
        $order_id = $this->get_current_orderid();
        $items = $this->get_cart($order_id) ? $this->get_cart($order_id) : array();
        $item = !empty($items) && isset($items[$line]) ? $items[$line] : null;
        $dbItems = $this->get_cart_db($order_id) ? $this->get_cart_db($order_id) : array();
        $dbItem = !empty($dbItems) && isset($dbItems[$line]) ? $dbItems[$line] : null;
        $itemGranted = $item ? $item : $dbItem;
        $bogo_data = array(
            'bogo' => $itemGranted['bogo'],
            'category' => $itemGranted['category'],
            'menu' => $itemGranted ['menu'],
            'deal' => $itemGranted['deal'],
            'selection' => $itemGranted['selection'],
            'bogo_discount_on' => $itemGranted['bogo_discount_on'],
        );
        $lines = array();
        if (!empty($items)) {
            foreach ($items as $key => $item) {
                $array_to_compare['bogo'] = $item['bogo'];
                $array_to_compare['category'] = $item['category'];
                $array_to_compare['menu'] = $item['menu'];
                $array_to_compare['deal'] = $item['deal'];
                $array_to_compare['selection'] = $item['selection'];
                $array_to_compare['bogo_discount_on'] = $item['bogo_discount_on'];
                if (!array_diff_assoc($bogo_data, $array_to_compare)) {
                    $lines[] = $key;
                }
            }
        }
        if (!empty($dbItems)) {
            foreach ($dbItems as $key => $item) {
                $array_to_compare['bogo'] = $item['bogo'];
                $array_to_compare['category'] = $item['category'];
                $array_to_compare['menu'] = $item['menu'];
                $array_to_compare['deal'] = $item['deal'];
                $array_to_compare['selection'] = $item['selection'];
                $array_to_compare['bogo_discount_on'] = $item['bogo_discount_on'];
                if (!array_diff_assoc($bogo_data, $array_to_compare)) {
                    $lines[] = $key;
                }
            }
        }
        $quantity = 0;
        if (!empty($lines)) {
            foreach ($lines as $line) {
                $item = isset($items[$line]) ? $items[$line] : $dbItems[$line];
                $quantity += $item['quantity'];
            }
        }

        $unit_price = 0;
        $currentOrderType = $this->get_current_ordertype();
        if ($bogo_data['bogo_discount_on'] == 'selection') {
            $result = $this->db->where('id', $bogo_data[$bogo_data['bogo_discount_on']])->get('gkpos_selection')->row();
            $price = to_currency_no_money(0);
            if ($currentOrderType == 'table') {
                $price = $result->in_price > 0 ? to_currency_no_money($result->in_price) : to_currency_no_money($result->base_price);
            } else {
                $price = $result->out_price > 0 ? to_currency_no_money($result->out_price) : to_currency_no_money($result->base_price);
            }
            $unit_price = $price;
        }
        if ($bogo_data['bogo_discount_on'] == 'deal') {
            $result = $this->db->where('id', $bogo_data[$bogo_data['bogo_discount_on']])->get('meal_deal')->row();
            $unit_price = $result->price;
        }
        if ($bogo_data['bogo_discount_on'] == 'menu') {
            $result = $this->db->where('id', $bogo_data[$bogo_data['bogo_discount_on']])->get('gkpos_menu')->row();
            $price = to_currency_no_money(0);
            if ($currentOrderType == 'table') {
                $price = $result->in_price > 0 ? to_currency_no_money($result->in_price) : to_currency_no_money($result->base_price);
            } else {
                $price = $result->out_price > 0 ? to_currency_no_money($result->out_price) : to_currency_no_money($result->base_price);
            }
            $unit_price = $price;
        }

        $bogo_discount = $this->get_bogo_discount($order_id) ? $this->get_bogo_discount($order_id) : array();

        $bogokey = $bogo_data['bogo_discount_on'] . '_' . $bogo_data[$bogo_data['bogo_discount_on']];

        if ($action == 'plus') {
            if ($quantity >= 2) {
                $divideByTwo = $quantity / 2;
                $multiDiscount = (int) $divideByTwo * $unit_price;
                $bogo_discount[$bogokey] = $multiDiscount;
            }
        }
        if ($action == 'minus') {
            if ($quantity == 2 || $quantity == 1) {
                unset($bogo_discount[$bogokey]);
                $this->db->delete('bogo_discount', array('order_id' => $order_id, 'item' => $bogokey));
            } else {
                $quantity -= 1;
                $divideByTwo = $quantity / 2;
                $multiDiscount = (int) $divideByTwo * $unit_price;
                $bogo_discount[$bogokey] = $multiDiscount;
            }
        }
        if ($action == 'remove') {
            $lineQuantity = $itemGranted['quantity'];
            $quantity -= $lineQuantity;
            if ($quantity < 2 || count($lines) <= 1) {
                unset($bogo_discount[$bogokey]);
                $this->db->delete('bogo_discount', array('order_id' => $order_id, 'item' => $bogokey));
            } else {
                $divideByTwo = $quantity / 2;
                $multiDiscount = (int) $divideByTwo * $unit_price;
                $bogo_discount[$bogokey] = $multiDiscount;
            }
        }
        $this->set_bogo_discount($order_id, $bogo_discount);
    }

    // Multiple Payments
    function initiate_payments($order_id) {
        $payments = $this->get_list_array('gkpos_order_payment', array('order_id' => $order_id));
        $payments_data = null;
        if (!empty($payments)) {
            foreach ($payments as $payment) {
                $payments_data[$payment['method']] = $payment;
            }
            $this->set_payments($order_id, $payments_data);
        }
    }

    function get_payments($order_id) {
        if ($this->session->userdata('payments_' . $order_id))
            return $this->session->userdata('payments_' . $order_id);
    }

    function set_payments($order_id, $payments_data) {
        $this->session->set_userdata('payments_' . $order_id, $payments_data);
    }

    // Multiple Payments
    function empty_payments($order_id) {
        if ($this->session->userdata('payments_' . $order_id)) {
            $this->session->unset_userdata('payments_' . $order_id);
        }
    }

    // Multiple Payments
    function delete_payment($order_id, $payment_id) {
        $payments = $this->get_payments($order_id);
        unset($payments[urldecode($payment_id)]);
        $this->set_payments($order_id, $payments);
        return true;
    }

    // Multiple Payments
    function get_payments_total($order_id) {
        $subtotal = 0;
        $payemts_arr = $this->get_payments($order_id);
        if (!empty($payemts_arr)) {
            foreach ($this->get_payments($order_id) as $payments) {
                $subtotal = bcadd($payments['amount'], $subtotal, PRECISION);
            }
        }
        return to_currency_no_money($subtotal);
    }

    // Multiple Payments
    function get_amount_due($order_id) {
        $payment_total = to_currency_no_money($this->get_payments_total($order_id));
        $sales_total = to_currency_no_money($this->get_total($order_id));
        return to_currency_no_money(bcsub($sales_total, $payment_total, PRECISION));
    }

    public function set_voidorder_status($order_id, $data) {
        $this->session->set_userdata('cahnge_db_cart_' . $order_id, $data);
    }

    public function get_voidorder_status($order_id) {
        if ($this->session->userdata('cahnge_db_cart_' . $order_id))
            return $this->session->userdata('cahnge_db_cart_' . $order_id);
    }

    public function clear_voidorder_status($order_id) {
        if ($this->session->userdata('cahnge_db_cart_' . $order_id)) {
            $this->session->unset_userdata('cahnge_db_cart_' . $order_id);
        }
    }

    public function set_cc_fee($order_id, $data) {
        $this->session->set_userdata('ccFee_' . $order_id, $data);
    }

    public function get_cc_fee($order_id) {
        if ($this->session->userdata('ccFee_' . $order_id))
            return $this->session->userdata('ccFee_' . $order_id);
    }

    public function clear_cc_fee($order_id) {
        $this->session->unset_userdata('ccFee_' . $order_id);
    }

    public function initiate_cc_fee($order_id) {
        $cc_feeObj = $this->db->where('id', $order_id)->get('gkpos_order')->row();
        $cc_fee = 0;
        if (!empty($cc_feeObj)) {
            $cc_fee = $cc_feeObj->cc_fee;
        }
        if ($cc_fee > 0) {
            $this->set_cc_fee($order_id, $cc_fee);
        } else {
            $this->clear_cc_fee($order_id);
        }
    }

    public function set_foodtotal($order_id, $data) {
        $this->session->set_userdata('foodtotal_' . $order_id, $data);
    }

    public function get_foodtotal($order_id) {
        if ($this->session->userdata('foodtotal_' . $order_id)) {
            return $this->session->userdata('foodtotal_' . $order_id);
        }
    }

    public function clear_foodtotal($order_id) {
        $this->session->unset_userdata('foodtotal_' . $order_id);
    }

    public function set_nonfoodtotal($order_id, $data) {
        $this->session->set_userdata('nonfoodtotal_' . $order_id, $data);
    }

    public function get_nonfoodtotal($order_id) {
        if ($this->session->userdata('nonfoodtotal_' . $order_id)) {
            return $this->session->userdata('nonfoodtotal_' . $order_id);
        }
    }

    public function clear_nonfoodtotal($order_id) {
        $this->session->unset_userdata('nonfoodtotal_' . $order_id);
    }

    function clear_all($order_id) {
        $this->empty_cart($order_id);
        $this->empty_cart_db($order_id);
        $this->clear_cart_new($order_id);
        $this->clear_discount($order_id);
        $this->clear_discount_amount($order_id);
        $this->clear_servicecharge($order_id);
        $this->clear_servicecharge_amount($order_id);
        $this->clear_vat($order_id);
        $this->clear_vat_amount($order_id);
        $this->clear_subtotal($order_id);
        $this->clear_total($order_id);
        $this->clear_deliveryplan($order_id);
        $this->clear_deliveryplan_amount($order_id);
        $this->clear_updated_cart($order_id);
        $this->clear_voidorder_status($order_id);
        $this->clear_min_order_discounted_amount($order_id);
        $this->clear_order_total($order_id);
        $this->clear_discount_on($order_id);
        $this->clear_cc_fee($order_id);
        $this->clear_current_ordertype();
        $this->clear_current_orderid();
        $this->clear_discount_amount($order_id);
        $this->clear_foodtotal($order_id);
        $this->clear_nonfoodtotal($order_id);
    }

    public function clear_while_conversion($order_id) {
        if ($order_id) {
            $this->db->delete('gkpos_order_discount', array('order_id' => $order_id));
            $this->db->delete('gkpos_order_vat', array('order_id' => $order_id));
            $this->db->delete('gkpos_order_servicecharge', array('order_id' => $order_id));
            $this->db->update('gkpos_order', array('cc_fee' => to_currency_no_money(0), 'delivery_charge' => 0), array('id' => $order_id));
        }
        $this->clear_updated_cart($order_id);
        $this->clear_cart_new($order_id);
        $this->clear_discount($order_id);
        $this->clear_discount_amount($order_id);
        $this->clear_servicecharge($order_id);
        $this->clear_servicecharge_amount($order_id);
        $this->clear_vat($order_id);
        $this->clear_vat_amount($order_id);
        $this->clear_subtotal($order_id);
        $this->clear_total($order_id);
        $this->clear_deliveryplan($order_id);
        $this->clear_deliveryplan_amount($order_id);
        $this->clear_voidorder_status($order_id);
        $this->clear_min_order_discounted_amount($order_id);
        $this->clear_order_total($order_id);
        $this->clear_discount_on($order_id);
        $this->clear_cc_fee($order_id);
        $this->clear_current_ordertype();
        $this->clear_current_orderid();
        $this->clear_discount_amount($order_id);
        $this->clear_foodtotal($order_id);
        $this->clear_nonfoodtotal($order_id);
    }

    function clear_chossen_delivery($order_id) {
        $this->clear_deliveryplan($order_id);
        $this->clear_deliveryplan_amount($order_id);
    }

    public function save_cart($data, $id = null) {
        $this->_table_name = 'gkpos_order_detail';
        $this->_primary_key = 'id';
        return $this->save($data, $id);
    }

    public function save_discount($discount_data, $order_id = null) {
        $this->_table_name = 'gkpos_order_discount';
        $this->_primary_key = 'order_id';
        return $this->save($discount_data, $order_id);
    }

    public function save_vat($vat_data, $order_id = null) {
        $this->_table_name = 'gkpos_order_vat';
        $this->_primary_key = 'order_id';
        return $this->save($vat_data, $order_id);
    }

    public function save_servicecharge($servicecharge_data, $order_id = null) {
        $this->_table_name = 'gkpos_order_servicecharge';
        $this->_primary_key = 'order_id';
        return $this->save($servicecharge_data, $order_id);
    }

    public function update_order($order_data, $order_id = null) {
        $this->_table_name = 'gkpos_order';
        $this->_primary_key = 'order_id';
        return $this->save($order_data, $order_id);
    }

}
