<?php

class Report_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_todays_orders() {
        return $this->get_list('gkpos_order', array('created >=' => date('Y-m-d', strtotime('today')), 'paid_status' => 1), '*', 10, 0, 'created', 'DESC');
    }

    public function get_order_payments($order_id) {
        return $this->get_list('gkpos_order_payment', array('order_id' => $order_id));
    }

    public function get_order_paymentscool($order_id) {
        $payments = $this->get_list('gkpos_order_payment', array('order_id' => $order_id));
        $payments_cool = array();
        foreach ($payments as $key => $obj) {
            $payments_cool[$obj->method] = array(
                'method' => $obj->method,
                'amount' => $obj->amount,
                'order_id' => $obj->order_id
            );
        }
        return $payments_cool;
    }

    function count_report_rows($table, $filters) {
        if (isset($filters['start_date']) && isset($filters['end_date'])) {
            if (isset($filters['is_by_closing']) && $filters['is_by_closing'] == 'yes') {
                $this->db->where('closing_date BETWEEN ' . $this->db->escape($filters['start_date']) . ' AND ' . $this->db->escape($filters['end_date']));
            } else {
                $this->db->where('created BETWEEN ' . $this->db->escape($filters['start_date']) . ' AND ' . $this->db->escape($filters['end_date']));
            }
        }
        if (isset($filters['order_type']) && $filters['order_type'] != null) {
            $this->db->where('order_type', $filters['order_type']);
        }

        if (isset($filters['order_type']) && ($filters['order_type'] != null || $filters['order_type'] != 'online') && (isset($filters['method']) && $filters['method'] != null)) {
            $this->db->where('order_type', $filters['method']);
        }
        $this->db->where('paid_status', 1);
        $this->db->group_by('id');
        $this->db->order_by('created', 'DESC');
        $this->db->from($table);
        return $this->db->count_all_results();
    }

    public function search($filters = array(), $offset = 0, $limit = 0) {
        $this->db->select('gpo.*,gpod.amount as discount,gpov.amount as vat,gpos.amount as service_charge');
        $this->db->from('gkpos_order gpo');
        $this->db->join('gkpos_order_payment AS gpop', 'gpo.id = gpop.order_id', 'left');
        $this->db->join('gkpos_order_discount AS gpod', 'gpo.id = gpod.order_id', 'left');
        $this->db->join('gkpos_order_vat AS gpov', 'gpo.id = gpov.order_id', 'left');
        $this->db->join('gkpos_order_servicecharge AS gpos', 'gpo.id = gpos.order_id', 'left');

        if (isset($filters['start_date']) && isset($filters['end_date'])) {
            if ($filters['is_by_closing'] == 'yes') {
                $this->db->where('closing_date BETWEEN ' . $this->db->escape($filters['start_date']) . ' AND ' . $this->db->escape($filters['end_date']));
            } else {
                $this->db->where('created BETWEEN ' . $this->db->escape($filters['start_date']) . ' AND ' . $this->db->escape($filters['end_date']));
            }
        }
        if (isset($filters['order_type']) && $filters['order_type'] != null) {
            $this->db->where('order_type', $filters['order_type']);
        }

        if (isset($filters['order_type']) && ($filters['order_type'] != null || $filters['order_type'] != 'online') && (isset($filters['method']) && $filters['method'] != null)) {
            $this->db->where('gpop.method', $filters['method']);
        }
        $this->db->where('paid_status', 1);
        $this->db->group_by('gpo.id');
        $this->db->order_by('gpo.created', 'DESC');
        if ($limit) {
            $this->db->limit($limit, $offset);
        }
        return $this->db->get();
    }

    public function count_report_rows_online($table, $filters) {
        if (isset($filters['start_date']) && isset($filters['end_date'])) {
            $this->db->where('created BETWEEN ' . $this->db->escape($filters['start_date']) . ' AND ' . $this->db->escape($filters['end_date']));
        }
        if (isset($filters['order_type']) && $filters['order_type'] != null) {
            $this->db->where('online_type', $filters['order_type']);
        }
        if (isset($filters['name']) && $filters['name'] != null) {
            $this->db->like('name', $filters['name']);
        }
        if (isset($filters['phone']) && $filters['phone'] != null) {
            $this->db->like('phone', $filters['phone']);
        }
        if (isset($filters['id']) && $filters['id'] != null) {
            $this->db->like('id', strtolower($filters['id']));
        }
        $this->db->where('order_type', 'online');
        $this->db->group_by('id');
        $this->db->order_by('created', 'DESC');

        $this->db->from($table);
        return $this->db->count_all_results();
    }

    public function search_online($filters = array(), $rows = 0, $limit = 0) {
        if (isset($filters['start_date']) && isset($filters['end_date'])) {
            $this->db->where('created BETWEEN ' . $this->db->escape($filters['start_date']) . ' AND ' . $this->db->escape($filters['end_date']));
        }
        if (isset($filters['order_type']) && $filters['order_type'] != null) {
            $this->db->where('online_type', $filters['order_type']);
        }
        if (isset($filters['name']) && $filters['name'] != null) {
            $this->db->like('name', $filters['name']);
        }
        if (isset($filters['phone']) && $filters['phone'] != null) {
            $this->db->like('phone', $filters['phone']);
        }
        if (isset($filters['id']) && $filters['id'] != null) {
            $this->db->like('id', strtolower($filters['id']));
        }
        $this->db->where('order_type', 'online');
        $this->db->group_by('id');
        $this->db->order_by('created', 'DESC');
        if ($limit > 0) {
            $this->db->limit($limit, $rows);
        }
        return $this->db->get('gkpos_order');
    }

    public function customers($filters = array(), $rows = 0, $limit = 0) {
        if (isset($filters['name']) && $filters['name'] != null) {
            $this->db->like('name', $filters['name']);
        }
        if (isset($filters['phone']) && $filters['phone'] != null) {
            $this->db->like('phone', $filters['phone']);
        }
        if (isset($filters['email']) && $filters['email'] != null) {
            $this->db->like('email', strtolower($filters['email']));
        }

        if (isset($filters['postcode']) && $filters['postcode'] != null) {
            $this->db->or_like('postcode', postcodeFormat($filters['postcode']));
        }
        if (isset($filters['city']) && $filters['city'] != null) {
            $this->db->or_like('city', $filters['city']);
        }
        $this->db->group_by('phone');
        $this->db->order_by('name', 'DESC');
        if ($rows > 0) {
            $this->db->limit($rows, $limit);
        }
        return $this->db->get('gkpos_customer');
    }

    function get_expense($filters = array()) {
        $this->db->select_sum('total', 'total');
        $this->db->where('created BETWEEN ' . $this->db->escape($filters['start_date']) . ' AND ' . $this->db->escape($filters['end_date']));
        $this->db->where('cash_from_till', 'yes');
        return $this->db->get('gkpos_expense')->row()->total;
    }

    public function get_total_report_rows($table, $filters) {
        $this->db->where('created BETWEEN ' . $this->db->escape($filters['start_date']) . ' AND ' . $this->db->escape($filters['end_date']));
        $this->db->where('paid_status', 1);
        $this->db->from($table);
        return $this->db->count_all_results();
    }

    public function get_total_customer_rows($table) {
        $this->db->from($table);
        return $this->db->count_all_results();
    }

    public function get_total_onlinereport_rows($table, $filters) {
        $this->db->where('created BETWEEN ' . $this->db->escape($filters['start_date']) . ' AND ' . $this->db->escape($filters['end_date']));
        $this->db->where('order_type', 'online');
        if (isset($filters['order_type']) && $filters['order_type'] != null) {
            $this->db->where('online_type', $filters['order_type']);
        }
        $this->db->from($table);
        return $this->db->count_all_results();
    }

    public function set_nextbtn_counter($value) {
        $this->session->set_userdata('nextbtn', $value);
    }

    public function set_prevbtn_counter($value) {
        $this->session->set_userdata('prevbtn', $value);
    }

    public function get_nextbtn_counter() {
        if ($this->session->userdata('nextbtn')) {
            return $this->session->userdata('nextbtn');
        } else {
            return 0;
        }
    }

    public function get_prevbtn_counter() {
        if ($this->session->userdata('prevbtn')) {
            return $this->session->userdata('prevbtn');
        } else {
            return 0;
        }
    }

    public function clear_nextbtn_counter() {
        if ($this->session->userdata('nextbtn')) {
            $this->session->unset_userdata('nextbtn');
        }
    }

    public function clear_prevbtn_counter() {
        if ($this->session->userdata('prevbtn')) {
            $this->session->unset_userdata('prevbtn');
        }
    }

    public function empty_btn_counter() {
        $this->clear_nextbtn_counter();
        $this->clear_prevbtn_counter();
    }

    function delete_order($order_id) {
        $this->db->trans_start();
        //delete from vat
        $this->db->delete('gkpos_order_vat', array('order_id' => $order_id));
        //delete order discount
        $this->db->delete('gkpos_order_discount', array('order_id' => $order_id));
        //delete service charge 
        $this->db->delete('gkpos_order_servicecharge', array('order_id' => $order_id));
        //delete payments
        $this->db->delete('gkpos_order_payment', array('order_id' => $order_id));
        //delete order_detail 
        $this->db->delete('gkpos_order_detail', array('order_id' => $order_id));
        //delete order 
        $this->db->delete('gkpos_order', array('id' => $order_id));
        $this->db->delete('gkpos_billcopy', array('order_id' => $order_id));
        $this->db->trans_complete();
        $activity = array(
            'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has deleted order-' . $order_id
        );
        $this->posactivity($activity);
        return $this->db->trans_status();
    }

}
