<?php

class Settings_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function save_promotion($data, $id = null) {
        $this->_table_name = 'gkpos_voucher';
        $this->_primary_key = 'id';
        return $this->save($data, $id);
    }

    public function save_deliveryplan($data, $id = null) {
        $this->_table_name = 'gkpos_deliveryplan';
        $this->_primary_key = 'id';
        return $this->save($data, $id);
    }

    public function get_giftcard_code() {
        $key = self::_generate_giftcard_code();
        if ($key) {
            return $key;
        }
    }

    private function _generate_giftcard_code($length = 10) {
        do {
            $newkey = substr(str_shuffle(str_repeat($x = '0123456789', ceil($length / strlen($x)))), 1, $length);
        } while (self::_code_exists($newkey));
        return $newkey;
    }

    private function _code_exists($key) {
        return $this->db->where('id', $key)->count_all_results('gkpos_giftcard') > 0;
    }

}
