<?php

class Userlogs_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function search($filters = array(), $rows = 0, $limit = 0) {
        if (isset($filters['start_date']) && isset($filters['end_date'])) {
            $this->db->where('access_time BETWEEN ' . $this->db->escape($filters['start_date']) . ' AND ' . $this->db->escape($filters['end_date']));
        }
        $this->db->group_by('id');
        $this->db->order_by('access_time', 'DESC');
        if ($rows > 0) {
            $this->db->limit($rows, $limit);
        }
        return $this->db->get('gkpos_log');
    }

    public function get_total_report_rows($table, $filters) {
        $this->db->where('access_time BETWEEN ' . $this->db->escape($filters['start_date']) . ' AND ' . $this->db->escape($filters['end_date']));
        $this->db->from($table);
        return $this->db->count_all_results();
    }

    public function set_nextbtn_counter($value) {
        $this->session->set_userdata('nextbtn', $value);
    }

    public function set_prevbtn_counter($value) {
        $this->session->set_userdata('prevbtn', $value);
    }

    public function get_nextbtn_counter() {
        if ($this->session->userdata('nextbtn')) {
            return $this->session->userdata('nextbtn');
        } else {
            return 0;
        }
    }

    public function get_prevbtn_counter() {
        if ($this->session->userdata('prevbtn')) {
            return $this->session->userdata('prevbtn');
        } else {
            return 0;
        }
    }

    public function clear_nextbtn_counter() {
        if ($this->session->userdata('nextbtn')) {
            $this->session->unset_userdata('nextbtn');
        }
    }

    public function clear_prevbtn_counter() {
        if ($this->session->userdata('prevbtn')) {
            $this->session->unset_userdata('prevbtn');
        }
    }

    public function empty_btn_counter() {
        $this->clear_nextbtn_counter();
        $this->clear_prevbtn_counter();
    }
}
