<?php

class Voidorders_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function search($filters = array(), $rows = 0, $limit = 0) {
        if (isset($filters['start_date']) && isset($filters['end_date'])) {
            $this->db->where('created BETWEEN ' . $this->db->escape($filters['start_date']) . ' AND ' . $this->db->escape($filters['end_date']));
        }
        if ($this->session->userdata('gkpos_usertype') == 1 || $this->session->userdata('gkpos_usertype') == 2) {
            $this->db->where('status<=', 3);
        } else {
            $this->db->where('status', 1);
        }
        $this->db->where('order_type <>', 'online');
        $this->db->group_by('id');
        $this->db->order_by('created', 'DESC');
        if ($limit > 0) {
            $this->db->limit($limit,$rows);
        }
        return $this->db->get('gkpos_order');
    }

    public function get_total_report_rows($table, $filters) {
        $this->db->where('created BETWEEN ' . $this->db->escape($filters['start_date']) . ' AND ' . $this->db->escape($filters['end_date']));
        if ($this->session->userdata('gkpos_usertype') == 1 || $this->session->userdata('gkpos_usertype') == 2) {
            $this->db->where('status<=', 3);
        } else {
            $this->db->where('status', 1);
        }
        $this->db->where('order_type <>', 'online');
        $this->db->from($table);
        return $this->db->count_all_results();
    }

    function delete_order($order_id) {
        $order = $this->get_single('gkpos_order', array('id' => $order_id));
        if (!empty($order)) {
            $this->db->trans_start();
            $this->db->delete('gkpos_order_vat', array('order_id' => $order_id));
            //delete order discount
            $this->db->delete('gkpos_order_discount', array('order_id' => $order_id));
            //delete service charge 
            $this->db->delete('gkpos_order_servicecharge', array('order_id' => $order_id));
            //delete payments
            $this->db->delete('gkpos_order_payment', array('order_id' => $order_id));
            //delete order_detail 
            $this->db->delete('gkpos_order_detail', array('order_id' => $order_id));
            if ($order->order_type == 'table') {
                $this->db->update('gkpos_table', array('is_vacant' => 1), array('table_number' => $order->table_number));
            }
            $this->db->delete('gkpos_billcopy', array('order_id' => $order_id));
            $this->db->delete('gkpos_order', array('id' => $order_id));
            $this->db->trans_complete();
            $activity = array(
                'activity' => ucfirst($this->session->userdata('gkpos_username')) . ' has deleted order-' . $order_id
            );
            $this->posactivity($activity);
            return $this->db->trans_status();
        }
        return false;
    }

}
