<div class="col-lg-10 col-md-10 col-sm-10 col-xs-10 bodyitem">
    <div class="modal-content">
        <div class="modal-header">
            <div class="modal-title">
                <div class="col-lg-12 col-md-12 col-sm-12 text-center no-padding">Add New Booking</div>
            </div>
        </div>
        <form class="form-horizontal" action="<?php echo site_url('gkpos/booking/save') ?>" method="post" id="newBookingForm">
            <table class="table table-bordered">
                <tr>
                    <td colspan="5"><span class="text-uppercase">Booking Information</span></td>
                </tr>
                <tr>
                    <td class="text-left" colspan="1">First Name: <input data-error="#firstNameError" type="text" class="form-control" name="first_name" value="" autocomplete="off"><div id="firstNameError"></div></td>
                    <td class="text-left" colspan="1">Last Name: <input data-error="#lastNameError" type="text" class="form-control" name="last_name" value="" autocomplete="off"><div id="lastNameError"></div></td>
                    <td class="text-left" colspan="1">Email: <input data-error="#resEmailError" type="text" class="form-control" name="res_email" value="" autocomplete="off"><div id="resEmailError"></div></td>
                    <td class="text-left" colspan="1">Phone: <input data-error="#resPhoneError"  type="text" class="form-control" name="res_phone" autocomplete="off"><div id="resPhoneError"></div></td>
                </tr>
                <tr>
                    <td class="text-left" colspan="1">Number Of Guests : <input data-error="#resGuestNumberError" type="text" class="form-control" name="guest_number"><div id="resGuestNumberError"></div></td>
                    <td class="text-left" colspan="1">Booking Date : <input data-error="#resDateError" type="text" name="res_date" class="form-control date_filter"><div id="resDateError"></div></td>
                    <td class="text-left" colspan="1">Time: 
                        <select class="required form-control" data-error="#resTimeFromError"  name="time_from" id="bookingTimeFrom">
                            <?php if ($time_slot): ?>
                                <?php foreach ($time_slot as $aslot): ?>
                                    <option value='<?php echo $aslot ?>'><?php echo $aslot ?></option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                        <div id="resTimeFromError"></div>
                    </td>
                    <td class="text-left" colspan="2">Message : <textarea data-error="#resMessageError" name="res_message" style="width: 100%; height: 70px;"></textarea><div id="resMessageError"></div></td>
                </tr>
                <tr><td colspan="5"> <input class="form-submit-button mainsystembg2 waiting-bg img-responsive delivery-info-submit-btn" type="submit" name="submit_form" value="<?php echo $this->lang->line('gkpos_finished') ?>" onclick="saveBooking('newBookingForm')"></td></tr>
            </table>
        </form>
    </div>
</div>

<script>
    $(document).ready(function () {
        $(".date_filter").datepicker({
            dateFormat: "dd/mm/yy"
        });
    });
    function saveBooking(formId) {
        
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            getSettingPage('<?php echo site_url('gkpos/booking/index') ?>', 'Booking');
                        } else {
                            alert(response.message);
                        }
                        manageWindowHeight();
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('td').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('td').removeClass('has-error');
            },
            rules: {
                first_name: {
                    lettersonly: true,
                    required: true
                },
                last_name: {
                    lettersonly: true,
                    required: true
                },
                res_email: {
                    email: true,
                    required: true
                },
                res_phone: {
                    phone: true,
                    required: true
                },
                res_date: "required",
                guest_number: {
                    required: true,
                    number: true
                }
            },
            messages: {
                first_name: "First is required",
                last_name: "Last Name is required",
                res_phone: "Customer phone is required",
                res_date: "Reservation date is required",
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }

</script>
<style>
    .pac-container {
        z-index: 10000 !important;
    }
    .has-error{
        color: #FF0000;
    }
    #virtualKeyboard .button{
        width: 7.3% !important;
    }
    .ui-timepicker-wrapper {
        width: 15%;
    }
    .ui-timepicker-list li {
        background: #fff none repeat scroll 0 0;
        border: 1px solid #000;
        border-radius: 5px;
        color: #000;
        cursor: pointer;
        height: 50px;
        list-style: outside none none;
        margin: 5px;
        padding: 14px 0 3px 15px;
        white-space: nowrap;
    }
</style>
