<div class="col-lg-10 col-md-10 col-sm-10 col-xs-10 bodyitem no-padding">
    <fieldset style="margin-bottom: 0px; padding-bottom: 0px; border-radius: 10px 10px 0px 0px ">
        <div class="row">
            <form id="bookingFilterForm">
                <table class="table table-bg-color table-responsive no-padding">
                    <tr>
                        <th style="vertical-align: middle">Start Date</th>
                        <th style="vertical-align: middle">End Date</th>
                        <th><a href="javascript:void()" class="btn btn-primary btn-sm gradient" style="width: 100%" type="button" onclick="getSettingPage('<?php echo site_url('gkpos/booking/add') ?>', 'Add New Booking')">Add New Booking</a></th>
                    </tr>
                    <tr>
                        <td><?php echo form_input(array('name' => 'start_date', 'value' => date('d/m/Y', strtotime($start_date)), 'class' => 'date_filter form-control input-sm', 'id' => 'filterStartDate')); ?></td>
                        <td><?php echo form_input(array('name' => 'end_date', 'value' => date('d/m/Y', strtotime($end_date)), 'class' => 'date_filter form-control input-sm', 'id' => 'filterEndDate')); ?></td>
                        <td class="text-center"><a href="javascript:void(0)" class="btn btn-success btn-sm gradient" style="width: 100%" onclick="filterReport()">Filter Result</a></td>
                    </tr>
                </table>
            </form>
            <div id="filterContent">
                <?php echo $this->load->view('filter'); ?>
            </div>
        </div>
    </fieldset>
</div>
<div id="bookingAddForm"></div>

<script>
    $(document).ready(function () {
        $(".date_filter").datepicker({
            dateFormat: "dd/mm/yy"
        });
    });
    function openMessage(id) {
        //alert(id);
        $('#reservationMessage_' + id).toggle('slow');
    }
    function addBooking() {
        $.ajax({
            url: "<?php echo site_url('gkpos/booking/add') ?>",
            type: "POST",
            success: function (json) {
                $('#bookingAddForm').html(json);
                $('#CustomerForm').modal({
                    keyboard: false,
                    backdrop: 'static',
                    width: '700px',
                    show: true
                });
            }
        });
    }
    function filterReport() {
        var myform = document.getElementById('bookingFilterForm');
        var formdata = new FormData(myform);
        $.ajax({
            url: '<?php echo site_url('gkpos/booking/filter') ?>',
            data: formdata,
            cache: false,
            processData: false,
            contentType: false,
            type: 'POST',
            success: function (output) {
                $('#filterContent').html(output);
                manageWindowHeight();
            }
        });
    }
    function paginateReport(segment) {
        $.ajax({
            url: "<?php echo site_url('gkpos/booking/filter/') ?>" + segment,
            data: {
                start_date: $('#filterStartDate').val(),
                end_date: $('#filterEndDate').val(),

            },
            type: "POST",
            beforeSend: function () {
                $('#GkposAjaxPageLoader').show();
            },
            success: function (response) {
                $('#GkposAjaxPageLoader').hide();
                $("#filterContent").html(response)
                manageWindowHeight();
            }
        });
    }
    function updateBookingStatus(id, segment) {
        var status = $('#updateBookingStatus_' + id).val();
        updateBooking(id, status, segment);
    }
    function updateBooking(id, status, segment) {
        $.ajax({
            url: '<?php echo site_url("gkpos/booking/reaction") ?>',
            data: {
                id: id,
                status: status
            },
            type: "POST",
            dataType: "json",
            success: function (output) {
                if (output.success) {
                    ALERT_TITLE = "<?php echo $this->lang->line('gkpos_alert_title_success') ?>";
                    alert(output.message)
                    paginateReport(segment)
                } else {
                    ALERT_TITLE = "<?php echo $this->lang->line('gkpos_alert_title_error') ?>";
                    alert(output.message);
                }
            }
        });
    }
    function deleteReservation(id, segment) {
        $.confirm({
            'title': '<?php echo $this->lang->line("gkpos_alert_title_warning") ?>',
            'message': 'Are you sure to delete this reservation?',
            'buttons': {
                'Yes': {
                    'class': 'btn btn-success',
                    'action': function () {
                        $.ajax({
                            url: '<?php echo site_url('gkpos/booking/delete') ?>',
                            type: 'POST',
                            dataType: 'json',
                            data: {
                                id: id
                            },
                            success: function (response) {
                                if (response.success) {
                                    paginateReport(segment)
                                } else {
                                    ALERT_TITLE = "<?php echo $this->lang->line('gkpos_alert_title_error') ?>";
                                    alert(response.message);
                                }
                            }
                        });
                    }
                },
                'No': {
                    'class': 'btn btn-danger',
                    'action': function () {}
                }
            }
        });
    }

</script>

