<div class="modal-header" style="padding-top: 15px;">
    <div class="phone-call col-md-12">
        <span class="fa fa-phone"></span>
        <?php if (isset($isPhoneCall) && $isPhoneCall == 'yes'): ?>
            <span class="phone-yes"><?php echo $this->lang->line('gkpos_call') ?></span>
        <?php else: ?>
            <span class="phone-no"><?php echo $this->lang->line('gkpos_no_call') ?></span>
        <?php endif ?>
        <span><?php echo" ( " . $current_section . " )" ?></span>
    </div>
</div>
<div class="formpartbg">
    <fieldset>
        <div class="form-group">
            <label class="col-md-4 control-label text-right"><?php echo $this->lang->line('gkpos_search_address') ?></label>  
            <div class="col-md-8">
                <div class="input-group">
                    <span class="input-group-addon"><a href="#"><i class="fa fa-search" aria-hidden="true"></i></a></span>
                    <input id="autocompleteGPlace" placeholder="Enter your address" onFocus="geolocate()" type="text" class="form-control input-sm" style="width: 105%" autocomplete="off"/>
                </div>
            </div>
        </div>
        <form class="form-horizontal" action="<?php echo site_url('gkpos/orderinitiate') ?>" method="post" id="gkposDeliveryForm">
            <legend style="font-size: 15px;"><?php echo $this->lang->line('gkpos_customer') . " " . $this->lang->line('gkpos_information') ?></legend>
            <!-- Text input-->
            <div class="form-group">
                <label class="col-md-4 control-label" ><?php echo $this->lang->line('gkpos_phone') ?></label> 
                <div class="col-md-8">
                    <div class="input-group">
                        <span class="input-group-addon"><a href="#"><i class="fa fa-phone" aria-hidden="true"></i></a></span>
                        <?php $customerPhone = isset($customer->phone) ? $customer->phone : '' ?>
                        <input data-error="#phoneError" name="phone" placeholder="<?php echo $this->lang->line('gkpos_phone') ?>" class="form-control required input-sm customer-phone"  type="text" id="phone" value="<?php echo $customerPhone ?>">
                        <span class="input-group-addon" style="background-color: #FF0000;" data-toggle="tooltip-delivery-phone" data-placement="bottom"  title="<?php echo $this->lang->line('gkpos_click_to_get_customer_by_phone') ?>"><a href="javascript:void(0)" onclick="searchCustomerByKey('phone')"><i class="fa fa-search" aria-hidden="true"></i></a></span>
                    </div>
                    <div id="phoneError"></div>
                </div>

            </div>
            <div class="form-group">
                <label class="col-md-4 control-label"><?php echo $this->lang->line('gkpos_name') ?></label>  
                <div class="col-md-8">
                    <div class="input-group">
                        <span class="input-group-addon"><a href="#"><i class="fa fa-user" aria-hidden="true"></i></a></span>
                        <?php $customerName = isset($customer->name) ? $customer->name : '' ?>
                        <input data-error="#nameErrorr"  type="text" name="name" id="name" placeholder="<?php echo $this->lang->line('gkpos_name') ?>" class="form-control required input-sm customer-name" value="<?php echo $customerName ?>">
                    </div>
                    <div id="nameErrorr"></div>
                </div>
            </div>
            <!-- Text input-->
            <div class="form-group">
                <label class="col-md-4 control-label"><?php echo $this->lang->line('gkpos_house') ?></label>  
                <div class="col-md-8">
                    <div class="input-group form-inline">
                        <span class="input-group-addon"><a href="#"><i class="fa fa-home" aria-hidden="true"></i></a></span>
                        <input value="<?php isset($customer->house) ? print $customer->house : print'' ?>" name="house"  id="street_number" placeholder="<?php echo $this->lang->line('gkpos_house') . ' ', $this->lang->line('gkpos_number') ?>" class="form-control input-sm" type="text" style="width: 33.5%;">
                        <input value="<?php isset($customer->floor_or_apt) ? print $customer->floor_or_apt : print'' ?>"  name="floor_or_apt" placeholder="<?php echo $this->lang->line('gkpos_floor_or_apt_no') ?>" class="form-control input-sm" id="floor_or_apt"  type="text" style="width: 33.5%;" >
                        <input value="<?php isset($customer->building) ? print $customer->building : print'' ?>"  name="building" placeholder="<?php echo $this->lang->line('gkpos_building') ?>" class="form-control input-sm" type="text" id="building" style="width: 32%;">   
                    </div>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-4 control-label"><?php echo $this->lang->line('gkpos_street') . ' ', $this->lang->line('gkpos_name') ?></label>  
                <div class="col-md-8">
                    <div class="input-group">
                        <span class="input-group-addon"><a href="#"><i class="fa fa-adn" aria-hidden="true"></i></a></span>
                        <input data-error="#streetError" value="<?php isset($customer->street) ? print $customer->street : print'' ?>" name="street" placeholder="<?php echo $this->lang->line('gkpos_street') . ' ', $this->lang->line('gkpos_name') ?>" class="form-control required field input-sm" type="text" id="route">
                    </div>
                    <div id="streetError"></div>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-4 control-label"><?php echo $this->lang->line('gkpos_postal_code') ?></label>  
                <div class="col-md-8">
                    <div class="input-group">
                        <span class="input-group-addon"><a href="#"><i class="fa fa-street-view" aria-hidden="true"></i></a></span>
                        <input data-error="#postcodeError" value="<?php isset($customer->postcode) ? print $customer->postcode : print'' ?>" name="postcode" placeholder="<?php echo $this->lang->line('gkpos_postal_code') ?>" class="form-control text-uppercase required field input-sm" type="text" id="postal_code">
                    </div>
                    <div id="postcodeError"></div>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-4 control-label"><?php echo $this->lang->line('gkpos_address_line2') ?></label>  
                <div class="col-md-8 form-inline">
                    <div class="input-group">
                        <span class="input-group-addon"><a href="#"><i class="fa fa-home" aria-hidden="true"></i></a></span>
                        <input value="<?php isset($customer->city) ? print $customer->city : print'' ?>" name="city" placeholder="City" class="form-control input-sm field text-capitalize" type="text" id="locality" style="width: 33.5%">
                        <input value="<?php isset($customer->state) ? print $customer->state : print'' ?>" name="state" placeholder="State" class="form-control  input-sm field text-capitalize" type="text" id="administrative_area_level_1" style="width: 33.5%">
                        <input value="<?php isset($customer->country) ? print $customer->country : print'' ?>" name="country" placeholder="Country" class="form-control input-sm field text-capitalize" type="text" id="country" style="width: 33%">
                    </div>
                </div>
            </div>
            <div class="form-group">
                <label class="col-md-4 control-label"><?php echo $this->lang->line('gkpos_delivery_time') ?><span class="glyphicon glyphicon-plus"></span></label>  
                <div class="col-md-8">
                    <div class="input-group">
                        <span class="input-group-addon"><a href="#"><i class="fa fa-calendar" aria-hidden="true"></i></a></span>
                        <div class="stylish">
                            <span>
                                <input onclick="$(this).closest('div').find('select').slideToggle(110)" class="form-control customernambg" readonly="1" type="text" name="delivery_time" id="delivery_time"  placeholder="<?php echo $this->lang->line('gkpos_delivery_time') ?>" style="left: 0; width: 150px;"/><span style="font-weight: bold; font-size: 14px; padding-top: 10px;">Mins</span>
                                <br>
                                <select size=15 onclick="$(this).hide().closest('div').find('input').val($(this).find('option:selected').val());" class="customernambg" style="min-height:250px; margin: 0 auto; left:0px; margin-top: -20px">
                                    <option value="10" class="btn btn-default btn-lg btn-block text-lowercase">10-min</option>
                                    <option value="20" class="btn btn-default btn-lg btn-block text-lowercase">20-min</option>
                                    <option value="30" class="btn btn-default btn-lg btn-block text-lowercase">30-min</option>
                                    <option value="40" class="btn btn-default btn-lg btn-block text-lowercase">40-min</option>
                                    <option value="50" class="btn btn-default btn-lg btn-block text-lowercase">50-min</option>
                                </select>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group"> 
                <div class="col-md-offset-4 col-md-8">
                    <input type="hidden" name="order_type" value="<?php (isset($info) && ($info != '' || $info != null) && $info = 'delivery' ) ? print strtolower($info) : print"delivery" ?>">
                    <input class="form-submit-button mainsystembg2 waiting-bg img-responsive delivery-info-submit-btn" type="submit" name="submit_form" value="<?php echo $this->lang->line('gkpos_finished') ?>" onclick="saveDeliveryInfo('gkposDeliveryForm')">
                </div>
            </div>
        </form>
    </fieldset>
</div>
<script type="text/javascript">
    jQuery(document).ready(function () {
        $('[data-toggle="tooltip-delivery-phone"]').tooltip();
        var MapLoaded = false;
        if (!MapLoaded) {
            $.getScript('https://maps.googleapis.com/maps/api/js?key=<?php echo GOOGLE_API_KEY; ?>&libraries=places&callback=initAutocomplete', function (data, textStatus) {
                if (textStatus) {
                    MapLoaded = true;
                }
            });
        }
    });
    function saveDeliveryInfo(formId) {
        
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        $("#waitingAjaxLoading").show();
                    },
                    success: function (response) {
                        $("#waitingAjaxLoading").hide();
                        if (response.success) {
                            getBaseAjaxPage('<?php echo site_url('gkpos/orders/indexajax/') ?>' + response.order_id, 'Bar-' + response.name);
                        } else {
                            alert(response.message);
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules:
                    {
                        name: {
                            required: true
                        },
                        phone: {
                            phone: true,
                            required: true
                        },
                        street: "required",
                        postcode: {
                            required: true
                        }
                    },
            messages: {
                name: "<?php echo $this->lang->line('gkpos_valid_name_required') ?>",
                phone: "<?php echo $this->lang->line('gkpos_valid_phone_required') ?>",
                street: "<?php echo $this->lang->line('gkpos_customer_street_required') ?>",
                postcode: "<?php echo $this->lang->line('gkpos_customer_postcode_required') ?>",
                delivery_time: "<?php echo $this->lang->line('gkpos_order_delivery_time_required') ?>"
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
</script>
<script>
    var placeSearch, autocomplete;
    var componentForm = {
        street_number: 'short_name',
        route: 'long_name',
        locality: 'long_name',
        administrative_area_level_1: 'short_name',
        country: 'long_name',
        postal_code: 'short_name'
    };
    function initAutocomplete() {
        autocomplete = new google.maps.places.Autocomplete((document.getElementById('autocompleteGPlace')), {types: ['geocode']});
        autocomplete.addListener('place_changed', fillInAddress);
    }
    function fillInAddress() {
        var place = autocomplete.getPlace();
        for (var component in componentForm) {
            document.getElementById(component).value = '';
            document.getElementById(component).disabled = false;
        }
        for (var i = 0; i < place.address_components.length; i++) {
            var addressType = place.address_components[i].types[0];
            if (componentForm[addressType]) {
                var val = place.address_components[i][componentForm[addressType]];
                document.getElementById(addressType).value = val;
            }
        }
    }

    function geolocate() {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(function (position) {
                var geolocation = {
                    lat: position.coords.latitude,
                    lng: position.coords.longitude
                };
                var circle = new google.maps.Circle({
                    center: geolocation,
                    radius: position.coords.accuracy
                });
                autocomplete.setBounds(circle.getBounds());
            });
        }

    }
</script>
