<?php
$catagory_type = array(1 => $this->lang->line('gkpos_food'), 2 => $this->lang->line('gkpos_non_food'));
$print_option = printing_options();
$status = array(1 => $this->lang->line('gkpos_active'), 2 => $this->lang->line('gkpos_inactive'), 3 => $this->lang->line('gkpos_archived'));
$show_online = array(1 => $this->lang->line('gkpos_yes'), 0 => $this->lang->line('gkpos_no'));

$organizedToppings = array();
if (!empty($allToppings)) {
    foreach ($allToppings as $key => $item) {
        $organizedToppings[$item->category][] = $item;
    }
}
$dealList = get_record_list('meal_deal', array('status' => 1));
?>
<div class="col-lg-10 col-md-10 col-sm-10 col-xs-10 bodyitem">
    <a href="javascript:void(0)" class="manage-menu btn btn-block btn-primary gradient  text-center text-capitalize" onclick="toggleContent('AddCategoryBlock')"><span class="glyphicon glyphicon-plus"></span>&nbsp;<?php echo $this->lang->line('gkpos_add') . ' ' . $this->lang->line('gkpos_menu') . ' ' . $this->lang->line('gkpos_category') ?></a>
    <div id="AddCategoryBlock" style="display: none;" class="add-category-block">
        <div class="row content">
            <fieldset class="no-padding">
                <?php $action = $this->uri->segment(4) ? 'gkpos/menumanagement/category/' . $this->uri->segment(4) : 'gkpos/menumanagement/category' ?>
                <?php echo form_open($action, array('id' => 'gkposMenuCategoryForm', 'enctype' => 'multipart/form-data', 'class' => 'form-horizontal')); ?>
                <div class="fieldset">
                    <div class='form-input-part col-lg-8 col-md-8 col-sm-8 col-xs-8 '>
                        <legend><?php echo $this->lang->line('gkpos_basic_information') ?></legend>
                        <div class="form-group">
                            <?php echo form_label($this->lang->line('gkpos_category') . ' ' . $this->lang->line('gkpos_title'), 'title', array('class' => 'col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label')); ?>
                            <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                <?php echo form_input(array('name' => 'title', 'id' => 'title', 'class' => 'form-control required', 'value' => isset($title) ? $title : '')); ?>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="discount" class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label"><?php echo $this->lang->line('gkpos_category_type') ?></label>
                            <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                <label class="radio-inline text-capitalize"><input type="radio" name="type" id="type1" value="1" <?php (isset($type) && $type == "1") ? print "checked" : '' ?> ><?php echo $this->lang->line('gkpos_food') ?></label>
                                <label class="radio-inline text-capitalize"><input type="radio" name="type" id="type2" value="2" <?php (isset($type) && $type == "2") ? print "checked" : '' ?>><?php echo $this->lang->line('gkpos_non_food') ?></label>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="content" class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label"><?php echo $this->lang->line('gkpos_description') ?></label>
                            <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                <?php echo form_textarea(array('name' => 'content', 'rows' => 2, 'class' => 'form-control', 'id' => 'content'), isset($content) ? $content : '') ?>
                            </div>
                        </div>
                        <div class="fieldset">
                            <legend><?php echo $this->lang->line('gkpos_kitchen_print_setting') ?></legend>
                            <div class="form-group">
                                <label for="radio-inline" class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label"><?php echo $this->lang->line('gkpos_options') ?></label>
                                <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8 text-left">
                                    <?php $printingOptions = printing_options(); ?>
                                    <?php foreach ($printingOptions as $key => $prinOption): ?>
                                        <label class="radio-inline text-capitalize"><input type="radio" name="print_option" id="printerSet<?php $key ?>" value="<?php echo $key ?>" ><?php echo $prinOption ?></label>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <a href='javascript:void(0)'>
                                    <?php
                                    echo form_submit(array(
                                        'name' => 'submit_form',
                                        'id' => 'submit_form',
                                        'value' => $this->lang->line('gkpos_save'),
                                        'class' => 'form-submit-button mainsystembg2 collection-bg img-responsive'));
                                    ?>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class='form-message-part col-lg-4 col-md-4 col-sm-4 col-xs-4'>
                        <ul id="error_message_box" class="error_message_box"></ul>
                    </div>
                </div>
                <?php echo form_close() ?>
            </fieldset>
        </div>
        <?php if ($this->config->item('is_touch') == 'enable'): ?>
            <div class="main-keyboardbg">
                <div id="virtualKeyboard"></div>
            </div>
        <?php endif ?>
    </div>
    <div class="clearfix"></div>
    <?php if ($categories): ?>
        <div id="accordion">
            <?php foreach ($categories as $cat): ?>
                <div class="s_panel" id="<?php echo $cat->id . '_' . $cat->order ?>">
                    <h3 class="text-capitalize"><?php echo html_entity_decode($cat->title) ?></h3>
                    <div class="cat-info">
                        <table class="table table-responsive table-bordered category-table">
                            <tr>
                                <th><?php echo $this->lang->line('gkpos_title') ?></th>
                                <th><?php echo $this->lang->line('gkpos_description') ?></a></th>
                                <th><?php echo $this->lang->line('gkpos_category_type') ?></th>
                                <th><?php echo $this->lang->line('gkpos_options') ?></th>
                                <th><?php echo $this->lang->line('gkpos_update_status') ?></th>
                                <th><?php echo $this->lang->line('gkpos_online') ?></th>
                            </tr>
                            <tr>
                                <td><a href="javascript:void(0)" onclick="editcategorycell('<?php echo"category_title_" . $cat->id ?>')" data-type="text" id="category_title_<?php echo $cat->id ?>" data-name="title" data-pk="<?php echo $cat->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editcategorycell') ?>" data-title="<?php echo $this->lang->line('gkpos_category') . ' ' . $this->lang->line('gkpos_title') ?>">
                                        <?php echo $cat->title ?>
                                    </a>
                                </td>

                                <td><a href="javascript:void(0)" onclick="editcategorycell('<?php echo"category_content_" . $cat->id ?>')" data-type="textarea" id="category_content_<?php echo $cat->id ?>" data-name="content" data-pk="<?php echo $cat->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editcategorycell') ?>" data-title="<?php echo $this->lang->line('gkpos_category') . ' ' . $this->lang->line('gkpos_description') ?>">
                                        <?php $cat->content == null ? print '>>init' : print $cat->content ?>
                                    </a>
                                </td>

                                <td>
                                    <a href="javascript:void(0)" onclick="editcategorycell('<?php echo"type_" . $cat->id ?>')" data-type="select" id="type_<?php echo $cat->id ?>" data-name="type" data-pk="<?php echo $cat->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editcategorycell') ?>" data-value="<?php echo $cat->type ?>" data-title="<?php echo $this->lang->line('gkpos_update') . ' ' . $this->lang->line('gkpos_category_type') ?>">
                                        <?php echo $catagory_type[$cat->type] ?>
                                    </a>

                                </td>
                                <td>
                                    <a href="javascript:void(0)" onclick="editcategorycell('<?php echo"print_option_" . $cat->id ?>')" data-type="select" id="print_option_<?php echo $cat->id ?>" data-name="print_option" data-pk="<?php echo $cat->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editcategorycell') ?>" data-value="<?php echo $cat->print_option ?>" data-title="<?php echo $this->lang->line('gkpos_update') . ' ' . $this->lang->line('gkpos_options') ?>">
                                        <?php echo $print_option[$cat->print_option] ?>
                                    </a>
                                </td>
                                <td>
                                    <a href="javascript:void(0)" onclick="editcategorycell('<?php echo"category_status_" . $cat->id ?>')" data-type="select" id="category_status_<?php echo $cat->id ?>" data-name="status" data-pk="<?php echo $cat->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editcategorycell') ?>" data-value="<?php echo $cat->status ?>" data-title="<?php echo $this->lang->line('gkpos_update_status') ?>">
                                        <?php
                                        $color = 'black';
                                        if ($cat->status == 1) {
                                            $color = 'green';
                                        }
                                        if ($cat->status == 2) {
                                            $color = 'orange';
                                        }
                                        if ($cat->status == 3) {
                                            $color = 'red';
                                        }
                                        ?>
                                        <span style="color:<?php echo $color ?>;"><?php echo $status[$cat->status] ?></span>
                                    </a>
                                </td>
                                <td>
                                    <a href="javascript:void(0)" onclick="editcategorycell('<?php echo"category_online_" . $cat->id ?>')" data-type="select" id="category_online_<?php echo $cat->id ?>" data-name="online" data-pk="<?php echo $cat->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editcategorycell') ?>" data-value="<?php echo $cat->online ?>" data-title="<?php echo $this->lang->line('gkpos_update_status') ?>">
                                        <span><?php isset($show_online[$cat->online]) ? print $show_online[$cat->online] : print $this->lang->line('gkpos_no') ?></span>
                                    </a>
                                </td>

                            </tr>
                        </table>
                        <div class="menu-info">
                            <a href="javascript:void(0)" class="manage-menu btn btn-block btn-info text-center" onclick="toggleContent('AddMenuBlock<?php echo $cat->id ?>')"><span class="glyphicon glyphicon-plus"></span>&nbsp;<?php echo $this->lang->line('gkpos_add') . ' ' . $this->lang->line('gkpos_menu') ?></a>
                            <div id="AddMenuBlock<?php echo $cat->id ?>" style="display: none;" class="add-menu-block">
                                <div class="clearfix"></div>
                                <fieldset>
                                    <?php $action = $this->uri->segment(4) ? 'gkpos/menumanagement/menu/' . $this->uri->segment(4) : 'gkpos/menumanagement/menu' ?>
                                    <?php echo form_open($action, array('id' => 'gkposMenuForm' . $cat->id, 'enctype' => 'multipart/form-data', 'class' => 'form-horizontal')); ?>
                                    <div class="fieldset">
                                        <div class='form-input-part col-lg-12 col-md-12 col-sm-12 col-xs-12 '>
                                            <div class='pull-left col-lg-6 col-md-6 col-sm-6 col-xs-6' >
                                                <div class="form-group">
                                                    <?php echo form_label($this->lang->line('gkpos_menu') . ' ' . $this->lang->line('gkpos_title'), 'title', array('class' => 'col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label required')); ?>
                                                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                                        <?php echo form_input(array('data-error' => '#menuTitleError_' . $cat->id, 'name' => 'title', 'id' => 'title', 'class' => 'form-control required', 'value' => isset($title) ? $title : '')); ?>
                                                        <div id='menuTitleError_<?php echo $cat->id ?>'></div>
                                                    </div>

                                                </div>
                                                <div class="form-group">
                                                    <label for="content" class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label"><?php echo $this->lang->line('gkpos_description') ?></label>
                                                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                                        <?php echo form_textarea(array('name' => 'content', 'rows' => 2, 'class' => 'form-control', 'id' => 'content' . $cat->id), isset($content) ? $content : '') ?>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class='pull-right col-lg-6 col-md-6 col-sm-6 col-xs-6' >
                                                <div class="form-group">
                                                    <label for="base_price" class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label"><?php echo $this->lang->line('gkpos_menu_base_price') ?></label>
                                                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                                        <div class="input-group">
                                                            <span class="input-group-addon"><?php echo $this->config->item('currency_symbol') ?></span>
                                                            <?php echo form_input(array('data-error' => '#menuBasePriceError_' . $cat->id, 'name' => 'base_price', 'id' => 'base_price', 'class' => 'form-control addon-input', 'value' => isset($base_price) && $base_price > 0 ? $base_price : '')); ?>
                                                        </div>
                                                        <div id='menuBasePriceError_<?php echo $cat->id ?>'></div>
                                                    </div>
                                                </div>
                                                <div class="clearfix"></div>

                                                <div class="fieldset">
                                                    <div class="checkbox col-sm-offset-4">
                                                        <label><legend><input type="checkbox" name='is_dine' value='yes' id="idToCheck<?php echo $cat->id ?>" onclick="checkBlock('<?php echo "idToCheck" . $cat->id ?>', '<?php echo "checkBlock" . $cat->id ?>')"><?php echo $this->lang->line('gkpos_menu_price_differs_in_dine') ?></legend></label>
                                                    </div>
                                                    <div id="checkBlock<?php echo $cat->id ?>" style="display: none;" >
                                                        <div class="form-group">
                                                            <label for="in_price" class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label"><?php echo $this->lang->line('gkpos_menu_dine_in_price') ?></label>
                                                            <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                                                <div class="input-group">
                                                                    <div class="input-group-addon"><?php echo $this->config->item('currency_symbol') ?></div>
                                                                    <?php echo form_input(array('data-error' => '#menuInPriceError_' . $cat->id, 'name' => 'in_price', 'id' => 'in_price' . $cat->id, 'class' => 'form-control addon-input', 'value' => isset($in_price) && $in_price > 0 ? $in_price : '')); ?>
                                                                </div>
                                                                <div id='menuInPriceError_<?php echo $cat->id ?>'></div>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="out_price" class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label"><?php echo $this->lang->line('gkpos_menu_dine_out_price') ?></label>
                                                            <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                                                <div class="input-group">
                                                                    <div class="input-group-addon"><?php echo $this->config->item('currency_symbol') ?></div>                                                                         
                                                                    <?php echo form_input(array('data-error' => '#menuOutPriceError_' . $cat->id, 'name' => 'out_price', 'id' => 'out_price' . $cat->id, 'class' => 'form-control addon-input', 'value' => isset($out_price) && $out_price > 0 ? $out_price : '')); ?>
                                                                </div>
                                                                <div id='menuOutPriceError_<?php echo $cat->id ?>'></div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="fieldset">
                                                    <div class="checkbox col-sm-offset-4">
                                                        <label><legend><input type="checkbox" name='is_special' value='yes' id="idToCheckSpecial<?php echo $cat->id ?>" onclick="checkBlock('<?php echo "idToCheckSpecial" . $cat->id ?>', '<?php echo "idToCheckSpecialBlock" . $cat->id ?>')"><?php echo 'Is Special ?' ?></legend></label>
                                                    </div>
                                                </div>
                                                <div id="idToCheckSpecialBlock<?php echo $cat->id ?>" style="display: none;" class="col-sm-offset-4" >
                                                    <?php if (!empty($dealList)): ?>
                                                        <?php foreach ($dealList as $alist): ?>
                                                            <label class="radio-inline"><input data-error="#gkposMenuFormDealError<?php echo $cat->id ?>" type="radio" name="deal" value="<?php echo $alist->id ?>"><?php echo $alist->title ?></label>
                                                        <?php endforeach; ?>
                                                    <?php endif; ?>
                                                    <br/>
                                                    <div id="gkposMenuFormDealError<?php echo $cat->id ?>"></div>
                                                </div>

                                            </div>
                                        </div>
                                        <div class="clearfix"></div>
                                        <div class="form-group">
                                            <input type='hidden' name='category' value='<?php echo $cat->id ?>'>
                                            <input class="form-submit-button mainsystembg2 waiting-bg img-responsive" type="submit" name="submit_form" value="<?php echo $this->lang->line('gkpos_save') ?>" onclick="savemenu('gkposMenuForm<?php echo $cat->id ?>', 'idToCheck<?php echo $cat->id ?>', '<?php echo "idToCheckSpecial" . $cat->id ?>')">
                                        </div>
                                    </div>
                                    <?php echo form_close() ?>
                                </fieldset>
                                <div class="clearfix"></div>
                            </div>
                            <div class="menuList">
                                <?php $menusCollection = $menus[$cat->id] ?>
                                <?php if (!empty($menusCollection)): ?>
                                    <?php $count = 1; ?>
                                    <table class="table table-responsive table-bordered category-table" id="table-<?php echo $cat->id ?>">
                                        <tr>
                                            <th class="text-capitalize"><?php echo $this->lang->line('gkpos_menu') . ' ' . $this->lang->line('gkpos_title') ?></th>
                                            <th class="text-capitalize" style="width: 35%;"> <?php echo $this->lang->line('gkpos_description') ?></th>
                                            <th class="text-capitalize"><?php echo $this->lang->line('gkpos_price') . "[" . $this->config->item('currency_symbol') . "]" ?></th>
                                            <th class="text-capitalize"><?php echo $this->lang->line('gkpos_in') . "[" . $this->config->item('currency_symbol') . "]" ?></th>
                                            <th class="text-capitalize"><?php echo $this->lang->line('gkpos_out') . "[" . $this->config->item('currency_symbol') . "]" ?></th>
                                            <th class="text-capitalize"><?php echo $this->lang->line('gkpos_update_status') ?></th>
                                            <th class="text-capitalize"><?php echo $this->lang->line('gkpos_excahnge_category') ?></th>
                                            <th class="text-capitalize"><?php echo $this->lang->line('gkpos_serial') ?></th>
                                            <th><?php echo $this->lang->line('gkpos_online') ?></th>
                                            <th>Toppings</th>
                                            <th>Bogo</th>
                                        </tr>

                                        <?php foreach ($menusCollection as $menu): ?>
                                            <tr>
                                                <td>
                                                    <a href="javascript:void(0)" onclick="editmenucell('<?php echo"title_" . $menu->id ?>')" data-type="text" id="title_<?php echo $menu->id ?>" data-name="title" data-pk="<?php echo $menu->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editmenucell') ?>" data-title="<?php echo $this->lang->line('gkpos_menu') . ' ' . $this->lang->line('gkpos_title') ?>">
                                                        <?php echo html_entity_decode($menu->title) ?>
                                                    </a>
                                                </td>
                                                <td>
                                                    <a href="javascript:void(0)" onclick="editmenucell('<?php echo"content_" . $menu->id ?>')" data-type="textarea" id="content_<?php echo $menu->id ?>" data-name="content" data-pk="<?php echo $menu->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editmenucell') ?>" data-title="<?php echo $this->lang->line('gkpos_menu') . ' ' . $this->lang->line('gkpos_description') ?>">
                                                        <?php $menu->content == null ? print '>>init' : print $menu->content ?>
                                                    </a>
                                                </td>
                                                <td>
                                                    <a href="javascript:void(0)" onclick="editmenucell('<?php echo"base_price_" . $menu->id ?>')" data-type="text" id="base_price_<?php echo $menu->id ?>" data-name="base_price" data-pk="<?php echo $menu->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editmenucell') ?>" data-title="<?php echo $this->lang->line('gkpos_menu_base_price') ?>">
                                                        <?php isset($menu->base_price) && $menu->base_price > 0 ? print $menu->base_price : print $this->lang->line('gkpos_n_a') ?>
                                                    </a>
                                                </td>
                                                <td>
                                                    <a href="javascript:void(0)" onclick="editmenucell('<?php echo"in_price_" . $menu->id ?>')" data-type="text" id="in_price_<?php echo $menu->id ?>" data-name="in_price" data-pk="<?php echo $menu->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editmenucell') ?>" data-title="<?php echo $this->lang->line('gkpos_menu_dine_in_price') ?>">
                                                        <?php isset($menu->in_price) && $menu->in_price > 0 ? print $menu->in_price : print $this->lang->line('gkpos_n_a') ?>
                                                    </a>
                                                </td>
                                                <td>
                                                    <a href="javascript:void(0)" onclick="editmenucell('<?php echo"out_price_" . $menu->id ?>')" data-type="text" id="out_price_<?php echo $menu->id ?>" data-name="out_price" data-pk="<?php echo $menu->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editmenucell') ?>" data-title="<?php echo $this->lang->line('gkpos_menu_dine_out_price') ?>">
                                                        <?php isset($menu->out_price) && $menu->out_price > 0 ? print $menu->out_price : print $this->lang->line('gkpos_n_a') ?>
                                                    </a>
                                                </td>
                                                <td>
                                                    <a href="javascript:void(0)" onclick="editmenucell('<?php echo"status_" . $menu->id ?>')" data-type="select" id="status_<?php echo $menu->id ?>" data-name="status" data-pk="<?php echo $menu->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editmenucell') ?>" data-value="<?php echo $menu->status ?>" data-title="<?php echo $this->lang->line('gkpos_update_status') ?>">
                                                        <?php
                                                        $color = 'black';
                                                        if ($menu->status == 1) {
                                                            $color = 'green';
                                                        }
                                                        if ($menu->status == 2) {
                                                            $color = 'orange';
                                                        }
                                                        if ($menu->status == 3) {
                                                            $color = 'red';
                                                        }
                                                        ?>
                                                        <span style="color:<?php echo $color ?>;"><?php echo $status[$menu->status] ?></span>
                                                    </a>
                                                </td>
                                                <td>
                                                    <a href="javascript:void(0)" onclick="editmenucell('<?php echo"category_" . $menu->id ?>')" data-type="select" id="category_<?php echo $menu->id ?>" data-name="category" data-pk="<?php echo $menu->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/exchange_category') ?>" data-value="<?php echo $menu->category ?>" data-title="<?php echo $this->lang->line('gkpos_change_category') ?>">
                                                        <span><?php echo get_gkcategory_name($menu->category) ?></span>
                                                    </a>
                                                </td>
                                                <td>
                                                    <a href="javascript:void(0)" onclick="editmenucell('<?php echo"order_" . $menu->id ?>')" data-type="number" data-value="<?php echo $menu->order ?>" id="order_<?php echo $menu->id ?>" data-name="<?php echo $menu->category ?>" data-pk="<?php echo $menu->id ?>"  data-url="<?php echo site_url('gkpos/menumanagement/savemenuorder') ?>" data-title="<?php echo $this->lang->line('gkpos_menu') . ' ' . $this->lang->line('gkpos_title') ?>">
                                                        <?php echo $menu->order ?>
                                                    </a>
                                                </td>
                                                <td>
                                                    <a href="javascript:void(0)" onclick="editmenucell('<?php echo"menu_online_" . $menu->id ?>')" data-type="select" id="menu_online_<?php echo $menu->id ?>" data-name="online" data-pk="<?php echo $menu->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editmenucell') ?>" data-value="<?php echo $menu->online ?>" data-title="<?php echo $this->lang->line('gkpos_update_status') ?>">
                                                        <span><?php isset($show_online[$menu->online]) ? print $show_online[$menu->online] : print $this->lang->line('gkpos_no') ?></span>
                                                    </a>
                                                </td>
                                                <td><a href="javascript:void(0)" onclick="openTopingBox('<?php echo $menu->id ?>', 'gkpos_menu', 'menu','<?php echo $menu->category?>')">Toppings</a></td>
                                                <td>
                                                    <a href="javascript:void(0)" onclick="editmenucell('<?php echo"menu_bogo_" . $menu->id ?>')" data-type="select" id="menu_bogo_<?php echo $menu->id ?>" data-name="bogo" data-pk="<?php echo $menu->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editmenucell') ?>" data-value="<?php echo $menu->bogo ?>" data-title="<?php echo $this->lang->line('gkpos_update_status') ?>">
                                                        <span><?php $menu->bogo == 1 ? print $this->lang->line('gkpos_yes') : print $this->lang->line('gkpos_no') ?></span>
                                                    </a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="11">
                                                    <div class="menu-selection">
                                                        <a href="javascript:void(0)" class="text-capitalize manage-menu-selection btn btn-block btn-success text-center" onclick="toggleContent('AddMenuSelectionBlock<?php echo $menu->id . $count ?>')"><span class="glyphicon glyphicon-plus"></span>&nbsp;<?php echo $this->lang->line('gkpos_manage') . ' ' . $menu->title . ' ' . $this->lang->line('gkpos_selection') ?></a>
                                                        <div id="AddMenuSelectionBlock<?php echo $menu->id . $count ?>" style="display: none;" class="add-menu-selection-block">
                                                            <div class="clearfix"></div>
                                                            <a href="javascript:void(0)" class="text-capitalize manage-menu-selection btn btn-warning btn-block" onclick="toggleContent('AddSelectionPanel<?php echo $menu->id . $count ?>')"><span class="glyphicon glyphicon-plus"></span>&nbsp;<?php echo $this->lang->line('gkpos_add') . ' ' . $menu->title . ' ' . $this->lang->line('gkpos_selection') ?></a>
                                                            <fieldset id="AddSelectionPanel<?php echo $menu->id . $count ?>" style="display: none;">
                                                                <?php $action = $this->uri->segment(4) ? 'gkpos/menumanagement/selection/' . $this->uri->segment(4) : 'gkpos/menumanagement/selection' ?>
                                                                <?php echo form_open($action, array('id' => 'gkposMenuSelectionForm' . $menu->id, 'enctype' => 'multipart/form-data', 'class' => 'form-horizontal')); ?>
                                                                <div class="fieldset">
                                                                    <div class='form-input-part col-lg-12 col-md-12 col-sm-12 col-xs-12 '>
                                                                        <div class='pull-left col-lg-6 col-md-6 col-sm-6 col-xs-6' >
                                                                            <div class="form-group">
                                                                                <?php echo form_label($this->lang->line('gkpos_selection') . ' ' . $this->lang->line('gkpos_title'), 'title', array('class' => 'col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label required')); ?>
                                                                                <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                                                                    <?php echo form_input(array('name' => 'title', 'id' => 'title' . $menu->id . $count, 'class' => 'form-control required', 'value' => isset($title) ? $title : '')); ?>
                                                                                </div>
                                                                            </div>
                                                                            <div class="form-group">
                                                                                <label for="content" class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label"><?php echo $this->lang->line('gkpos_description') ?></label>
                                                                                <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                                                                    <?php echo form_textarea(array('name' => 'content', 'rows' => 2, 'class' => 'form-control', 'id' => 'content' . $menu->id . $count), isset($content) ? $content : '') ?>
                                                                                </div>
                                                                            </div>
                                                                            <div class='form-group form-message-part'>
                                                                                <ul id="selection_error_message_box<?php echo $menu->id . $count ?>" class="selection_error_message_box"></ul>
                                                                            </div>
                                                                        </div>
                                                                        <div class='pull-right col-lg-6 col-md-6 col-sm-6 col-xs-6' >
                                                                            <div class="form-group">
                                                                                <label for="base_price" class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label"><?php echo $this->lang->line('gkpos_menu_base_price') ?></label>
                                                                                <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                                                                    <div class="input-group">
                                                                                        <span class="input-group-addon"><?php echo $this->config->item('currency_symbol') ?></span>
                                                                                        <?php echo form_input(array('data-error' => '#selectionPriceError_' . $menu->id . $count, 'name' => 'base_price', 'id' => 'base_price' . $menu->id . $count, 'class' => 'form-control addon-input', 'value' => isset($base_price) && $base_price > 0 ? $base_price : '')); ?>
                                                                                    </div>
                                                                                    <div id="selectionPriceError_<?php echo $menu->id . $count ?>"></div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="clearfix"></div>
                                                                            <div class="fieldset col-sm-offset-4" style="text-align: left">
                                                                                <div class="checkbox">
                                                                                    <label><legend><input type="checkbox" name='is_dine' value='yes' id="menuIdToCheck<?php echo $menu->id . $count ?>" onclick="checkBlock('<?php echo "menuIdToCheck" . $menu->id . $count ?>', '<?php echo "selectionCheckBlock" . $menu->id . $count ?>')"><?php echo $this->lang->line('gkpos_menu_price_differs_in_dine') ?></legend></label>
                                                                                </div>
                                                                                <div id="selectionCheckBlock<?php echo $menu->id . $count ?>" style="display: none;" >
                                                                                    <div class="form-group">
                                                                                        <label for="in_price" class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label"><?php echo $this->lang->line('gkpos_menu_dine_in_price') ?></label>
                                                                                        <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                                                                            <div class="input-group">
                                                                                                <span class="input-group-addon"><?php echo $this->config->item('currency_symbol') ?></span>
                                                                                                <?php echo form_input(array('data-error' => '#selectionInPriceError_' . $menu->id . $count, 'name' => 'in_price', 'id' => 'in_price' . $menu->id . $count, 'class' => 'form-control addon-input', 'value' => isset($in_price) && $in_price > 0 ? $in_price : '')); ?>
                                                                                            </div>
                                                                                            <div id="selectionInPriceError_<?php echo $menu->id . $count ?>"></div>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="form-group">
                                                                                        <label for="out_price" class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label"><?php echo $this->lang->line('gkpos_menu_dine_out_price') ?></label>
                                                                                        <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                                                                            <div class="input-group">
                                                                                                <div class="input-group-addon"><?php echo $this->config->item('currency_symbol') ?></div>                                                                         
                                                                                                <?php echo form_input(array('data-error' => '#selectionOutPriceError_' . $menu->id . $count, 'name' => 'out_price', 'id' => 'out_price' . $menu->id . $count, 'class' => 'form-control addon-input', 'value' => isset($out_price) && $out_price > 0 ? $out_price : '')); ?>
                                                                                            </div>
                                                                                            <div id="selectionOutPriceError_<?php echo $menu->id . $count ?>"></div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="fieldset col-sm-offset-4" style="text-align: left">
                                                                                <div class="checkbox">
                                                                                    <label><legend><input type="checkbox" name='is_special' value='yes' id="idToCheckSelectionSpecial<?php echo $menu->id . $count ?>" onclick="checkBlock('<?php echo "idToCheckSelectionSpecial" . $menu->id . $count ?>', '<?php echo "idToCheckSpecialSelectionBlock" . $menu->id . $count ?>')"><?php echo 'Is Special ?' ?></legend></label>
                                                                                </div>

                                                                                <div id="idToCheckSpecialSelectionBlock<?php echo $menu->id . $count ?>" style="display: none;">
                                                                                    <?php if (!empty($dealList)): ?>
                                                                                        <?php foreach ($dealList as $alist): ?>
                                                                                            <label class="radio-inline"><input data-error="#gkposSelectionFormDealError<?php echo $cat->id ?>" type="radio" name="deal" value="<?php echo $alist->id ?>"><?php echo $alist->title ?></label>
                                                                                        <?php endforeach; ?>
                                                                                    <?php endif; ?>
                                                                                    <br/>
                                                                                    <div id="gkposSelectionFormDealError<?php echo $cat->id ?>"></div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="clearfix"></div>
                                                                    <div class="form-group">
                                                                        <input type='hidden' name='category' value='<?php echo $cat->id ?>'>
                                                                        <input type='hidden' name='menu' value='<?php echo $menu->id ?>'>
                                                                        <input class="form-submit-button mainsystembg2 waiting-bg img-responsive" type="submit" name="submit_form" value="<?php echo $this->lang->line('gkpos_save') ?>" onclick="savemenuselection('gkposMenuSelectionForm<?php echo $menu->id ?>', 'menuIdToCheck<?php echo $menu->id . $count ?>', 'idToCheckSelectionSpecial<?php echo $menu->id . $count ?>')">
                                                                    </div>
                                                                </div>
                                                                <?php echo form_close() ?>
                                                            </fieldset>
                                                            <div class="clearfix"></div>
                                                            <div class="selectionList">
                                                                <?php $selCollection = $selections[$cat->id][$menu->id] ?>
                                                                <?php if (!empty($selCollection)): ?>
                                                                    <?php $sel_counter = 1; ?>
                                                                    <table class="table table-responsive table-bordered category-table" id="table-<?php echo $cat->id . $menu->id ?>">
                                                                        <tr>
                                                                            <th class="text-capitalize"><?php echo $this->lang->line('gkpos_title') ?></th>
                                                                            <th style="width: 35%;" class="text-capitalize"> <?php echo $this->lang->line('gkpos_description') ?></th>
                                                                            <th class="text-capitalize"><?php echo $this->lang->line('gkpos_price') . "[" . $this->config->item('currency_symbol') . "]" ?></th>
                                                                            <th class="text-capitalize"><?php echo $this->lang->line('gkpos_in') . "[" . $this->config->item('currency_symbol') . "]" ?></th>
                                                                            <th class="text-capitalize"><?php echo $this->lang->line('gkpos_out') . "[" . $this->config->item('currency_symbol') . "]" ?></th>
                                                                            <th class="text-capitalize"><?php echo $this->lang->line('gkpos_update_status') ?></th>
                                                                            <th><?php echo $this->lang->line('gkpos_online') ?></th>
                                                                            <th>Toppings</th>
                                                                            <th>bogo</th>
                                                                        </tr>

                                                                        <?php foreach ($selCollection as $sel): ?>
                                                                            <tr>
                                                                                <td>
                                                                                    <a href="javascript:void(0)" onclick="editmenuselcell('<?php echo"title_" . $cat->id . $menu->id . $sel->id ?>')" data-type="text" id="title_<?php echo $cat->id . $menu->id . $sel->id ?>" data-name="title" data-pk="<?php echo $sel->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editmenuselcell') ?>" data-title="<?php echo $menu->title . ' ' . $this->lang->line('gkpos_selection') . ' ' . $this->lang->line('gkpos_title') ?>">
                                                                                        <?php echo html_entity_decode($sel->title) ?>
                                                                                    </a>
                                                                                </td>

                                                                                <td>
                                                                                    <a href="javascript:void(0)" onclick="editmenuselcell('<?php echo"content_" . $cat->id . $menu->id . $sel->id ?>')" data-type="textarea" id="content_<?php echo $cat->id . $menu->id . $sel->id ?>" data-name="content" data-pk="<?php echo $sel->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editmenuselcell') ?>" data-title="<?php echo $menu->title . ' ' . $this->lang->line('gkpos_selection') . ' ' . $this->lang->line('gkpos_description') ?>">
                                                                                        <?php $sel->content == null ? print'>>init' : print $sel->content ?>
                                                                                    </a>
                                                                                </td>

                                                                                <td>
                                                                                    <a href="javascript:void(0)" onclick="editmenuselcell('<?php echo"base_price_" . $cat->id . $menu->id . $sel->id ?>')" data-type="text" id="base_price_<?php echo $cat->id . $menu->id . $sel->id ?>" data-name="base_price" data-pk="<?php echo $sel->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editmenuselcell') ?>" data-title="<?php echo $menu->title . ' ' . $this->lang->line('gkpos_selection') . ' ' . $this->lang->line('gkpos_price') ?>">
                                                                                        <?php isset($sel->base_price) && $sel->base_price > 0 ? print $sel->base_price : print $this->lang->line('gkpos_n_a') ?>
                                                                                    </a>
                                                                                </td>

                                                                                <td>
                                                                                    <a href="javascript:void(0)" onclick="editmenuselcell('<?php echo"in_price_" . $cat->id . $menu->id . $sel->id ?>')" data-type="text" id="in_price_<?php echo $cat->id . $menu->id . $sel->id ?>" data-name="in_price" data-pk="<?php echo $sel->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editmenuselcell') ?>" data-title="<?php echo $menu->title . ' ' . $this->lang->line('gkpos_selection') . ' ' . $this->lang->line('gkpos_in') . ' ' . $this->lang->line('gkpos_price') ?>" >
                                                                                        <?php isset($sel->in_price) && $sel->in_price > 0 ? print $sel->in_price : print $this->lang->line('gkpos_n_a') ?>
                                                                                    </a>
                                                                                </td>
                                                                                <td>
                                                                                    <a href="javascript:void(0)" onclick="editmenuselcell('<?php echo"out_price_" . $cat->id . $menu->id . $sel->id ?>')" data-type="text" id="out_price_<?php echo $cat->id . $menu->id . $sel->id ?>" data-name="out_price" data-pk="<?php echo $sel->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editmenuselcell') ?>" data-title="<?php echo $menu->title . ' ' . $this->lang->line('gkpos_selection') . ' ' . $this->lang->line('gkpos_out') . ' ' . $this->lang->line('gkpos_price') ?>">
                                                                                        <?php isset($sel->out_price) && $sel->out_price > 0 ? print $sel->out_price : print $this->lang->line('gkpos_n_a') ?>
                                                                                    </a>
                                                                                </td>
                                                                                <td>
                                                                                    <a href="javascript:void(0)" onclick="editmenuselcell('<?php echo"status_" . $cat->id . $menu->id . $sel->id ?>')" data-type="select" id="status_<?php echo $cat->id . $menu->id . $sel->id ?>" data-name="status" data-pk="<?php echo $sel->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editmenuselcell') ?>" data-value="<?php echo $sel->status ?>" data-title="<?php echo $this->lang->line('gkpos_update_status') ?>">
                                                                                        <?php
                                                                                        $color = 'black';
                                                                                        if ($sel->status == 1) {
                                                                                            $color = 'green';
                                                                                        }
                                                                                        if ($sel->status == 2) {
                                                                                            $color = 'orange';
                                                                                        }
                                                                                        if ($sel->status == 3) {
                                                                                            $color = 'red';
                                                                                        }
                                                                                        ?>
                                                                                        <span style="color:<?php echo $color ?>;"><?php echo $status[$sel->status] ?></span>

                                                                                    </a>
                                                                                </td>
                                                                                <td>
                                                                                    <a href="javascript:void(0)" onclick="editmenuselcell('<?php echo"online_" . $cat->id . $menu->id . $sel->id ?>')" data-type="select" id="online_<?php echo $cat->id . $menu->id . $sel->id ?>" data-name="online" data-pk="<?php echo $sel->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editmenuselcell') ?>" data-value="<?php echo $sel->online ?>" data-title="<?php echo $this->lang->line('gkpos_update_status') ?>">
                                                                                        <span><?php isset($show_online[$sel->online]) ? print $show_online[$sel->online] : print $this->lang->line('gkpos_no') ?></span>
                                                                                    </a>
                                                                                </td>
                                                                                <td><a href="javascript:void(0)" onclick="openTopingBox('<?php echo $sel->id ?>', 'gkpos_selection', 'selection','<?php echo $sel->category?>')">Toppings</a></td>
                                                                                <td>
                                                                                    <a href="javascript:void(0)" onclick="editmenuselcell('<?php echo"bogo_" . $cat->id . $menu->id . $sel->id ?>')" data-type="select" id="bogo_<?php echo $cat->id . $menu->id . $sel->id ?>" data-name="bogo" data-pk="<?php echo $sel->id ?>" data-url="<?php echo site_url('gkpos/menumanagement/editmenuselcell') ?>" data-value="<?php echo $sel->online ?>" data-title="<?php echo $this->lang->line('gkpos_update_status') ?>">
                                                                                        <span><?php $sel->bogo == 1 ? print $this->lang->line('gkpos_yes') : print $this->lang->line('gkpos_no') ?></span>
                                                                                    </a>
                                                                                </td>
                                                                            </tr>

                                                                            <?php $sel_counter++ ?>
                                                                        <?php endforeach; ?>
                                                                    </table>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                            <?php $count++ ?>
                                        <?php endforeach; ?>
                                    </table>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
            <div class="clearfix" style="margin-bottom: 5px; padding-bottom: 50px;"></div>
        </div>
    <?php endif; ?>
</div>
<div id="TopingToolBoxHolder"></div>
<script>
    $(document).ready(function () {
        manageWindowHeight();
        $('#accordion').accordion({
            collapsible: true,
            active: false,
            height: 'fill',
            header: 'h3',
            autoHeight: false,
        }).sortable({
            items: '.s_panel',
            cursor: "move",
            update: function (event, ui) {
                var data = $(this).sortable('serialize');
                $.post("<?php echo site_url('gkpos/menumanagement/categorysort') ?>", {data: data}, function (output) {
                    console.log(output);
                }, 'json');
            }
        });
        $('#accordion').on('accordionactivate', function (event, ui) {
            if (ui.newPanel.length) {
                $('#accordion').sortable('disable');
            } else {
                $('#accordion').sortable('enable');
            }
        });
    <?php if ($this->config->item('is_touch') == 'enable') { ?>
            keyboard('virtualKeyboard');
<?php } ?>
        setnumkeys('discount');
        $('#gkposMenuCategoryForm').validate({
            submitHandler: function () {
                var myform = document.getElementById('gkposMenuCategoryForm');
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#gkposMenuCategoryForm').attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            ALERT_TITLE = 'Success';
                            alert(response.message + ' Please Click on Refresh Button left to see action');
                        } else {
                            alert(response.message);
                        }
                    }
                });
            },
            errorClass: "has-error",
            errorLabelContainer: "#error_message_box",
            wrapper: "li",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                title: "required",
                print_option: "required",
                type: "required"
            },
            messages: {
                title: "<?php echo $this->lang->line('gkpos_category_title_required'); ?>",
                print_option: "<?php echo $this->lang->line('gkpos_print_option_required'); ?>",
                type: "<?php echo $this->lang->line('gkpos_select_category_food_type') ?>"
            }
        });
    });

    function editcategorycell(field) {
        
        $.fn.editable.defaults.mode = 'inline';
        $('#' + field).editable({
            source: function () {
                if (field.includes("type")) {
                    return [
                        {value: 1, text: '<?php echo $this->lang->line('gkpos_food') ?>'},
                        {value: 2, text: '<?php echo $this->lang->line('gkpos_non_food') ?>'},
                    ]
                }
                if (field.includes("online")) {
                    return [
                        {value: 1, text: '<?php echo $this->lang->line('gkpos_yes') ?>'},
                        {value: 0, text: '<?php echo $this->lang->line('gkpos_no') ?>'}, ]
                }
                if (field.includes("category_status")) {
                    return [
                        {value: 1, text: '<?php echo $this->lang->line('gkpos_active') ?>'},
                        {value: 2, text: '<?php echo $this->lang->line('gkpos_inactive') ?>'},
                        {value: 3, text: '<?php echo $this->lang->line('gkpos_deleted') ?>'}
                    ]
                }
                if (field.includes("print_option")) {
                    return [
                        {value: 6, text: '<?php echo $this->lang->line('gkpos_kitchen_print_setting6') ?>'},
                        {value: 1, text: '<?php echo $this->lang->line('gkpos_kitchen_print_setting1') ?>'},
                        {value: 2, text: '<?php echo $this->lang->line('gkpos_kitchen_print_setting2') ?>'},
                        {value: 3, text: '<?php echo $this->lang->line('gkpos_kitchen_print_setting3') ?>'},
                        {value: 4, text: '<?php echo $this->lang->line('gkpos_kitchen_print_setting4') ?>'},
                        {value: 5, text: '<?php echo $this->lang->line('gkpos_kitchen_print_setting5') ?>'},
                        {value: 7, text: '<?php echo $this->lang->line('gkpos_kitchen_print_setting7') ?>'}
                    ]
                }
            }
        });
    }
    function MenuCellEdit(field, pk, type) {
        $('#' + field).editable({
            type: type,
            pk: pk,
            url: '<?php echo site_url("gkpos/menumanagement/editcell") ?>',
            title: 'New Value'
        });
    }
    function editmenucell(field) {
        $.fn.editable.defaults.mode = 'inline';
        $('#' + field).editable({
            source: function () {
                if (field.includes("status")) {
                    return [
                        {value: 1, text: '<?php echo $this->lang->line('gkpos_active') ?>'},
                        {value: 2, text: '<?php echo $this->lang->line('gkpos_inactive') ?>'},
                        {value: 3, text: '<?php echo $this->lang->line('gkpos_deleted') ?>'}
                    ]
                }
                if (field.includes("category")) {
                    return '<?php echo json_encode($selectCategories) ?>';
                }
                if (field.includes("online")) {
                    return [
                        {value: 1, text: '<?php echo $this->lang->line('gkpos_yes') ?>'},
                        {value: 0, text: '<?php echo $this->lang->line('gkpos_no') ?>'}
                    ]
                }

                if (field.includes("bogo")) {
                    return [
                        {value: 1, text: '<?php echo $this->lang->line('gkpos_yes') ?>'},
                        {value: 0, text: '<?php echo $this->lang->line('gkpos_no') ?>'}
                    ]
                }

                if (field.includes("print_option")) {
                    return [
                        {value: 1, text: '<?php echo $this->lang->line('gkpos_kitchen_print_setting1') ?>'},
                        {value: 2, text: '<?php echo $this->lang->line('gkpos_kitchen_print_setting2') ?>'},
                        {value: 3, text: '<?php echo $this->lang->line('gkpos_kitchen_print_setting3') ?>'},
                        {value: 4, text: '<?php echo $this->lang->line('gkpos_kitchen_print_setting4') ?>'}
                    ]
                }
            }
        });
    }
    function savemenu(formId, idToCheck, idToCheckSpecial) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        $('#GkposAjaxPageLoader').toggle('slow');
                    },
                    success: function (response) {
                        $('#GkposAjaxPageLoader').toggle('slow');
                        if (response.success) {
                            var msg = response.message + ' ' + 'Please Click on Refresh Button left to see action';
                            ALERT_TITLE = "Success!";
                            alert(msg);
                        } else
                        {
                            ALERT_TITLE = "Error!";
                            alert(response.message);
                        }
                    },
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                title: {
                    required: true,
                },
                base_price: {
                    number: true,
                    required: function () {
                        var idToCheckTest = $("#" + idToCheck).is(":checked");
                        var idToCheckSpecialTest = $("#" + idToCheckSpecial).is(":checked");
                        return !idToCheckTest && !idToCheckSpecialTest;
                    }
                },
                in_price: {
                    number: true,
                    required: function (element) {
                        var idToCheckSpecialTest = $("#" + idToCheckSpecial).is(":checked");
                        var idToCheckTest = $("#" + idToCheck).is(":checked");
                        return !idToCheckSpecialTest && idToCheckTest;
                    }
                },
                out_price: {
                    number: true,
                    required: function (element) {
                        var idToCheckSpecialTest = $("#" + idToCheckSpecial).is(":checked");
                        var idToCheckTest = $("#" + idToCheck).is(":checked");
                        return !idToCheckSpecialTest && idToCheckTest;
                    }
                },
                deal: {
                    number: true,
                    required: function (element) {
                        var idToCheckSpecialTest = $("#" + idToCheckSpecial).is(":checked");
                        var idToCheckTest = $("#" + idToCheck).is(":checked");
                        return idToCheckSpecialTest && !idToCheckTest;
                    }
                }
            },
            messages: {
                title: "<?php echo $this->lang->line('gkpos_menu_title_rquired') ?>",
                base_price: "<?php echo $this->lang->line('gkpos_menu_price_rquired') ?>",
                in_price: "<?php echo $this->lang->line('gkpos_dine_in_price_required') ?>",
                out_price: "<?php echo $this->lang->line('gkpos_dine_in_price_required') ?>",
                deal: "Please choose one of the deals"
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
    function editmenuselcell(field) {
        
        $.fn.editable.defaults.mode = 'inline';
        $('#' + field).editable({
            source: function () {
                if (field.includes("status")) {
                    return [
                        {value: 1, text: '<?php echo $this->lang->line('gkpos_active') ?>'},
                        {value: 2, text: '<?php echo $this->lang->line('gkpos_inactive') ?>'},
                        {value: 3, text: '<?php echo $this->lang->line('gkpos_deleted') ?>'}
                    ]
                }
                if (field.includes("online")) {
                    return [
                        {value: 1, text: '<?php echo $this->lang->line('gkpos_yes') ?>'},
                        {value: 0, text: '<?php echo $this->lang->line('gkpos_no') ?>'}
                    ]
                }
                if (field.includes("bogo")) {
                    return [
                        {value: 1, text: '<?php echo $this->lang->line('gkpos_yes') ?>'},
                        {value: 0, text: '<?php echo $this->lang->line('gkpos_no') ?>'}
                    ]
                }
            }
        });
    }
    function savemenuselection(formId, menuIdToCheck, idToCheckSpecial) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        $('#GkposAjaxPageLoader').toggle('slow');
                    },
                    success: function (response) {
                        $('#GkposAjaxPageLoader').toggle('slow');
                        if (response.success) {
                            var msg = response.message + ' ' + 'Please Click on Refresh Button left to see action';
                            ALERT_TITLE = "Success!";
                            alert(msg);
                        } else {
                            ALERT_TITLE = "Error!";
                            alert(response.message);
                        }
                    },
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                title: "required",
                base_price: {
                    number: true,
                    required: function () {
                        var idToCheckTest = $("#" + menuIdToCheck).is(":checked");
                        var idToCheckSpecialTest = $("#" + idToCheckSpecial).is(":checked");
                        return !idToCheckTest && !idToCheckSpecialTest;
                    }
                },
                in_price: {
                    number: true,
                    required: function (element) {
                        var idToCheckSpecialTest = $("#" + idToCheckSpecial).is(":checked");
                        var idToCheckTest = $("#" + menuIdToCheck).is(":checked");
                        return !idToCheckSpecialTest && idToCheckTest;
                    }
                },
                out_price: {
                    number: true,
                    required: function (element) {
                        var idToCheckSpecialTest = $("#" + idToCheckSpecial).is(":checked");
                        var idToCheckTest = $("#" + menuIdToCheck).is(":checked");
                        return !idToCheckSpecialTest && idToCheckTest;
                    }
                },
                deal: {
                    number: true,
                    required: function (element) {
                        var idToCheckSpecialTest = $("#" + idToCheckSpecial).is(":checked");
                        var idToCheckTest = $("#" + menuIdToCheck).is(":checked");
                        return idToCheckSpecialTest && !idToCheckTest;
                    }
                }
            },
            messages: {
                title: "<?php echo $this->lang->line('gkpos_menu_selection_title_rquired') ?>",
                base_price: "<?php echo $this->lang->line('gkpos_menu_selection_price_rquired') ?>",
                in_price: "<?php echo $this->lang->line('gkpos_selection_dine_in_price_required') ?>",
                out_price: "<?php echo $this->lang->line('gkpos_selection_dine_out_price_required') ?>",
                deal: "Please choose one of the deals"
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
</script>