<?php $status = array('Inactive', 'Active') ?>
<?php $status_color = array('color:#FF9900;', 'color:#219921;') ?>
<div class="col-lg-10 col-md-10 col-sm-10 col-xs-10 bodyitem" id="menuManagerBody">
    <div class="row no-padding">
        <fieldset>
            <div class="modal-header">Add a Topping to a Category</div>
            <?php echo form_open('gkpos/menumanagement/save_toppings', array('class' => 'form-horizontal', 'id' => 'toppingsForm')) ?>
            <?php if (isset($thisTopping)): ?>
                <input type="hidden" name="id" value="<?php echo $thisTopping[0]->id ?>">
            <?php endif; ?>

            <div class="col-sm-3">
                <div class="form-group form-group-sm" style="margin:0">
                    <?php echo form_label('Name', 'title', array('class' => 'control-label text-capitalize')); ?>
                    <div class="input-group">
                        <span class="input-group-addon" style="background-color: #FF0000;"><a href="#"><i class="fa fa-table" aria-hidden="true"></i></a></span>
                        <input tabindex="1" data-error="#toppingsFormTitleError" name="title" class="form-control"  type="text" id="title" value="<?php isset($thisTopping) ? print $thisTopping[0]->title : print'' ?>">
                    </div>
                </div>
                <div id="toppingsFormTitleError"></div>
            </div>
            <div class="col-sm-3">
                <div class="form-group form-group-sm" style="margin: 0">
                    <?php echo form_label($this->lang->line('gkpos_price'), 'price', array('class' => 'control-label text-capitalize')); ?>
                    <div class="input-group">
                        <span class="input-group-addon" style="background-color: #FF0000;"><a href="#"><i class="fa fa-table" aria-hidden="true"></i></a></span>
                        <input tabindex="2" data-error="#toppingsFormPriceError" name="price" class="form-control required"  type="text" id="price" value="<?php isset($thisTopping) ? print $thisTopping[0]->price : print'' ?>">
                    </div>
                </div>
                <div id="toppingsFormPriceError"></div>
            </div>
            <div class="col-sm-3">
                <div class="form-group form-group-sm" style="margin: 0">
                    <label for="radio-inline" class="control-label text-uppercase"><?php echo $this->lang->line('gkpos_status') ?></label>
                    <div>
                        <label tabindex="3" class="radio-inline text-capitalize"><input data-error="#toppingsFormStatusError" type="radio" name="status" value="1" <?php (isset($thisTopping) && $thisTopping[0]->status == "1") ? print "checked" : '' ?> ><?php echo $this->lang->line('gkpos_active') ?></label>
                        <label tabindex="4" class="radio-inline text-capitalize"><input data-error="#toppingsFormStatusError" type="radio" name="status" value="0" <?php (isset($thisTopping) && $thisTopping[0]->status == "0") ? print "checked" : '' ?> ><?php echo $this->lang->line('gkpos_inactive') ?></label>
                        &nbsp;&nbsp;&nbsp;
                        <?php
                        echo form_submit(array(
                            'name' => 'submit_form',
                            'id' => 'submit_form',
                            'tabindex' => "4",
                            'value' => $this->lang->line('gkpos_numpad_key_enter'),
                            'class' => 'btn btn-sm btn-danger'));
                        ?>
                    </div>
                    <div id="toppingsFormStatusError"></div>
                </div>
            </div>
            <?php echo form_close() ?>
        </fieldset>
    </div>
    <div class="row no-padding">
        <fieldset>
            <table class="table table-bg-color">
                <tr class="text-center">
                    <th class="text-center">Title</th>
                    <th class="text-center">Price</th>
                    <th class="text-center">Edit</th>
                    <th class="text-center">Delete</th>
                </tr>
                <?php if (!empty($toppings)): ?>
                    <?php foreach ($toppings as $atopping): ?>
                        <tr class="table-bg-color-white text-center">
                            <td><?php echo $atopping->title ?></td>
                            <td><?php echo to_currency($atopping->price) ?></td>
                            <td style="cursor: pointer" onclick="getMenumanagementPage('<?php echo site_url('gkpos/menumanagement/toppings/' . $atopping->id) ?>', '<?php echo $this->lang->line("gkpos_system_topping") ?>')">Edit</td>
                            <td style="cursor: pointer" onclick="deleteTopping('<?php echo $atopping->id ?>')">Delete</td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr class="table-bg-color-white text-center">
                        <td colspan="4">No Toppings created yet</td>
                    </tr>
                <?php endif; ?>
            </table>
        </fieldset>
    </div>    
</div>
<script>
    $(document).ready(function (){
        addjqueryValidatorFunction();
        $('#toppingsForm').validate({
            submitHandler: function () {
                var myform = document.getElementById('toppingsForm');
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#toppingsForm').attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            getMenumanagementPage('<?php echo site_url('gkpos/menumanagement/toppings') ?>', 'Toppings');
                        } else {
                            alert(response.message);
                        }
                    },
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                title: {required: true},
                status: "required",
                price: {number: true, required: true},
            },
            messages: {
                title: "Toppings name is a required field",
                status: "Check status, active or in active",
                price: "Please provide price of the topping"

            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    });

    function deleteTopping(id) {
        
        $.ajax({
            url: '<?php echo site_url('gkpos/menumanagement/delete_atopping') ?>',
            type: 'POST',
            data: {
                id: id
            },
            dataType: 'json',
            success: function (output) {
                if (output.success) {
                    getMenumanagementPage('<?php echo site_url('gkpos/menumanagement/toppings') ?>');
                } else {
                    alert(output.message);
                }
            }
        });
    }
</script>