<?php $reviewStatus = array('Pending', 'Approved', 'Disapproved') ?>
<div class="col-lg-10 col-md-10 col-sm-10 col-xs-10 bodyitem no-padding">
    <div  style="padding-top:15px;">
        <div class="row voucher-list" style="margin: 10px">
            <div class="modal-header">
                <div class="page-title col-md-12"><?php echo 'Customer Review' ?></div>
            </div>
            <div class="clearfix"></div>
            <table class="table table-responsive table-bordered">
                <tr>
                    <th class="text-capitalize">Customer</th> 
                    <th class="text-capitalize">Rating</th> 
                    <th style="width: 50%" class="text-capitalize">Message</th> 
                    <th class="text-capitalize">Status</th> 
                    <th class="text-capitalize"><?php echo $this->lang->line('gkpos_action') ?></th> 
                </tr>
                <?php if (!empty($reviews)): ?>
                    <?php foreach ($reviews as $areview): ?> 
                        <tr>
                            <td><?php echo get_customer_name($areview->customer) ?></td> 
                            <td>
                                <small> 
                                    <?php $rating = $areview->rating ?>
                                    <?php for ($i = 1; $i <= 5; $i++): ?>
                                        <span class="glyphicon <?php $i <= $rating ? print'glyphicon-star star-active' : print 'glyphicon-star-empty' ?> "></span>
                                    <?php endfor; ?>
                                </small>
                            </td> 
                            <td><?php echo $areview->message ?></td>
                            <td><?php echo $reviewStatus[$areview->status]; ?></td>
                            <td>
                                <a href='javascript:void(0)' onclick="updateReview('<?php echo $areview->id ?>', '<?php echo site_url('gkpos/online/update_review') ?>', '<?php ($areview->status == 0 || $areview->status == 2) ? print'approve' : print'disapprove' ?>')"><?php ($areview->status == 0 || $areview->status == 2) ? print'Approve' : print'Disapprove' ?></a>
                                |
                                <a href='javascript:void(0)' onclick="updateReview('<?php echo $areview->id ?>', '<?php echo site_url('gkpos/online/update_review') ?>', 'delete')">Delete</a> 
                            </td> 
                        </tr>
                    <?php endforeach; ?>
                    <?php if ($ajaxpages > 1): ?>   
                        <tr>
                            <td colspan="4">
                                <ul class="pagination">
                                    <?php for ($i = 0; $i < $ajaxpages; $i++): ?>
                                        <li <?php $i === $segment ? print "class='active'" : "" ?>><a href="javascript:void(0)" onclick="getOnlineSettingPage('<?php echo site_url('gkpos/online/listreviews/' . $i) ?>', 'listreviews')"><?php echo $i + 1 ?></a></li>
                                    <?php endfor; ?>
                                </ul> 
                            </td>
                        </tr>
                    <?php endif; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="4">No Reviews Found</td> 
                    </tr>
                <?php endif; ?>
            </table>                        
        </div>
    </div>
</div>
<script>
    function updateReview(review_id, url, action) {
        $.ajax({
            url: url,
            data: {
                id: review_id,
                action: action
            },
            type: "POST",
            success: function (output) {
                getSettingPage('<?php echo site_url("gkpos/online/listreviews") ?>', 'Online - Review');
            }
        });
    }
</script>