<div class="menu guest-table">
    <div class="iteammenubg">
        <h2><?php $order_info->order_type == 'table' ? print $this->lang->line('gkpos_table_information') : print $this->lang->line('gkpos_customer_information') ?></h2>
        <table class="table-no-bordered">
            <tr>
                <td><?php echo '#OrderID' ?></td>
                <td class="text-capitalize"><?php echo $order_info->id ?></td>
            </tr>
            <tr>
                <td><?php echo $this->lang->line('gkpos_order_type') ?></td>
                <td class="text-capitalize"><?php echo $order_info->order_type ?>&nbsp;&nbsp;<?php ($order_info->switched_from != null && $order_info->order_type != 'table' ) ? print ' (' . $order_info->switched_from . ')' : '' ?></td>
            </tr>
            <?php if ($order_info->order_type == 'table'): ?>
                <tr>
                    <td class="text-capitalize" ><?php echo $this->lang->line('gkpos_table_number') ?></td>
                    <td class="text-capitalize"><?php echo $order_info->table_number ?>&nbsp;&nbsp;<?php ($order_info->switched_from != null && $order_info->switched_from > 0) ? print ' (' . $order_info->switched_from . ')' : '' ?></td>
                </tr>
                <tr>
                    <td class="text-capitalize"><?php echo $this->lang->line('gkpos_table_guest_quantity') ?></td>
                    <td class="text-capitalize"><?php echo $order_info->guest_quantity ?></td>
                </tr>
            <?php else: ?>
                <?php if ($order_info->name != null): ?>
                    <tr>
                        <td class="text-capitalize"><?php echo $this->lang->line('gkpos_name') ?></td>
                        <td class="text-capitalize"><?php echo $order_info->name ?></td>
                    </tr>
                <?php endif; ?>
                <?php if ($order_info->phone != null): ?>
                    <tr>
                        <td class="text-capitalize"><?php echo $this->lang->line('gkpos_phone') ?></td>
                        <td class="text-capitalize"><?php echo $order_info->phone ?></td>
                    </tr>
                <?php endif; ?>
                <?php if ($order_info->floor_or_apt != null): ?>
                    <tr>
                        <td class="text-capitalize"><?php echo $this->lang->line('gkpos_floor_or_apt_no') ?></td>
                        <td class="text-capitalize"><?php echo $order_info->floor_or_apt ?></td>
                    </tr>
                <?php endif; ?>
                <?php if ($order_info->building != null): ?>
                    <tr>
                        <td class="text-capitalize"><?php echo $this->lang->line('gkpos_building') ?></td>
                        <td class="text-capitalize"><?php echo $order_info->building ?></td>
                    </tr>
                <?php endif; ?>
                <?php if ($order_info->house != null): ?>
                    <tr>
                        <td class="text-capitalize"><?php echo $this->lang->line('gkpos_house') ?></td>
                        <td class="text-capitalize"><?php echo $order_info->house ?></td>
                    </tr>
                <?php endif; ?>
                <?php if ($order_info->street != null): ?>
                    <tr>
                        <td class="text-capitalize"><?php echo $this->lang->line('gkpos_street') ?></td>
                        <td class="text-capitalize"><?php echo $order_info->street ?></td>
                    </tr>
                <?php endif; ?>
                <?php if ($order_info->postcode != null): ?>
                    <tr>
                        <td class="text-capitalize"><?php echo $this->lang->line('gkpos_postal_code') ?></td>
                        <td class="text-capitalize"><?php echo $order_info->postcode ?></td>
                    </tr>
                <?php endif; ?>
            <?php endif ?>

            <tr>
                <td><?php $order_info->order_type == 'table' ? print $this->lang->line('gkpos_table_guest_seated_time') : print 'Created At' ?></td>
                <?php $seated_time = explode(' ', $order_info->created) ?>
                <td><?php echo date('h:i:s a', strtotime($seated_time[1])); ?>&nbsp;-&nbsp;<?php echo get_user_name($order_info->created_by) ?></td>
            </tr>
            <tr>
                <td><?php echo $this->lang->line('gkpos_table_first_order_taken') ?></td>
                <?php $first_taken_arr = $first_taken != '' ? explode(' ', $first_taken) : array('', '') ?>
                <td>
                    <?php $first_taken_arr[1] != '' ? print date('h:i:s a', strtotime($first_taken_arr[1])) : print $this->lang->line('gkpos_n_a') ?>&nbsp;<?php $first_taken_by != null ? print "-&nbsp;" . trim(get_user_name($first_taken_by)) : '' ?>
                </td>
            </tr>
            <tr>
                <td><?php echo $this->lang->line('gkpos_table_last_order_taken') ?></td>
                <?php $last_taken_arr = $last_taken != '' ? explode(' ', $last_taken) : array('', '') ?>
                <td><?php $last_taken_arr[1] !== '' ? print date('h:i:s a', strtotime($last_taken_arr[1])) : print $this->lang->line('gkpos_n_a') ?>&nbsp;<?php $last_taken_by != null ? print "-&nbsp;" . trim(get_user_name($last_taken_by)) : '' ?></td>
            </tr>
            <?php if ($order_info->delivery_time != null): ?>
                <tr>
                    <td><?php $order_info->order_type == 'collection' ? print $this->lang->line('gkpos_collection_time') : print $this->lang->line('gkpos_delivery_time') ?></td>
                    <td><?php print date('h:i:s a', strtotime($order_info->delivery_time)) ?></td>
                </tr>
            <?php endif; ?>
            <tr>
                <td><?php echo $this->lang->line('gkpos_bill_printed') ?></td>
                <td><?php $order_info->bill_printed == 1 ? print $this->lang->line('gkpos_yes') : print $this->lang->line('gkpos_no') ?></td>
            </tr>
            <tr>
                <td><?php echo "Send Kitchen?"; //debugPrint($order_info)                                                                                                                                                                               ?></td>
                <td><?php $order_info->has_print == 0 && $order_info->is_printed == 1 ? print $this->lang->line('gkpos_yes') : print $this->lang->line('gkpos_no') ?></td>
            </tr>
            <tr>
                <td colspan="2" style="padding: 0px;">
                    <?php if ($order_info->order_type == 'table'): ?>
                        <a href="javascript:void(0)" class="btn btn-block btn-sm btn-danger gradient off-click" onclick="openPopupBox('shifTable', 'noForm')">Shift Table</a>
                    <?php endif; ?>
                    <a href="javascript:void(0)" class="btn btn-block btn-sm btn-info gradient off-click" onclick="showCustomerUpdateForm()">Update Information</a>
                </td>
            </tr>

        </table>
    </div>
</div>
<div id="shifTable" class="modal modal-message modal-danger fade" style="display: none;" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <div class="modal-title">
                    <div class="col-lg-11 col-md-11 col-sm-11">Shifting Table</div>
                    <div class="col-lg-1 col-md-1 col-sm-1 close" data-dismiss="modal" aria-label="Close" style="cursor: default"><i class="fa fa-close" aria-hidden="true"></i></div>
                </div>
            </div>
            <div class="modal-body">
                <form class="form-horizontal" id="gkposTableShiftForm">
                    <div class="pin-calculatorbg collection-pin-calculatorbg">
                        <div id="TableNumber">
                            <input type="hidden" name="order_id" value="<?php echo $order_info->id ?>">
                            <input type="text" id="table_number" name="table_number" class="form-control" placeholder="<?php echo $this->lang->line('gkpos_table') ?>&nbsp;<?php echo $this->lang->line('gkpos_number') ?>">
                            <input type="hidden" id="existing_table_number" name="existing_table_number" value="<?php echo $order_info->table_number; ?>">
                            <ul>
                                <li class="numkey"><?php echo $this->lang->line('gkpos_numpad_key1') ?></li>
                                <li class="numkey"><?php echo $this->lang->line('gkpos_numpad_key2') ?></li>
                                <li class="numkey"><?php echo $this->lang->line('gkpos_numpad_key3') ?></li>
                            </ul>
                            <ul>
                                <li class="numkey"><?php echo $this->lang->line('gkpos_numpad_key4') ?></li>
                                <li class="numkey"><?php echo $this->lang->line('gkpos_numpad_key5') ?></li>
                                <li class="numkey"><?php echo $this->lang->line('gkpos_numpad_key6') ?></li>
                            </ul>
                            <ul>
                                <li class="numkey"><?php echo $this->lang->line('gkpos_numpad_key7') ?></li>
                                <li class="numkey"><?php echo $this->lang->line('gkpos_numpad_key8') ?></li>
                                <li class="numkey"><?php echo $this->lang->line('gkpos_numpad_key9') ?></li>
                            </ul>
                            <ul>
                                <li class="btnPin"><?php echo $this->lang->line('gkpos_numpad_key_del') ?></li>
                                <li class="numkey"><?php echo $this->lang->line('gkpos_numpad_key0') ?></li>
                                <li class="btnPin"><?php echo $this->lang->line('gkpos_numpad_key_clr') ?></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <ul id="gkposTableFormErrorMsgBox" class="error_message_box"></ul>
                    </div>
                    <a href="javascript:void(0)" class="form-submit-button mainsystembg2 waiting-bg img-responsive delivery-info-submit-btn" onclick="shiftTable()"><?php echo $this->lang->line('gkpos_numpad_key_enter') ?></a>
                </form>
            </div>
        </div>
    </div>
</div>

<div id="CustomerForm" class="modal modal-message modal-danger fade" style="display: none;" aria-hidden="true">
    <div class="modal-dialog" style="left: 0%!important;  width: 90%!important; height: 95%">
        <div class="modal-content">
            <div class="modal-header">
                <div class="modal-title">
                    <div class="col-lg-11 col-md-11 col-sm-11">Add Customer</div>
                    <div class="col-lg-1 col-md-1 col-sm-1 close" data-dismiss="modal" aria-label="Close" style="cursor: default"><i class="fa fa-close" aria-hidden="true"></i></div>
                </div>
            </div>
            <div class="modal-body">
                <form class="form-horizontal" action="<?php echo site_url('gkpos/updateOrderedCustomerInfo') ?>" method="post" id="gkposCustomerForm">
                    <input type="hidden" name="id" value="<?php echo $order_info->id ?>">
                    <table class="table table-bordered">
                        <tr>
                            <td colspan="5"><span class="text-uppercase">Identity</span></td>
                        </tr>
                        <tr>
                            <?php if ($order_info->order_type != 'table'): ?>
                                <td class="text-left" colspan="2">Name: <input type="text" class="form-control" name="name" value="<?php echo $order_info->name ?>" autocomplete="off"></td>
                                <td class="text-left" colspan="2">Contact no: <input type="text" class="form-control" name="phone" value="<?php echo $order_info->phone ?>" autocomplete="off" readonly="true"></td>
                                <td class="text-left" colspan="1">Delivery Time: <input type="text" class="form-control timepicker" name="delivery_time" value="<?php echo date($this->config->item('timeformat'), strtotime($order_info->delivery_time)) ?>" autocomplete="off" id='deliveryTimepicker'></td>
                            <?php else: ?>
                                <td class="text-left" colspan="3">Table Number: <input type="text" class="form-control" name="table_number" value="<?php echo $order_info->table_number ?>" autocomplete="off" disabled="true"></td>
                                <td class="text-left" colspan="2">Guest Quantity: <input type="text" class="form-control" name="guest_quantity" value="<?php echo $order_info->guest_quantity ?>" autocomplete="off" id='guest_quantity2'></td>
                            <?php endif; ?>
                        </tr>
                        <?php if ($order_info->order_type == 'delivery'): ?>
                            <tr>
                                <td colspan="5">
                                    <span class="text-uppercase">
                                        Location Details
                                    </span>
                                    <div class="input-group" style="width: 100%">
                                        <span class="input-group-addon"><a href="#"><i class="fa fa-search" aria-hidden="true"></i></a></span>
                                        <input id="autocompleteGPlace" placeholder="Enter your address to complete location details" onFocus="geolocate()" type="text" class="form-control" autocomplete="off"/>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td class="text-left">Postal Code: <input type="text" class="form-control" name="postcode" id="postal_code" value="<?php echo $order_info->postcode ?>" autocomplete="off"></td>
                                <td class="text-left">Street: <input type="text" class="form-control field" name="street" id="route" value="<?php echo $order_info->street ?>" autocomplete="off"></td>
                                <td class="text-left">City: <input type="text" class="form-control field" name="city" id="locality" value="<?php echo $order_info->city ?>" autocomplete="off"></td>
                                <td class="text-left">state: <input type="text" class="form-control field" name="state" id="administrative_area_level_1" value="<?php echo $order_info->state ?>" autocomplete="off"></td>
                                <td class="text-left">Country: <input type="text" class="form-control" name="country" id="country" value="<?php echo $order_info->country ?>" autocomplete="off"></td>
                            </tr>
                            <tr>
                                <td colspan="5"><span class="text-uppercase">House Info (optional)</span></td>
                            </tr>
                            <tr>
                                <td class="text-left" colspan="1">House: <input type="text" class="form-control field" name="house" id="street_number" value="<?php echo $order_info->house ?>" autocomplete="off"></td>
                                <td class="text-left" colspan="2">Floor/Apartment: <input type="text" class="form-control" name="floor_or_apt" value="<?php echo $order_info->floor_or_apt ?>" autocomplete="off"></td>
                                <td class="text-left" colspan="2">Building: <input type="text" class="form-control" name="building" value="<?php echo $order_info->building ?>" autocomplete="off"></td>
                            </tr>
                        <?php endif; ?>
                        <tr><td colspan="5"> <input class="form-submit-button mainsystembg2 waiting-bg img-responsive delivery-info-submit-btn" type="submit" name="submit_form" value="<?php echo $this->lang->line('gkpos_finished') ?>" onclick="saveCustomerInfo('gkposCustomerForm')"></td></tr>
                    </table>
                </form>
                <?php if ($this->config->item('is_touch') == 'enable'): ?>
                    <?php if ($order_info->order_type == 'table'): ?>
                        <div class="pin-calculatorbg collection-pin-calculatorbg">
                            <div id="GuestQuantity">
                                <ul>
                                    <li class="numkey2"><?php echo $this->lang->line('gkpos_numpad_key1') ?></li>
                                    <li class="numkey2"><?php echo $this->lang->line('gkpos_numpad_key2') ?></li>
                                    <li class="numkey2"><?php echo $this->lang->line('gkpos_numpad_key3') ?></li>
                                </ul>
                                <ul>
                                    <li class="numkey2"><?php echo $this->lang->line('gkpos_numpad_key4') ?></li>
                                    <li class="numkey2"><?php echo $this->lang->line('gkpos_numpad_key5') ?></li>
                                    <li class="numkey2"><?php echo $this->lang->line('gkpos_numpad_key6') ?></li>
                                </ul>
                                <ul>
                                    <li class="numkey2"><?php echo $this->lang->line('gkpos_numpad_key7') ?></li>
                                    <li class="numkey2"><?php echo $this->lang->line('gkpos_numpad_key8') ?></li>
                                    <li class="numkey2"><?php echo $this->lang->line('gkpos_numpad_key9') ?></li>
                                </ul>
                                <ul>
                                    <li class="btnPin2"><?php echo $this->lang->line('gkpos_numpad_key_del') ?></li>
                                    <li class="numkey2"><?php echo $this->lang->line('gkpos_numpad_key0') ?></li>
                                    <li class="btnPin2"><?php echo $this->lang->line('gkpos_numpad_key_clr') ?></li>
                                </ul>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="main-keyboardbg">
                            <div id="virtualKeyboard"></div>
                        </div>
                    <?php endif; ?>
                <?php endif ?>
            </div>
        </div>
    </div>
</div>



<script>
    $(document).ready(function () {
        setnumkeys('table_number');
    });
    function showCustomerUpdateForm() {
        setnumkeys2('guest_quantity2');
        <?php if ($this->config->item('is_touch') == 'enable') { ?>
            keyboard('virtualKeyboard');
        <?php } ?>
        <?php if ($order_info->order_type == 'delivery') { ?>
            $.getScript('https://maps.googleapis.com/maps/api/js?key=<?php echo GOOGLE_API_KEY; ?>&libraries=places&callback=initAutocomplete', function (data, textStatus) {
                if (textStatus) {
                    console.log(textStatus);
                }
            });
        <?php } ?>
        $('#deliveryTimepicker').timepicker({
            'minTime': '5:00pm',
            'maxTime': '2:30am',
            'step': 5
        });
        $('#CustomerForm').modal({
            keyboard: false,
            backdrop: 'static',
            width: '700px',
            show: true
        });

    }
    function shiftTable() {
        if (Number($('#table_number').val()) > 0) {
            var exitingTable = Number($('#existing_table_number').val()) > 0 ? Number($('#existing_table_number').val()) : null;
            var newTable = Number($('#table_number').val()) > 0 ? Number($('#table_number').val()) : null;
            if (exitingTable === newTable) {
                alert('Please privide different value other than the existing table number');
            } else {
                var myform = document.getElementById('gkposTableShiftForm');
                var formdata = new FormData(myform);
                $.ajax({
                    url: '<?php echo site_url('gkpos/shift_table') ?>',
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (output) {
                        if (output.success) {
                            $('#shifTable').modal('hide');
                            alert(output.message);
                            getBaseAjaxPage('<?php echo site_url('gkpos/orders/indexajax/'); ?>' + output.order_id);
                        } else {
                            alert(output.message);
                        }
                    }
                });
            }
        } else {
            alert('Please supply new table number');
        }

    }
</script>
<style>
    .pac-container {
        z-index: 10000 !important;
    }
    .has-error{
        color: #FF0000;
    }
    #virtualKeyboard .button{
        width: 7.3%!important;
    }
    .ui-timepicker-wrapper {
        width: 15%;

    }
    .ui-timepicker-list li {
        background: #fff none repeat scroll 0 0;
        border: 1px solid #000;
        border-radius: 5px;
        color: #000;
        cursor: pointer;
        height: 50px;
        list-style: outside none none;
        margin: 5px;
        padding: 14px 0 3px 15px;
        white-space: nowrap;
    }
</style>
<?php if ($order_info->order_type == 'delivery'): ?>
    <script>
        var placeSearch, autocomplete;
        var componentForm = {
            street_number: 'short_name',
            route: 'long_name',
            locality: 'long_name',
            administrative_area_level_1: 'short_name',
            country: 'long_name',
            postal_code: 'short_name'
        };
        function initAutocomplete() {
            autocomplete = new google.maps.places.Autocomplete((document.getElementById('autocompleteGPlace')), {types: ['geocode']});
            autocomplete.addListener('place_changed', fillInAddress);
        }
        function fillInAddress() {
            var place = autocomplete.getPlace();
            for (var component in componentForm) {
                document.getElementById(component).value = '';
                document.getElementById(component).disabled = false;
            }
            for (var i = 0; i < place.address_components.length; i++) {
                var addressType = place.address_components[i].types[0];
                if (componentForm[addressType]) {
                    var val = place.address_components[i][componentForm[addressType]];
                    document.getElementById(addressType).value = val;
                }
            }
        }
        function geolocate() {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function (position) {
                    var geolocation = {
                        lat: position.coords.latitude,
                        lng: position.coords.longitude
                    };
                    var circle = new google.maps.Circle({
                        center: geolocation,
                        radius: position.coords.accuracy
                    });
                    autocomplete.setBounds(circle.getBounds());
                });
            }
        }
    </script>
<?php endif; ?>
<script>
    function saveCustomerInfo(formId) {
        
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (output) {
                        if (output.success) {
                            $('#CustomerForm').modal('hide');
                            getBaseAjaxPage('<?php echo site_url('gkpos/orders/indexajax/'); ?>' + output.order_id);
                        } else {
                            alert(output.message);
                        }
                    },
                });
            },
            errorClass: "has-error",
            wrapper: "li",
            highlight: function (e) {
                $(e).closest('td').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('td').removeClass('has-error');
            },
            rules: {
                name: "<?php $order_info->order_type != 'table' ? print'required' : print'' ?>",
                phone: "<?php $order_info->order_type != 'table' ? print'required' : print'' ?>",
                street: "<?php $order_info->order_type != 'table' ? print'required' : print'' ?>",
                postcode: "<?php $order_info->order_type != 'table' ? print'required' : print'' ?>",
                table_number: "<?php $order_info->order_type != 'table' ? print'' : print'required' ?>",
                guest_quantity: "<?php $order_info->order_type != 'table' ? print'' : print'required' ?>"
            },
            messages: {
                name: "<?php echo $this->lang->line('gkpos_valid_name_required') ?>",
                phone: "<?php echo $this->lang->line('gkpos_valid_phone_required') ?>",
                street: "<?php echo $this->lang->line('gkpos_customer_street_required') ?>",
                postcode: "<?php echo $this->lang->line('gkpos_customer_postcode_required') ?>",
                table_number: "<?php echo $this->lang->line('gkpos_table_number_required') ?>",
                guest_quantity: "<?php echo $this->lang->line('gkpos_table_guest_quantity_required') ?>",
            }
        });
    }
</script>
