<?php $status = array('Inactive', 'Active', 'Deleted', 'Wating For Online Payment') ?>
<?php $status_color = array('color:#FF9900;', 'color:#219921;', 'color:#D52229;', 'color:#FF9900;') ?>
<fieldset style="margin-top:0px; margin-bottom: 0px; padding-bottom: 0px; border-radius: 0px 0px 10px 10px">
    <div class="row report-row">
        <div id="entireReport">
            <table class="table table-responsive table-bordered" id="reportTableContent">
                <tr class="table-bg-color">
                    <th class="text-center text-capitalize">Phone#</th>
                    <th class="text-center text-capitalize">Name</th>
                    <th class="text-center text-capitalize">Email</th>
                    <th class="text-center text-capitalize">Address</th>
                    <th class="text-center text-capitalize">Status</th>
                    <th class="text-center text-capitalize">Verified</th>
                    <th class="text-center text-capitalize">Edit</th>
                </tr>
                <?php if (!empty($customers)): ?>
                    <?php foreach ($customers as $obj): ?>
                        <tr class="table-bg-color-white table-content">
                            <td class="text-center text-capitalize"><?php echo $obj->phone ?></td>
                            <td class="text-center text-capitalize"><?php echo $obj->name ?></td>
                            <td class="text-center"><?php echo $obj->email ?></td>
                            <?php
                            $billAddressString = '';
                            $billAddressString .= $obj->street != null ? $obj->street . ', ' : '';
                            $billAddressString .= $obj->city != null ? $obj->city . ', ' : '';
                            $billAddressString .= $obj->postcode;
                            ?>
                            <td class="text-center text-capitalize"><?php echo $billAddressString ?></td>
                            <td class="text-center text-capitalize">
                                <a href="javascript:void(0)" style="<?php echo $status_color[3] ?>" onclick="editCustomer('<?php echo"status_" . $obj->phone ?>')" data-type="select" id="status_<?php echo $obj->phone ?>" data-name="status" data-pk="<?php echo $obj->phone ?>" data-url="<?php echo site_url('gkpos/report/update_customer') ?>" data-value="<?php echo $obj->status ?>" data-title="<?php echo $this->lang->line('gkpos_update_status') ?>">
                                    <span style="<?php echo $status_color[$obj->status] ?>"><?php echo $status[$obj->status] ?></span>
                                </a>
                            </td>
                            <td class="text-center text-capitalize">
                                <a href="javascript:void(0)" style="color: #000000" onclick="editCustomer('<?php echo"verified_" . $obj->phone ?>')" data-type="select" id="verified_<?php echo $obj->phone ?>" data-name="is_verified" data-pk="<?php echo $obj->phone ?>" data-url="<?php echo site_url('gkpos/report/update_customer') ?>" data-value="<?php echo $obj->is_verified ?>" data-title="<?php echo $this->lang->line('gkpos_update_status') ?>">
                                    <span><?php $obj->is_verified == 1 ? print'Yes' : print 'No' ?></span>
                                </a>
                            </td>
                            <td class="text-center text-capitalize">
                                <a style="color: #000000" href="javascript:void(0)" onclick="addCustomer('<?php echo $obj->phone ?>')">Edit</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="8">No Customers Found</td></tr>
                <?php endif; ?>
            </table>
            <div class="clearfix pages-height"></div>
        </div>
    </div>
</fieldset>
<script>
    $(document).ready(function () {
        $("#name").autocomplete({
            delay: 0,
            source: '<?php echo site_url('gkpos/get_customer') ?>',
            minLength: 2
        });
        $("#phone").autocomplete({
            delay: 0,
            source: '<?php echo site_url('gkpos/get_customer_phone') ?>',
            minLength: 4
        });
        $("#city").autocomplete({
            delay: 0,
            source: '<?php echo site_url('gkpos/get_customer_city') ?>',
            minLength: 0
        });
        $("#postcode").autocomplete({
            delay: 0,
            source: '<?php echo site_url('gkpos/get_customer_postcode') ?>',
            minLength: 2
        });
        $(".date_filter").datepicker({
            dateFormat: "dd/mm/yy"
        });
        $(".closeWarningPopup").click(function () {
            $.colorbox.close();
            return false;
        });
        $('.closeServiceChargePopup').click(function () {
            $.colorbox.close();
            return false;
        });
    });
    function filterReport() {
        $('#customerReportFilterForm').validate({
            submitHandler: function () {
                var myform = document.getElementById('customerReportFilterForm');
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#customerReportFilterForm').attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    success: function (response) {
                        $("#filterContent3").html(response)
                    }
                });
            }
        });
    }
    function editCustomer(field) {
        
        $.fn.editable.defaults.mode = 'inline';
        $('#' + field).editable({
            source: function () {
                if (field.includes("status")) {
                    return [
                        {value: 1, text: '<?php echo $this->lang->line('gkpos_active') ?>'},
                        {value: 0, text: '<?php echo $this->lang->line('gkpos_inactive') ?>'},
                        {value: 2, text: '<?php echo $this->lang->line('gkpos_deleted') ?>'}
                    ]
                }

                if (field.includes("verified")) {
                    return [
                        {value: 0, text: '<?php echo $this->lang->line('gkpos_no') ?>'},
                        {value: 1, text: '<?php echo $this->lang->line('gkpos_yes') ?>'}
                    ]
                }
            }
        });
    }
</script>