<div class="col-lg-10 col-md-10 col-sm-10 col-xs-10 bodyitem">
    <div class="row no-padding">
        <fieldset>
            <table class="table table-bg-color table-responsive table-bordered">
                <caption>Occupied/Locked Table</caption>
                <tr>
                    <th class="text-center">Table Number</th>
                    <th class="text-center">Guest Quantity</th>
                    <th class="text-center">Status</th>
                    <th class="text-center">Order At</th>
                    <th class="text-center">Vacant Now</th>
                    <?php if ($this->session->userdata('gkpos_usertype') == 1): ?>
                        <th class="text-center"><a  href="javascript:void(0)" style="width: 130px" class="btn btn-sm btn-danger" onclick="vacantTable('gkpos_table', '<?php echo site_url('gkpos/report/vacant_table') ?>', '<?php echo site_url('gkpos/settings/engaged_table') ?>', '0')">Vacant All Tables</a></th>
                    <?php else: ?>
                        <th>&nbsp;</th>
                    <?php endif; ?>
                </tr>
                <?php if (!empty($lockedOrders)): ?>
                    <?php foreach ($lockedOrders as $lOrder): ?>
                        <tr>
                            <td class="text-center"><?php echo $lOrder->table_number ?></td>
                            <td class="text-center"><?php echo $lOrder->guest_quantity ?></td>
                            <td class="text-center"><?php echo $lOrder->is_vacant == 2 ? 'Engaged' : 'Vacant'?></td>
                            <td class="text-center"><?php echo $lOrder->modified ?></td>
                            <td class="text-center"><i class="fa fa-lock fa-2x" onclick="vacantTable('gkpos_table', '<?php echo site_url('gkpos/report/vacant_table') ?>', '<?php echo site_url('gkpos/settings/engaged_table') ?>',<?php echo $lOrder->id ?>)"></i></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="3">No Engaged Table Found</td></tr>
                <?php endif; ?>
            </table>
        </fieldset>
    </div>
</div>
<script>
    $(document).ready(function () {
        manageWindowHeight();
    });
    function vacantTable(table, url, targetUrl, id) {
        $.confirm({
            'title': 'Vacant Table Warning',
            'message': 'Are you sure? you need to vacant the table',
            'buttons': {
                'YES': {
                    'class': 'btn btn-danger btn-sm',
                    'action': function () {
                        $.ajax({
                            url: url,
                            data: {
                                table: table,
                                id: id
                            },
                            type: "POST",
                            dataType: 'json',
                            success: function (output) {
                                if (output.success) {
                                    getSettingPage(targetUrl, '');
                                } else {
                                    alert(output.message);
                                }
                            }
                        });
                    }
                },
                'NO': {
                    'class': 'btn btn-success btn-sm',
                    'action': function () {}
                }
            }
        });
    }
</script>
