<div class="col-lg-10 col-md-10 col-sm-10 col-xs-10 bodyitem">
    <div class="row no-padding">
        <div style="width: 97%; margin: 0 auto">
            <input type="checkbox" class="checkbox-inline" id="showHideAddExpense" onclick="checkBlock(this.id, 'AddNewExpenseBox')">
            <span style="color: #FFF"><?php echo $this->lang->line('gkpos_add_new_expense') ?></span>
            <div class="clearfix" id="AddNewExpenseBox">
                <?php echo form_open('gkpos/settings/save_expense/', array('id' => 'expense_form', 'enctype' => 'multipart/form-data', 'class' => 'form-horizontal')); ?>
                <fieldset>
                    <input type="hidden" id="giftcard_id" name="id">
                    <div class="form-group form-group-sm">	
                        <?php echo form_label($this->lang->line('gkpos_expense_type'), 'expense_type', array('class' => 'control-label col-lg-4 col-md-4 col-sm-4 col-xs-4 text-uppercase required')); ?>
                        <div class="col-lg-8 col-md-8 col-sm-4 col-xs-8">
                            <div class="input-group">
                                <span class="input-group-addon" style="background-color: #FF0000;"><a href="#"><i class="fa" aria-hidden="true"><?php echo $this->config->item('currency_symbol') ?></i></a></span>
                                <input name="type" class="form-control required"  type="text" id="expense_type" value="<?php isset($type) ? print $type : print'' ?>"  style="width: 93%">
                            </div>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                    <div class="col-lg-offset-4 col-md-offset-4 col-sm-offset-4 col-xs-offset-4 col-lg-8 col-md-8 col-sm-8 col-xs-8">
                        <table>

                            <tr>
                                <td><?php echo form_label($this->lang->line('gkpos_total'), 'expense_total', array('class' => 'control-label text-capitalize col-md-2')) ?></td>
                                <td><div class="input-group"> <span class="input-group-addon" style="background-color: #FF0000;"><a href="#"><i class="fa" aria-hidden="true"><?php echo $this->config->item('currency_symbol') ?></i></a></span><input name="total" class="form-control required col-md-4 input-sm"  type="text" id="expense_total" value="<?php isset($type) ? print $type : print'' ?>"> </div></td>
                                <td> <?php echo form_label($this->lang->line('gkpos_vat'), 'expense_vat', array('class' => 'control-label text-capitalize col-md-2')) ?></td>
                                <td><div class="input-group"> <span class="input-group-addon" style="background-color: #FF0000;"><a href="#"><i class="fa" aria-hidden="true"><?php echo $this->config->item('currency_symbol') ?></i></a></span><input name="vat" class="form-control required col-md-4 input-sm"  type="text" id="expense_vat" value="<?php isset($type) ? print $type : print'' ?>"></div></td>
                            </tr>

                        </table>
                    </div>
                    <div class="form-group form-group-sm" style="padding-top:40px; ">	
                        <label for="radio-inline" class="col-lg-offset-4 col-md-offset-4 col-sm-offset-4 col-xs-offset-3 col-lg-3 col-md-3 col-sm-3 col-xs-3 control-label text-uppercase required"><?php echo $this->lang->line('gkpos_cash_from_till') ?></label>
                        <div class="col-lg-3 col-md-3 col-sm-3 col-xs-3">
                            <label class="radio-inline text-uppercase required"><input type="radio" name="cash_from_till" id="gk_discount_applied1" value="yes" ><?php echo $this->lang->line('gkpos_yes') ?></label>
                            <label class="radio-inline text-uppercase required"><input type="radio" name="cash_from_till" id="gk_discount_applied2" value="no"  ><?php echo $this->lang->line('gkpos_no') ?></label>
                        </div>
                    </div>
                    <div id="AleternativeOption" style="display: none">
                        <div class="form-group form-group-sm">	
                            <?php echo form_label($this->lang->line('gkpos_alternatives'), 'alternatives', array('class' => 'control-label col-lg-4 col-md-4 col-sm-4 col-xs-4 text-uppercase required')); ?>
                            <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                <label class="radio-inline text-uppercase required"><input type="radio" name="other" id="alternative1" value="cash" ><?php echo $this->lang->line('gkpos_payment_cash') ?></label>
                                <label class="radio-inline text-uppercase required"><input type="radio" name="other" id="alternative2" value="eft"  ><?php echo $this->lang->line('gkpos_payment_card') ?></label>
                                <label class="radio-inline text-uppercase required"><input type="radio" name="other" id="alternative3" value="cheque"  ><?php echo $this->lang->line('gkpos_payment_cheque') ?></label>
                            </div>
                        </div>
                    </div>

                    <div class="margin-bottom:20px">&nbsp;</div>
                    <div class="form-group form-group-md">	
                        <div class="col-md-offset-4 col-md-8">
                            <ul id="expense_form_error_message_box" class="error_message_box"></ul>
                            <?php
                            echo form_submit(array(
                                'name' => 'submit_form',
                                'id' => 'submit_form',
                                'value' => $this->lang->line('gkpos_numpad_key_enter'),
                                'class' => 'btn btn-block btn-danger round btn-sm'));
                            ?>
                        </div>
                    </div>
                </fieldset>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <script type='text/javascript'>
        $(document).ready(function () {
            keyboard('clientsCTA1');
            keyboard('clientsCTA');
            $("#expense_type").autocomplete({
                delay: 0,
                source: '<?php echo site_url('gkpos/settings/get_expensetype') ?>',
                minLength: 1
            });
            $('input[type=radio][name=cash_from_till]').change(function () {
                if (this.value == 'no') {
                    $('#AleternativeOption').show();
                } else {
                    $('#AleternativeOption').hide();
                }
            });
            $('#expense_form').validate({
                submitHandler: function () {
                    var myform = document.getElementById('expense_form');
                    var formdata = new FormData(myform);
                    $.ajax({
                        url: $('#expense_form').attr('action'),
                        data: formdata,
                        cache: false,
                        processData: false,
                        contentType: false,
                        type: 'POST',
                        dataType: 'json',
                        success: function (response) {
                            if (response.success) {
                                getSettingPage('<?php echo site_url('gkpos/settings/expense') ?>', 'Expense');
                            } else {
                                ALERT_TITLE = "Error!";
                                alert(response.message);
                            }
                        }
                    });
                },
                errorClass: "has-error",
                errorLabelContainer: "#expense_form_error_message_box",
                wrapper: "li",
                highlight: function (e) {
                    $(e).closest('.form-group').addClass('has-error');
                },
                unhighlight: function (e) {
                    $(e).closest('.form-group').removeClass('has-error');
                },
                rules: {
                    type: {
                        lettersonly: true,
                        required: true
                    },
                    total: {
                        number: true,
                        required: true
                    },
                    vat: {
                        number: true,
                        required: true
                    },
                    cash_from_till: "required",
                },
                messages: {
                    type: "Please specify Expense Type in letters only",
                    total: "Expense Total needed in amount only",
                    vat: "Please insert vat on that expense in number",
                    cash_from_till: "Please mention if spent from cash till"
                }
            });
        });
    </script>
    <div class="row no-padding">
        <div class="modal-header">
            <div class="page-title col-md-12"><?php echo $this->lang->line('gkpos_restaurant_expense') ?></div>
        </div>
        <div class="clearfix"></div>
        <fieldset style="margin-bottom: 0px; padding-bottom: 0px; border-radius: 10px 10px 0px 0px ">
            <div class="row">
                <form action="<?php echo site_url('gkpos/settings/expense_filter') ?>" method="post"  id="expenseReportFilterForm">
                    <table class="table table-bg-color table-responsive table-bordered">
                        <tr>
                            <th>Date Range From</th>
                            <th>To</th>
                        </tr>
                        <tr>
                            <td><?php echo form_input(array('name' => 'start_date', 'value' => $start_date, 'class' => 'date_filter form-control input-sm')); ?></td>
                            <td><?php echo form_input(array('name' => 'end_date', 'value' => $end_date, 'class' => 'date_filter form-control input-sm',)); ?></td>
                            <td class="text-center"><button class="btn btn-primary btn-sm" style="width: 130px" type="submit" onclick="filterExpenseReport()"><?php echo "Submit" ?></button></td>
                        </tr>
                    </table>
                </form>
            </div>
        </fieldset>
        <div id="expenseFilterContent">
            <?php $this->load->view('expense_filter') ?>
        </div>

    </div>
</div>
<script>
    function showTotalAndVat() {
        $('#showTotoalAndVat').show();
    }
    $(document).ready(function () {
        $(".date_filter").datepicker({
            dateFormat: "dd/mm/yy",
            maxDate: "<?php echo date('d/m/Y') ?>"

        });
        if ($('#showHideAddExpense').is(":checked")) {
            $('#AddNewExpenseBox').show();
        } else {
            $('#AddNewExpenseBox').hide();
        }
    });
    function filterExpenseReport() {
        $('#expenseReportFilterForm').validate({
            submitHandler: function () {
                var myform = document.getElementById('expenseReportFilterForm');
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#expenseReportFilterForm').attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    success: function (response) {
                        $("#expenseFilterContent").html(response);
                        manageWindowHeight();
                    }
                });
            }
        });
    }
</script>