<table class="table table-responsive table-bordered table-bg-color">
    <tr>
        <th class="text-center text-uppercase" style="color: #FFF"><?php echo $this->lang->line('gkpos_expense_type') ?></th> 
        <th class="text-center text-uppercase" style="color: #FFF"><?php echo $this->lang->line('gkpos_total') ?></th> 
        <th class="text-center text-uppercase" style="color: #FFF"><?php echo $this->lang->line('gkpos_vat') ?></th> 
        <th class="text-center text-uppercase" style="color: #FFF"><?php echo $this->lang->line('gkpos_cash_from_till') ?></th> 
        <th class="text-center text-uppercase" style="color: #FFF">Cash</th> 
        <th class="text-center text-uppercase" style="color: #FFF">EFT</th>
        <th class="text-center text-uppercase" style="color: #FFF"><?php echo $this->lang->line('gkpos_entry_at') ?></th> 
        <th class="text-center text-uppercase" style="color: #FFF"><?php echo $this->lang->line('gkpos_entry_by') ?></th> 
    </tr>
    <?php if (!empty($expense_list)): ?>
        <?php $total = 0; ?>
        <?php $vat_total = 0; ?>
        <?php $from_till_total = 0; ?>
        <?php $from_other_cash_total = 0; ?>
        <?php $from_other_eft_total = 0; ?>
        <?php foreach ($expense_list as $expense): ?> 
            <tr class="table-bg-color-white">
                <td class="text-center"><?php echo $expense->type ?></td> 
                <td class="text-center">
                    <?php
                    $total += $expense->total;
                    echo to_currency($expense->total)
                    ?>
                </td> 
                <td class="text-center">
                    <?php
                    $vat_total += $expense->vat;
                    echo to_currency($expense->vat)
                    ?>
                </td> 
                <td class="text-center">
                    <?php
                    if ($expense->cash_from_till == 'yes') {
                        echo to_currency($expense->total);
                        $from_till_total += $expense->total;
                    } else {
                        echo to_currency($expense->total);
                    }
                    ?>
                </td> 
                <td class="text-center text-uppercase">
                    <?php
                    if ($expense->other == 'cash') {
                        $from_other_cash_total += $expense->total;
                        echo to_currency($expense->total);
                    } else {
                        echo to_currency(0);
                    }
                    ?>
                </td>
                <td class = "text-center text-uppercase">
                    <?php
                    if ($expense->other == 'eft') {
                        $from_other_eft_total += $expense->total;
                        echo to_currency($expense->total);
                    } else {
                        echo to_currency(0);
                    }
                    ?>
                </td>
                <td class="text-center"><?php echo date($this->config->item('dateformat') . ' ' . $this->config->item('timeformat'), strtotime($expense->created)) ?></td> 
                <th class="text-center"><?php echo get_user_name($expense->created_by) ?></th> 
            </tr>
        <?php endforeach; ?>
        <tr>
            <th class="text-right" style="color: #FFF">Total</th>
            <th class="text-center" style="color: #FFF"><?php echo to_currency($total) ?></th>
            <th class="text-center" style="color: #FFF"><?php echo to_currency($vat_total) ?></th>
            <th class="text-center" style="color: #FFF"><?php echo to_currency($from_till_total) ?></th>
            <th class="text-center" style="color: #FFF"><?php echo to_currency($from_other_cash_total) ?></th>
            <th class="text-center" style="color: #FFF"><?php echo to_currency($from_other_eft_total) ?></th>
        </tr>
    <?php else: ?>
        <tr>
            <td colspan="7">No Expense</td> 
        </tr>
    <?php endif; ?>
</table>         