<div class="col-lg-10 col-md-10 col-sm-10 col-xs-10 bodyitem">
    <div class="row no-padding">
        <div class="buttons">
            <div onclick="getSettingPage('<?php echo site_url('gkpos/settings/general') ?>', '<?php echo $this->lang->line('gkpos_general_info') ?>')" class="btn btn-primary gradient text-center" style="font-size:90%;min-width: 90px;"><?php echo $this->lang->line('gkpos_general_info') ?></div>
            <div onclick="getSettingPage('<?php echo site_url('gkpos/settings/vatsetup') ?>', '<?php echo $this->lang->line('gkpos_general_vat_setup') ?>')" class="btn btn-primary gradient text-center" style="font-size: 90%;min-width: 90px;"><?php echo $this->lang->line('gkpos_general_vat_setup') ?></div>
            <div onclick="getSettingPage('<?php echo site_url('gkpos/settings/discountsetup') ?>', '<?php echo $this->lang->line('gkpos_discount') ?>')" class="btn btn-primary gradient text-center" style="font-size: 90%;min-width: 90px;"><?php echo $this->lang->line('gkpos_discount') ?></div>
            <div onclick="getSettingPage('<?php echo site_url('gkpos/settings/delivery_time') ?>', '<?php echo $this->lang->line('gkpos_delivery_time') ?>')" class="btn btn-primary gradient text-center" style="font-size: 90%;min-width: 110px;"><?php echo $this->lang->line('gkpos_delivery_time') ?></div>
            <div onclick="getSettingPage('<?php echo site_url('gkpos/settings/depliveryplan') ?>', '<?php echo $this->lang->line('gkpos_delivery_plan') ?>')" class="btn btn-primary gradient text-center" style="font-size: 90%;min-width: 110px;"><?php echo $this->lang->line('gkpos_delivery_plan') ?></div>
            <div onclick="getSettingPage('<?php echo site_url('gkpos/settings/pagination') ?>', '<?php echo $this->lang->line('gkpos_pagination') ?>')" class="btn btn-primary gradient text-center" style="font-size: 90%;min-width: 90px;" ><?php echo $this->lang->line('gkpos_pagination') ?></div>
            <?php if ($this->config->item('gk_only_online_admin') == 'no'): ?>
                <div onclick="getSettingPage('<?php echo site_url('gkpos/settings/add_cc_fee') ?>', '<?php echo $this->lang->line('gkpos_add_cce_fee') ?>')" class="btn btn-primary gradient text-center" style="font-size: 90%;min-width: 90px;" ><?php echo $this->lang->line('gkpos_add_cce_fee') ?></div>
            <?php endif; ?>
        </div>
    </div>
    <div class="row no-padding">
        <div class='col-lg-12 col-md-12 col-sm-12 col-xs-12 text-uppercase'style="margin-top: 5px;">
            <input type="checkbox" class="checkbox-inline" id="showHideAddDeliveryPlan" onclick="checkBlock(this.id, 'AddNewdeliveryPlanBox')">
            <span style="color: #FFF"><?php echo $this->lang->line('gkpos_add_new_delivery_plan') ?></span>
        </div>
    </div>
    <div class="row no-padding" id="AddNewdeliveryPlanBox">
        <?php echo form_open('gkpos/settings/save_deliveryplan/', array('id' => 'deliveryplan_form', 'enctype' => 'multipart/form-data', 'class' => 'form-horizontal')); ?>
        <div id="config_wrapper">
            <fieldset id="config_info">
                <div class="form-group form-group-sm">	
                    <?php echo form_label($this->lang->line('gkpos_area_or_title'), 'area', array('class' => 'control-label col-lg-4 col-md-4 col-sm-4 col-xs-4 text-uppercase required')); ?>
                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                        <div class="input-group">
                            <span class="input-group-addon" style="background-color: #FF0000;"><a href="#"><i class="fa fa-table" aria-hidden="true"></i></a></span>
                            <input name="area" class="form-control required"  type="text" id="area" value="<?php isset($area) ? print $area : print'' ?>">
                        </div>
                    </div>
                </div>
                <input type="hidden" name="id" id="deliveryplan_id">
                <div class="form-group form-group-sm">	
                    <?php echo form_label($this->lang->line('gkpos_is_free'), '	is_free', array('class' => 'control-label col-lg-4 col-md-4 col-sm-4 col-xs-4 text-uppercase')); ?>
                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                        <?php echo form_checkbox(array('name' => 'is_free', 'id' => 'is_free', 'value' => 1, 'checked' => isset($is_free) ? $is_free : '')); ?>
                    </div>
                </div>

                <div class="form-group form-group-sm">	
                    <?php echo form_label($this->lang->line('gkpos_delivery_charge'), 'delivery_charge', array('class' => 'control-label col-lg-4 col-md-4 col-sm-4 col-xs-4 text-uppercase required')); ?>
                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                        <div class="input-group">
                            <span class="input-group-addon" style="background-color: #FF0000;"><a href="#"><i><?php echo $this->config->item('currency_symbol') ?></i></a></span>

                            <input name="delivery_charge" class="form-control required"  type="text" id="delivery_charge" value="<?php isset($delivery_charge) ? print $delivery_charge : print '' ?>">

                        </div>
                    </div>
                </div>
                <div class="form-group form-group-sm">	
                    <?php echo form_label($this->lang->line('gkpos_minimum_order'), 'min_order', array('class' => 'control-label col-lg-4 col-md-4 col-sm-4 col-xs-4 text-uppercase')); ?>
                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                        <div class="input-group">
                            <span class="input-group-addon" style="background-color: #FF0000;"><a href="#"><i><?php echo $this->config->item('currency_symbol') ?></i></a></span>

                            <input name="min_order" class="form-control required"  type="text" id="min_order" value="<?php isset($min_order) ? print $min_order : print'' ?>">

                        </div>
                    </div>
                </div>
                <div class="form-group form-group-sm">
                    <label class="col-md-4 control-label"><?php echo $this->lang->line('gkpos_delivery_time') ?></label>  
                    <div class="col-md-8">
                        <div class="input-group">
                            <span class="input-group-addon" style="background-color: #FF0000;"><a href="#"><i class="fa fa-calendar" aria-hidden="true"></i></a></span>
                            <select class="form-control" id="delivery_time" name="delivery_time" class="required input-sm">
                                <option></option>
                                <option value="15">15-min</option>
                                <option value="20">20-min</option>
                                <option value="25">25-min</option>
                                <option value="30">30-min</option>
                                <option value="35">35-min</option>
                                <option value="40">40-min</option>
                                <option value="45" selected="true">45-min</option>
                                <option value="50">50-min</option>
                                <option value="55">55-min</option>
                                <option value="60">01-hour</option>
                                <option value="65">01:05-hour</option>
                                <option value="70">01:10-hour</option>
                                <option value="75">01:15-hour</option>
                                <option value="80">01:20-hour</option>
                                <option value="85">01:25-hour</option>
                                <option value="90">01:30-hour</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="form-group form-group-sm">	
                    <?php echo form_label($this->lang->line('gkpos_initial_postcode'), 'initial_code', array('class' => 'control-label col-lg-4 col-md-4 col-sm-4 col-xs-4 text-uppercase')); ?>
                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                        <div class="input-group">
                            <span class="input-group-addon" style="background-color: #FF0000;"><a href="#"><i class="fa fa-street-view"></i></a></span>
                            <input name="initial_code" class="form-control required"  type="text" id="initial_code" value="<?php isset($initial_code) ? print $initial_code : print'' ?>">
                        </div>
                    </div>
                </div>
                <div class="form-group form-group-sm">	
                    <?php echo form_label($this->lang->line('gkpos_applied_to_poscodes'), 'postcodes', array('class' => 'control-label col-lg-4 col-md-4 col-sm-4 col-xs-4 required text-uppercase')); ?>
                    <div class='col-lg-8 col-md-8 col-sm-8 col-xs-8'>
                        <?php echo form_textarea(array('name' => 'postcodes', 'rows' => 2, 'class' => 'form-control', 'id' => 'postcodes'), isset($postcodes) ? $postcode : '') ?>
                    </div>
                </div>
                <div class="form-group form-group-md">	
                    <div class="col-md-offset-4 col-md-8">
                        <ul id="deliveryplan_error_message_box" class="error_message_box"></ul>
                        <?php
                        echo form_submit(array(
                            'name' => 'submit_form',
                            'id' => 'submit_form',
                            'value' => $this->lang->line('gkpos_numpad_key_enter'),
                            'class' => 'btn btn-block btn-danger round btn-sm'));
                        ?>
                    </div>
                </div>
            </fieldset>
        </div>
        <?php echo form_close(); ?>
        <script type='text/javascript'>
            $(document).ready(function ()
            {
                var isFree = $('#is_free').val();
                if (isFree == '1') {
                    $('#is_free').attr('checked', true);
                }
                $('#is_free').click(function () {
                    if ($(this).is(":checked")) {
                        $('#is_free').attr('checked', true);
                        $(this).val('1');
                    } else {
                        $(this).val('');
                        $('#is_free').attr('checked', false);
                    }
                });
                $('#deliveryplan_form').validate({
                    submitHandler: function () {
                        var myform = document.getElementById('deliveryplan_form');
                        var formdata = new FormData(myform);
                        $.ajax({
                            url: $('#deliveryplan_form').attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            success: function (response) {
                                if (response.success) {
                                    ALERT_TITLE = "Success!";
                                    alert(response.message);
                                    getSettingPage('<?php echo site_url('gkpos/settings/depliveryplan') ?>', 'g - deliveryplan')
                                } else {
                                    ALERT_TITLE = "Error!";
                                    alert(response.message);
                                }

                            },
                        });
                    },
                    errorClass: "has-error",
                    errorLabelContainer: "#deliveryplan_error_message_box",
                    wrapper: "li",
                    highlight: function (e) {
                        $(e).closest('.form-group').addClass('has-error');
                    },
                    unhighlight: function (e) {
                        $(e).closest('.form-group').removeClass('has-error');
                    },
                    rules: {
                        area: "required",
                        delivery_charge: {
                            number: true,
                            required: true
                        },
                        min_order: {
                            number: true,
                            required: true
                        },
                        initial_code: {
                            required: true,
                            maxlength: 4
                        },
                        postcodes: "required",
                        delivery_time: "required"

                    },
                    messages: {
                        area: "Delivery Plan Area or title is a required field",
                        delivery_charge: "Please specify Delivery charge",
                        min_order: "You need to mention minimum order amount",
                        initial_code: "Postcode Initial of 1-4 chars is a required field",
                        postcodes: "you must provided atleat one postcode",
                        delivery_time: "Delivery time is required"

                    }
                });
            });
        </script>
    </div>
    <div class="row voucher-list no-padding">
        <table class="table table-responsive table-bordered fieldset no-padding" style="margin: 0px 5px;">
            <caption class="text-center">Delivery Plans</caption>
            <tr>
                <th class="text-center text-uppercase" style="font-size: 12px"><?php echo $this->lang->line('gkpos_area_or_title') ?></th> 
                <th class="text-center text-uppercase" style="font-size: 12px"><?php echo $this->lang->line('gkpos_is_free') ?></th> 
                <th class="text-center text-uppercase" style="font-size: 12px"><?php echo $this->lang->line('gkpos_delivery_charge') ?></th> 
                <th class="text-center text-uppercase" style="font-size: 12px"><?php echo $this->lang->line('gkpos_minimum_order') ?></th> 
                <th class="text-center text-uppercase" style="font-size: 12px"><?php echo $this->lang->line('gkpos_initial_postcode') ?></th> 
                <th class="text-center text-uppercase" style="font-size: 12px"><?php echo $this->lang->line('gkpos_delivery_time') ?></th>
                <th class="text-center text-uppercase" style="font-size: 12px"><?php echo $this->lang->line('gkpos_action') ?></th> 
            </tr>
            <?php if (!empty($deliveryplan_list)): ?>
                <?php foreach ($deliveryplan_list as $deliveryplan): ?> 
                    <tr>
                        <td class="text-center"><?php echo $deliveryplan->area ?></td> 
                        <td><?php $deliveryplan->is_free == 1 ? print 'Yes' : print'No' ?></td>
                        <td class="text-center"><?php echo to_currency($deliveryplan->delivery_charge) ?></td> 
                        <td class="text-center"><?php echo to_currency($deliveryplan->min_order) ?></td> 
                        <td onclick="viewPostcodeList('<?php echo $deliveryplan->id ?>')" style="cursor: pointer"><?php echo $deliveryplan->initial_code . ' (view list)' ?></td>
                        <td class="text-center"><?php echo $deliveryplan->delivery_time . '-min'; ?></td>
                        <td class="text-center">
                            <a href='javascript:void(0)' onclick="updateDeliveryplan('<?php echo $deliveryplan->id ?>', '<?php echo site_url('gkpos/settings/update_deliveryplan') ?>', '<?php $deliveryplan->status == 1 ? print'deactivate' : print 'activate' ?>')"><?php $deliveryplan->status == 1 ? print'Deactivate' : print 'Activate' ?> </a>
                            |
                            <a href='javascript:void(0)' onclick="updateDeliveryplan('<?php echo $deliveryplan->id ?>', '<?php echo site_url('gkpos/settings/update_deliveryplan') ?>', 'delete')">Delete</a> 
                            |<a href='javascript:void(0)' onclick="editDeliveryplan('<?php echo $deliveryplan->id ?>', '<?php echo site_url('gkpos/settings/edit_deliveryplan') ?>')">Edit</a> 
                        </td> 
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="7">No Delivery Plans Found Found</td> 
                </tr>
            <?php endif; ?>
        </table>  
        <script>
            function updateDeliveryplan(id, url, action) {
                $.ajax({
                    url: url,
                    data: {
                        id: id,
                        action: action
                    },
                    type: "POST",
                    success: function (output) {
                        getSettingPage('<?php echo site_url("gkpos/settings/depliveryplan") ?>', 'G-depliveryplan');
                    },
                });
            }
            function viewPostcodeList(id) {
                $.ajax({
                    url: '<?php echo site_url("gkpos/settings/get_postcodelist") ?>',
                    data: {id: id},
                    type: "POST",
                    success: function (output) {
                        var obj = $.parseJSON(output);
                        jQuery("#warningPopupHeader").text("POSTCODE LIST");
                        jQuery("#warningPopupContent").text(obj.postcodes.postcodes);
                        jQuery(".warningPopup").colorbox({inline: true, scrolling: true, height: 400, open: true, width: '100%', maxWidth: '600px'});
                    }
                });
            }
            function editDeliveryplan(id, url) {
                $.ajax({
                    url: url,
                    data: {
                        id: id
                    },
                    type: "POST",
                    dataType: 'json',
                    success: function (output) {
                        if (true == output.success) {
                            $('#showHideAddDeliveryPlan').attr('checked', true);
                            checkBlock('showHideAddDeliveryPlan', 'AddNewdeliveryPlanBox');
                            var obj = output.toEdit;
                            $('#deliveryplan_id').val(obj.id);
                            $('#area').val(obj.area);
                            $('#is_free').val(obj.is_free);
                            if (obj.is_free == '1') {
                                $('#is_free').attr('checked', true);
                            } else {
                                $('#is_free').removeAttr('checked');
                            }
                            $('#delivery_charge').val(obj.delivery_charge);
                            $('#min_order').val(obj.min_order);
                            $('#initial_code').val(obj.initial_code);
                            $('#postcodes').val(obj.postcodes);
                            $('#delivery_time').val(obj.delivery_time);
                            console.log(obj);
                        } else {
                            $('#showHideAddDeliveryPlan').removeAttr('checked');
                        }
                    }
                });
            }
            $(document).ready(function () {
                if ($('#showHideAddDeliveryPlan').is(":checked")) {
                    $('#AddNewdeliveryPlanBox').show();
                } else {
                    $('#AddNewdeliveryPlanBox').hide();
                }
            });
        </script>
    </div>

    <div class="row no-padding">
        <?php echo form_open('gkpos/settings/google_deliveryplan/', array('id' => 'google_deliveryplan', 'enctype' => 'multipart/form-data', 'class' => 'form-horizontal')); ?>
        <div id="config_wrapper">
            <fieldset id="config_info">
                <h1 class="text-center">Delivery Calculation</h1>
                <div class="form-group form-group-sm">	
                    <?php echo form_label('API KEY', 'google_map_api_key', array('class' => 'control-label col-lg-4 col-md-4 col-sm-4 col-xs-4 text-capitalize')); ?>
                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                        <div class="input-group">
                            <span class="input-group-addon" style="background-color: #FF0000;"><a href="#"><i class="fa fa-map" aria-hidden="true"></i></a></span>
                            <input name="google_map_api_key" class="form-control"  type="text" id="google_map_api_key" value="<?php echo $this->config->item('google_map_api_key') ?>">
                        </div>
                    </div>
                </div>

                <div class="form-group form-group-sm">	
                    <?php echo form_label('Restaurant Postcode', 'deliverypan_source_postcode', array('class' => 'control-label col-lg-4 col-md-4 col-sm-4 col-xs-4 text-capitalize')); ?>
                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                        <div class="input-group">
                            <span class="input-group-addon" style="background-color: #FF0000;"><a href="#"><i class="fa fa-street-view" aria-hidden="true"></i></a></span>
                            <input name="deliveryplan_source_postcode" class="form-control"  type="text" id="gk_vat_reg" value="<?php echo $this->config->item('deliveryplan_source_postcode') ?>">
                        </div>
                    </div>
                </div>

                <div class="form-group form-group-sm">	
                    <?php echo form_label('Rate/mile', 'deliveryplan_rate', array('class' => 'control-label col-lg-4 col-md-4 col-sm-4 col-xs-4 text-capitalize')); ?>
                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                        <div class="input-group">
                            <span class="input-group-addon" style="background-color: #FF0000;"><a href="#"><i class="fa" aria-hidden="true"><?php echo $this->config->item('currency_symbol') ?></i></a></span>
                            <input name="deliveryplan_rate" class="form-control"  type="text" id="delivery_rate" value="<?php echo $this->config->item('deliveryplan_rate') ?>">
                        </div>
                    </div>
                </div>
                <div class="form-group form-group-sm">	
                    <?php echo form_label('Free Distance in mile', 'deliveryplan_offset', array('class' => 'control-label col-lg-4 col-md-4 col-sm-4 col-xs-4 text-capitalize')); ?>
                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                        <div class="input-group">
                            <span class="input-group-addon" style="background-color: #FF0000;"><a href="#"><i class="fa fa-road" aria-hidden="true"></i></a></span>
                            <input name="deliveryplan_offset" class="form-control"  type="text" id="deliveryplan_offset" value="<?php echo $this->config->item('deliveryplan_offset') ?>">
                        </div>
                    </div>
                </div>
                <div class="form-group form-group-sm">	
                    <?php echo form_label('Delivery Radious Distance in mile', 'deliveryplan_offset', array('class' => 'control-label col-lg-4 col-md-4 col-sm-4 col-xs-4 text-capitalize')); ?>
                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                        <div class="input-group">
                            <span class="input-group-addon" style="background-color: #FF0000;"><a href="#"><i class="fa fa-road" aria-hidden="true"></i></a></span>
                            <input name="deliveryplan_radius_distance" class="form-control"  type="text" id="deliveryplan_offset" value="<?php echo $this->config->item('deliveryplan_radius_distance') ?>">
                        </div>
                    </div>
                </div>
                <div class="form-group form-group-sm">	
                    <label for="radio-inline" class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label text-capitalize">Active?</label>
                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                        <label class="radio-inline text-capitalize"><input type="radio" name="deliveryplan_google" id="deliveryplan_google1" value="yes" <?php ($this->config->item('deliveryplan_google') == "yes") ? print "checked" : '' ?> ><?php echo $this->lang->line('gkpos_yes') ?></label>
                        <label class="radio-inline text-capitalize"><input type="radio" name="deliveryplan_google" id="deliveryplan_google1" value="no" <?php ($this->config->item('deliveryplan_google') == "no") ? print "checked" : '' ?> ><?php echo $this->lang->line('gkpos_no') ?></label>
                    </div>
                </div>

                <div class="form-group form-group-md">	
                    <div class="col-md-offset-4 col-md-8">
                        <ul id="vat_error_message_box" class="error_message_box"></ul>
                        <?php
                        echo form_submit(array(
                            'name' => 'submit_form',
                            'id' => 'submit_form',
                            'value' => $this->lang->line('gkpos_numpad_key_enter'),
                            'class' => 'btn btn-block btn-danger round btn-sm'));
                        ?>
                    </div>
                </div>
            </fieldset>
        </div>
        <?php echo form_close(); ?>
        <script type='text/javascript'>
            //validation and submit handling
            $(document).ready(function ()
            {
                $('#google_deliveryplan').validate({
                    submitHandler: function () {
                        var myform = document.getElementById('google_deliveryplan');
                        var formdata = new FormData(myform);
                        $.ajax({
                            url: $('#google_deliveryplan').attr('action'),
                            data: formdata,
                            cache: false,
                            processData: false,
                            contentType: false,
                            type: 'POST',
                            dataType: 'json',
                            success: function (response) {
                                if (response.success) {
                                    ALERT_TITLE = "Success!";
                                    alert(response.message);

                                } else {
                                    ALERT_TITLE = "Error!";
                                    alert(response.message);
                                }
                            }
                        });
                    },
                    errorClass: "has-error",
                    errorLabelContainer: "#vat_error_message_box",
                    wrapper: "li",
                    highlight: function (e) {
                        $(e).closest('.form-group').addClass('has-error');
                    },
                    unhighlight: function (e) {
                        $(e).closest('.form-group').removeClass('has-error');
                    },
                    rules:
                            {
                                google_map_api_key: "required",
                                deliveryplan_source_postcode: "required",
                                deliveryplan_rate: {
                                    number: true
                                },
                                deliveryplan_offset: {
                                    number: true
                                },
                                deliveryplan_google: "required",

                            },
                    messages:
                            {
                                google_map_api_key: "Google Map Api Key is required",
                                deliveryplan_source_postcode: "Postcode in Full Form is Required",
                                deliveryplan_rate: "Delivery rate per mile",
                                deliveryplan_offset: "Mention free delivery distance",
                                deliveryplan_google: "Pleaese yes to activate and not to deactivate",

                            }
                });
            });
        </script>
    </div>
</div>
