<div class = "col-lg-10 col-md-10 col-sm-10 col-xs-10 bodyitem">
    <fieldset>
        <table class="table table-responsive table-bordered">
            <tr>
                <td colspan="4" class="text-right">
                    <div class="col-lg-3 col-md-3 col-sm-4 col-xs-4 text-center btn btn-info btn-sm" onclick="getSettingPage('<?php echo site_url('gkpos/settings/view_user') ?>', '<?php echo $this->lang->line("gkpos_system_user") ?>')">View Users</div>
                    <div class="col-lg-3 col-md-3 col-sm-4 col-xs-4 text-center btn btn-sm btn-primary" onclick="getSettingPage('<?php echo site_url('gkpos/settings/user') ?>', '<?php echo $this->lang->line("gkpos_system_user") ?>')">Add New User</div>
                </td>
            </tr>
            <tr class="table-bg-color">
                <th class="text-capitalize text-center">Name</th>
                <th class="text-capitalize text-center">Image</th>
                <th class="text-capitalize text-center">Address</th>
                <th class="text-capitalize text-center">Action</th>
            </tr>
            <?php if (!empty($users)): ?>
                <?php foreach ($users as $user): ?>
                    <?php
                    $nameString = '';
                    $nameString = $user->first_name != null ? $user->first_name . ' ' : '';
                    $nameString .= $user->middle_name != null ? $user->middle_name . ' ' : '';
                    $nameString .= $user->last_name != null ? $user->last_name : '';
                    $addressString = '';
                    $addressString = $user->house != null ? $user->house . ' ' : '';
                    $addressString .= $user->street != null ? $user->street . ', ' : '';
                    $addressString .= $user->town != null ? $user->town . ', ' : '';
                    $addressString .= $user->city != null ? $user->city . ', ' : '';
                    $addressString .= $user->postcode != null ? $user->postcode : '';
                    ?>
                    <tr class="table-bg-color-white">
                        <td class="text-capitalize text-center"><?php echo $nameString ?></td>
                        <td class="text-capitalize text-center"><img src="<?php isset($user->image) && ($user->image != null || $user->image != '' ) ? print UPLOAD_PATH . 'gkpos/user/' . $user->image : print ASSETS_GKPOS_PATH . 'images/adminbg.png' ?>" width="24px" height="24px"></td>
                        <td class="text-capitalize text-center"><?php echo $addressString ?></td>
                        <td class="text-capitalize text-center">
                            <a href="javascript:void(0)" onclick="showUserDetail(<?php echo $user->id; ?>);"><span><img src="<?php echo ASSETS_GKPOS_PATH . 'images/grid-view-block-glyph.png' ?>" width="24px" height="24px" alt="View Details" title="View Details"></span></a>
                            <a href="javascript:void(0)" onclick="showUserSettingForm(<?php echo $user->id ?>)"><span><img src="<?php echo ASSETS_GKPOS_PATH . 'images/settingbg3.png' ?>" width="24px" height="24px" alt="User Setting" title="User Setting"></span></a>
                            <a href="javascript:void(0)" onclick="getSettingPage('<?php echo site_url('gkpos/settings/user/' . $user->id) ?>', '<?php echo $this->lang->line("gkpos_system_user") ?>')"><span><img src="<?php echo ASSETS_GKPOS_PATH . 'images/edit-note.png' ?>" width="24px" height="24px" alt="Edit User Information" title="Edit User Information"></span></a>
                            <a href="javascript:void(0)" onclick="deleteUser(<?php echo $user->id ?>)"><span><img src="<?php echo ASSETS_GKPOS_PATH . 'images/delete.png' ?>" width="24px" height="24px" alt="Delete user" title="Delete User"></span></a>
                        </td>
                    </tr>
                    <tr style="display: none; background-color: #ffffff;" class="userDetailBlock<?php echo $user->id; ?>">
                        <td colspan="3">
                            <table class="table table-bg-color table-bordered">
                                <tr>
                                    <td style="color: #000; line-height: 15px;">
                                        <p>Username: <?php echo $user->username; ?></p>
                                        <p>Email: <?php echo $user->email; ?></p>
                                        <p>Phone: <?php echo $user->phone; ?></p>
                                        <p>Joining Date: <?php echo $user->join_date; ?></p>
                                        <p>Date Of Birth: <?php echo $user->dob; ?></p>
                                        <p>Gender:<?php echo $user->gender == 1 ? "Male" : "Female"; ?></p>
                                        <p>Insurance:<?php echo $user->insurance ?></p>
                                    </td>
                                    <td style="width: 30px"><a onclick="closeUserDetails('<?php echo $user->id ?>');"href="javascript:void(0);" title="Close"><img src="<?php echo ASSETS_GKPOS_PATH; ?>images/closebg.png" width="16" height="16" /></a></td>
                                </tr>
                            </table>
                        </td>
                    </tr>

                    <tr style="display: none; background-color: #ffffff;" class="userSettingForm<?php echo $user->id; ?>">
                        <td colspan="3">
                            <table class="table table-bg-color table-bordered">
                                <tr>
                                    <td style="color: #000; line-height: 15px;">
                                        <fieldset>
                                            <ul id="userSettingFormContentError<?php echo $user->id ?>" class="error_message_box"></ul>
                                            <form class="form-horizontal" action="<?php echo site_url('gkpos/settings/config_user') ?>" method="post"  id="userSettingFormContent<?php echo $user->id ?>">
                                                <input type="hidden" name="id" value="<?php echo $user->id ?>"/>
                                                <p><label>Username:</label> <input class="form-control" type="text" value="<?php echo $user->username ?>" name="username"/></p>
                                                <p><label>Email:</label> <input class="form-control" type="text" value="<?php echo $user->email ?>" name="email"/></p>
                                                <p><label>Phone:</label> <input class="form-control" type="text" value="<?php echo $user->phone ?>" name="phone"/></p>
                                                <p><label>Access Pin:</label> <input class="form-control" type="password" value="" name="password"/></p>
                                                <p>
                                                    <label class="radio-inline">User Type:</label>
                                                    <label class="radio-inline text-uppercase required"><input style="margin-top: 0px;" type="radio" name="type" id="type3" value="3" <?php $user->type == '3' ? print "checked" : '' ?> ><?php echo "General User" ?></label>
                                                    <label class="radio-inline text-uppercase required"><input style="margin-top: 0px;" type="radio" name="type" id="type0" value="2" <?php $user->type == '2' ? print "checked" : '' ?> ><?php echo "Admin" ?></label>
                                                </p>
                                                <p> <label class="radio-inline">User Status:</label>
                                                    <label class="radio-inline text-uppercase required"><input style="margin-top: 0px;" type="radio" name="status" id="status1" value="1" <?php $user->status == "1" ? print "checked" : '' ?> ><?php echo "Active" ?></label>
                                                    <label class="radio-inline text-uppercase required"><input style="margin-top: 0px;" type="radio" name="status" id="status0" value="0" <?php $user->status == "0" ? print "checked" : '' ?> ><?php echo "Inactive" ?></label>
                                                    <label class="radio-inline text-uppercase required"><input style="margin-top: 0px;" type="radio" name="status" id="status0" value="2" <?php $user->status == "2" ? print "checked" : '' ?> ><?php echo "Suspended" ?></label>
                                                </p>
                                                <p><input class="btn btn-block btn-danger round btn-sm" type="submit" name="submit_form" value="<?php echo $this->lang->line('gkpos_numpad_key_enter') ?>" onclick="configUserInfo(<?php echo $user->id ?>)"></p>
                                            </form>
                                        </fieldset>
                                    </td>
                                    <td style="width: 30px"><a onclick="closeUserSettingForm(<?php echo $user->id ?>);"href="javascript:void(0);" title="Close"><img src="<?php echo ASSETS_GKPOS_PATH; ?>images/closebg.png" width="16" height="16" /></a></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <td colspan="4" class="text-capitalize text-center">No users found</td>
            <?php endif; ?>
        </table>
    </fieldset>
</div>
<script>
    $(document).ready(function () {
        keyboard('clientsCTA1');
        keyboard('clientsCTA');
        addjqueryValidatorFunction();
    });
    function showUserDetail(user_id) {
        $('.userDetailBlock' + user_id).fadeIn();
        manageWindowHeight();
    }
    function closeUserDetails(user_id) {
        $('.userDetailBlock' + user_id).fadeOut();
        manageWindowHeight();
    }
    function showUserSettingForm(user_id) {
        $('.userSettingForm' + user_id).fadeIn();
        manageWindowHeight();
    }
    function closeUserSettingForm(user_id) {
        $('.userSettingForm' + user_id).fadeOut()();
        manageWindowHeight();
    }
    function configUserInfo(user_id) {
        
        $('#userSettingFormContent' + user_id).validate({
            submitHandler: function () {
                var myform = document.getElementById('userSettingFormContent'+user_id);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#userSettingFormContent'+user_id).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            ALERT_TITLE = "Success!";
                            alert(response.message);
                        } else {
                            alert(response.message);
                        }
                    }
                });
            },
            errorClass: "has-error",
            errorLabelContainer: "#userSettingFormContentError" + user_id,
            wrapper: "li",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                username: {
                    loginRegex: true,
                    required: true
                },
                email: {
                    email: true,
                    required: true
                },
                phone: {
                    phone: true,
                    required: true
                },
                password: {
                    number: true,
                    min: 4,
                    required: true
                }
            },
            messages: {
                username: "Username must contain only letters, numbers, or dashes.",
                email: "Please specify valid email addresss",
                phone: "<?php echo $this->lang->line('gkpos_valid_phone_required') ?>",
                password: "Access Pin in minimum 4 digit"
            }
        });
    }
    function deleteUser(id) {
        $.confirm({
            'title': 'User Delete Warning',
            'message': 'Are you sure? You want to delete this user',
            'buttons': {
                'YES': {
                    'class': 'btn btn-success',
                    'action': function () {
                        $.ajax({
                            url: "<?php echo site_url('gkpos/settings/delete_user') ?>",
                            data: {
                                id: id
                            },
                            type: "POST",
                            dataType: "json",
                            success: function (output) {
                                if (output.success) {
                                    getSettingPage('<?php echo site_url('gkpos/settings/view_user') ?>', '<?php echo $this->lang->line("gkpos_system_user") ?>');
                                } else {
                                    ALERT_TITLE = "Error!";
                                    alert('Delete Failed');
                                }
                            }
                        });
                    }
                },
                'NO': {
                    'class': 'btn btn-danger',
                    'action': function () {}
                }
            }
        });
    }
</script>