<fieldset style="margin-top:0px; margin-bottom: 0px; padding-bottom: 0px; border-radius: 0px 0px 10px 10px">
    <div class="row report-row">
        <?php if (!empty($voidorders)): ?>
            <table class="table table-responsive table-bordered">
                <tr class="table-bg-color">
                    <th>Created At</th>
                    <th>Order Type</th>
                    <th>Order Identity</th>
                    <th>Delete</th>
                </tr>
                <?php if (!empty($voidorders)): ?>
                    <?php foreach ($voidorders as $voidorder): ?>
                        <tr class="table-bg-color-white">
                            <td><?php print date('F j, Y H:i a', strtotime($voidorder->created)) ?></td>
                            <?php $voidOrderType = isset($voidorder->online_type) ? $voidorder->online_type : $voidorder->order_type ?>
                            <td><?php echo $voidOrderType ?></td>
                            <?php $orderIdentity = $voidorder->table_number != null ? "Table Number-" . $voidorder->table_number : $voidorder->name . '(' . $voidorder->phone . ')'; ?>
                            <td><?php echo $orderIdentity ?></td>
                            <?php $hasCartItems = $this->Voidorders_Model->count_rows('gkpos_order_detail', array('order_id' => $voidorder->id)) ?>
                            <td class="text-center text-capitalize">
                                <span><img src="<?php echo ASSETS_GKPOS_PATH ?>images/delete.png" width="24px" height="24px" onclick="deleteReportRow('<?php echo $voidorder->id ?>', '<?php echo $segment ?>')"></span>
                                <?php if ($hasCartItems > 0): ?>
                                    <span>&nbsp;&nbsp;|&nbsp;&nbsp;</span>
                                    <span><a href="javascript:void(0);" onclick="getBaseAjaxPage('<?php echo site_url('gkpos/orders/voidorder_cart/' . $voidorder->id) ?>', false)"><img src="<?php echo ASSETS_GKPOS_PATH ?>images/cart.png" width="24px" height="24px"/></a></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (!empty($voidorders) && $maxCounter > 1): ?>
                        <tr>
                            <td colspan="4">
                                <div class="table-bg-color">
                                    <?php if (isset($maxCounter) && $maxCounter > 1): ?>
                                        <div class="main-arrowbg text-center pull-left">
                                            <ul class="pagination">
                                                <?php for ($i = 0; $i < $maxCounter; $i++): ?>
                                                    <li <?php $segment == $i ? print'class="active"' : '' ?>><a href="javascript:void(0)" onclick="paginateReport('<?php echo $i ?>')" style="padding: 5px 10px !important"><?php echo $i + 1; ?></a></li>
                                                <?php endfor; ?>
                                            </ul>
                                        </div>
                                    <?php endif ?>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                <?php else: ?>
                    <tr class="table-bg-color-white">
                        <td colspan="3">No found Order Found Yet</td>
                    </tr>
                <?php endif; ?>
            </table>
        <?php endif; ?>
    </div>
</fieldset>
<script>
    $(document).ready(function () {
        $(".date_filter").datepicker({
            dateFormat: "dd/mm/yy",
            maxDate: "<?php echo date('d/m/Y') ?>"
        });
    });
    function filterReport() {
        $('#reportFilterForm').validate({
            submitHandler: function () {
                var myform = document.getElementById('reportFilterForm');
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#reportFilterForm').attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    success: function (response) {
                        $("#filterContent").html(response);
                        manageWindowHeight();

                    }
                });
            }
        });
    }

    function paginateReport(segment) {
        $.ajax({
            url: "<?php echo site_url('gkpos/voidorders/filter/') ?>" + segment,
            data: {
                start_date: $('#filterStartDate').val(),
                end_date: $('#filterEndDate').val(),
            },
            type: "POST",
            beforeSend: function () {
                $('#GkposAjaxPageLoader').show();
            },
            success: function (response) {
                $('#GkposAjaxPageLoader').hide();
                $("#filterContent").html(response)
                manageWindowHeight();
            }
        });
    }
    function deleteReportRow(id, segment) {
        $.confirm({
            'title': 'Order Delete Warning',
            'message': 'Are you sure? You want to delete this order ',
            'buttons': {
                'YES': {
                    'class': 'btn btn-danger',
                    'action': function () {
                        $.ajax({
                            url: "<?php echo site_url('gkpos/voidorders/deleteReportRow') ?>",
                            type: "POST",
                            dataType: "json",
                            data: {
                                id: id
                            },
                            success: function (response) {
                                if (response.status) {
                                    paginateReport(segment);
                                }
                            }
                        });
                    }
                },
                'NO': {
                    'class': 'btn btn-success',
                    'action': function () {}
                }
            }
        });
    }
</script>