<div id="contact" class="contact-wrapper wrapper">
    <div class="container <?php echo $this->config->item('website_style') == 'singlepage' ? 'inner' : 'inner-customer-dashboard' ?>">
        <h2 class="section-title text-center"><?php trim($contact[0]->title) != null ? print $contact[0]->title : 'Contact' ?></h2>
        <p class="text-center"><?php trim($contact[0]->content) != null ? print $contact[0]->content : print '&nbsp;' ?></p>
        <div class="row">
            <div class="col-md-8">
                <?php echo form_open('contact/sentmail', array('id' => 'contactForm')) ?>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="name">Name</label>
                            <input name="name" type="text" class="form-control" data-error="#contactFormNameError" placeholder="Enter name" />
                            <div id="contactFormNameError"></div>
                        </div>

                        <div class="form-group">
                            <label for="phone">Phone/Mobile</label>
                            <input name="phone" type="phone" class="form-control" data-error="#contactFormPhoneError" placeholder="Enter phone/mobile number"/>
                            <div id="contactFormPhoneError"></div>
                        </div>

                        <div class="form-group">
                            <label for="email">Email Address</label>
                            <input name="email" type="email" class="form-control" data-error="#contactFormEmailError" placeholder="Enter email" />
                            <div id="contactFormEmailError"></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="name">Message</label>
                            <textarea name="message" data-error="#contactFormMessageError" class="form-control" rows="11" cols="25" placeholder="Message"></textarea>
                            <div id="contactFormMessageError"></div>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <input class="btn pull-right" style="width: 230px; height:50px;" type="submit" name="submit_form" tabindex="4" value="Send Message" onclick="AjaxContactFormPostSubmission('contactForm')">
                    </div>
                </div>
                <?php echo form_close() ?>
            </div>
            <div class="col-md-4">
                <form>
                    <legend><i class="fa fa-globe"></i>Address</legend>
                    <?php if (!detectDevice()): ?>
                        <?php echo $contact[0]->image ?>
                    <?php endif; ?>
                    <address>
                        <p><span style="text-transform: capitalize;"><?php echo $this->config->item('gk_address') ?></span><br/>
                            Phone : <?php echo $this->config->item('gk_phone') ?><br/>
                            Email : <?php echo $this->config->item('gk_email') ?>
                        </p>
                    </address>
                </form>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-6 col-xs-12 text-left">
                Connect us at:  
                <?php if (trim($this->config->item('footer_instagram') != null)): ?>
                    <a href="<?php echo $this->config->item('footer_instagram') ?>" class="fa fa-instagram fa-2x" title="Instagram" target="_blank"></a>
                <?php endif; ?>
                <?php if (trim($this->config->item('footer_youtube') != null)): ?>
                    <a href="<?php echo $this->config->item('footer_youtube') ?>" class="fa fa-youtube-square fa-2x" title="Youtube"  target="_blank"></a>
                <?php endif; ?>
                <?php if (trim($this->config->item('footer_facebook') != null)): ?>
                    <a href="<?php echo $this->config->item('footer_facebook') ?>" class="fa fa-facebook-square fa-2x" title="Facebook"  target="_blank"></a>
                <?php endif; ?>
                <?php if (trim($this->config->item('footer_pinterest') != null)): ?>
                    <a href="<?php echo $this->config->item('footer_pinterest') ?>" class="fa fa-pinterest-square fa-2x" title="Pinterest"  target="_blank"></a>
                <?php endif; ?>
                <?php if (trim($this->config->item('footer_twitter') != null)): ?>
                    <a href="<?php echo $this->config->item('footer_twitter') ?>" class="fa fa-twitter-square fa-2x" title="Twitter" target="_blank"></a>
                <?php endif; ?>
                <?php if (trim($this->config->item('footer_googleplus') != null)): ?>
                    <a href="<?php echo $this->config->item('footer_googleplus') ?>" class="fa fa-google-plus-square fa-2x" title="Googleplus" target="_blank"></a>
                <?php endif; ?>
            </div>
            <div class="col-sm-6 hidden-xs text-right">
                Download App:
                <?php if (trim($this->config->item('footer_android')) != null || trim($this->config->item('footer_android') == "#")): ?>
                    <a href="<?php echo $this->config->item('footer_android') ?>"><img src="<?php echo ASSETS_PUBLIC_PATH . 'img/playstore.png' ?>" target="_blank" width="130px" height="40px"></a>
                <?php endif; ?>
                <?php if (trim($this->config->item('footer_apple')) != null || trim($this->config->item('footer_android') == "#")): ?>
                    <a href="<?php echo $this->config->item('footer_apple') ?>"><img src="<?php echo ASSETS_PUBLIC_PATH . 'img/applestore.jpg' ?>" target="_blank" width="130px" height="40px"></a>
                <?php endif; ?>   
            </div>
            <div class="col-xs-12 hidden-sm  hidden-lg hidden-md">
                Download App:
                <?php if (trim($this->config->item('footer_android')) != null || trim($this->config->item('footer_android') == "#")): ?>
                    <p><a href="<?php echo $this->config->item('footer_android') ?>"><img src="<?php echo ASSETS_PUBLIC_PATH . 'img/playstore.png' ?>" target="_blank" width="130px" height="40px"></a></p>
                <?php endif; ?>
                <?php if (trim($this->config->item('footer_apple')) != null || trim($this->config->item('footer_android') == "#")): ?>
                    <p><a href="<?php echo $this->config->item('footer_apple') ?>"><img src="<?php echo ASSETS_PUBLIC_PATH . 'img/applestore.jpg' ?>" target="_blank" width="130px" height="40px"></a></p>
                <?php endif; ?>   
            </div>
            <div class="hidden-sm hidden-lg hidden-md">
                <div style="margin-bottom: 50px;">&nbsp;</div>
            </div>
        </div>
    </div>
    <!-- container --> 
</div>
<script type="text/javascript">

    function AjaxContactFormPostSubmission(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            ALERT_TITLE = "Success!";
                            alert(response.message);
                            $('#' + formId).find('input[type=text],input[type=email],input[type=number], select,textarea').each(function () {
                                $(this).val('');
                            });
                        } else {
                            ALERT_TITLE = "Warning!"
                            alert('There some problem in sending your mail');
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                name: {lettersonly: true, required: true},
                email: {email: true, required: true},
                message: {required: true},
                phone: {phone: true}
            },
            messages: {
                name: "Pleae enter your name",
                email: "Please specify valid Email Address",
                message: "Please send us a message as well",
                phone: "Valid phone number, Please"
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
</script>