<div id="reservation" class="reservation-wrapper wrapper">
    <div class="container <?php echo $this->config->item('website_style') == 'singlepage' ? 'inner' : 'inner-customer-dashboard' ?>">
        <h2 class="section-title text-center">Reservation</h2>
        <p class="text-center">Reserve your table </p>

        <div class="row">
            <div class="col-md-6">
                <?php echo form_open('contact/sent_booking', array('id' => 'reservationForm', 'class' => 'form form-table')) ?>
                <div class="form-group">
                    <h4>Fill the form for table reservation (all fields required)</h4>
                </div>
                <div class="row">
                    <div class="col-lg-6 col-md-6 form-group">
                        <label class="sr-only" for="first_name">First Name</label>
                        <input class="form-control hint" type="text" data-error="#reservationFormErrorFirstName" name="first_name" placeholder="First name">
                        <div id="reservationFormErrorFirstName"></div>
                    </div>
                    <div class="col-lg-6 col-md-6 form-group">
                        <label class="sr-only" for="last_name">Last Name</label>
                        <input class="form-control hint" type="text" data-error="#reservationFormErrorLastName" name="last_name" placeholder="Last name">
                        <div id="reservationFormErrorLastName"></div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-6 col-md-6 form-group">
                        <label class="sr-only" for="res_email">Email Address</label>
                        <input class="form-control hint" type="email" data-error="#reservationFormErrorEmail" name="res_email" placeholder="Email@domain.com">
                        <div id="reservationFormErrorEmail"></div>
                    </div>
                    <div class="col-lg-6 col-md-6 form-group">
                        <label class="sr-only" for="res_phone">Phone/Mobile</label>
                        <input class="form-control hint" type="text" data-error="#reservationFormErrorPhone" name="res_phone" placeholder="Phone">
                        <div id="reservationFormErrorPhone"></div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-6 col-md-6 form-group">
                        <label class="sr-only" for="reservationDate">reservation date</label>
                        <input class="form-control hasDatepicker" value="<?php echo date($this->config->item('dateformat'), strtotime('today')) ?>" type="text" data-error="#reservationFormErrorDate" id="res_date" name="res_date" placeholder="Reservation date">
                        <div id="reservationFormErrorDate"></div>
                    </div>
                    <div class="col-lg-3 col-md-3 form-group">
                        <label class="sr-only" for="timeFrom">time from</label>
                        <select class="required form-control" data-error="#reservationFormErrorTimeTo"  name="time_from">
                            <?php if ($time_slot): ?>
                                <?php foreach ($time_slot as $aslot): ?>
                                    <option value='<?php echo $aslot ?>'><?php echo $aslot ?></option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                        <div id="reservationFormErrorTimeFrom"></div>
                    </div>

                    <div class="col-lg-3 col-md-3 form-group">
                        <label class="sr-only" for="guest_number">number of guests</label>
                        <input class="form-control hint" data-error="#reservationFormErrorGuest" type="number" min="1" id="guest_number" name="guest_number" placeholder="Guests">
                        <div id="reservationFormErrorGuest"></div>
                    </div>
                </div>

                <div class="row hidden">
                    <div class="col-lg-6 col-md-6 form-group">
                        <label class="sr-only" for="timeTo">time To</label>
                        <select class="form-control timepicker ui-timepicker-input hint" id="timeTo" data-error="#reservationFormErrorTimeTo"  name="time_to">
                            <?php if ($time_slot): ?>
                                <?php foreach ($time_slot as $aslot): ?>
                                    <option value='<?php echo $aslot ?>'><?php echo $aslot ?></option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                        <div id="reservationFormErrorTimeTo"></div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12 col-md-12">
                        <textarea data-error="#reservationFormErrorMessage" name="res_message" class="form-control" rows="3" placeholder="Anything extra to say..."></textarea>
                        <div id="reservationFormErrorMessage"></div>
                    </div>
                </div>
                <div class="clearfix"></div>
                <br/>
                <div class="row">
                    <div class="col-lg-12 col-md-12">
                        <div class="form-group pull-right" style="margin-bottom: 3px">
                            <input class="btn" style="width: 230px; height: 45px; margin: 0 auto;" type="submit" name="submit_form" tabindex="4" value="Reserve" onclick="reservationValidation('reservationForm')">
                        </div>
                    </div>
                </div>
                <?php echo form_close() ?>
            </div><!-- col-md-6 -->
            <div class="col-md-5 col-md-offset-1">
                <div id="RestaurantSchedule">
                    <h4 class="text-center text-uppercase">Restaurant Opening Hours</h4>
                    <table class="table table-bg-color table-responsive table-bordered">
                        <tr style="color: #FFF000;">
                            <td>Day</td>
                            <td>Open</td>
                            <td>Close</td>
                        </tr>
                        <tr <?php $week['mon']->day == strtolower(date('D')) ? print 'class="alert-warning"' : print'' ?>>
                            <td>Monday</td>
                            <td><?php $week['mon']->is_opened == 'yes' ? print $week['mon']->open : print 'Closed' ?></td>
                            <td><?php $week['mon']->is_opened == 'yes' ? print $week['mon']->closed : print'Closed' ?></td>
                        </tr>
                        <tr <?php $week['tue']->day == strtolower(date('D')) ? print 'class="alert-warning"' : print'' ?>>
                            <td>Tuesday</td>
                            <td><?php $week['tue']->is_opened == 'yes' ? print $week['tue']->open : print'Closed' ?></td>
                            <td><?php $week['tue']->is_opened == 'yes' ? print $week['tue']->closed : print'Closed' ?></td>
                        </tr>
                        <tr <?php $week['wed']->day == strtolower(date('D')) ? print 'class="alert-warning"' : print'' ?>>
                            <td>Wednesday</td>
                            <td><?php $week['wed']->is_opened == 'yes' ? print $week['wed']->open : print'Closed' ?></td>
                            <td><?php $week['wed']->is_opened == 'yes' ? print $week['wed']->closed : print 'Closed' ?></td>
                        </tr>
                        <tr <?php $week['thu']->day == strtolower(date('D')) ? print 'class="alert-warning"' : print'' ?>>
                            <td>Thursday</td>
                            <td><?php $week['thu']->is_opened == 'yes' ? print $week['thu']->open : print 'Closed' ?></td>
                            <td><?php $week['thu']->is_opened == 'yes' ? print $week['thu']->closed : print 'Closed' ?></td>
                        </tr>
                        <tr <?php $week['fri']->day == strtolower(date('D')) ? print 'class="alert-warning"' : print'' ?>>
                            <td>Friday</td>
                            <td><?php $week['fri']->is_opened == 'yes' ? print $week['fri']->open : print 'Closed' ?></td>
                            <td><?php $week['fri']->is_opened == 'yes' ? print $week['fri']->closed : print 'Closed' ?></td>
                        </tr>
                        <tr <?php $week['sat']->day == strtolower(date('D')) ? print 'class="alert-warning"' : print'' ?>>
                            <td>Saturday</td>
                            <td><?php $week['sat']->is_opened == 'yes' ? print $week['sat']->open : print 'Closed' ?></td>
                            <td><?php $week['sat']->is_opened == 'yes' ? print $week['sat']->closed : print'Closed' ?></td>
                        </tr>
                        <tr <?php $week['sun']->day == strtolower(date('D')) ? print 'class="alert-warning"' : print'' ?>>
                            <td>Sunday</td>
                            <td><?php $week['sun']->is_opened == 'yes' ? print $week['sun']->open : print'Closed' ?></td>
                            <td><?php $week['sun']->is_opened == 'yes' ? print $week['sun']->closed : print 'Closed' ?></td>
                        </tr>
                    </table>
                    <h3 class="text-left">Contact Address</h3>
                    <p style="font-size: 14px;"><span style="text-transform: capitalize;"><?php echo $this->config->item('gk_address') ?></span><br/>
                        Phone : <?php echo $this->config->item('gk_phone') ?><br/>
                        Email : <?php echo $this->config->item('gk_email') ?>
                    </p>
                </div>

            </div><!-- col-md-6 -->
            <div class="hidden-sm hidden-lg hidden-md">
                <div style="margin-bottom: 50px;">&nbsp;</div>
            </div>
        </div>

        <!-- /.services --> 
    </div>
</div><!-- #reservation -->
<script>
    $(document).ready(function () {
        $('#res_date').datetimepicker({
            lang: 'en',
            timepicker: false,
            format: 'd/m/Y',
            minDate: "<?php echo date('d/m/Y', strtotime('today')) ?>",
        }).focus(function () {
            this.blur();
        });
    });
    
    function reservationValidation(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            $('#' + formId).find('input[type=text],input[type=email],input[type=number], select,textarea').each(function () {
                                $(this).val('');
                            });
                            ALERT_TITLE = "Success!";
                            alert(response.message);
                        } else {
                            alert(response.message);
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                first_name: {lettersonly: true, required: true},
                last_name: {lettersonly: true, required: true},
                res_email: {email: true, required: true},
                res_phone: {phone: true, required: true},
                res_date: {required: true},
                time_from: {required: true},
                guest_number: {required: true}
            },
            messages: {
                first_name: "First Name is required",
                last_name: "Last Name is required",
                res_phone: "Phone Number is required",
                res_email: "Valid Email is required",
                res_date: "Reservation Date is required",
                time_from: "Time required",
                guest_number: "Guest Number"
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
</script>
