<div id="story" class="light-wrapper customer-wrapper">
    <div class="container-fluid inner-customer-dashboard ">
        <div class="col-md-3">
            <?php echo $this->load->view('customer/site_nav') ?>
        </div>
        <div class="col-md-9">
            <h3 class="text-center">My Cart</h3>
            <div class="panel cart" id="shoppingCart">
                <div class="panel-heading">
                    <div class="panel-title">
                        <div class="row">
                            <div class="col-xs-6">
                                <h5><span class="glyphicon glyphicon-shopping-cart"></span> Cart &nbsp;&nbsp;&nbsp;<span class="please-wait" style="display:none;">Please wait...</span></h5>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row text-center order-type">
                    <?php if ($this->config->item('gk_order_delivery') == 'yes'): ?>
                    <label class="radio-inline click-to-add"><input disabled="true" type="radio" onclick="getOrderType(this.id)" id="online_delivery" name="order_type" <?php isset($order_type) && $order_type == 'online_delivery' ? print "checked='true'" : '' ?>>Delivery</label>&nbsp;&nbsp;
                    <?php else: ?>
                        <label>&nbsp;</label>
                    <?php endif; ?>
                    <?php if ($this->config->item('gk_order_collection') == 'yes'): ?>
                        &nbsp;&nbsp;<label class="click-to-add radio-inline"><input disabled="true" type="radio" onclick="getOrderType(this.id)" id="online_collection" name="order_type" <?php isset($order_type) && $order_type == 'online_collection' ? print "checked='true'" : '' ?>>Collection</label>
                    <?php else: ?>
                        <label>&nbsp;</label>
                    <?php endif; ?>
                </div>
                <div class="panel-body">
                    <div class="row cart-scroll-pane no-padding" style="margin-left: 0px;">
                        <?php if (!empty($cart)): ?>
                            <?php //debugPrint($cart)?>
                            <?php foreach ($cart as $key => $item): ?>
                                <?php $itemName = isset($item['selection_title']) && trim($item['selection_title']) != null ? trim($item['selection_title']) . '-' . trim($item['menu_title']) : trim($item['menu_title']); ?>
                                <?php $setItems = trim($item['set_items']) != null ? '<i><strong>Items:</strong> ' . trim($item['set_items']) . '</i>' : ''; ?>
                                <?php $toppingSet = trim($item['toppings']) != null ? '<i> <strong style="text-transform: uppercase;">T/S : </strong>' . trim($item['toppings']) . '</i>' : ''; ?>
                                <div class="cart-item col-xs-12 no-padding line" id="line-<?php echo $item['line'] ?>">
                                    <div class="col-xs-8" style="padding: 0px 0px">
                                        <h5 class="product-name">
                                            <strong><?php echo to_quantity_decimals($item ['quantity']) ?>&nbsp;&nbsp;<?php echo $itemName; ?></strong>
                                        </h5>
                                        <h6>
                                            <small>
                                                <?php trim($setItems) != null ? print $setItems : '' ?>
                                                <?php trim($toppingSet) != null && trim($setItems) != null ? print'<br/>' . $toppingSet : print($toppingSet) ?>
                                            </small>
                                        </h6>
                                    </div>
                                    <div class="col-xs-4 text-right" style="padding: 0px 0px">
                                        <h6><strong><?php echo to_currency($item ['quantity'] * $item ['price']) ?></strong></h6>
                                    </div>
                                </div>

                            <?php endforeach ?>
                        <?php endif; ?>
                    </div>
                    <hr class="checkout-hr-border">
                    <div class="row">
                        <div class="text-center">
                            <div class="col-xs-9">
                                <!-- 1 -->
                                <h6 class="text-right">Subtotal</h6>
                                <!-- 2 -->
                                <?php if (isset($vat) && $vat > 0): ?>
                                    <h6 class="text-right">VAT</h6>
                                <?php endif; ?>
                                <!-- 3 -->
                                <?php if ($order_type == 'online_delivery' && !empty($deliveryPlan)): ?>
                                    <h6 class="text-right">Delivery Fee</h6>
                                <?php endif; ?>
                                <!-- 4 -->
                                <?php if ($discount != null && $discount > 0): ?>
                                    <h6 class="text-right">Discount</h6>
                                <?php endif; ?>
                                <!-- 5 -->
                                <?php if ($cross_promotion == 'yes' && $cross_promo_amount > 0): ?>
                                    <h6 class="text-right">Promo Discount</h6>
                                <?php endif; ?>   
                                <!-- 6 -->

                                <?php if (isset($bogodiscount) && $bogodiscount > 0): ?>
                                    <h6 class="text-right">Multi Discount</h6>
                                <?php endif ?>   

                                <!-- 7 -->
                                <?php if (isset($cc_fee) && $cc_fee > 0): ?>
                                    <h6 class="text-right">ccFee</h6>
                                <?php endif ?>   
                            </div>
                            <div class="col-xs-3" style="padding-right: 26px;">
                                <!-- 1 -->
                                <h6 class="text-right"><?php echo to_currency($subtotal) ?></h6>
                                <!-- 2 -->
                                <?php if (isset($vat) && $vat > 0): ?>
                                    <h6 class="text-right"><?php echo to_currency($vat) ?></h6>
                                <?php endif; ?>
                                <!-- 3 -->
                                <?php if ($order_type == 'online_delivery' && !empty($deliveryPlan)): ?>
                                    <h6 class="text-right"><?php $deliveryPlan['is_free'] == 1 ? print "Free" : print to_currency($deliveryPlan['delivery_charge']) ?></h6>
                                <?php endif; ?>
                                <!-- 4 -->
                                <?php if ($discount != null && $discount > 0): ?>
                                    <h6 class="text-right"><?php echo to_currency($discount) ?></h6>
                                <?php endif ?>
                                <!-- 5 -->
                                <?php if ($cross_promotion == 'yes' && $cross_promo_amount > 0): ?>
                                    <h6 class="text-right"><?php echo to_currency($cross_promo_amount) ?></h6>
                                <?php endif; ?>    
                                <!-- 6 -->
                                <?php if (isset($bogodiscount) && $bogodiscount > 0): ?>
                                    <h6 class="text-right"><?php echo to_currency($bogodiscount) ?></h6>
                                <?php endif ?>   
                                <!-- 7 -->
                                <?php if (isset($cc_fee) && $cc_fee > 0): ?>
                                    <h6 class="text-right"><?php echo to_currency($cc_fee) ?></h6>
                                <?php endif ?>   

                            </div>
                        </div>
                    </div>
                </div>
                <div class="panel-footer cart-footer">
                    <div class="row">
                        <div class="col-xs-12">
                            <h4 class="text-right">Total <strong id="GrandTotal"><?php echo to_currency($total) ?></strong></h4>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

