<?php $status = array('Pending', 'Confirmed', 'Canceled', 'Wating For Online Payment') ?>
<?php $status_color = array('color:#FF9900;', 'color:#219921;', 'color:#D52229;', 'color:#FF9900;') ?>
<div id="story" class="light-wrapper customer-wrapper">
    <div class="container-fluid inner-customer-dashboard ">
        <div class="col-md-3">
            <?php echo $this->load->view('customer/site_nav') ?>
        </div>
        <div class="col-md-9 gktable">
            <h3 class="text-center">Order Details</h3>
            <?php if (isset($order) && !empty($order[0])): ?>
                <div class="innercommon-right-content">
                    <table class="payment-table" width="100%" cellspacing="0" cellpadding="0" border="0">
                        <tbody>
                            <tr class="even">
                                <td class="bdr-bottom" colspan="3"><b><?php $order[0]->online_type == 'collection' ? print 'Collection Address' : print'Delivery Address' ?></b></td>
                            </tr>
                        </tbody>
                    </table>
                    <table class="payment-table" width="100%" cellspacing="0" cellpadding="0" border="0">
                        <tbody>
                            <?php if ($order[0]->online_type == 'collection'): ?>
                                <tr class="odd">
                                    <td class="bdr-bottom bdr-right" width="40%">Order ID</td>
                                    <td class="bdr-bottom" width="60%"><?php echo strtoupper($order[0]->id) ?></td>
                                </tr>
                                <tr class="even">
                                    <td class="bdr-bottom bdr-right" width="40%">Order Type</td>
                                    <td class="bdr-bottom" width="60%">Collection</td>
                                </tr>

                                <tr class="odd">
                                    <td class="bdr-bottom bdr-right" width="40%">Restaurant Name</td>
                                    <td class="bdr-bottom" width="60%"><?php echo ucwords($this->config->item('gk_name')) ?></td>
                                </tr>
                                <tr class="even">
                                    <td class="bdr-bottom bdr-right" width="40%">Restaurant Phone</td>
                                    <td class="bdr-bottom" width="60%"><?php echo $this->config->item('gk_phone') ?></td>
                                </tr>
                                <tr class="odd">
                                    <td class="bdr-bottom bdr-right" width="40%">Address:</td>
                                    <td class="bdr-bottom" width="60%"><?php echo ucwords($this->config->item('gk_address')) ?></td>
                                </tr>
                                <tr class="even">
                                    <td class="bdr-bottom bdr-right" width="40%">Order Status</td>
                                    <td class="bdr-bottom" width="60%">
                                        <span style="<?php echo $status_color[$order[0]->online_status] ?>"><?php echo $status[$order[0]->online_status] ?></span>
                                    </td>
                                </tr>

                                <tr class="odd">
                                    <td class="bdr-bottom bdr-right" width="40%">Order Date</td>
                                    <td class="bdr-bottom" width="60%"><?php isset($order[0]->created) && $order[0]->created !== '0000-00-00 00:00:00' ? print date('F j, Y H:i:A', strtotime($order[0]->created)) : print'' ?></td>
                                </tr>
                                 <tr class="even">
                                    <td class="bdr-bottom bdr-right" width="40%">Collection Time</td>
                                    <td class="bdr-bottom" width="60%"><?php isset($order[0]->delivery_time)? print $order[0]->delivery_time : '' ?></td>
                                </tr>
                                <tr class="even">
                                    <td class="bdr-bottom bdr-right" width="40%">Payment Method</td>
                                    <td class="bdr-bottom" width="60%"><?php echo strtoupper($order[0]->online_method) ?></td>
                                </tr>

                            <?php else: ?>
                                <tr class="odd">
                                    <td class="bdr-bottom bdr-right" width="40%">Order ID</td>
                                    <td class="bdr-bottom" width="60%"><?php echo strtoupper($order[0]->id) ?></td>
                                </tr>
                                <tr class="even">
                                    <td class="bdr-bottom bdr-right" width="40%">Order Type</td>
                                    <td class="bdr-bottom" width="60%">Delivery</td>
                                </tr>
                                <tr class="odd">
                                    <td class="bdr-bottom bdr-right" width="40%">Customer Name</td>
                                    <td class="bdr-bottom text-capitalize" width="60%"><?php echo $order[0]->namealt ? $order[0]->namealt : $order[0]->name ?></td>
                                </tr>

                                <tr class="even">
                                    <td class="bdr-bottom bdr-right" width="40%">Customer Phone</td>
                                    <td class="bdr-bottom" width="60%"><?php echo $order[0]->phonealt ? $order[0]->phonealt : $order[0]->phone ?></td>
                                </tr>

                                <?php
                                $billAddressString = '';
                                $billAddressString .= trim($order[0]->floor_or_apt) ? $this->lang->line('gkpos_floor_or_apt_no') . '&nbsp;:&nbsp;' . ucwords($order[0]->floor_or_apt) . ', ' : '';
                                $billAddressString .= trim($order[0]->building) ? $this->lang->line('gkpos_building') . '&nbsp;:&nbsp;' . ucwords($order[0]->building) . ', ' : '';
                                $billAddressString .= trim($order[0]->house) ? ucwords($order[0]->house) . '&nbsp;' : '';
                                $billAddressString .= trim($order[0]->street) ? ucwords($order[0]->street) . ', ' : '';
                                $billAddressString .= trim($order[0]->city) ? ucwords($order[0]->city) . ', ' : '';
                                $billAddressString .= trim($order[0]->postcode) ? ucwords($order[0]->postcode) : '';
                                ?>
                                <tr class="odd">
                                    <td class="bdr-bottom bdr-right" width="40%">Address</td>
                                    <td class="bdr-bottom" width="60%"><?php echo $billAddressString ?></td>
                                </tr>
                                <tr class="even">
                                    <td class="bdr-bottom bdr-right" width="40%">Order Status</td>
                                    <td class="bdr-bottom" width="60%">
                                        <span style="<?php echo $status_color[$order[0]->online_status] ?>"><?php echo $status[$order[0]->online_status] ?></span>
                                    </td>
                                </tr>

                                <tr class="odd">
                                    <td class="bdr-bottom bdr-right" width="40%">Order Date</td>
                                    <td class="bdr-bottom" width="60%"><?php isset($order[0]->created) && $order[0]->created !== '0000-00-00 00:00:00' ? print date('F j, Y H:i A', strtotime($order[0]->created)) : print'' ?></td>
                                </tr>
                                 <tr class="even">
                                    <td class="bdr-bottom bdr-right" width="40%">Delivery Time</td>
                                    <td class="bdr-bottom" width="60%"><?php isset($order[0]->delivery_time)? print $order[0]->delivery_time : '' ?></td>
                                </tr>
                                <tr class="odd">
                                    <td class="bdr-bottom bdr-right" width="40%">Payment Method</td>
                                    <td class="bdr-bottom" width="60%"><?php echo strtoupper($order[0]->online_method) ?></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="innercommon-right-content">
                    <table class="payment-table" width="100%" cellspacing="0" cellpadding="0" border="0">
                        <tbody>
                            <tr class="odd">
                                <td class="bdr-bottom bdr-right" width="40%"><strong>Name</strong></td>
                                <td class="bdr-bottom bdr-right" width="20%"><strong>U.P</strong></td>
                                <td class="bdr-bottom bdr-right" width="20%"><strong>Qty</strong></td>
                                <td class="bdr-bottom bdr-right" width="20%">Price</td>
                            </tr>

                            <?php if (!empty($items)): ?>
                                <?php $index = 0; ?>
                                <?php foreach ($items as $item): ?>
                                    <tr class="<?php $index % 2 == 0 ? print 'even' : print'odd' ?>">
                                        <td class="bdr-bottom bdr-right" width="40%">
                                            <?php
                                            $itemString = isset($item->selection_title) && $item->selection_title != null ? $item->selection_title . '-' . $item->menu_title : $item->menu_title;
                                            $itemString .= $item->set_items != null ? '<br/> <i><strong>Items: </strong>' . $item->set_items . '</i>' : '';
                                            $itemString .= $item->toppings != null ? '<br/> <i> <strong>Toppings: </strong>' . $item->toppings . '</i>' : '';
                                            echo $itemString;
                                            ?>
                                        </td>
                                        <td class = "bdr-bottom bdr-right" width = "20%"><?php echo to_currency($item->price)?></td>
                                        <td class="bdr-bottom bdr-right" width="20%"><?php echo $item->quantity ?></td>
                                        <td class="bdr-bottom bdr-right" width="20%"><?php echo to_currency($item->price * $item->quantity) ?></td>
                                    </tr>
                                    <?php $index++; ?>
                                <?php endforeach; ?>
                            <?php endif; ?>
                            <tr class="odd">
                                <td colspan="3" class="bdr-bottom bdr-right" width="80%" style="text-align: right;"><strong>Subtotal</strong></td>
                                <td class="bdr-bottom bdr-right" width="20%" style="text-align: left;"><strong><?php echo to_currency($order[0]->order_total) ?></strong></td>
                            </tr>
                            <?php if (isset($discount) && $discount > 0): ?>
                                <tr class="even">
                                    <td colspan="3" class="bdr-bottom bdr-right" width="80%" style="text-align: right;">Discount(-)</td>
                                    <td class="bdr-bottom bdr-right" width="20%" style="text-align: left;"><?php echo to_currency($discount) ?></td>
                                </tr>
                            <?php endif; ?>
                            <?php if (isset($vat) && $vat > 0): ?>
                                <tr class="even">
                                    <td colspan="3" class="bdr-bottom bdr-right" width="80%" style="text-align: right;">VAT(+)</td>
                                    <td class="bdr-bottom bdr-right" width="20%" style="text-align: left;"><?php echo to_currency($vat) ?></td>
                                </tr>
                            <?php endif; ?>
                            <?php if ($order[0]->delivery_charge > 0): ?>
                                <tr class="even">
                                    <td colspan="3" class="bdr-bottom bdr-right" width="80%" style="text-align: right;">DeliveryFee(+)</td>
                                    <td class="bdr-bottom bdr-right" width="20%" style="text-align: left;"><?php echo to_currency($order[0]->delivery_charge) ?></td>
                                </tr>
                            <?php endif; ?>
                            <?php if ($order[0]->cc_fee != null && $order[0]->cc_fee > 0): ?>
                                <tr class="odd">
                                    <td colspan="3" class="bdr-bottom bdr-right" width="80%" style="text-align: right;">ccFee(+)</td>
                                    <td class="bdr-bottom bdr-right" width="20%" style="text-align: left;"><?php echo to_currency($order[0]->cc_fee) ?></td>
                                </tr>
                            <?php endif; ?>  
                            <?php if ($order[0]->bogo_discount != null && $order[0]->bogo_discount > 0): ?>
                                <tr class="odd">
                                    <td colspan="3" class="bdr-bottom bdr-right" width="80%" style="text-align: right;">Multi Discount(-)</td>
                                    <td class="bdr-bottom bdr-right" width="20%" style="text-align: left;"><?php echo to_currency($order[0]->bogo_discount) ?></td>
                                </tr>
                            <?php endif; ?>  

                            <tr class="even">
                                <td colspan="3" class="bdr-bottom bdr-right" width="80%" style="text-align: right;"><strong>Grand Total</strong></td>
                                <td class="bdr-bottom bdr-right" width="20%" style="text-align: left;"><strong><?php echo to_currency($order[0]->grand_total) ?></strong></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>

    </div>
</div>
