<div id="story" class="light-wrapper customer-wrapper">
    <div class="container-fluid inner-customer-dashboard ">
        <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12">
            <?php echo $this->load->view('customer/site_nav') ?>
        </div>
        <div class="col-lg-9 col-md-9 col-sm-9 col-xs-12">
            <h3 class="text-center"><?php echo $current_section ?></h3>
            <div id="registrationForm" style="margin-top: 30px;">
                <ul id="userRegistrationFormError" class="error_message_box"></ul>
                <?php echo $template['partials']['flash_messages'] ?>
                <?php echo form_open('customer/update_profile', array('class' => 'form-horizontal', 'id' => 'userProfileUpdateForm')) ?>
                <ul class="list-group" style="list-style: none;">
                    <li class="list-group-item">
                        <div class='block'>
                            <div class="block-header">Basic Information</div>
                            <div class="form-group">
                                <label class="col-sm-4 control-label" style='padding-top: 20px;color: #000000;'>Name</label>
                                <div class="col-sm-8">
                                    <input type='text' data-error="#userProfileUpdateFormNameError" class="form-control input-sm" name='name' value="<?php echo $user[0]->name ?>">
                                </div>
                                <div id="userProfileUpdateFormNameError"  class="col-sm-offset-4 col-sm-8"></div>
                            </div>
                            <div class="form-group">
                                <label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label" style='padding-top: 20px;color: #000000;'>Contact No</label>
                                <div class="col-sm-8">
                                    <input type='text' data-error="#userProfileUpdateFormPhoneError" class="form-control input-sm" name='phone' value="<?php echo $user[0]->phone ?>" readonly="true">
                                </div>
                                <div id="userProfileUpdateFormPhoneError"  class="col-sm-offset-4 col-sm-8"></div>
                            </div>
                            <div class="form-group">
                                <label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label" style='padding-top: 20px;color: #000000;'>Email</label>
                                <div class="col-sm-8">
                                    <input type='text' data-error="#userProfileUpdateFormEmailError" class="form-control input-sm" name='email' value="<?php echo $user[0]->email ?>"readonly="true">
                                </div>
                                <div id="userProfileUpdateFormEmailError"  class="col-sm-offset-4 col-sm-8"></div>
                            </div>
                        </div>
                    </li>
                    <li class="list-group-item">
                        <div class='block'>
                            <div class="block-header">Location Details</div>
                            <div class="form-group">
                                <label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label" style='padding-top: 20px;color: #000000;'>House</label>
                                <div class="col-sm-8">
                                    <input type='text' data-error="#userProfileUpdateFormHouseError" class="form-control input-sm" name='house' value="<?php echo postcodeFormat($user[0]->house) ?>">
                                </div>
                                <div id="userProfileUpdateFormHouseError"  class="col-sm-offset-4 col-sm-8"></div>
                            </div>
                            <div class="form-group">
                                <label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label" style='padding-top: 20px;color: #000000;'>Floor/Apt</label>
                                <div class="col-sm-8">
                                    <input type='text' data-error="#userProfileUpdateFormFloororaptError" class="form-control input-sm" name='floor_or_apt' value="<?php echo postcodeFormat($user[0]->floor_or_apt) ?>">
                                </div>
                                <div id="userProfileUpdateFormFloororaptError"  class="col-sm-offset-4 col-sm-8"></div>
                            </div>
                            <div class="form-group">
                                <label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label" style='padding-top: 20px;color: #000000;'>Building</label>
                                <div class="col-sm-8">
                                    <input type='text' data-error="#userProfileUpdateFormBuildingError" class="form-control input-sm" name='building' value="<?php echo postcodeFormat($user[0]->building) ?>">
                                </div>
                                <div id="userProfileUpdateFormBuildingError"  class="col-sm-offset-4 col-sm-8"></div>
                            </div>
                            <div class="form-group">
                                <label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label" style='padding-top: 20px;color: #000000;'>Postal Code</label>
                                <div class="col-sm-8">
                                    <input type='text' data-error="#userProfileUpdateFormPostcodeError" class="form-control input-sm" name='postcode' value="<?php echo postcodeFormat($user[0]->postcode) ?>" style='text-transform: uppercase'>
                                </div>
                                <div id="userProfileUpdateFormPostcodeError"  class="col-sm-offset-4 col-sm-8"></div>
                            </div>
                            <div class="form-group">
                                <label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label" style='padding-top: 20px;color: #000000;'>Street Address</label>
                                <div class="col-sm-8">
                                    <input type='text' data-error="#userProfileUpdateFormStreetError" class="form-control input-sm" name='street' value="<?php echo $user[0]->street ?>">
                                </div>
                                <div id="userProfileUpdateFormStreetError"  class="col-sm-offset-4 col-sm-8"></div>
                            </div>
                            <div class="form-group">
                                <label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label" style='padding-top: 20px; color: #000000;'>City</label>
                                <div class="col-lg-8 col-md-8 col-sm-8 col-xs-8">
                                    <input type='text' data-error="#userProfileUpdateFormCityError" class="form-control input-sm" name='city'  value="<?php echo $user[0]->city ?>">
                                </div>
                                <div id="userProfileUpdateFormCityError"  class="col-sm-offset-4 col-sm-8"></div>
                            </div>
                            <div class="form-group">
                                <label class="col-lg-4 col-md-4 col-sm-4 col-xs-4 control-label" style='padding-top: 20px; color: #000000;'>Country</label>
                                <div class="col-sm-8">
                                    <input type='text' data-error="#userProfileUpdateFormCountryError" class="form-control input-sm" name='country'  value="<?php echo $user[0]->country ?>">
                                </div>
                                <div id="userProfileUpdateFormCountryError"  class="col-sm-offset-4 col-sm-8"></div>
                            </div>
                        </div>
                    </li>
                    <li class="list-group-item">
                        <div class="form-group">
                            <div class="col-sm-offset-4 col-sm-8">
                                <input class="btn btn-danger round" style="width: 100%; margin: 0 auto;" type="submit" name="submit_form" tabindex="4" value="<?php echo $this->lang->line('gkpos_numpad_key_enter') ?>" onclick="UpdateProfile('userProfileUpdateForm')">
                            </div>
                        </div>
                    </li>
                </ul>
                <?php echo form_close() ?>
            </div> 
        </div>
    </div>
</div>
<script>
    $(document).ready(function () {
        $("#country").autocomplete({
            delay: 0,
            source: '<?php echo site_url('user/get_country') ?>',
            minLength: 1
        });
        $("#city").autocomplete({
            delay: 0,
            source: '<?php echo site_url('user/get_city') ?>',
            minLength: 1
        });
    });
    function UpdateProfile(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            window.location.reload();
                        } else {
                            alert(response.message);
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                name: {lettersonly: true, required: true},
                phone: {required: true, phone: true},
                email: {email: true, required: true},
                street: "required",
                city: "required",
                postcode: {postcodeUK: true, required: true}
            },
            messages: {
                name: "<?php echo $this->lang->line('gkpos_valid_name_required') ?>",
                phone: "<?php echo $this->lang->line('gkpos_valid_phone_required') ?>",
                email: "Please specify valid Email Address",
                postcode: "Postal code with UK format is required",
                street: "Please Provide your street address",
                city: "Your city is a required field"
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
</script>

