<?php if (!empty($images)): ?>
    <div id="gallery" class="gallery-wrapper">
        <div class="container-fluid <?php echo $this->config->item('website_style') == 'singlepage' ? 'inner' : 'inner-customer-dashboard' ?>">
            <h2 class="section-title text-center"><?php trim($gallery[0]->title) != null ? print$gallery[0]->title : print'Gallery' ?></h2>
            <p class="main text-center"><?php trim($gallery[0]->content) != null ? print $gallery[0]->content : print '' ?></p>
            <div id="main_area">
                <!-- Slider -->
                <div class="row">
                    <div class="col-sm-6 col-xs-12" id="slider-thumbs">
                        <!-- Bottom switcher of slider -->
                        <ul class="hide-bullets">
                            <?php foreach ($images as $image_key => $imageValue) : ?>
                                <li class="col-lg-4 col-md-4 col-sm-4 col-xs-12 gallery-thumbnails hidden-xs">
                                    <a class="" id="carousel-selector-0">
                                        <img class="thumbnail img-reponsive center-block" id="carousel-selector-<?php echo $image_key ?>" src="<?php echo UPLOAD_PATH . 'gallery/' . $imageValue->image; ?>" alt="thumb" >
                                    </a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <div class="col-sm-6 col-xs-12">
                        <div class="col-xs-12" id="slider">
                            <!-- Top part of the slider -->
                            <div class="row">
                                <div class="col-sm-12" id="carousel-bounding-box">
                                    <div class="carousel slide" id="myCarousel">
                                        <!-- Carousel items -->
                                        <div class="carousel-inner">
                                            <?php foreach ($images as $image_index => $imageObj) : ?>
                                                <div class="<?php $image_index == 0 ? print 'active' : '' ?> item" data-slide-number="<?php echo $image_index ?>">
                                                    <img src="<?php echo UPLOAD_PATH . 'gallery/' . $imageObj->image; ?>" class="img-reponsive">
                                                </div>
                                            <?php endforeach; ?>

                                        </div>
                                        <!-- Carousel nav -->
                                        <a class="left carousel-control" href="#myCarousel" role="button" data-slide="prev">
                                            <span class="glyphicon glyphicon-chevron-left"></span>
                                        </a>
                                        <a class="right carousel-control" href="#myCarousel" role="button" data-slide="next">
                                            <span class="glyphicon glyphicon-chevron-right"></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/Slider-->
                </div>
            </div>
        </div>
    </div>
    <script>
        jQuery(document).ready(function ($) {
            $('#myCarousel').carousel({
                interval: 5000
            });
            $('[id^=carousel-selector-]').click(function () {
                var id_selector = $(this).attr("id");
                try {
                    var id = /-(\d+)$/.exec(id_selector)[1];
                    jQuery('#myCarousel').carousel(parseInt(id));
                } catch (e) {
                }
            });
            $('#myCarousel').on('slide.bs.carousel', function (e) {
                var id = $('.item.active').data('slide-number');
                $('#carousel-text').html($('#slide-content-' + id).html());
            });
        });
    </script>
<?php endif; ?>