<script type="text/javascript" src="https://js.squareup.com/v2/paymentform"></script>
<script type="text/javascript">
    var isLive = '<?php echo $gateway_info[0]->is_live ?>';
    var sqPaymentForm = new SqPaymentForm({
        applicationId: isLive === '2' ? '<?php echo trim($gateway_info[0]->success_url) ?>' : '<?php echo trim($gateway_info[0]->merchant) ?>',
        inputClass: 'sq-input',
        cardNumber: {
            elementId: 'sq-card-number',
            placeholder: "0000 0000 0000 0000"
        },
        cvv: {
            elementId: 'sq-cvv',
            placeholder: 'CVV'
        },
        expirationDate: {
            elementId: 'sq-expiration-date',
            placeholder: 'MM/YY'
        },
        postalCode: {
            elementId: 'sq-postal-code',
            placeholder: 'Postal Code'
        },
        inputStyles: [
            {
                fontSize: '14px',
                padding: '10px'
            },

            {
                mediaMaxWidth: '400px',
                fontSize: '18px',
            }
        ],
        callbacks: {
            cardNonceResponseReceived: function (errors, nonce, cardData) {
                if (errors) {
                    var errorDiv = document.getElementById('errors');
                    errorDiv.innerHTML = "";
                    errors.forEach(function (error) {
                        var p = document.createElement('p');
                        p.innerHTML = error.message;
                        errorDiv.appendChild(p);
                    });
                } else {
                    var nonceField = document.getElementById('card-nonce');
                    nonceField.value = nonce;
                    document.getElementById('form').submit();
                }
            },
            unsupportedBrowserDetected: function () {

            }
        }
    });
    function submitButtonClick(event) {
        event.preventDefault();
        sqPaymentForm.requestCardNonce();
    }
</script>
<style type="text/css">
    .form-block {
        width: 450px;

        margin: 0 auto;
    }
    .sq-input {
        border: 1px solid #CCCCCC;
        margin-bottom: 10px;
        padding: 1px;
    }
    .sq-input--focus {
        outline-width: 5px;
        outline-color: #70ACE9;
        outline-offset: -1px;
        outline-style: auto;
    }
    .sq-input--error {
        outline-width: 5px;
        outline-color: #FF9393;
        outline-offset: 0px;
        outline-style: auto;
    }
</style>
<div id="story" class="light-wrapper">
    <div class="container-fluid inner-customer-dashboard">
        <div class="row" style="margin-top: 5%">
            <div class="form-block">
                <ul class="list-group">
                    <li class="list-group-item">
                        <h1 class="text-center" style="border-bottom: 1px dotted #ccc ">Card Details</h1>
                        <form id="form" novalidate action="<?php echo site_url('onlineorder/process_square/' . $order_id) ?>" method="post">
                            <label>Number</label>
                            <div id="sq-card-number"></div>
                            <label>Expiration Date</label>
                            <div id="sq-expiration-date"></div>
                            <label>CVV</label>
                            <div id="sq-cvv"></div>
                            <label>Postal Code</label>
                            <div id="sq-postal-code"></div>
                            <input type="hidden" id="card-nonce" name="nonce">
                            <input type="submit" onclick="submitButtonClick(event)" id="card-nonce-submit" class="btn btn-primary">
                        </form>
                        <div id="errors"></div>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>




