<script src="https://js.stripe.com/v3/"></script>
<style>
    .StripeElement {background-color: white;padding: 10px 12px;border-radius: 4px;border: 1px solid transparent;box-shadow: 0 1px 3px 0 #e6ebf1;-webkit-transition: box-shadow 150ms ease;transition: box-shadow 150ms ease;}
    .StripeElement--focus {box-shadow: 0 1px 3px 0 #cfd7df;}
    .StripeElement--invalid {border-color: #fa755a;}
    .StripeElement--webkit-autofill {background-color: #fefde5 !important;}
    .online-payment-form {margin: 0 auto;padding: 17px 10px 1px 10px;background: #fff;border-radius: 10px;}
    @media (min-width: 768px) {
        .form-block{
            width: 50%;
            margin: 0 auto;
        }
        .list-group{
            padding: 50px;
        }
    }
</style>
<div id="story" class="light-wrapper">
    <div class="container-fluid inner-customer-dashboard">
        <div class="row" style="margin-top: 5%">
            <div class="form-block">
                <ul class="list-group">
                    <li class="list-group-item">
                        <h1 class="text-center" style="border-bottom: 1px dotted #ccc;font-size: 16px;">Please insert your credit/debit card details</h1>
                         <div style="color: #ff0000; text-align: center;"><?php $this->session->flashdata('paymentGatewayError') ? print $this->session->flashdata('paymentGatewayError') : '' ?></div>
                        <form action="<?php echo site_url('onlineorder/process_stripe/' . $order_id) ?>" method="post" id="payment-form" style="top: 30%">
                            <div class="form-row">
                                <div id="card-element"></div>
                                <div id="card-errors" role="alert"></div>
                            </div>
                            <button class="submit-button btn btn-success" style="font-size: 14px; width: 100%; ">Pay <?php echo to_currency($total) ?></button>
                        </form>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<script>
    if (window.module) {
        module = window.module;
    }
    var isLive = '<?php echo $gateway_info[0]->is_live ?>';
    var stripe = Number(isLive) === 2 ? Stripe('<?php echo $gateway_info[0]->merchant ?>') : Stripe('<?php echo $gateway_info[0]->success_url ?>');
    var elements = stripe.elements();
    var style = {base: {color: '#32325d', fontFamily: '"Helvetica Neue", Helvetica, sans-serif', fontSmoothing: 'antialiased', fontSize: '16px', '::placeholder': {color: '#aab7c4'}}, invalid: {color: '#fa755a', iconColor: '#fa755a'}};
    var card = elements.create('card', {hidePostalCode: true, style: style});
    card.mount('#card-element');
    card.addEventListener('change', function (event) {
        var displayError = document.getElementById('card-errors');
        if (event.error) {
            displayError.textContent = event.error.message;
        } else {
            displayError.textContent = '';
        }
    });
    var form = document.getElementById('payment-form');
    form.addEventListener('submit', function (event) {
        event.preventDefault();
        stripe.createToken(card).then(function (result) {
            if (result.error) {
                var errorElement = document.getElementById('card-errors');
                errorElement.textContent = result.error.message;
            } else {
                $('.page-loader').show();
                $('.submit-button').attr('disabled', 'disabled');
                stripeTokenHandler(result.token);
            }
        });
    });
    function stripeTokenHandler(token) {
        var form = document.getElementById('payment-form');
        var hiddenInput = document.createElement('input');
        hiddenInput.setAttribute('type', 'hidden');
        hiddenInput.setAttribute('name', 'stripeToken');
        hiddenInput.setAttribute('value', token.id);
        form.appendChild(hiddenInput);
        form.submit();
    }
</script>