<!-- Login -->
<div class="hidden">
    <div id="loginFormPopup">
        <div class="popup-content">
            <div class="modal-header">
                <button type="button" class="close" onclick="javascript:closeColorbox()" style="color: #ff0000"><i class="fa fa-close"></i></button>
                <h4 class="modal-title">Login</h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="tab-content">
                            <?php echo form_open('user/validate', array('class' => 'form-horizontal', 'id' => 'loginVerificationForm')) ?>
                            <div class="form-group">
                                <label for="email" class="col-sm-3 control-label">Email</label>
                                <div class="col-sm-9">
                                    <input type="email" name="email" data-error="#loginFormEmailError" class="form-control" id="LoginEmail1" placeholder="Email" />
                                </div>
                                <div id="loginFormEmailError"  class="col-sm-offset-3 col-sm-9"></div>
                            </div>
                            <div class="form-group">
                                <label for="exampleInputPassword1" class="col-sm-3 control-label">
                                    Password</label>
                                <div class="col-sm-9">
                                    <input type="password" name="password" data-error="#loginFormPasswordError" class="form-control" id="exampleInputPassword1" placeholder="Password" />
                                </div>
                                <div id="loginFormPasswordError"  class="col-sm-offset-3 col-sm-9"></div>
                            </div>
                            <input type="hidden" id="isCheckout" value="no">
                            <div class="row">
                                <div class="col-sm-9 col-sm-offset-3">
                                    <input class="btn-u btn" type="submit" name="submit_form" tabindex="4" value="Submit" onclick="loginVerification('loginVerificationForm')">
                                    &nbsp;&nbsp;<a href="javascript:void(0)" onclick="javascript:openForgetPasswordForm()">Forgot password?</a>
                                    &nbsp;&nbsp;Yet not a member, <a href="javascript:void(0)" onclick="javascript:switchingToRegiterForm()">Register</a>
                                    &nbsp;&nbsp;<span class="please-wait" style="display:none;">Validating...</span>
                                </div>

                            </div>
                            <?php echo form_close() ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Registration  -->
<div class="hidden">
    <div id="RegisterFormPopup">
        <div class="popup-content">
            <div class="modal-header">
                <button type="button" class="close" onclick="closeColorbox()" style="color: #ff0000"><i class="fa fa-close"></i></button>
                <h4 class="modal-title">Registration </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="tab-content">
                            <?php echo form_open('user/register', array('class' => 'form-horizontal', 'id' => 'userRegistrationForm')) ?>

                            <div class="form-group">
                                <label for="registerFormName" class="col-sm-4 control-label">Name</label>
                                <div class="col-sm-8">
                                    <input type="text" name="name" data-error="#registerFormNameError" class="form-control" id="registerFormName" placeholder="Name" />
                                </div>
                                <div class="col-md-8 col-sm-offset-4" id="registerFormNameError"></div>
                            </div>

                            <div class="form-group">
                                <label for="registerFormEmail" class="col-sm-4 control-label">Email</label>
                                <div class="col-sm-8">
                                    <input type="email" name="email" data-error="#registerFormEmailError" class="form-control" id="registerFormEmail" placeholder="Email" />
                                </div>
                                <div class="col-sm-8 col-sm-offset-4" id="registerFormEmailError"></div>
                            </div>

                            <div class="form-group">
                                <label for="registerFormPhone" class="col-sm-4 control-label">Phone</label>
                                <div class="col-sm-8">
                                    <input type="tel" name="phone" data-error="#registerFormPhoneError"  class="form-control" id="registerFormPhone" placeholder="Phone" />
                                </div>
                                <div class="col-sm-8 col-sm-offset-4" id="registerFormPhoneError"></div>
                            </div>

                            <div class="form-group">
                                <label for="registerFormPassword" class="col-sm-4 control-label">Password</label>
                                <div class="col-sm-8">
                                    <input type="password" data-error="#registerFormPasswordError"  name="password" class="form-control" id="registerFormPassword" placeholder="Password" />
                                </div>
                                <div class="col-sm-8 col-sm-offset-4" id="registerFormPasswordError"></div>
                            </div>

                            <div class="form-group">
                                <label for="registerFormPassword" class="col-sm-4 control-label">Confirm Password</label>
                                <div class="col-sm-8">
                                    <input type="password" data-error="#registerFormConfirmPasswordError"  name="confirm_password" class="form-control" id="registerFormPasswordConfirmPassword" placeholder="Confirm Password" />
                                </div>
                                <div class="col-sm-8 col-sm-offset-4" id="registerFormConfirmPasswordError"></div>
                            </div>

                            <div class="form-group">
                                <div class="form-check col-sm-8 col-sm-offset-4">
                                    <label class="form-check-label">
                                        <input type="checkbox" class="form-check-input" name="licence_agreement" data-error="#registerFormLicenceAgreementError">
                                        I agree to the Terms of <a  href="javascript:void(0)" onclick="javascript:showTermsCondition()">Service and Privacy Policy</a> of <?php echo $this->config->item('gk_name') ?> 
                                    </label>
                                </div>
                                <div class="col-sm-8 col-sm-offset-4" id="registerFormLicenceAgreementError"></div>
                            </div>
                            <div class="row">
                                <div class="col-sm-8 col-sm-offset-4">
                                    <input class="btn-u btn" type="submit" name="submit_form" tabindex="6" value="Save & Continue" onclick="register('userRegistrationForm')">
                                    <button type="button" class="btn-u btn-brd btn-brd-hover btn-u-red" onclick="closeColorbox()" >Cancel</button>
                                    &nbsp;&nbsp;Already a member, <a href="javascript:void(0)" onclick="javascript:switchingToLoginForm()">Login</a>
                                    &nbsp;&nbsp;<span class="please-wait" style="display:none;">saving...</span>
                                </div>
                            </div>
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Login -->
<div class="hidden">
    <div id="ForgetPasswordForm">
        <div class="popup-content">
            <div class="modal-header">
                <button type="button" class="close" onclick="javascript:closeColorbox()" style="color: #ff0000"><i class="fa fa-close"></i></button>
                <h4 class="modal-title">Password Recovery</h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="tab-content">
                            <?php echo form_open('user/forgetpassword', array('class' => 'form-horizontal', 'id' => 'resetPasswordForm')) ?>
                            <div class="form-group">
                                <label for="rocovery_email" class="col-sm-4 control-label">Recovery Email Address</label>
                                <div class="col-sm-8">
                                    <input type="email" name="rocovery_email" data-error="#resetPasswordFormEmailError" class="form-control" id="rocovery_email" placeholder="Email" />
                                </div>
                                <div id="resetPasswordFormEmailError"  class="col-sm-offset-4 col-sm-9"></div>
                            </div>
                            <div class="row">
                                <div class="col-sm-9 col-sm-offset-4">
                                    <input class="btn-u btn" type="submit" name="submit_form" tabindex="4" value="Submit" onclick="resetPassword('resetPasswordForm')">
                                </div>
                            </div>
                            <?php echo form_close() ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<script>
    $(document).ready(function () {
        $('#licenceAgreementAnchor').on('click', function () {
            $('#RegisterFormTermsAndServiceTab').click();
        });
    });
    function openCheckoutLoginForm() {
        $('#isCheckout').val('yes');
        if ($('#isCheckout').val() === 'yes') {
            openLoginForm();
        }
    }
    function loginVerification(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        $('.please-wait').removeAttr('style').css({'display': 'inline-block'});
                    },
                    success: function (response) {
                        $('.please-wait').removeAttr('style').css({'display': 'none'});
                        if (response.success) {
                            $.colorbox.close();
                            if (WrapperPage == 'singlepage') {
                                $('#navigationShowLogin').removeAttr('style');
                                $('#navigationShowLogin').css({'display': 'none'});
                                $('#navigationShowRegister').removeAttr('style');
                                $('#navigationShowRegister').css({'display': 'none'});
                                if (jQuery(window).width() <= 767) {
                                    $('#navigationShowAccount').removeAttr('style');
                                    $('#navigationShowAccount').css({'display': 'block'});
                                    $('#navigationShowLogout').removeAttr('style');
                                    $('#navigationShowLogout').css({'display': 'block'});
                                } else {
                                    $('#navigationShowAccount').removeAttr('style');
                                    $('#navigationShowAccount').css({'display': 'inline-block'});
                                    $('#navigationShowLogout').removeAttr('style');
                                    $('#navigationShowLogout').css({'display': 'inline-block'});
                                }
                                if ($('#isCheckout').val() == 'yes') {
                                    $('#isCheckout').val('no');
                                    window.location.replace('<?php echo site_url('onlineorder/checkout') ?>');
                                }
                                if ($('#isCheckout').val() == 'review') {
                                    $('#isCheckout').val('no');
                                    $('#reviewBoxOpener').length > 0 ? $('#reviewBoxOpener').removeAttr('style').css({'display': 'block'}).click() : '';
                                    $('#reviewLoginOpener').length > 0 ? $('#reviewLoginOpener').removeAttr('style').css({'display': 'none'}) : '';

                                }
                            } else {
                                if ($('#isCheckout').val() == 'yes') {
                                    $('#isCheckout').val('no');
                                    window.location.replace('<?php echo site_url('onlineorder/checkout') ?>');
                                } else {
                                    window.location.reload();
                                }
                                if ($('#isCheckout').val() == 'review') {
                                    $('#isCheckout').val('no');
                                    $('#reviewBoxOpener').length > 0 ? $('#reviewBoxOpener').removeAttr('style').css({'display': 'block'}) : '';
                                    $('#reviewLoginOpener').length > 0 ? $('#reviewLoginOpener').removeAttr('style').css({'display': 'none'}) : '';
                                }

                            }
                        } else {
                            if (WrapperPage == 'singlepage') {
                                $('#navigationShowAccount').removeAttr('style');
                                $('#navigationShowAccount').css({'display': 'none'});
                                $('#navigationShowLogout').removeAttr('style');
                                $('#navigationShowLogout').css({'display': 'none'});
                                if ($('#isCheckout').val() == 'review') {
                                    $('#isCheckout').val('no');
                                    $('#reviewBoxOpener').length > 0 ? $('#reviewBoxOpener').removeAttr('style').css({'display': 'none'}) : '';
                                    $('#reviewLoginOpener').length > 0 ? $('#reviewLoginOpener').removeAttr('style').css({'display': 'block'}) : '';
                                }
                                if (jQuery(window).width() <= 767) {
                                    $('#navigationShowLogin').removeAttr('style');
                                    $('#navigationShowLogin').css({'display': 'block'});
                                    $('#navigationShowRegister').removeAttr('style');
                                    $('#navigationShowRegister').css({'display': 'block'});
                                } else {
                                    $('#navigationShowLogin').removeAttr('style');
                                    $('#navigationShowLogin').css({'display': 'inline-block'});
                                    $('#navigationShowRegister').removeAttr('style');
                                    $('#navigationShowRegister').css({'display': 'inline-block'});
                                }
                            }
                            alert(response.message);
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $('#colorbox').colorbox.resize();
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
                $('#colorbox').colorbox.resize();
            },
            rules: {
                email: {email: true, required: true},
                password: {required: true}
            },
            messages: {
                email: "Your Email Address, Pleaese",
                password: "Password is required"
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
    function register(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    beforeSend: function () {
                        $('.please-wait').removeAttr('style').css({'display': 'inline-block'});
                    },
                    success: function (response) {
                        $('.please-wait').removeAttr('style').css({'display': 'none'});
                        if (response.success) {
                            closeColorbox();
                            if (WrapperPage == 'singlepage') {
                                LoginSpecificNavigation();
                            } else {
                                window.location.reload();
                            }
                        } else {
                            alert(response.message)
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
                $('#colorbox').colorbox.resize();
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
                $('#colorbox').colorbox.resize();
            },
            rules: {
                name: {lettersonly: true, required: true},
                phone: {required: true, phone: true},
                email: {email: true, required: true},
                password: {required: true},
                confirm_password: {equalTo: "#registerFormPassword"},
                licence_agreement: {required: true}
            },
            messages: {
                name: "<?php echo $this->lang->line('gkpos_valid_name_required') ?>",
                phone: "<?php echo $this->lang->line('gkpos_valid_phone_required') ?>",
                email: "Please specify valid Email Address",
                password: "Password is a required field",
                confirm_password: "Confirmed Password does not match",
                licence_agreement: "You must agree to our terms of service and privacy policy",
            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
    function resetPassword(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            closeColorbox();
                            ALERT_TITLE = "Success!"
                            alert(response.message);
                        } else {
                            ALERT_TITLE = "Warning!";
                            alert(response.message);
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $('#colorbox').colorbox.resize();
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $('#colorbox').colorbox.resize();
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {rocovery_email: "required"},
            messages: {rocovery_email: "Recovery email address is required"},
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
  
</script>
<!-- Modal -->

