<div id="review" class="review-wrapper wrapper">
    <div class="container <?php echo $this->config->item('website_style') == 'singlepage' ? 'inner' : 'inner-customer-dashboard' ?> carousel-reviews broun-block">
        <h2 class="section-title text-center">Our Customer Feedback</h2>
        <div class="" style="margin: 0 auto;">
            <div class="text-center">
                <a  href="javascript:void(0)" data-toggle="collapse" data-target="#post-review-box" id="reviewBoxOpener" style="display: none;">Leave your review with rating</a>
                <a  href="javascript:void(0)" onclick="openReviewLoginForm()" id="reviewLoginOpener" style="display: none;">Would you like to leave a review?</a>
            </div>
            <div class="row collapse" id="post-review-box">
                <?php echo form_open('review/save', array('id' => 'reviewForm')) ?>
                <div class="col-sm-6 form-group">
                    <label for="name">Your Rating</label>
                    <div style="border: 1px solid #ccc; border-radius: 10px;">
                        <div id="rateYo"></div>
                        <input class="form-control"  id="rating" name="rating" type="text" style="border: none;"/>
                    </div>
                </div>
                <div class="col-sm-6 form-group">
                    <label for="name">Your Message</label>
                    <textarea style="border: 1px solid #ccc; border-radius: 10px;" class="form-control" name="message" rows="2" placeholder="Write a short review..." title="Review"></textarea>
                </div>
                <div class="col-sm-12 form-group">
                    <input class="btn" style="width: 100%; height:50px;" type="submit" name="submit_form" tabindex="4" value="Submit Review" onclick="AjaxReviewFormPostSubmission('reviewForm')">
                </div>
                <?php echo form_close() ?>
            </div>
        </div>
        <div class="row">
            <?php if (!empty($reviews)): ?>
                <?php foreach ($reviews as $areview): ?>
                    <div class="col-md-6">
                        <div class="blockquote-box clearfix">
                            <h4><?php echo get_customer_name($areview->customer) ?>
                                <small>My rating: 
                                    <?php $rating = $areview->rating ?>
                                    <?php for ($i = 1; $i <= 5; $i++): ?>
                                        <span class="glyphicon <?php $i <= $rating ? print'glyphicon-star star-active' : print 'glyphicon-star-empty' ?> "></span>
                                    <?php endfor; ?>
                                </small>
                                 <br/>
                                <small><?php echo date('d.m.Y', strtotime($areview->created_at))?></small>
                            </h4>
                            <p><?php echo $areview->message ?></p>
                        </div>
                    </div>
                <?php endforeach; ?>
                <div class="pagination pagination-sm text-center">
                    <?php echo $pagination; ?>
                </div>
            <?php else: ?>
                <div class="col-md-6">
                    <div class="blockquote-box clearfix">
                        <p>No reviews yet</p>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <div class="hidden-sm hidden-lg hidden-md">
            <div style="margin-bottom: 20px;">&nbsp;</div>
        </div>
    </div>
</div>
<script>
    $(function () {
        $("#rateYo").rateYo({
            fullStar: true,
            halfStar: false,
            onSet: function (rating, rateYoInstance) {
                $('#rating').val(rating);
            }
        });
    });
    function openReviewLoginForm() {
        $('#isCheckout').val('review');
        if ($('#isCheckout').val() === 'review') {
            openLoginForm();
        }
    }
    function AjaxReviewFormPostSubmission(formId) {
        $('#' + formId).validate({
            submitHandler: function () {
                var myform = document.getElementById(formId);
                var formdata = new FormData(myform);
                $.ajax({
                    url: $('#' + formId).attr('action'),
                    data: formdata,
                    cache: false,
                    processData: false,
                    contentType: false,
                    type: 'POST',
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            ALERT_TITLE = 'Success';
                            alert(response.message);
                            $('#' + formId).find("input, textarea").val("");
                        } else {
                            $('#' + formId).find("input, textarea").val("");
                        }
                    }
                });
            },
            errorClass: "has-error",
            highlight: function (e) {
                $(e).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (e) {
                $(e).closest('.form-group').removeClass('has-error');
            },
            rules: {
                message: {required: true},
                rating: {
                    min: 0,
                    max: 5,
                    digits: true,
                    required: true
                }
            },
            messages: {
                rating: "Please provide your rating points (0-5) in integer value",
                message: "Your Review Message, Please "

            },
            errorPlacement: function (error, element) {
                errorPlacement(error, element);
            }
        });
    }
</script>
<style>
    .blockquote-box{border-right:5px solid #E6E6E6;margin-bottom:25px}
    div.pagination a {padding: 10px 20px;}
</style>